/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.rational.wvcm.ri.impl.ActivityImpl;
import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.team.connector.scm.client.JzLocation;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.client.JzRepoResource;
import com.ibm.team.connector.scm.client.JzRepoWorkItem;
import com.ibm.team.connector.scm.client.JzRepoWorkspace;
import com.ibm.team.filesystem.client.workitems.IFileSystemWorkItemManager;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.IReference;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.links.ChangeSetLinks;
import com.ibm.team.scm.common.providers.ProviderFactory;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.wvcm.Activity;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.WvcmException;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JzRepoChangeSet
extends JzRepoResource {
    public JzRepoChangeSet(JzProvider provider, Location loc) {
        super(provider, loc);
    }

    @Override
    public Class<?> get_proxyClass() {
        return ActivityImpl.class;
    }

    @Override
    protected Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Activity.TASK_LIST)) {
            return this.getTaskList(feedback);
        }
        if (propertyName.equals((Object)Resource.COMMENT)) {
            return this.getComment(feedback);
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    private List<SrvcResource> getTaskList(SrvcFeedback feedback) throws WvcmException {
        ArrayList<SrvcResource> results = new ArrayList<SrvcResource>();
        JzProvider provider = this.getProvider();
        ITeamRepository repo = provider.getRepo();
        IProgressMonitor monitor = provider.getMonitor();
        ProviderFactory providerFactory = (ProviderFactory)repo.getClientLibrary(ProviderFactory.class);
        IChangeSetHandle chs = (IChangeSetHandle)this.getItemHandle();
        try {
            List cachedLinks = ChangeSetLinks.findLinks((ProviderFactory)providerFactory, (IChangeSetHandle)chs, (IProgressMonitor)monitor);
            for (ILink link : cachedLinks) {
                IReference targetRef;
                if (!link.getLinkTypeId().equals("com.ibm.team.filesystem.workitems.change_set") || !(targetRef = link.getTargetRef()).isItemReference()) continue;
                IWorkItemHandle wiHandle = (IWorkItemHandle)((IItemReference)targetRef).getReferencedItem();
                JzRepoWorkItem task = JzRepoWorkItem.create(provider, wiHandle);
                results.add(task);
            }
            return results;
        }
        catch (TeamRepositoryException e) {
            throw this.wrapException("getTaskList", (Exception)((Object)e));
        }
    }

    private String getComment(SrvcFeedback feedback) throws WvcmException {
        JzProvider provider = this.getProvider();
        try {
            IChangeSet cs = (IChangeSet)provider.getRepo().itemManager().fetchPartialItem(this.getItemHandle(), 0, (Collection)Collections.singletonList(IChangeSet.COMMENT_PROPERTY), provider.getMonitor());
            return cs.getComment();
        }
        catch (TeamRepositoryException e) {
            throw this.wrapException("getComment", (Exception)((Object)e));
        }
    }

    public void setPropertyFromClient(PropertyNameList.PropertyName<?> propertyName, Object value, boolean initialize, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Resource.COMMENT) && value instanceof String) {
            this.setComment((String)value);
        } else if (propertyName.equals((Object)Activity.TASK_LIST)) {
            this.setTaskList((List)value);
        }
    }

    private void setTaskList(List<JzRepoWorkItem> workItems) throws WvcmException {
        JzProvider provider = this.getProvider();
        ITeamRepository repo = provider.getRepo();
        IProgressMonitor monitor = provider.getMonitor();
        IChangeSetHandle csh = (IChangeSetHandle)this.getItemHandle();
        ArrayList<IItemHandle> workItemHandles = new ArrayList<IItemHandle>(workItems.size());
        for (JzRepoWorkItem wi : workItems) {
            if (wi.getItemHandle().getOrigin() == null) {
                throw new IllegalArgumentException("work item handle origin must not be null");
            }
            workItemHandles.add(wi.getItemHandle());
        }
        IWorkItemHandle[] workItemHandlesArray = workItemHandles.toArray(new IWorkItemHandle[0]);
        try {
            IFileSystemWorkItemManager workItemManager = (IFileSystemWorkItemManager)repo.getClientLibrary(IFileSystemWorkItemManager.class);
            workItemManager.createLink(null, csh, workItemHandlesArray, monitor);
        }
        catch (TeamRepositoryException e) {
            throw this.wrapException("setTaskList", (Exception)((Object)e));
        }
    }

    private void setComment(String comment) throws WvcmException {
        JzProvider provider = this.getProvider();
        IWorkspaceManager wm = this.getWorkspaceManager();
        try {
            wm.setComment((IChangeSetHandle)this.getItemHandle(), comment, provider.getMonitor());
        }
        catch (TeamRepositoryException e) {
            throw this.wrapException("setComment: " + comment, (Exception)((Object)e));
        }
    }

    public static JzRepoChangeSet lookup(JzProvider provider, JzLocation loc) {
        JzRepoChangeSet result = null;
        IItemHandle myItemHandle = JzRepoChangeSet.lookupItemHandle(provider, loc);
        if (myItemHandle != null) {
            result = JzRepoChangeSet.create(provider, loc, myItemHandle);
        }
        return result;
    }

    public static JzRepoChangeSet create(JzProvider provider, JzLocation loc, IItemHandle myItemHandle) {
        JzRepoChangeSet result = new JzRepoChangeSet(provider, loc);
        result.setItemHandle(myItemHandle);
        return result;
    }

    public static JzRepoChangeSet create(JzProvider provider, IChangeSetHandle changeSetHandle, SrvcFeedback feedback) throws WvcmException {
        JzLocation myLoc = JzLocation.createChangeSetLocation(JzRepoChangeSet.getCurrentStateDisplayName((IItemHandle)changeSetHandle));
        return JzRepoChangeSet.create(provider, myLoc, (IItemHandle)changeSetHandle);
    }

    public static SrvcResource doCreateGeneratedResource(JzProvider provider, JzLocation locationHint, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        IChangeSetHandle csh = JzRepoWorkspace.doCreateGeneratedChangeSet(provider, locationHint, updates, updated, feedback);
        return JzRepoChangeSet.create(provider, csh, feedback);
    }
}

