/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.team.connector.scm.client.JzLocation;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.client.JzRepoComponent;
import com.ibm.team.connector.scm.client.JzRepoControllableFolder;
import com.ibm.team.connector.scm.client.JzRepoWorkspace;
import com.ibm.team.connector.scm.client.Messages;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IFolderHandle;
import java.util.List;
import java.util.Map;
import javax.wvcm.ControllableFolder;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.WvcmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JzRepoBaselineControlledFolder
extends JzRepoControllableFolder {
    public JzRepoBaselineControlledFolder(JzProvider provider, Location loc) {
        super(provider, loc);
    }

    @Override
    public Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Resource.RESOURCE_IDENTIFIER)) {
            return this.getResourceIdentifier(feedback);
        }
        if (propertyName.equals((Object)Resource.PATHNAME_LOCATION)) {
            return this.getPathnameLocation(feedback);
        }
        if (propertyName.equals((Object)ControllableFolder.ROOT_FOLDER_OF)) {
            return this.getWvcmConfiguration();
        }
        if (propertyName.equals((Object)Resource.DISPLAY_NAME)) {
            return this.getDisplayName();
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    @Override
    protected String getResourceIdentifier(SrvcFeedback feedback) throws WvcmException {
        JzRepoWorkspace ws = this.getWvcmWorkspace();
        JzRepoComponent comp = ws.getJzRepoComponent(this.getLocation().getComponentLocation(), feedback);
        JzLocation resultLoc = JzLocation.createBCFLoc(ws.getLocation(), comp.getLocation());
        return resultLoc.string();
    }

    @Override
    public IItemHandle computeItemHandle() throws WvcmException {
        JzRepoWorkspace ws = this.getWvcmWorkspace();
        JzLocation myLoc = this.getLocation();
        JzRepoComponent comp = ws.getJzRepoComponent(myLoc.getComponentLocation(), null);
        String locationString = myLoc.string();
        if (comp == null) {
            throw new WvcmException(NLS.bind((String)Messages.JzRepoBaselineControlledFolder_ERROR_GET_BCF_COMPONENT_FAILED, (Object[])new Object[]{locationString}), WvcmException.ReasonCode.NOT_FOUND);
        }
        IFolderHandle rootFolder = comp.getRootFolderHandle();
        if (rootFolder == null) {
            throw new WvcmException(NLS.bind((String)Messages.JzRepoBaselineControlledFolder_ERROR_GET_BCF_ROOT_DIR_FAILED, (Object[])new Object[]{locationString}), WvcmException.ReasonCode.NOT_FOUND);
        }
        return rootFolder;
    }

    @Override
    public String getDisplayName() throws WvcmException {
        return this.getJzRepoComponent().getName();
    }

    public static JzRepoBaselineControlledFolder doCreateResource(JzProvider provider, JzLocation myLoc, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        JzLocation wsLoc = myLoc.parent();
        JzRepoWorkspace ws = (JzRepoWorkspace)provider.lookup(wsLoc, feedback);
        if (ws == null) {
            throw new WvcmException(NLS.bind((String)Messages.JzRepoBaselineControlledFolder_ERROR_GET_WORKSPACE_FROM_BCF_LOC_FAILED, (Object[])new Object[]{myLoc.string()}), WvcmException.ReasonCode.NOT_FOUND);
        }
        JzLocation compLoc = ws.doCreateComponent(myLoc.getComponentLocation(), updates, updated, feedback);
        JzLocation resultLoc = JzLocation.createBCFLoc(wsLoc, compLoc);
        JzRepoBaselineControlledFolder result = (JzRepoBaselineControlledFolder)provider.lookup(resultLoc, feedback);
        return result;
    }

    @Override
    public JzLocation getPathnameLocation(SrvcFeedback feedback) throws WvcmException {
        JzProvider provider = this.getProvider();
        JzLocation myLoc = this.getLocation();
        return JzRepoBaselineControlledFolder.getPathnameLocation(provider, myLoc, feedback);
    }

    private static JzLocation getPathnameLocation(JzProvider provider, JzLocation myLoc, SrvcFeedback feedback) throws WvcmException {
        JzRepoWorkspace ws = (JzRepoWorkspace)provider.lookup(myLoc.getWorkspaceLocation(), feedback);
        JzLocation wsPathnameLoc = ws.getPathnameLocation(feedback);
        JzRepoComponent comp = ws.getJzRepoComponent(myLoc.getComponentLocation(), null);
        JzLocation result = wsPathnameLoc.child(comp.getName());
        return result;
    }

    public static JzRepoBaselineControlledFolder lookup(JzProvider provider, JzLocation myLoc) {
        JzRepoBaselineControlledFolder result = null;
        try {
            JzLocation myPathnameLoc = JzRepoBaselineControlledFolder.getPathnameLocation(provider, myLoc, null);
            if (myPathnameLoc != null) {
                result = new JzRepoBaselineControlledFolder(provider, myLoc);
            }
        }
        catch (WvcmException e) {
            provider.logIgnoredException("lookup", (Exception)((Object)e));
        }
        return result;
    }
}

