/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.rational.wvcm.ri.impl.BaselineImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.team.connector.scm.client.JzLocation;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.client.JzRepoComponent;
import com.ibm.team.connector.scm.client.JzRepoException;
import com.ibm.team.connector.scm.client.JzRepoFolderItem;
import com.ibm.team.connector.scm.client.JzRepoResource;
import com.ibm.team.connector.scm.client.JzRepoVersion;
import com.ibm.team.connector.scm.client.JzRepoVersionHistory;
import com.ibm.team.connector.scm.client.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.common.IBaselineHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.wvcm.Baseline;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Version;
import javax.wvcm.WvcmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JzRepoBaseline
extends JzRepoResource {
    public JzRepoBaseline(JzProvider provider, JzLocation loc) {
        super(provider, loc);
    }

    @Override
    public Class<?> get_proxyClass() {
        return BaselineImpl.class;
    }

    @Override
    protected Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Baseline.VERSION_HISTORY)) {
            JzLocation compLoc = this.getLocation().getComponentLocation();
            JzRepoComponent myComp = (JzRepoComponent)this.getProvider().lookup(compLoc, feedback);
            return myComp;
        }
        if (propertyName.equals((Object)Baseline.VERSION_LIST)) {
            return this.getVersionList();
        }
        if (propertyName.equals((Object)Version.VERSION_NAME)) {
            return this.getConnection().getName();
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    private List<JzRepoVersion> getVersionList() throws WvcmException {
        JzRepoComponent comp = (JzRepoComponent)this.getProvider().lookup(this.getLocation().getComponentLocation(), null);
        ArrayList<JzRepoVersion> result = new ArrayList<JzRepoVersion>();
        JzRepoBaseline.getVersionList(this.getProvider(), comp, this.getConfiguration(), result);
        return result;
    }

    public List<SrvcResource.SrvcCompareReport> doCompareReport(SrvcResource otherBaselineGeneric, Baseline.CompareFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        IBaselineConnection thisConn = this.getConnection();
        JzRepoBaseline otherBl = (JzRepoBaseline)otherBaselineGeneric;
        this.logDebug(String.format("comparing this BL: %s with other BL: %s", this.getLocation().string(), otherBl.getLocation().string()));
        List nullCHL = Collections.EMPTY_LIST;
        return this.computeWvcmCompareReport((IConnection)thisConn, (IConnection)otherBl.getConnection(), Collections.singletonList(thisConn.getComponent()), nullCHL, flags);
    }

    public IBaselineConnection getConnection() throws WvcmException {
        JzProvider provider = this.getProvider();
        IBaselineHandle blH = (IBaselineHandle)this.getItemHandle();
        IWorkspaceManager workspaceManager = this.getWorkspaceManager();
        try {
            IBaselineConnection result = workspaceManager.getBaselineConnection(blH, provider.getMonitor());
            return result;
        }
        catch (TeamRepositoryException e) {
            throw new JzRepoException(Messages.JzRepoBaseline_ERROR_GET_CONNECTION, (JzRepoResource)this, (Exception)((Object)e));
        }
    }

    public static JzRepoBaseline lookup(JzProvider provider, JzLocation location) {
        JzRepoBaseline result = null;
        try {
            result = new JzRepoBaseline(provider, location);
            result.getConnection();
        }
        catch (Exception e) {
            provider.logIgnoredException("lookup", e);
            result = null;
        }
        return result;
    }

    protected SrvcResource locateByHistory(SrvcResource genericVersionHistory) throws WvcmException {
        return ((JzRepoVersionHistory)genericVersionHistory).lookupVersion(this.getConnection().configuration());
    }

    public Map<String, SrvcResource> getFolderVersionChildMap(SrvcResource folderVersion) throws WvcmException {
        return ((JzRepoFolderItem)folderVersion).childMap(true, this.getConnection().configuration());
    }

    public List<SrvcResource> getFolderVersionChildList(SrvcResource folderVersion) throws WvcmException {
        return ((JzRepoFolderItem)folderVersion).childList(this.getConnection().configuration());
    }
}

