/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.rational.wvcm.interop.InteropStream;
import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.impl.ResourceImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcProvider;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.team.connector.scm.client.FB;
import com.ibm.team.connector.scm.client.JzLocation;
import com.ibm.team.connector.scm.client.JzRepoBaseline;
import com.ibm.team.connector.scm.client.JzRepoBaselineControlledFolder;
import com.ibm.team.connector.scm.client.JzRepoChangeSet;
import com.ibm.team.connector.scm.client.JzRepoComponent;
import com.ibm.team.connector.scm.client.JzRepoConfiguration;
import com.ibm.team.connector.scm.client.JzRepoControllableFolder;
import com.ibm.team.connector.scm.client.JzRepoControllableResource;
import com.ibm.team.connector.scm.client.JzRepoException;
import com.ibm.team.connector.scm.client.JzRepoNYIException;
import com.ibm.team.connector.scm.client.JzRepoResource;
import com.ibm.team.connector.scm.client.JzRepoRootBaseline;
import com.ibm.team.connector.scm.client.JzRepoRootVersion;
import com.ibm.team.connector.scm.client.JzRepoStream;
import com.ibm.team.connector.scm.client.JzRepoSymbolicLink;
import com.ibm.team.connector.scm.client.JzRepoVersion;
import com.ibm.team.connector.scm.client.JzRepoVersionHistory;
import com.ibm.team.connector.scm.client.JzRepoWorkItem;
import com.ibm.team.connector.scm.client.JzRepoWorkspace;
import com.ibm.team.connector.scm.client.Messages;
import com.ibm.team.connector.scm.common.CcConnectorUtils;
import com.ibm.team.interop.client.IInteropManager;
import com.ibm.team.interop.common.IExternalProxyHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.internal.common.query.BaseTeamAreaQueryModel;
import com.ibm.team.repository.client.IContributorManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.LineDelimiter;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.query.ast.IString;
import com.ibm.team.repository.common.service.IQueryService;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.query.BaseWorkspaceQueryModel;
import java.io.File;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wvcm.Component;
import javax.wvcm.Configuration;
import javax.wvcm.ControllableResource;
import javax.wvcm.Feedback;
import javax.wvcm.Folder;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.PropertyRequestItem;
import javax.wvcm.ProviderFactory;
import javax.wvcm.Resource;
import javax.wvcm.ResourceList;
import javax.wvcm.Stream;
import javax.wvcm.Task;
import javax.wvcm.Version;
import javax.wvcm.VersionHistory;
import javax.wvcm.Workspace;
import javax.wvcm.WvcmException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JzProvider
extends SrvcProvider {
    public static final String EMPTY_STRING = new String();
    public static final String UNDERSCORE = String.valueOf('_');
    public static final String COMMA = String.valueOf(',');
    public static final String SPACE = String.valueOf(' ');
    public static final String COMMA_SPACE = String.valueOf(COMMA) + SPACE;
    public static final String DASH_DASH = "--";
    public static final String DOUBLE_QUOTE = String.valueOf('\"');
    public static final String FALSE = "false";
    public static final String TRUE = "true";
    public static final String COMMAND_STRING = "cccToolsCommand";
    public static final String WINDOWS = "windows";
    public static final PropertyNameList.PropertyName<String> PN_TASK_ID = new PropertyNameList.PropertyName("com.ibm.team.interop", "TASK_ID");
    private static final String IA_TEMPLATE_ID_NAME = String.valueOf(InteropStream.IA_PREFIX) + "WORKITEM_TEMPLATE_ID";
    private static final String OLD_DEFAULT_TEMPLATE_ID = "do not use a template for workitem creation";
    private static final String IA_SYNC_VIA_BUILD = String.valueOf(InteropStream.IA_PREFIX) + "SYNC_VIA_BUILD";
    private static final String DEFAULT_SYNC_VIA_BUILD = "true";
    public static final String SYNC_USER_ID_BASENAME = "SYNC_USER_ID";
    public static final String IA_SYNC_USER_ID = String.valueOf(InteropStream.IA_PREFIX) + "SYNC_USER_ID";
    public static final String DEFAULT_SYNC_USER_ID = "ccsync";
    public static final String IA_TEAM_AREA_PATH = String.valueOf(InteropStream.IA_PREFIX) + "TEAM_AREA_PATH";
    private static final String IA_DEFAULT_COMPONENT_RI = "defaultComponentRI";
    private static final String IA_BUILD_DEF_LOC_STR = String.valueOf(InteropStream.IA_PREFIX) + "BUILD_DEF_LOC_STR";
    public static final String IA_BUILD_ENGINE_NAME = String.valueOf(InteropStream.IA_PREFIX) + "BUILD_ENGINE_NAME";
    public static final String IA_BUILD_KIND = String.valueOf(InteropStream.IA_PREFIX) + "BUILD_KIND";
    public static final String IA_REPOSITORY_URI = String.valueOf(InteropStream.IA_PREFIX) + "REPOSITORY_URI";
    public static final String IA_BUILD_CLI_PATH = String.valueOf(InteropStream.IA_PREFIX) + "CLI_PATH";
    public static final String IA_INSTALL_LOCATION_BASENAME = "INSTALL_LOCATION";
    public static final String IA_INSTALL_PATH = String.valueOf(InteropStream.IA_PREFIX) + "INSTALL_LOCATION";
    public static final String IA_SLEEP_TIME = String.valueOf(InteropStream.IA_PREFIX) + "BUILD_ENGINE_SLEEP_TIME";
    public static final String IA_SYNC_HOST = String.valueOf(InteropStream.IA_PREFIX) + "SYNC_HOST";
    public static final String IA_SCRIPT_LOCATION_PREFIX_BASENAME = "SCRIPT_LOCATION_PREFIX";
    public static final String IA_SCRIPT_LOCATION_PREFIX = String.valueOf(InteropStream.IA_PREFIX) + "SCRIPT_LOCATION_PREFIX";
    public static final String IA_ALLOW_MOD_MOD_MERGE = String.valueOf(InteropStream.IA_PREFIX) + "ALLOW_MOD_MOD_MERGE";
    public static final BuildKind DEFAULT_BUILD_KIND = BuildKind.ANT;
    public static final String BUILD_CLI_PATH_DEFAULT = "eclipse" + File.separator + "scm";
    public static final String IA_MAX_CONTENT_COMMIT_DEFERRAL_MILLIS = String.valueOf(InteropStream.IA_PREFIX) + "DEFER_CONTENT_OPS";
    public static final String DEFAULT_SLEEP_TIME = "120";
    public static final String DEFAULT_IGNORE_TASK_CREATION_FAILURE = "false";
    public static final String DEFAULT_SCRIPT_LOCATION_PREFIX = JzProvider.myToString(File.separator, System.getProperty("user.home"), "ClearCaseConnector");
    private static final Long MILLIS_PER_MINUTE = new Long(60000L);
    private static final Long DEFAULT_MAX_COMMIT_LAG = 5L * MILLIS_PER_MINUTE;
    public static SimpleDateFormat timeFormatter = new SimpleDateFormat("HH.mm.ss");
    private ITeamRepository _jazzRepository;
    private Log _log = null;
    private OpsForAllConfigurations deferrals = new OpsForAllConfigurations();

    public JzProvider() {
    }

    public JzProvider(ProviderFactory.Callback callback, Map<String, String> args) throws WvcmException {
        this();
        this.initialize(args, callback);
    }

    public void initialize(Map<String, String> args, ProviderFactory.Callback callback) throws WvcmException {
        args.put("com.ibm.rational.wvcm.DISPLAYNAME", "Jazz");
        args.put("com.ibm.rational.wvcm.VERSION_KNOWS_PARENT", "true");
        if (args.get(InteropStream.IA_DESYNC) == null) {
            args.put(InteropStream.IA_DESYNC, EMPTY_STRING);
        }
        if (args.get(InteropStream.IA_NO_COMPONENT_ROOT_CLONE) == null) {
            args.put(InteropStream.IA_NO_COMPONENT_ROOT_CLONE, "true");
        }
        if (JzProvider.getTemplateId(args) == null) {
            JzProvider.setTemplateId(args, EMPTY_STRING);
        }
        if (JzProvider.getSyncViaBuild(args) == null) {
            JzProvider.setSyncViaBuild(args, "true");
        }
        if (JzProvider.getSyncUserId(args) == null) {
            this.setSyncUserIdToDefault(args);
        }
        if (JzProvider.getLineDelimiterString(args) == null) {
            JzProvider.setLineDelimiter(args, InteropStream.LINE_SEPARATOR_DEFAULT.name());
        }
        if (JzProvider.getBuildKind(args) == null) {
            JzProvider.setBuildKind(args, DEFAULT_BUILD_KIND);
        }
        if (this.getMaxContentCommitDeferralMillis(args) == null) {
            this.setMaxContentCommitDeferralMillis(args, DEFAULT_MAX_COMMIT_LAG.toString());
        }
        if (JzProvider.getBuildCliPath(args) == null) {
            this.setBuildCliPath(args, BUILD_CLI_PATH_DEFAULT);
        }
        if (JzProvider.getInstallLocation(args) == null) {
            this.setInstallLocation(args, EMPTY_STRING);
        }
        if (JzProvider.getBuildEngineSleepTime(args) == null) {
            this.setBuildEngineSleepTime(args, DEFAULT_SLEEP_TIME);
        }
        if (JzProvider.getSyncHost(args) == null) {
            JzProvider.setSyncHost(args, JzProvider.getHostname());
        }
        if (args.get("com.ibm.rational.wvcm.LOG_MINIMUM_DURATION") == null) {
            args.put("com.ibm.rational.wvcm.LOG_MINIMUM_DURATION", String.valueOf(300000));
        }
        if (args.get(InteropStream.IA_IGNORE_TASK_CREATION_FAILURE) == null) {
            args.put(InteropStream.IA_IGNORE_TASK_CREATION_FAILURE, "false");
        }
        if (!args.containsKey(IA_SCRIPT_LOCATION_PREFIX)) {
            args.put(IA_SCRIPT_LOCATION_PREFIX, DEFAULT_SCRIPT_LOCATION_PREFIX);
        }
        super.initialize(args, callback);
        String repoUriString = JzProvider.getRepositoryURI(args);
        if (!TeamPlatform.isStarted()) {
            TeamPlatform.startup();
        }
        this._jazzRepository = null;
        if (repoUriString == null) {
            throw new IllegalArgumentException("Repository URI String must not be null");
        }
        ITeamRepository teamRepository = TeamPlatform.getTeamRepositoryService().getTeamRepository(repoUriString, 4);
        if (teamRepository != null && teamRepository.loggedIn()) {
            this._jazzRepository = teamRepository;
        } else {
            ITeamRepository[] repos;
            ITeamRepository[] iTeamRepositoryArray = repos = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
            int n = repos.length;
            int n2 = 0;
            while (n2 < n) {
                ITeamRepository repo = iTeamRepositoryArray[n2];
                if (repo.loggedIn()) {
                    this._jazzRepository = repo;
                    break;
                }
                ++n2;
            }
        }
        if (this._jazzRepository == null) {
            throw new WvcmException(NLS.bind((String)Messages.JzProvider_ERROR_NO_CONNECTION_FOUND_FOR_URI, (Object[])new Object[]{repoUriString}), WvcmException.ReasonCode.CONFLICT);
        }
    }

    public static String getHostname() throws WvcmException {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new WvcmException(Messages.JzProvider_ERROR_COULD_NOT_GET_LOCAL_HOSTNAME, null, WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
        }
    }

    public static ITeamRepository doLogin(String repoUriString, String authLoginName, String authPassword) {
        try {
            return JzProvider.doLoginThrowsTRE(repoUriString, authLoginName, authPassword);
        }
        catch (TeamRepositoryException e) {
            throw new RuntimeException("login failed", e);
        }
    }

    public static ITeamRepository doLoginThrowsTRE(String repoUriString, final String authLoginName, final String authPassword) throws TeamRepositoryException {
        if (!TeamPlatform.isStarted()) {
            TeamPlatform.startup();
        }
        ITeamRepositoryService teamRepositoryService = TeamPlatform.getTeamRepositoryService();
        ITeamRepository result = teamRepositoryService.getTeamRepository(repoUriString, 2);
        result.registerLoginHandler(new ITeamRepository.ILoginHandler(){

            public ITeamRepository.ILoginHandler.ILoginInfo challenge(ITeamRepository repo) {
                return new ITeamRepository.ILoginHandler.ILoginInfo(){

                    public String getPassword() {
                        return authPassword;
                    }

                    public String getUserId() {
                        return authLoginName;
                    }
                };
            }
        });
        result.login(null);
        teamRepositoryService.addTeamRepository(result);
        return result;
    }

    public ResourceList<Folder> activityFolderList(PropertyRequestItem.PropertyRequest propertyRequest) throws WvcmException {
        throw new WvcmException("activityFolderList is NYI", WvcmException.ReasonCode.FORBIDDEN);
    }

    public SrvcResource doBaselineControl(Location location, Location baselineLoc, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        throw new JzRepoNYIException((Object)this, "doBaselineControl", location);
    }

    public SrvcResource doCreateActivity(Location location, boolean isStream, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        throw new JzRepoNYIException((Object)this, "doCreateActivity", location);
    }

    public SrvcResource doCreateControllableFolder(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        return JzRepoControllableFolder.doCreateResource(this, JzLocation.create(location), updates, updated, feedback);
    }

    public SrvcResource doCreateControllableResource(Location genericLocation, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        return JzRepoControllableResource.doCreateControllableResource(this, JzLocation.create(genericLocation), updates, updated, feedback);
    }

    public SrvcResource doCreateControllableSymbolicLink(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        return JzRepoSymbolicLink.doCreateSymbolicLink(this, JzLocation.create(location), updates, updated, feedback);
    }

    public SrvcResource doCreateGeneratedActivity(Location location, boolean isStream, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        if (isStream) {
            return JzRepoStream.doCreateGeneratedResource(this, JzLocation.create(location), updates, updated, feedback);
        }
        return JzRepoChangeSet.doCreateGeneratedResource(this, JzLocation.create(location), updates, updated, feedback);
    }

    public SrvcResource doCreateGeneratedWorkspace(Location locationHint, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        return JzRepoWorkspace.doCreateGeneratedWorkspace(this, JzLocation.create(locationHint), updates, updated, feedback);
    }

    public SrvcResource doCreateVersionControlledResource(Location location, Location versionLoc, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        return JzRepoControllableFolder.doCreateVersionControlledResource(this, location, versionLoc, updates, updated, feedback);
    }

    public SrvcResource doBaselineControl(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        SrvcResource folder = this.lookup(location, feedback);
        if (folder != null) {
            if (folder instanceof JzRepoBaselineControlledFolder) {
                return folder;
            }
            throw new WvcmException("Must be a controllable folder", WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
        }
        return this.doCreateControllableFolder(location, updates, updated, feedback);
    }

    public SrvcResource doCreateBaselineControlledFolder(Location location, Location baselineLoc, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        return JzRepoControllableFolder.doCreateBaselineControlledFolder(this, location, baselineLoc, updates, updated, feedback);
    }

    public SrvcResource doCreateWorkspace(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        return JzRepoWorkspace.doCreateResource(this, JzLocation.create(location), updates, updated, feedback);
    }

    public SrvcResource doCreateGeneratedTask(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        return JzRepoWorkItem.doCreateGeneratedResource(this, JzLocation.create(location), updates, updated, feedback);
    }

    public List<Object> doFind(Resource query, PropertyRequestItem.PropertyRequest propertyRequest, boolean all, SrvcFeedback feedback) throws WvcmException {
        Object compNameVal;
        Object requestedIdVal;
        List<Object> result = Collections.emptyList();
        if (query instanceof Task && (requestedIdVal = query.lookupProperty(PN_TASK_ID)) instanceof String) {
            String requestedId = (String)requestedIdVal;
            JzRepoWorkItem requestedItem = JzRepoWorkItem.lookupById(this, requestedId, feedback);
            Task resultEntry = (Task)requestedItem.buildProxy(propertyRequest, feedback);
            result = new ArrayList<Object>(1);
            result.add(resultEntry);
            return result;
        }
        if (query instanceof Component && (compNameVal = query.lookupProperty(Component.DISPLAY_NAME)) instanceof String) {
            String compName = (String)compNameVal;
            JzLocation compLoc = JzLocation.createComponentNameLocation(compName);
            SrvcResource comp = this.lookup(compLoc, feedback);
            if (comp != null) {
                ResourceImpl compImpl = comp.buildProxy(propertyRequest, feedback);
                result = Collections.singletonList(compImpl);
            }
            return result;
        }
        if (query instanceof VersionHistory || query instanceof Task || query instanceof Component) {
            return this.doFindClone(query, propertyRequest, all, feedback);
        }
        if (query instanceof Stream) {
            return this.doFindStream((Stream)query, propertyRequest, all, feedback);
        }
        if (query instanceof Version) {
            return this.doFindVersionInWorkspace((Version)query, propertyRequest, all, feedback);
        }
        if (query instanceof Configuration) {
            Configuration confQuery = (Configuration)query;
            Component queryComp = (Component)confQuery.getVersionHistory();
            JzLocation compLoc = JzLocation.create(queryComp.getPathnameLocation());
            JzLocation wsLoc = JzLocation.create(confQuery.getWorkspace().getPathnameLocation());
            JzRepoWorkspace jzWS = new JzRepoWorkspace(this, wsLoc);
            IConfiguration conf = jzWS.lookupConfiguration(compLoc);
            if (conf != null) {
                result = new ArrayList<Object>(1);
                JzLocation configLoc = JzLocation.createConfigurationLoc(wsLoc, compLoc);
                Configuration crProxy = (Configuration)this.buildProxy(configLoc, propertyRequest, feedback);
                result.add(crProxy);
            }
            return result;
        }
        if (query instanceof ControllableResource) {
            JzLocation wsLoc;
            JzRepoWorkspace jzWS;
            ControllableResource crQuery = (ControllableResource)query;
            VersionHistory queryVh = crQuery.getVersionHistory();
            Location vhLoc = queryVh.getPathnameLocation();
            JzRepoVersionHistory jzV = (JzRepoVersionHistory)this.lookup(vhLoc, feedback);
            JzRepoControllableResource cr = jzV.createControllableResource(jzWS = new JzRepoWorkspace(this, wsLoc = JzLocation.create(crQuery.getWorkspace().getPathnameLocation())));
            if (cr != null) {
                result = new ArrayList<Object>(1);
                ControllableResource crProxy = (ControllableResource)this.buildProxy(cr.getLocation(), propertyRequest, feedback);
                result.add(crProxy);
            }
            return result;
        }
        throw new WvcmException("Unhandled query", WvcmException.ReasonCode.FORBIDDEN);
    }

    private List<Object> doFindVersionInWorkspace(Version query, PropertyRequestItem.PropertyRequest propertyRequest, boolean all, SrvcFeedback feedback) throws WvcmException {
        ArrayList<Object> results = new ArrayList<Object>(1);
        ResourceList workspaceQueryList = query.getInWorkspaceList();
        JzLocation workspaceLoc = JzLocation.create(((Workspace)workspaceQueryList.get(0)).getPathnameLocation());
        JzRepoWorkspace workspace = (JzRepoWorkspace)this.lookup(workspaceLoc, feedback);
        VersionHistory vhQuery = query.getVersionHistory();
        JzLocation vhLoc = JzLocation.create(vhQuery.getPathnameLocation());
        JzRepoVersionHistory vh = (JzRepoVersionHistory)this.lookup(vhLoc, feedback);
        JzRepoVersion resultVersion = JzRepoWorkspace.locateByHistory(this, workspace.getConnection(), vh);
        if (resultVersion != null) {
            Version result = (Version)resultVersion.buildProxy(propertyRequest, workspace, feedback);
            results.add(result);
        }
        return results;
    }

    private List<Object> doFindClone(Resource query, PropertyRequestItem.PropertyRequest propertyRequest, boolean all, SrvcFeedback feedback) throws WvcmException {
        JzLocation resultLoc;
        JzRepoWorkItem resultWI;
        ArrayList<Object> result = new ArrayList<Object>(1);
        String cloneValue = (String)query.getProperty(InteropStream.PN_CLONE);
        IItemHandle foundItem = JzRepoResource.lookupByCloneValue(this, InteropStream.PN_CLONE, cloneValue);
        if (foundItem == null) {
            result.add(null);
        } else if (query instanceof Component) {
            JzRepoComponent comp = JzRepoComponent.create((IComponentHandle)foundItem, this);
            if (comp != null) {
                Component resultEntry = (Component)comp.buildProxy(propertyRequest, feedback);
                result.add(resultEntry);
            }
        } else if (query instanceof VersionHistory) {
            result.add(this.createVersionHistory((IVersionableHandle)foundItem, propertyRequest, feedback));
        } else if (query instanceof Task && (resultWI = (JzRepoWorkItem)this.lookup(resultLoc = JzLocation.createWorkItemLoc(JzRepoResource.getCurrentStateDisplayName(foundItem)), feedback)) != null) {
            Task resultEntry = (Task)resultWI.buildProxy(propertyRequest, feedback);
            result.add(resultEntry);
        }
        return result;
    }

    private Resource createVersionHistory(IVersionableHandle versionableHandle, PropertyRequestItem.PropertyRequest propertyRequest, SrvcFeedback feedback) throws WvcmException {
        VersionHistory result = null;
        JzRepoVersionHistory vh = JzRepoVersionHistory.create(this, versionableHandle, feedback);
        if (vh != null) {
            result = (VersionHistory)vh.buildProxy(propertyRequest, feedback);
        }
        return result;
    }

    private List<Object> doFindStream(Stream query, PropertyRequestItem.PropertyRequest propertyRequest, boolean all, SrvcFeedback feedback) throws WvcmException {
        ArrayList<Object> results = new ArrayList<Object>();
        if (!all) {
            throw new WvcmException("doFindStream NYI when all is false", WvcmException.ReasonCode.FORBIDDEN);
        }
        ITeamAreaHandle teamAreaHandle = this.lookupTeamAreaHandle();
        if (teamAreaHandle == null) {
            throw new IllegalArgumentException(Messages.JzProvider_ERROR_TEAM_AREA_HANDLE_NULL);
        }
        List<String> streamDisplayNames = this.findAllStreamDisplayNames(teamAreaHandle);
        for (String displayName : streamDisplayNames) {
            JzLocation streamLoc = JzLocation.createStreamLoc(displayName);
            Stream stream = (Stream)this.buildProxy(streamLoc, propertyRequest, feedback);
            results.add(stream);
        }
        return results;
    }

    private List<String> findAllStreamDisplayNames(ITeamAreaHandle teamAreaHandle) throws WvcmException {
        try {
            ITeamRepository teamRepository = this.getRepo();
            IClientLibraryContext context = (IClientLibraryContext)teamRepository;
            IQueryService qs = (IQueryService)context.getServiceInterface(IQueryService.class);
            if (qs == null) {
                throw new WvcmException(Messages.JzProvider_ERROR_COULD_NOT_GET_QUERY_SERVER, WvcmException.ReasonCode.FORBIDDEN);
            }
            BaseWorkspaceQueryModel.WorkspaceQueryModel wqm = BaseWorkspaceQueryModel.WorkspaceQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)wqm);
            query.filter(wqm.stream()._eq(Boolean.TRUE));
            query.filter(wqm.owner()._eq(query.newItemHandleArg()));
            IItemQueryPage page = qs.queryItems(query, new Object[]{teamAreaHandle}, 75);
            ArrayList items = new ArrayList(page.getResultSize());
            items.addAll(page.getItemHandles());
            while (page.hasNext()) {
                page = (IItemQueryPage)qs.fetchPage(page.getToken(), page.getNextStartPosition(), 75);
                items.addAll(page.getItemHandles());
            }
            ArrayList<String> results = new ArrayList<String>(items.size());
            for (IItemHandle itemHandle : items) {
                results.add(JzRepoResource.getCurrentStateDisplayName(itemHandle));
            }
            return results;
        }
        catch (TeamRepositoryException e) {
            throw new WvcmException("find all stream query failed", null, WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
        }
    }

    public IProgressMonitor getMonitor() {
        return null;
    }

    public ITeamRepository getRepo() {
        return this._jazzRepository;
    }

    public String lookupTeamAreaPathInitArg() {
        return JzProvider.getTeamAreaPath(this._initArgs);
    }

    public static String getTeamAreaPath(Map<String, String> args) {
        String result = args.get(IA_TEAM_AREA_PATH);
        if (result != null) {
            return result;
        }
        return args.get("teamAreaPath");
    }

    public static void setTeamAreaPathInitArg(Map<String, String> args, String path) {
        args.put(IA_TEAM_AREA_PATH, path);
    }

    public Location location(String string) throws WvcmException {
        return new JzLocation(string);
    }

    public SrvcResource lookup(Location genericLocation, SrvcFeedback feedback) {
        if (genericLocation == null) {
            return null;
        }
        JzLocation loc = JzLocation.create(genericLocation);
        JzRepoResource result = null;
        JzLocation.Kind kind = loc.kind();
        switch (kind) {
            case Baseline: {
                result = JzRepoBaseline.lookup(this, loc);
                break;
            }
            case BaselineControlledFolder: {
                result = JzRepoBaselineControlledFolder.lookup(this, loc);
                break;
            }
            case ChangeSet: {
                result = JzRepoChangeSet.lookup(this, loc);
                break;
            }
            case ControllableFolder: 
            case ControllableResource: 
            case FileSysPath: {
                result = JzRepoControllableResource.lookup(this, loc, feedback);
                break;
            }
            case Component: {
                result = JzRepoComponent.lookup(this, loc);
                break;
            }
            case Configuration: {
                result = JzRepoConfiguration.lookup(this, loc);
                break;
            }
            case Pathname: {
                result = this.lookupByPathname(loc, feedback);
                break;
            }
            case RootVersion: {
                result = new JzRepoRootVersion(this, loc);
                break;
            }
            case RootBaseline: {
                result = new JzRepoRootBaseline(this, loc);
                break;
            }
            case Stream: {
                result = JzRepoStream.lookup(this, loc);
                break;
            }
            case Version: {
                result = this.resolveVersion(loc);
                break;
            }
            case VersionHistory: {
                result = JzRepoVersionHistory.lookup(this, loc);
                break;
            }
            case Workspace: {
                result = JzRepoWorkspace.lookup(this, loc);
                break;
            }
            case WorkItem: {
                result = JzRepoWorkItem.lookup(this, loc);
            }
        }
        return result;
    }

    private SrvcResource lookupByPathname(JzLocation loc, SrvcFeedback feedback) {
        SrvcResource result = null;
        try {
            String wsUuid;
            JzRepoWorkspace ws;
            String pathKind;
            ArrayList segments = new ArrayList(Arrays.asList(loc.getPath()));
            if (segments.size() > 2 && (pathKind = (String)segments.remove(0)).equalsIgnoreCase(JzLocation.kindWorkspaceString) && (ws = JzRepoWorkspace.lookupByPathname(this, wsUuid = (String)segments.remove(0))) != null) {
                JzLocation resultLoc = ws.getLocation();
                for (String segment : segments) {
                    resultLoc = resultLoc.child(segment);
                }
                result = this.lookup(resultLoc, feedback);
            }
        }
        catch (WvcmException e) {
            this.logIgnoredException("lookupByPathname", (Exception)((Object)e));
        }
        return result;
    }

    public JzRepoResource resolveVersion(JzLocation loc) {
        JzRepoVersion result;
        block3: {
            result = null;
            try {
                IVersionableHandle h = (IVersionableHandle)JzRepoResource.getItemHandle(this, loc);
                if (h != null) {
                    result = JzRepoVersion.createAppropriateProxy(this, loc, (IItemHandle)h);
                }
            }
            catch (Throwable e) {
                if (!(e instanceof Exception)) break block3;
                this.logIgnoredException("resolveVersion", (Exception)e);
            }
        }
        return result;
    }

    public ResourceList<Folder> workspaceFolderList(PropertyRequestItem.PropertyRequest propertyRequest) {
        ResourceList resList = this.resourceList((Resource[])new Folder[0]);
        resList.add((Object)this.folder(JzLocation.workspaceFolderList()));
        return resList;
    }

    public Location rootLocation() {
        return JzLocation.root();
    }

    public Location relativeRootLocation() {
        return JzLocation.relativeRoot();
    }

    public ITeamAreaHandle lookupTeamAreaHandle() throws WvcmException {
        ITeamAreaHandle result = null;
        String teamAreaPath = this.lookupTeamAreaPathInitArg();
        if (teamAreaPath != null) {
            try {
                result = (ITeamAreaHandle)JzRepoResource.lookupItemHandle(this, new URI(teamAreaPath));
            }
            catch (URISyntaxException e) {
                throw new WvcmException("lookupTeamAreaByPath: " + teamAreaPath, null, WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
            }
        } else {
            result = JzProvider.lookupTeamArea("Interop SCM", this.getRepo());
        }
        return result;
    }

    public static ITeamAreaHandle lookupTeamArea(String teamAreaName, ITeamRepository teamRepository) throws WvcmException {
        Object[] queryParameterValues = new Object[]{teamAreaName};
        BaseTeamAreaQueryModel.TeamAreaQueryModel teamModel = BaseTeamAreaQueryModel.TeamAreaQueryModel.ROOT;
        IItemQuery teamQuery = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)teamModel);
        teamQuery.filter(teamModel.name()._eq((IString)teamQuery.newStringArg()));
        IClientLibraryContext context = (IClientLibraryContext)teamRepository;
        IQueryService qs = (IQueryService)context.getServiceInterface(IQueryService.class);
        if (qs == null) {
            throw new WvcmException(Messages.JzProvider_ERROR_COULD_NOT_GET_QUERY_SERVER, WvcmException.ReasonCode.FORBIDDEN);
        }
        ITeamAreaHandle result = null;
        try {
            IItemQueryPage page = qs.queryItems(teamQuery, queryParameterValues, 1);
            ArrayList items = new ArrayList(page.getItemHandles());
            if (items.size() > 0) {
                result = (ITeamAreaHandle)items.get(0);
            }
        }
        catch (TeamRepositoryException e) {
            e.printStackTrace();
        }
        return result;
    }

    private Log getLog() {
        if (this._log == null) {
            this._log = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());
        }
        return this._log;
    }

    public boolean isDebugLogEnabled() {
        return this.getLog().isDebugEnabled();
    }

    public void logCreation(String objectKind, JzLocation requestedLocation, String resourceIdentifer, String otherInfo) {
        if (this.isDebugLogEnabled()) {
            this.logDebug("created " + objectKind + "at requested location: " + requestedLocation.string() + " with resource Id: " + resourceIdentifer + " " + otherInfo);
        }
    }

    public void logCreation(String objectKind, JzLocation objectLocation) {
        if (this.isDebugLogEnabled()) {
            this.logDebug("created " + objectKind + " with location: " + objectLocation.string());
        }
    }

    public void logInfo(String msg) {
        this.getLog().info((Object)msg);
    }

    public void logDebug(String msg) {
        this.getLog().debug((Object)msg);
    }

    public void logIgnoredException(String methodName, Exception e) {
        this.logInfo("method: " + methodName + " is ignoring exception: " + e.getMessage());
    }

    public IProjectAreaHandle getProjectArea() throws WvcmException {
        ITeamArea a = this.getTeamArea();
        return a.getProjectArea();
    }

    public ITeamArea getTeamArea() throws WvcmException {
        ITeamAreaHandle h = this.lookupTeamAreaHandle();
        if (h == null) {
            throw new IllegalStateException("Could not get team area handle from JzProvider initArgs");
        }
        ITeamRepository repo = this.getRepo();
        IProgressMonitor monitor = this.getMonitor();
        try {
            ITeamArea result = (ITeamArea)repo.itemManager().fetchCompleteItem((IItemHandle)h, 0, monitor);
            return result;
        }
        catch (TeamRepositoryException e) {
            throw new WvcmException("could not get team area", null, WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
        }
    }

    public String setDefaultComponentRI(String value) {
        return this._initArgs.put(IA_DEFAULT_COMPONENT_RI, value);
    }

    public String getDefaultComponentRI() {
        return (String)this._initArgs.get(IA_DEFAULT_COMPONENT_RI);
    }

    public static void setTemplateId(Map<String, String> args, String templateId) {
        args.put(IA_TEMPLATE_ID_NAME, templateId);
    }

    private static String getTemplateId(Map<String, String> args) {
        return args.get(IA_TEMPLATE_ID_NAME);
    }

    public String getTemplateId() {
        return JzProvider.getTemplateId(this._initArgs);
    }

    public boolean templateIdHasInitialValue() {
        return this.getTemplateId().equals(OLD_DEFAULT_TEMPLATE_ID) || this.getTemplateId().length() == 0;
    }

    public static String getSyncViaBuild(Map<String, String> args) {
        return args.get(IA_SYNC_VIA_BUILD);
    }

    public String getSyncViaBuild() {
        return JzProvider.getSyncViaBuild(this._initArgs);
    }

    public static void setSyncViaBuild(Map<String, String> args, String value) {
        args.put(IA_SYNC_VIA_BUILD, value);
    }

    public static String getRepositoryURI(Map<String, String> args) {
        String result = args.get(IA_REPOSITORY_URI);
        if (result != null) {
            return result;
        }
        return args.get("RepositoryURI");
    }

    public static String getSyncUserId(Map<String, String> args) {
        return args.get(IA_SYNC_USER_ID);
    }

    public String getSyncUserId() {
        return JzProvider.getSyncUserId(this._initArgs);
    }

    public static void setSyncUserId(Map<String, String> args, String value) {
        args.put(IA_SYNC_USER_ID, value);
    }

    private void setSyncUserIdToDefault(Map<String, String> args) {
        String systemSyncUserIdString = System.getProperty(IA_SYNC_USER_ID);
        String idString = systemSyncUserIdString != null ? systemSyncUserIdString : DEFAULT_SYNC_USER_ID;
        JzProvider.setSyncUserId(args, idString);
    }

    public String lookupBuildDefinitionLocationString() {
        return (String)this._initArgs.get(IA_BUILD_DEF_LOC_STR);
    }

    public void setBuildDefinitionLocationString(String locString) {
        this._initArgs.put(IA_BUILD_DEF_LOC_STR, locString);
    }

    public static String lookupBuildEngineName(Map<String, String> args) {
        return args.get(IA_BUILD_ENGINE_NAME);
    }

    public String lookupBuildEngineBasename() {
        return JzProvider.lookupBuildEngineName(this._initArgs);
    }

    public static void setBuildEngineName(Map<String, String> args, String name) {
        if (name == null) {
            args.remove(IA_BUILD_ENGINE_NAME);
        } else {
            args.put(IA_BUILD_ENGINE_NAME, name);
        }
    }

    public void setBuildEngineName(String name) {
        JzProvider.setBuildEngineName(this._initArgs, name);
    }

    public void setInstallLocation(Map<String, String> args, String path) {
        args.put(IA_INSTALL_PATH, path);
    }

    public void setInstallLocation(String path) {
        this.setInstallLocation(this._initArgs, path);
    }

    public static String getInstallLocation(Map<String, String> args) {
        return args.get(IA_INSTALL_PATH);
    }

    public String getInstallLocation() {
        String installLocationValue = JzProvider.getInstallLocation(this._initArgs);
        if (installLocationValue == null) {
            throw new IllegalStateException(NLS.bind((String)Messages.JzProvider_ERROR_INSTALL_PATH_PROP_MUST_BE_NON_NULL_WITH_PROPNAME, (Object[])new Object[]{IA_INSTALL_PATH}));
        }
        return installLocationValue;
    }

    public void setBuildEngineSleepTime(String sleepTimeString) {
        this.setBuildEngineSleepTime(this._initArgs, sleepTimeString);
    }

    public void setBuildEngineSleepTime(Map<String, String> args, String sleepTimeString) {
        args.put(IA_SLEEP_TIME, sleepTimeString);
    }

    public String getBuildEngineSleepTime() {
        return JzProvider.getBuildEngineSleepTime(this._initArgs);
    }

    public static String getBuildEngineSleepTime(Map<String, String> args) {
        return args.get(IA_SLEEP_TIME);
    }

    public static void setSyncHost(Map<String, String> args, String hostname) {
        args.put(IA_SYNC_HOST, hostname);
    }

    public void setSyncHost(String hostname) {
        JzProvider.setSyncHost(this._initArgs, hostname);
    }

    public static String getSyncHost(Map<String, String> args) {
        return args.get(IA_SYNC_HOST);
    }

    public String getSyncHost() {
        return JzProvider.getSyncHost(this._initArgs);
    }

    public String getScriptLocationPrefix() {
        return JzProvider.getScriptLocationPrefix(this._initArgs);
    }

    public static String getScriptLocationPrefix(Map<String, String> args) {
        return args.get(IA_SCRIPT_LOCATION_PREFIX);
    }

    public void forEachExternalProxyWithTargetItemAndUri(IVisitCloneExternalProxy visitor) throws WvcmException {
        IProgressMonitor monitor = this.getMonitor();
        IInteropManager interopManager = (IInteropManager)this.getRepo().getClientLibrary(IInteropManager.class);
        try {
            IExternalProxyHandle[] externalProxyHandles;
            IExternalProxyHandle[] iExternalProxyHandleArray = externalProxyHandles = interopManager.findProxiesBySyncRule(null, monitor);
            int n = externalProxyHandles.length;
            int n2 = 0;
            while (n2 < n) {
                boolean continueOn;
                IExternalProxyHandle externalProxyHandle = iExternalProxyHandleArray[n2];
                URI otherUri = interopManager.getUri(externalProxyHandle, monitor);
                IItemHandle thisItem = interopManager.getTargetItem(externalProxyHandle, monitor);
                if (otherUri == null || thisItem == null || !CcConnectorUtils.CLONED_ITEM_TYPES.contains(thisItem.getItemType()) || (continueOn = visitor.visit(externalProxyHandle, thisItem, otherUri))) {
                    ++n2;
                    continue;
                }
                break;
            }
        }
        catch (TeamRepositoryException e) {
            throw new WvcmException("forEachExternalProxyWithTargetItemAndUri", null, WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
        }
    }

    private static String getLineDelimiterString(Map<String, String> args) {
        return args.get(InteropStream.IA_LINE_SEPARATOR);
    }

    public LineDelimiter getLineDelimiter() {
        LineDelimiter result;
        String value = JzProvider.getLineDelimiterString(this._initArgs);
        try {
            result = LineDelimiter.valueOf((String)("LINE_DELIMITER_" + value));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            result = LineDelimiter.valueOf((String)value);
        }
        return result;
    }

    public static void setLineDelimiter(Map<String, String> args, String value) {
        args.put(InteropStream.IA_LINE_SEPARATOR, value);
    }

    public static String getBuildKindValue(Map<String, String> args) {
        String value = args.get(IA_BUILD_KIND);
        return value;
    }

    public static BuildKind getBuildKind(Map<String, String> args) {
        String value = JzProvider.getBuildKindValue(args);
        BuildKind result = value == null ? null : BuildKind.valueOf(value);
        return result;
    }

    public BuildKind getBuildKind(BuildKind defaultBuildKind) {
        return JzProvider.getBuildKind(this._initArgs);
    }

    public static void setBuildKind(Map<String, String> args, BuildKind value) {
        args.put(IA_BUILD_KIND, value.name());
    }

    public static String getBuildCliPath(Map<String, String> args) {
        return args.get(IA_BUILD_CLI_PATH);
    }

    private void setBuildCliPath(Map<String, String> args, String value) {
        args.put(IA_BUILD_CLI_PATH, value);
    }

    public String getBuildCliPath() {
        return JzProvider.getBuildCliPath(this._initArgs);
    }

    public boolean allowModModMerge(Map<String, String> args) {
        String value = args.get(IA_ALLOW_MOD_MOD_MERGE);
        return Boolean.TRUE.toString().equalsIgnoreCase(value);
    }

    public boolean allowModModMerge() {
        return this.allowModModMerge(this._initArgs);
    }

    public static void setAllowModModMerge(Map<String, String> args, boolean boolValue) {
        args.put(IA_ALLOW_MOD_MOD_MERGE, boolValue ? "true" : "false");
    }

    private void setMaxContentCommitDeferralMillis(Map<String, String> args, String value) {
        args.put(IA_MAX_CONTENT_COMMIT_DEFERRAL_MILLIS, value);
    }

    private String getMaxContentCommitDeferralMillis(Map<String, String> args) {
        return args.get(IA_MAX_CONTENT_COMMIT_DEFERRAL_MILLIS);
    }

    public boolean areContentCommitsDeferred() {
        return this.getMaxCommitLag() > 0L;
    }

    private Long getMaxCommitLag() {
        Long result = new Long(0L);
        String value = this.getMaxContentCommitDeferralMillis(this._initArgs);
        try {
            result = Long.valueOf(value);
        }
        catch (NumberFormatException numberFormatException) {
            boolean oldValueCommitsAreDeferred = value != null && Boolean.valueOf(value) != false;
            result = oldValueCommitsAreDeferred ? DEFAULT_MAX_COMMIT_LAG : 0L;
        }
        return result;
    }

    public void deferOrCommitContentOp(JzRepoConfiguration wvcmConfiguration, IWorkspaceConnection.IConfigurationOp configOp, JzLocation location) throws WvcmException {
        Long timeOfFirstDeferredOp = this.deferrals.add(wvcmConfiguration, configOp, location);
        Long now = System.currentTimeMillis();
        Long ageOfFirstDeferredOp = now - timeOfFirstDeferredOp;
        if (ageOfFirstDeferredOp >= this.getMaxCommitLag()) {
            this.deferrals.applyDeferredContentCommits();
        }
    }

    public static String myToString(String separator, String ... parts) {
        if (parts == null) {
            return new String();
        }
        StringBuffer result = new StringBuffer();
        boolean needSep = false;
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String onePart = stringArray[n2];
            if (needSep) {
                result.append(separator);
            } else {
                needSep = true;
            }
            result.append(onePart);
            ++n2;
        }
        return result.toString();
    }

    public IContributor getContributor(String userId) throws WvcmException {
        try {
            IContributorManager s = this.getRepo().contributorManager();
            IContributor result = s.fetchContributorByUserId(userId, this.getMonitor());
            return result;
        }
        catch (TeamRepositoryException e) {
            throw new WvcmException(NLS.bind((String)Messages.JzProvider_ERROR_CONTRIBUTOR_NOT_FOUND, (Object[])new Object[]{userId}), null, JzRepoException.exceptionToReasonCode((Exception)((Object)e)), (Throwable)e);
        }
    }

    public List<Object> doFind(ResourceList<?> queries, PropertyRequestItem.PropertyRequest propertyRequest, SrvcFeedback feedback) throws WvcmException {
        BatchedQueryKind queryKind = BatchedQueryKind.UNOPTIMIZED;
        ArrayList<String> cloneValues = new ArrayList<String>(queries.size());
        ArrayList<ControllableResource> findCrQueries = new ArrayList<ControllableResource>(queries.size());
        for (Resource query : queries) {
            if (query instanceof VersionHistory) {
                if (BatchedQueryKind.UNOPTIMIZED.equals((Object)queryKind) || BatchedQueryKind.FIND_VH_CLONES.equals((Object)queryKind)) {
                    queryKind = BatchedQueryKind.FIND_VH_CLONES;
                    cloneValues.add((String)query.getProperty(InteropStream.PN_CLONE));
                    continue;
                }
                throw new IllegalStateException("found VersionHistory query after finding query kind : " + queryKind.name());
            }
            if (query instanceof ControllableResource) {
                if (BatchedQueryKind.UNOPTIMIZED.equals((Object)queryKind) || BatchedQueryKind.FIND_CR_IN_WORKSPACE.equals((Object)queryKind)) {
                    queryKind = BatchedQueryKind.FIND_CR_IN_WORKSPACE;
                    findCrQueries.add((ControllableResource)query);
                    continue;
                }
                throw new IllegalStateException("found ControllableResource query after finding query kind : " + queryKind.name());
            }
            if (BatchedQueryKind.UNOPTIMIZED.equals((Object)queryKind)) continue;
            throw new IllegalStateException("found unoptimized query after finding query kind : " + queryKind.name());
        }
        ArrayList<Object> results = new ArrayList<Object>(queries.size());
        switch (queryKind) {
            case FIND_VH_CLONES: {
                Map<String, IItemHandle> clones = JzRepoResource.lookupByManyCloneValue(this, null, cloneValues);
                for (String cloneValue : cloneValues) {
                    IItemHandle itemHandle = clones.get(cloneValue);
                    if (itemHandle == null) {
                        results.add(null);
                        continue;
                    }
                    try {
                        Resource vh = this.createVersionHistory((IVersionableHandle)itemHandle, propertyRequest, feedback);
                        results.add(vh);
                    }
                    catch (WvcmException e) {
                        throw new IllegalStateException(NLS.bind((String)"Could not create version history proxy whith itemId {0}, and clone value {1}", (Object[])new Object[]{JzRepoResource.getCurrentStateDisplayName(itemHandle), cloneValue}), e);
                    }
                }
                break;
            }
            case FIND_CR_IN_WORKSPACE: {
                List<JzRepoControllableResource> crs = JzRepoVersionHistory.computeControllableResources(this, findCrQueries, feedback);
                for (JzRepoControllableResource cr : crs) {
                    ControllableResource result = cr == null ? null : (ControllableResource)cr.buildProxy(propertyRequest, feedback);
                    results.add(result);
                }
                break;
            }
            default: {
                for (Resource query : queries) {
                    List<Object> oneResult = this.doFind(query, propertyRequest, false, feedback);
                    if (oneResult == null || oneResult.size() == 0) {
                        results.add(null);
                        continue;
                    }
                    results.add(oneResult.get(0));
                }
            }
        }
        return results;
    }

    public static IProgressMonitor getMonitor(Feedback feedback, int percentDone) {
        if (feedback != null && feedback instanceof FB) {
            return ((FB)feedback).getMonitor(percentDone);
        }
        return new NullProgressMonitor();
    }

    public static IProgressMonitor getMonitor(SrvcFeedback srvcFeedback, int percentDone) {
        if (srvcFeedback != null) {
            return JzProvider.getMonitor(srvcFeedback.get_feedback(), percentDone);
        }
        return new NullProgressMonitor();
    }

    public SrvcResource doWriteContent(Location location, InputStream input, String contentIdentifier, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        SrvcResource srvcResource = this.lookup(location, feedback);
        if (srvcResource == null) {
            srvcResource = JzRepoControllableResource.doCreateResourceWithContent(this, JzLocation.create(location), input, contentIdentifier, updates, updated, feedback);
        } else {
            srvcResource.doWriteContent(input, contentIdentifier, updates, updated, feedback);
        }
        return srvcResource;
    }

    public List<Object> doUpdateProperties(List<Location> locations, PropertyRequestItem.PropertyRequest propertyRequest, List<Map<PropertyNameList.PropertyName<?>, PropValue>> updatesList, List<List<PropertyNameList.PropertyName<?>>> updatedList, SrvcFeedback feedback) throws WvcmException {
        boolean requiresUnbatched = false;
        int count = locations.size();
        List<Object> results = new ArrayList<Object>(count);
        HashMap<JzRepoResource, String> sources2Values = new HashMap<JzRepoResource, String>();
        int i = 0;
        while (i < count) {
            Map<PropertyNameList.PropertyName<?>, PropValue> updates = updatesList.get(i);
            if (updates.size() > 0) {
                for (PropertyNameList.PropertyName<?> propertyName : updates.keySet()) {
                    if (InteropStream.PN_CLONE.equals(propertyName)) continue;
                    requiresUnbatched = true;
                    break;
                }
            } else {
                requiresUnbatched = true;
            }
            if (requiresUnbatched) break;
            JzRepoResource jrr = (JzRepoResource)this.lookup(locations.get(i), feedback);
            results.add((Object)jrr);
            PropValue propValue = updates.get(InteropStream.PN_CLONE);
            String value = (String)propValue.get_value();
            sources2Values.put(jrr, value);
            ++i;
        }
        if (requiresUnbatched) {
            results = super.doUpdateProperties(locations, propertyRequest, updatesList, updatedList, feedback);
        } else {
            JzRepoResource.storeInteropCloneValues(this, sources2Values, feedback);
        }
        return results;
    }

    public void applyDeferredContentCommits() throws WvcmException {
        this.deferrals.applyDeferredContentCommits();
    }

    public void applyDeferredContentCommits(JzRepoConfiguration config, JzLocation loc) throws WvcmException {
        this.deferrals.applyDeferredContentCommits(config, loc);
    }

    public void applyDeferredContentCommits(JzRepoConfiguration config) throws WvcmException {
        this.deferrals.applyDeferredContentCommits(config);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BatchedQueryKind {
        UNOPTIMIZED,
        FIND_VH_CLONES,
        FIND_CR_IN_WORKSPACE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BuildKind {
        ANT,
        CLI;

    }

    public static interface IVisitCloneExternalProxy {
        public boolean visit(IExternalProxyHandle var1, IItemHandle var2, URI var3) throws WvcmException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class OpsForAllConfigurations {
        private Map<JzRepoConfiguration, Map<JzLocation, IWorkspaceConnection.IConfigurationOp>> deferredContentOps = new HashMap<JzRepoConfiguration, Map<JzLocation, IWorkspaceConnection.IConfigurationOp>>();
        Long timeOfFirstDeferredOp = null;

        OpsForAllConfigurations() {
        }

        public Long add(JzRepoConfiguration wvcmConfiguration, IWorkspaceConnection.IConfigurationOp configOp, JzLocation location) {
            if (this.timeOfFirstDeferredOp == null) {
                this.timeOfFirstDeferredOp = System.currentTimeMillis();
            }
            if (!this.deferredContentOps.containsKey((Object)wvcmConfiguration)) {
                this.deferredContentOps.put(wvcmConfiguration, new HashMap());
            }
            Map<JzLocation, IWorkspaceConnection.IConfigurationOp> deferredOps = this.deferredContentOps.get((Object)wvcmConfiguration);
            deferredOps.put(location, configOp);
            return this.timeOfFirstDeferredOp;
        }

        public void applyDeferredContentCommits() throws WvcmException {
            Set<JzRepoConfiguration> configs = this.deferredContentOps.keySet();
            for (JzRepoConfiguration config : configs) {
                this.applyDeferredContentCommits(config);
            }
            this.timeOfFirstDeferredOp = null;
        }

        public void applyDeferredContentCommits(JzRepoConfiguration config) throws WvcmException {
            Map<JzLocation, IWorkspaceConnection.IConfigurationOp> commitThese = this.deferredContentOps.get((Object)config);
            if (commitThese != null) {
                this.commit(config, commitThese);
            }
        }

        private void commit(JzRepoConfiguration config, Map<JzLocation, IWorkspaceConnection.IConfigurationOp> commitThese) throws WvcmException {
            int count = commitThese.size();
            if (count > 0) {
                JzProvider.this.logDebug("committing deferred operations: " + String.valueOf(count));
                config.commit(commitThese);
                commitThese.clear();
            }
        }

        public void applyDeferredContentCommits(JzRepoConfiguration config, JzLocation loc) throws WvcmException {
            Map<JzLocation, IWorkspaceConnection.IConfigurationOp> commitThese = this.deferredContentOps.get((Object)config);
            if (commitThese != null && commitThese.containsKey(loc)) {
                config.commit(commitThese.get(loc), loc);
                commitThese.remove(loc);
            }
        }
    }
}

