/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.json.internal;

public class Token {
    public static final Token TokenEOF = new Token();
    public static final Token TokenBraceL = new Token();
    public static final Token TokenBraceR = new Token();
    public static final Token TokenBrackL = new Token();
    public static final Token TokenBrackR = new Token();
    public static final Token TokenColon = new Token();
    public static final Token TokenComma = new Token();
    public static final Token TokenTrue = new Token();
    public static final Token TokenFalse = new Token();
    public static final Token TokenNull = new Token();
    private String valueString;
    private Number valueNumber;

    public Token() {
    }

    public Token(String value) {
        this.valueString = value;
    }

    public Token(Number value) {
        this.valueNumber = value;
    }

    public String getString() {
        return this.valueString;
    }

    public Number getNumber() {
        return this.valueNumber;
    }

    public boolean isString() {
        return this.valueString != null;
    }

    public boolean isNumber() {
        return this.valueNumber != null;
    }

    public String toString() {
        if (this == TokenEOF) {
            return "Token: EOF";
        }
        if (this == TokenBraceL) {
            return "Token: {";
        }
        if (this == TokenBraceR) {
            return "Token: }";
        }
        if (this == TokenBrackL) {
            return "Token: [";
        }
        if (this == TokenBrackR) {
            return "Token: ]";
        }
        if (this == TokenColon) {
            return "Token: :";
        }
        if (this == TokenComma) {
            return "Token: ,";
        }
        if (this == TokenTrue) {
            return "Token: true";
        }
        if (this == TokenFalse) {
            return "Token: false";
        }
        if (this == TokenNull) {
            return "Token: null";
        }
        if (this.isNumber()) {
            return String.format("Token: Number - %s", this.getNumber().toString());
        }
        if (this.isString()) {
            return String.format("Token: String - \"%s\"", this.getString());
        }
        return "Token: unknown";
    }
}

