/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.CCaseObjInfo;
import com.ibm.rational.wvcm.ct.CTActivity;
import com.ibm.rational.wvcm.ct.CTBaseline;
import com.ibm.rational.wvcm.ct.CTLocation;
import com.ibm.rational.wvcm.ct.CTProvider;
import com.ibm.rational.wvcm.ct.CTView;
import com.ibm.rational.wvcm.ct.CommonUtils;
import com.ibm.rational.wvcm.ct.Messages;
import com.ibm.rational.wvcm.ct.ObjSelUtils;
import com.ibm.rational.wvcm.interop.InteropStream;
import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.impl.StreamImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wvcm.Activity;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.Stream;
import javax.wvcm.WvcmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CTStream
extends CTActivity {
    private static final String PROJECT_PREFIX = "project_";
    private Map<String, CCaseObjInfo> _blObjInfoCache = new HashMap<String, CCaseObjInfo>();

    CTStream(Location location, CTProvider provider) {
        super(location, provider);
    }

    @Override
    public Class<?> get_proxyClass() {
        return StreamImpl.class;
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    protected Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        CCaseLib cc = this.getProvider().getCCaseLib();
        if (propertyName.equals((Object)Activity.LATEST_VERSION_LIST)) {
            return this.doGetBaselines(feedback);
        }
        if (propertyName.equals((Object)Resource.PATHNAME_LOCATION)) {
            CCaseObjInfo ccInfo = this.getObjInfo(feedback);
            String vobUuidString = ccInfo.lookupVobUuid();
            if (vobUuidString == null) {
                throw new IllegalStateException("get pathname location property for location: " + this.getLocation().string() + " could not get VOB UUID");
            }
            String result = ObjSelUtils.formatSelector("stream", ccInfo.getPathName(), vobUuidString);
            return CTLocation.valueOf(CTLocation.Kind.STREAM, result);
        }
        if (propertyName.equals((Object)Resource.DISPLAY_NAME)) {
            return cc.getDisplayName(this.getLocation().getDisplayName(), feedback);
        }
        if (propertyName.equals(CTProvider.FULLY_QUALIFIED_DISPLAY_NAME)) {
            String dispName = this.getLocation().getDisplayName();
            return cc.getExtendedName(null, dispName, feedback);
        }
        if (propertyName.equals((Object)Stream.SOURCE_LIST)) {
            CTProvider p = (CTProvider)this.get_provider();
            String dispName = this.getLocation().getDisplayName();
            String FQName = cc.getExtendedName(null, dispName, feedback);
            List<CTLocation> locations = this.findUcmObjLocations(FQName, false, feedback);
            return p.getResources(locations, feedback);
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    @Override
    public void setPropertyFromClient(PropertyNameList.PropertyName<?> propertyName, Object value, boolean initialize, SrvcFeedback feedback) throws WvcmException {
        CCaseLib cc = this.getProvider().getCCaseLib();
        if (propertyName.equals((Object)InteropStream.PN_RESERVED_FOR_INTEROP)) {
            cc.lock(this.getUniversalSelector(feedback), feedback);
        }
        super.setPropertyFromClient(propertyName, value, initialize, feedback);
    }

    @Override
    public void removePropertyFromClient(PropertyNameList.PropertyName<?> propertyName, SrvcFeedback feedback) throws WvcmException {
        CCaseLib cc = this.getProvider().getCCaseLib();
        try {
            super.removePropertyFromClient(propertyName, feedback);
        }
        finally {
            if (propertyName.equals((Object)InteropStream.PN_RESERVED_FOR_INTEROP)) {
                cc.unlock(this.getUniversalSelector(feedback), feedback);
            }
        }
    }

    private CCaseObjInfo getBlObjInfo(String blName, SrvcFeedback feedback) throws WvcmException {
        CCaseObjInfo result;
        boolean foundInCache = this._blObjInfoCache.containsKey(blName);
        if (!foundInCache) {
            result = CCaseObjInfo.getObjInfo(this.getProvider().getCCaseLib(), blName, feedback);
            this._blObjInfoCache.put(blName, result);
        } else {
            result = this._blObjInfoCache.get(blName);
        }
        return result;
    }

    public List<CTBaseline> doGetBaselines(SrvcFeedback feedback) throws WvcmException {
        CTProvider provider = this.getProvider();
        CTLocation myLoc = this.getLocation();
        CCaseLib cc = provider.getCCaseLib();
        List<String> blNames = cc.getLatestRootedBaselines(myLoc.getDisplayName(), feedback);
        ArrayList<CTBaseline> latestBaselines = new ArrayList<CTBaseline>();
        for (String blName : blNames) {
            CCaseObjInfo blObjInfo = this.getBlObjInfo(blName, feedback);
            String blUniversalSelector = blObjInfo.getUniversalSelector();
            Location blLoc = provider.location(blUniversalSelector);
            CTBaseline bl = (CTBaseline)provider.lookup(blLoc, feedback);
            if (bl == null) {
                bl = new CTBaseline(blLoc, provider);
                feedback.setCacheEntry(blLoc, (SrvcResource)bl);
            }
            latestBaselines.add(bl);
        }
        return latestBaselines;
    }

    public static CTStream doCreateGeneratedResource(CTProvider provider, CTLocation locationHint, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        CCaseLib cc = provider.getCCaseLib();
        String streamName = locationHint.getDisplayName();
        PropValue targetStreamValue = updates != null ? updates.get(Stream.TARGET) : null;
        CTLocation targetStreamLoc = targetStreamValue != null ? (CTLocation)targetStreamValue.get_value() : null;
        String targetStreamLocString = targetStreamLoc != null ? targetStreamLoc.getDisplayName() : null;
        boolean isIntegration = false;
        if (targetStreamLocString == null) {
            isIntegration = true;
            String pVobTag = provider.getDefaultPvobTag();
            if (pVobTag == null) {
                String msg = feedback.format(Messages.CTStream_PVOB_UNKNOWN, new Object[]{streamName});
                throw new WvcmException(msg, WvcmException.ReasonCode.CONFLICT);
            }
            String projSel = ObjSelUtils.formatSelector("project", PROJECT_PREFIX + streamName + CommonUtils.uniquifier(), pVobTag);
            cc.makeProject(projSel, null, feedback);
            targetStreamLocString = projSel;
        }
        String streamSelector = cc.makeStream(targetStreamLocString, isIntegration, null, streamName, feedback);
        CTLocation streamLoc = (CTLocation)provider.location(streamSelector);
        CTStream result = new CTStream(streamLoc, provider);
        return result;
    }

    public <T extends SrvcResource> void doUpdate(List<T> sources, SrvcFeedback feedback) throws WvcmException {
        CTProvider provider = this.getProvider();
        CCaseLib cc = provider.getCCaseLib();
        String streamSel = this.getUniversalSelector(feedback);
        for (T source : sources) {
            if (source instanceof CTView) {
                String viewStreamSel = ((CTView)((Object)source)).getStreamSelector(feedback);
                if (!cc.equalObjSels(streamSel, viewStreamSel, feedback)) {
                    throw new IllegalArgumentException("View/stream mismatch");
                }
                this.flush(feedback);
                continue;
            }
            throw new IllegalArgumentException("Source is not a view");
        }
    }

    public void doUnbindAll(SrvcFeedback feedback) throws WvcmException {
        CTProvider provider = this.getProvider();
        CCaseLib cc = provider.getCCaseLib();
        String streamSel = cc.getExtendedName(null, this.getUniversalSelector(feedback), feedback);
        cc.removeStream(streamSel, feedback);
        this.flush(feedback);
    }
}

