/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.CCaseElemInfo;
import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.CCaseObjInfo;
import com.ibm.rational.wvcm.ct.CTFolder;
import com.ibm.rational.wvcm.ct.CTLocation;
import com.ibm.rational.wvcm.ct.CTProvider;
import com.ibm.rational.wvcm.ct.CTVersion;
import com.ibm.rational.wvcm.ct.CTView;
import com.ibm.rational.wvcm.ct.CommonUtils;
import com.ibm.rational.wvcm.ct.ObjSelUtils;
import com.ibm.rational.wvcm.interop.InteropStream;
import com.ibm.rational.wvcm.ri.impl.VersionHistoryImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import javax.wvcm.ControllableResource;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.VersionHistory;
import javax.wvcm.WvcmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CTElement
extends CTFolder {
    private static final String MAIN_ZERO = "/main/0";
    private static final String FILE_ENCODING = "file.encoding";
    private String _contentTypeCache = null;

    CTElement(Location location, CTProvider provider) {
        super(location, provider);
    }

    @Override
    public Class<?> get_proxyClass() {
        return VersionHistoryImpl.class;
    }

    @Override
    public boolean isImmutable() throws WvcmException {
        return !this.getObjInfo(null).getMtype().equals("symbolic link");
    }

    @Override
    protected Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)VersionHistory.ROOT_VERSION)) {
            return this.getRootVersion(feedback);
        }
        if (propertyName.equals((Object)Resource.CONTENT_TYPE)) {
            return this.getContentType(feedback);
        }
        if (propertyName.equals((Object)Resource.CONTENT_CHARACTER_SET)) {
            return this.lookupCharacterSet(feedback);
        }
        if (propertyName.equals((Object)InteropStream.PN_LINE_SEPARATOR)) {
            return this.lookupLineSeparator(feedback);
        }
        if (propertyName.equals((Object)ControllableResource.IS_EXECUTABLE)) {
            return this.getIsExecutable(feedback);
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    private boolean getIsExecutable(SrvcFeedback feedback) throws WvcmException {
        boolean result;
        CCaseLib cc = this.getProvider().getCCaseLib();
        CCaseObjInfo info = this.getObjInfo(feedback);
        if (info instanceof CCaseElemInfo) {
            CCaseElemInfo elemInfo = (CCaseElemInfo)info;
            result = CCaseLib.isExecutable(elemInfo.getPermissions());
        } else {
            result = cc.getExecutePermission(info.getPathName(), feedback);
        }
        return result;
    }

    public CTLocation lookupMyControllableResourceLoc(CTView view, SrvcFeedback feedback) throws WvcmException {
        CCaseLib cc = this.getProvider().getCCaseLib();
        String myID = this.getLocation().getDisplayName();
        String gpath = cc.gpath(myID, view.getViewTag(), feedback);
        String versionPath = ObjSelUtils.stripTrailingElementSuffix(gpath);
        String[] gpathSegments = gpath.split(CommonUtils.FWDSLASH);
        if (gpathSegments.length < 4 || gpathSegments[gpathSegments.length - 2].equals("lost+found")) {
            return null;
        }
        CTLocation result = null;
        if (!versionPath.contains("@@")) {
            result = CTLocation.valueOf(CTLocation.Kind.CONTROLLABLE_RESOURCE, versionPath);
        }
        return result;
    }

    public CTVersion getRootVersion(SrvcFeedback feedback) throws WvcmException {
        CCaseLib cc = this.getProvider().getCCaseLib();
        String elementSel = this.getLocation().getDisplayName();
        CTLocation rootVerLoc = CTLocation.valueOf(CTLocation.Kind.VERSION, String.valueOf(cc.gpath(elementSel, null, feedback)) + MAIN_ZERO);
        CTVersion ver = (CTVersion)this.getProvider().lookup(rootVerLoc, feedback);
        if (ver == null && this.getObjInfo(feedback).getMtype().equals("symbolic link")) {
            rootVerLoc = CTLocation.valueOf(CTLocation.Kind.SYMBOLIC_LINK_VERSION, this.getLocation().getDisplayName());
            ver = (CTVersion)this.getProvider().lookup(rootVerLoc, feedback);
        }
        if (ver == null) {
            throw new IllegalStateException("Root version is null");
        }
        return ver;
    }

    public synchronized String getContentType(SrvcFeedback feedback) throws WvcmException {
        if (this._contentTypeCache == null) {
            CCaseLib cc = this.getProvider().getCCaseLib();
            if (this.getObjInfo(feedback).isDirectory()) {
                this._contentTypeCache = "text/directory";
            } else {
                CCaseObjInfo objInfo = this.getObjInfo(feedback);
                if (objInfo instanceof CCaseElemInfo) {
                    CCaseElemInfo elemInfo = (CCaseElemInfo)objInfo;
                    String uSel = objInfo.getUniversalSelector();
                    this._contentTypeCache = cc.elementTypeToMimeContentType(ObjSelUtils.getObjSelVobSel(uSel), elemInfo.getElemType(), feedback);
                } else {
                    this._contentTypeCache = cc.getContentType(this.getLocation().getDisplayName(), feedback);
                }
            }
        }
        return this._contentTypeCache;
    }

    public String lookupCharacterSet(SrvcFeedback feedback) throws WvcmException {
        String result = this.isPlainText(this.getContentType(feedback)) ? System.getProperty(FILE_ENCODING) : null;
        return result;
    }

    private boolean isPlainText(String contentType) {
        return "text/plain".equals(contentType);
    }

    public String lookupLineSeparator(SrvcFeedback feedback) throws WvcmException {
        InteropStream.LineSeparator lineSeparator = this.isPlainText(this.getContentType(feedback)) ? this.getProvider().getDefaultLineSeparator() : InteropStream.LineSeparator.UNSPECIFIED;
        return lineSeparator.name();
    }
}

