/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.CCaseObjInfo;
import com.ibm.rational.wvcm.ct.CommandResult;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.wvcm.WvcmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CCaseElemInfo
extends CCaseObjInfo {
    private String _elementType;
    private String _permissions;

    public String getElemType() {
        return this._elementType;
    }

    public String getPermissions() {
        return this._permissions;
    }

    public CCaseElemInfo(CCaseLib cc, String universalSelector, boolean isDirectory, String pathName, String mtype, String elementType, String permissions) {
        super(cc, universalSelector, isDirectory, pathName, mtype);
        this._elementType = elementType;
        this._permissions = permissions;
    }

    public static List<CCaseElemInfo> getElemInfos(CCaseLib cc, List<String> pathNames, SrvcFeedback feedback) throws WvcmException {
        CommandResult.IgnoreFlags flags = new CommandResult.IgnoreFlags(CommandResult.IgnoreFlags.Kind.NO_VIEW_INFO);
        List<CCaseElemInfo> elemInfos = CCaseElemInfo.getElemInfos(cc, pathNames, flags, feedback);
        CCaseElemInfo.fixPermissions(cc, elemInfos, feedback);
        if (elemInfos == null) {
            throw new IllegalStateException(pathNames + " not found, but no exception thrown");
        }
        return elemInfos;
    }

    private static void fixPermissions(CCaseLib cc, List<CCaseElemInfo> elemInfos, SrvcFeedback feedback) throws WvcmException {
        String[] elemPaths = new String[elemInfos.size()];
        int i = 0;
        for (CCaseElemInfo elemInfo : elemInfos) {
            elemPaths[i++] = elemInfo.getPathName();
        }
        Map<String, String> results = cc.getExecutePermissionMap(feedback, elemPaths);
        for (CCaseElemInfo elemInfo : elemInfos) {
            elemInfo._permissions = results.get(elemInfo.getPathName());
        }
    }

    private static List<CCaseElemInfo> getElemInfos(CCaseLib cc, List<String> pathNames, CommandResult.IgnoreFlags flags, SrvcFeedback feedback) throws WvcmException {
        ArrayList<CCaseElemInfo> result = new ArrayList<CCaseElemInfo>(pathNames.size());
        List<String[]> tokensList = cc.describeForElemInfo(pathNames, flags, feedback);
        for (String[] tokens : tokensList) {
            if (tokens == null || tokens.length == 0) {
                result.add(null);
                continue;
            }
            result.add(new CCaseElemInfo(cc, tokens[1], tokens[0].startsWith("directory"), tokens[2], tokens[0], tokens[3], tokens[4]));
        }
        return result;
    }
}

