/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.patches;

import com.ibm.team.filesystem.common.changemodel.ChangeDescription;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.rcp.core.internal.patches.PatchResult;
import com.ibm.team.filesystem.rcp.core.patches.LocalFileOp;
import com.ibm.team.filesystem.rcp.core.patches.PatchOp;
import com.ibm.team.filesystem.rcp.core.patches.PatchPath;
import com.ibm.team.filesystem.rcp.core.patches.PatchedDirectory;
import com.ibm.team.filesystem.rcp.core.patches.PatchedFile;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.preferences.PreferencesUtil;
import com.ibm.team.repository.rcp.core.preferences.SerializationContext;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PendingContentChange {
    private static final String DESCRIPTION = "description";
    private static final String ATTR_UUID = "uuid";
    private WritableSet workItems;
    private WritableSet patchedDirectories;
    private Set<ItemId<IAuditable>> syncWorkItems = NewCollection.hashSet();
    private String description;
    private Map<VersionablePath, PatchedDirectory> directories = NewCollection.hashMap();
    private UUID id;

    public PendingContentChange(Realm realm, String description) {
        this(realm, description, UUID.generate());
    }

    public PendingContentChange(Realm realm, String description, UUID id) {
        this.patchedDirectories = new WritableSet(realm);
        this.workItems = new WritableSet(realm);
        this.description = description;
        this.id = id;
    }

    public Collection<LocalFileOp> getAllOps() {
        ArrayList<LocalFileOp> result = new ArrayList<LocalFileOp>();
        for (PatchedDirectory nextDirectory : this.getPatchedDirectories()) {
            for (PatchedFile nextFile : nextDirectory.getPatchedFiles()) {
                result.addAll((Collection<LocalFileOp>)nextFile.getOps());
            }
        }
        return result;
    }

    public ChangeDescription getChangeDescription() {
        return new ChangeDescription(this.description, (Collection)this.workItems, ItemId.getNullItem((IItemType)IComponent.ITEM_TYPE), (Collection)Collections.emptySet(), new Date());
    }

    public UUID getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public void addFile(PatchedFile file) {
        VersionablePath parentPath = file.getPath().getVersionablePath().removeLastSegments(1);
        PatchedDirectory directory = this.directories.get(parentPath);
        if (directory == null) {
            directory = new PatchedDirectory(parentPath);
            this.directories.put(parentPath, directory);
            this.patchedDirectories.add((Object)directory);
        }
        directory.addFile(file);
    }

    public IObservableSet getPatchedDirectories() {
        return this.patchedDirectories;
    }

    public PatchedFile getFile(PatchPath path) {
        return this.getFile(path.getVersionablePath());
    }

    public PatchedFile getFile(VersionablePath path) {
        VersionablePath parentPath = path.removeLastSegments(1);
        PatchedDirectory dir = this.directories.get(parentPath);
        if (dir == null) {
            return null;
        }
        for (Object next : dir.getPatchedFiles()) {
            PatchedFile nextFile = (PatchedFile)next;
            if (!nextFile.getVersionablePath().equals((Object)path)) continue;
            return nextFile;
        }
        return null;
    }

    public void removeFile(PatchedFile file) {
        VersionablePath parentPath = file.getPath().getVersionablePath().removeLastSegments(1);
        PatchedDirectory dir = this.directories.get(parentPath);
        if (dir != null) {
            dir.removeFile(file);
            if (dir.isEmpty()) {
                this.directories.remove(parentPath);
                this.patchedDirectories.remove((Object)dir);
            }
        }
    }

    public void removeHunk(LocalFileOp toRemove) {
        PatchedFile file = toRemove.getFile();
        file.removeOp(toRemove);
        if (file.getOps().isEmpty()) {
            this.removeFile(file);
        }
    }

    public static PendingContentChange load(Realm realm, SerializationContext context, IProgressMonitor monitor) throws CoreException {
        UUID uuid;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Preferences prefs = context.getPrefs();
        String description = PreferencesUtil.getString((Preferences)prefs, (String)DESCRIPTION, (String)"");
        String id = PreferencesUtil.getString((Preferences)prefs, (String)ATTR_UUID, (String)"");
        try {
            uuid = UUID.valueOf((String)id);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            uuid = UUID.generate();
        }
        final PatchResult patch = new PatchResult(context, (IProgressMonitor)progress.newChild(100));
        PendingContentChange result = new PendingContentChange(realm, description, uuid);
        realm.asyncExec(new Runnable(){

            public void run() {
                PendingContentChange.this.addResult(patch);
            }
        });
        return result;
    }

    public void addAll(Collection<PatchedFile> patchedFiles2) {
        for (PatchedFile next : patchedFiles2) {
            this.addFile(next);
        }
    }

    public void save(SerializationContext context, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        Preferences prefs = context.getPrefs();
        try {
            PreferencesUtil.clearDescendants((Preferences)prefs);
        }
        catch (BackingStoreException e) {
            throw new CoreException(StatusUtil.newStatus((Object)this, (Throwable)e));
        }
        prefs.put(DESCRIPTION, this.description);
        prefs.put(ATTR_UUID, this.id.getUuidValue());
        PatchResult result = this.getCurrentResult();
        try {
            result.save(context, (IProgressMonitor)progress.newChild(100));
        }
        finally {
            result.dispose();
        }
    }

    private PatchResult getCurrentResult() {
        PatchResult result = new PatchResult();
        for (PatchedDirectory next : this.directories.values()) {
            for (PatchedFile nextFile : next.getPatchedFiles()) {
                VersionablePath path = nextFile.getVersionablePath();
                for (LocalFileOp nextOp : nextFile.getOps()) {
                    result.addResult(path, nextOp.getOp().copy(), nextOp.getStatus());
                }
            }
        }
        return result;
    }

    public void removeAll(Collection<PatchedFile> toRemove) {
        for (PatchedFile next : toRemove) {
            this.removeFile(next);
        }
    }

    public void dispose() {
        for (PatchedDirectory next : this.patchedDirectories) {
            next.dispose();
        }
        this.patchedDirectories.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWorkItems(Collection<ItemId<IAuditable>> workItems) {
        workItems.addAll(workItems);
        PendingContentChange pendingContentChange = this;
        synchronized (pendingContentChange) {
            this.syncWorkItems.addAll(workItems);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWorkItem(ItemId<IAuditable> workItem) {
        this.workItems.remove(workItem);
        PendingContentChange pendingContentChange = this;
        synchronized (pendingContentChange) {
            this.workItems.remove(workItem);
        }
    }

    public IObservableSet getWorkItems() {
        return this.workItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ItemId<IAuditable>> syncGetWorkItems() {
        Collection result = NewCollection.arrayList();
        PendingContentChange pendingContentChange = this;
        synchronized (pendingContentChange) {
            result.addAll(this.syncWorkItems);
        }
        return result;
    }

    public void addResult(PatchResult result) {
        PendingContentChange change = this;
        Collection<VersionablePath> paths = result.getAffectedPaths();
        for (VersionablePath next : paths) {
            Collection<PatchOp> ops = result.getOpsForPath(next);
            PatchedFile nextFile = change.getFile(next);
            if (nextFile == null) {
                nextFile = new PatchedFile(change.getPatchedDirectories().getRealm(), change, next);
                change.addFile(nextFile);
            }
            for (PatchOp nextOp : ops) {
                LocalFileOp nextlf = new LocalFileOp(nextFile, nextOp);
                nextFile.addOp(nextlf);
                IStatus status = result.getResult(next, nextOp);
                if (status == null) continue;
                nextlf.setStatus(status);
            }
        }
    }
}

