/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.patches;

import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.rcp.core.patches.LocalFileOp;
import com.ibm.team.filesystem.rcp.core.patches.PatchPath;
import com.ibm.team.filesystem.rcp.core.patches.PendingContentChange;
import java.util.Collection;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatchedFile {
    private static final String ATTR_PROBLEMS = "problems";
    private IObservableSet localOps;
    private VersionablePath path;
    private PendingContentChange parent;

    public PatchedFile(Realm realm, PendingContentChange parent, PatchPath path) {
        this(realm, parent, path.getVersionablePath());
    }

    public PatchedFile(Realm realm, PendingContentChange parent, VersionablePath path) {
        this.path = path;
        this.localOps = new WritableSet(realm);
        this.parent = parent;
    }

    public IObservableSet getOps() {
        return this.localOps;
    }

    public void addAllOps(Collection<? extends LocalFileOp> toAdd) {
        this.localOps.addAll(toAdd);
    }

    public void addOp(LocalFileOp hunk) {
        this.localOps.add((Object)hunk);
    }

    public void removeOp(LocalFileOp hunk) {
        this.localOps.remove((Object)hunk);
        hunk.dispose();
    }

    public PatchPath getPath() {
        return new PatchPath(this.path);
    }

    public VersionablePath getVersionablePath() {
        return this.path;
    }

    public boolean isEmpty() {
        return this.localOps.isEmpty();
    }

    public PendingContentChange getPatch() {
        return this.parent;
    }

    public Realm getRealm() {
        return this.localOps.getRealm();
    }

    public void dispose() {
        for (LocalFileOp next : this.localOps) {
            next.dispose();
        }
        this.localOps.dispose();
    }
}

