/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.CopyFileAreaLockUtil;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.resources.ResourceShare;
import com.ibm.team.filesystem.rcp.core.internal.resources.ShareableResource;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnshareProjectsOperation
extends FileSystemOperation {
    private IProject[] projectsToUnshare;
    private boolean deleteContent;
    private Collection<Shareable> shareablesToUnshare;
    private ArrayList<ConfigurationDescriptor> configurationsToUnshare;

    public UnshareProjectsOperation(IProject[] projectsToUnshare, boolean deleteContent) {
        super(null);
        this.projectsToUnshare = projectsToUnshare;
        this.deleteContent = deleteContent;
    }

    public UnshareProjectsOperation(IConnection connection, Collection<? extends IComponentHandle> components, boolean deleteContent) {
        super(null);
        if (connection == null) {
            throw new IllegalArgumentException();
        }
        if (components == null) {
            throw new IllegalArgumentException();
        }
        this.configurationsToUnshare = new ArrayList();
        for (IComponentHandle iComponentHandle : components) {
            this.configurationsToUnshare.add(new ConfigurationDescriptor(connection, iComponentHandle));
        }
        this.deleteContent = deleteContent;
    }

    public UnshareProjectsOperation(Collection<ConfigurationDescriptor> configurationsToUnshare, boolean deleteContent) {
        super(null);
        if (configurationsToUnshare == null) {
            throw new IllegalArgumentException();
        }
        this.configurationsToUnshare = new ArrayList();
        this.configurationsToUnshare.addAll(configurationsToUnshare);
        this.deleteContent = deleteContent;
    }

    protected void execute(IProgressMonitor monitor) throws FileSystemClientException {
        final Collection<ConfigurationDescriptor> affected = this.getAffectedConfigurations();
        IWorkspaceRunnable workspaceOp = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"", (int)100);
                CopyFileAreaStore cfa = CopyFileAreaStore.getDefaultCopyFileArea();
                ISchedulingRule cfaLock = CopyFileAreaLockUtil.getWorkspaceComponentLock((CopyFileAreaStore)cfa, (Collection)affected, (IProgressMonitor)progress.newChild(1));
                try {
                    int i;
                    if (UnshareProjectsOperation.this.configurationsToUnshare != null) {
                        IShare[] shares = FileSystemCore.getSharingManager().allShares();
                        i = 0;
                        while (i < shares.length) {
                            Object descriptor;
                            ConfigurationDescriptor configuration;
                            IShare share = shares[i];
                            if (share instanceof ResourceShare && affected.contains(configuration = new ConfigurationDescriptor((descriptor = share.getSharingDescriptor()).getRepositoryId(), descriptor.getRepositoryUri(), descriptor.getConnectionHandle(), descriptor.getComponent()))) {
                                UnshareProjectsOperation.this.shareablesToUnshare.add((Shareable)share.getShareable(share.getPath(), true));
                            }
                            ++i;
                        }
                    }
                    int work = (UnshareProjectsOperation.this.deleteContent ? 2 : 1) * UnshareProjectsOperation.this.shareablesToUnshare.size();
                    progress.setWorkRemaining((work += UnshareProjectsOperation.this.configurationsToUnshare == null ? 0 : UnshareProjectsOperation.this.configurationsToUnshare.size()) + 1);
                    i = 1;
                    for (Shareable shareable : UnshareProjectsOperation.this.shareablesToUnshare) {
                        if (progress.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        try {
                            progress.subTask(NLS.bind((String)Messages.UnshareProjectsOperation_ProgressMessage, (Object[])new Object[]{shareable.getLocalFullPath(), i, UnshareProjectsOperation.this.shareablesToUnshare.size()}));
                            shareable.unshare((IProgressMonitor)progress.newChild(1));
                        }
                        catch (FileSystemClientException e) {
                            UnshareProjectsOperation.this.collectStatus(FileSystemStatus.getStatusFor((Throwable)e));
                        }
                        ++i;
                    }
                    if (UnshareProjectsOperation.this.configurationsToUnshare != null) {
                        for (ConfigurationDescriptor descriptor : UnshareProjectsOperation.this.configurationsToUnshare) {
                            cfa.componentUnloaded(descriptor.componentHandle, descriptor.connectionHandle, (IProgressMonitor)progress.newChild(1));
                        }
                    }
                }
                finally {
                    cfa.release(cfaLock, (IProgressMonitor)progress.newChild(1));
                }
                if (UnshareProjectsOperation.this.deleteContent) {
                    int i = 1;
                    for (Shareable shareable : UnshareProjectsOperation.this.shareablesToUnshare) {
                        progress.subTask(NLS.bind((String)Messages.UnshareProjectsOperation_ProgressMessage, (Object[])new Object[]{shareable.getLocalFullPath(), i + 1, UnshareProjectsOperation.this.shareablesToUnshare.size()}));
                        if (shareable instanceof ShareableResource) {
                            IResource resource = ((ShareableResource)shareable).getResource();
                            if (resource.getType() == 4) {
                                ((IProject)resource).delete(7, (IProgressMonitor)progress.newChild(1));
                            } else if (resource.getType() == 2) {
                                ((IFolder)resource).delete(true, true, (IProgressMonitor)progress.newChild(1));
                            } else if (resource.getType() == 1) {
                                ((IFile)resource).delete(true, true, (IProgressMonitor)progress.newChild(1));
                            }
                        } else {
                            shareable.getFileStorage().delete((IProgressMonitor)progress.newChild(1));
                        }
                        if (progress.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        ++i;
                    }
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(workspaceOp, monitor);
        }
        catch (CoreException e) {
            this.collectStatus(FileSystemStatus.getStatusFor((Throwable)e));
        }
    }

    private Collection<ConfigurationDescriptor> getAffectedConfigurations() {
        this.shareablesToUnshare = new ArrayList<Shareable>();
        HashSet<ConfigurationDescriptor> configurations = new HashSet<ConfigurationDescriptor>();
        if (this.configurationsToUnshare != null) {
            for (ConfigurationDescriptor configurationToUnshare : this.configurationsToUnshare) {
                if (configurationToUnshare.getClass() != ConfigurationDescriptor.class) {
                    configurations.add(new ConfigurationDescriptor(configurationToUnshare.id, configurationToUnshare.uri, configurationToUnshare.connectionHandle, configurationToUnshare.componentHandle));
                    continue;
                }
                configurations.add(configurationToUnshare);
            }
        }
        if (this.projectsToUnshare != null) {
            IProject[] iProjectArray = this.projectsToUnshare;
            int n = this.projectsToUnshare.length;
            int n2 = 0;
            while (n2 < n) {
                ShareableResource shareable;
                IShare share;
                IProject project = iProjectArray[n2];
                if (project.exists() && (share = (shareable = new ShareableResource((IResource)project)).getShare()) != null) {
                    ISharingDescriptor descriptor = share.getSharingDescriptor();
                    configurations.add(new ConfigurationDescriptor(descriptor.getRepositoryId(), descriptor.getRepositoryUri(), descriptor.getConnectionHandle(), descriptor.getComponent()));
                    this.shareablesToUnshare.add(shareable);
                }
                ++n2;
            }
        }
        return configurations;
    }
}

