/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.client.operations.IFileSystemOperation;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UndoDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.operations.EclipseWorkspaceUpdateOperation;
import com.ibm.team.filesystem.rcp.core.operations.EclipseWorkspaceVerifySharesOperation;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.StaleDataException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UndoChangesOperation
extends FileSystemOperation {
    private final IWorkspaceConnection workspaceConnection;
    private final HashMap<UUID, IChangeSetHandle> changeSetHandles;
    private final HashMap<UUID, Collection<IChange>> changesToUndo;
    private List<IChangeSet> fullChangeSets;

    public UndoChangesOperation(IWorkspaceConnection workspaceConnection, UndoDilemmaHandler problemHandler) {
        super((DilemmaHandler)problemHandler);
        if (workspaceConnection == null) {
            throw new IllegalArgumentException();
        }
        this.workspaceConnection = workspaceConnection;
        this.changeSetHandles = new HashMap();
        this.changesToUndo = new HashMap();
    }

    public void addChangesToUndo(IChangeSetHandle changeSetHandle, Collection<IChange> changes) {
        if (changeSetHandle == null) {
            throw new IllegalArgumentException();
        }
        if (changes == null) {
            throw new IllegalArgumentException();
        }
        for (IChange change : changes) {
            if (change instanceof IChange) continue;
            throw new IllegalArgumentException();
        }
        if (changes.isEmpty()) {
            return;
        }
        boolean found = false;
        Iterator iChangeSets = this.workspaceConnection.activeChangeSets().iterator();
        while (iChangeSets.hasNext()) {
            if (!changeSetHandle.sameItemId((IItemHandle)((IChangeSetHandle)iChangeSets.next()))) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalArgumentException("Not an active change set for the workspace supplied");
        }
        this.changeSetHandles.put(changeSetHandle.getItemId(), changeSetHandle);
        Collection<IChange> changesSoFar = this.changesToUndo.get(changeSetHandle.getItemId());
        if (changesSoFar == null) {
            changesSoFar = new ArrayList<IChange>(changes.size());
            this.changesToUndo.put(changeSetHandle.getItemId(), changesSoFar);
        }
        changesSoFar.addAll(changes);
    }

    protected void execute(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(2 + this.changeSetHandles.size()));
        DilemmaHandler dilemmaHandler = this.getDilemmaHandler();
        UndoDilemmaHandler problemHandler = dilemmaHandler instanceof UndoDilemmaHandler ? (UndoDilemmaHandler)dilemmaHandler : UndoDilemmaHandler.getDefault();
        ArrayList<IAuditable> determinants = new ArrayList<IAuditable>();
        Collection<ConfigurationDescriptor> affectedConfigurations = this.getAffectedConfigurations(determinants, (IProgressMonitor)progress.newChild(1));
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWrite(affectedConfigurations, determinants);
        try {
            this.verify(problemHandler, (IProgressMonitor)progress.newChild(1));
            ArrayList<IChangeSetHandle> changeSetsToCommit = new ArrayList<IChangeSetHandle>(this.changeSetHandles.size());
            ArrayList configOpsToCommit = new ArrayList(this.changeSetHandles.size());
            for (IChangeSetHandle changeSet : this.changeSetHandles.values()) {
                if (progress.isCanceled()) {
                    throw new OperationCanceledException();
                }
                Collection<IChange> changes = this.changesToUndo.get(changeSet.getItemId());
                if (changes.isEmpty()) continue;
                ArrayList<IWorkspaceConnection.IUndoOp> ops = new ArrayList<IWorkspaceConnection.IUndoOp>(changes.size());
                for (IChange change : changes) {
                    ops.add(this.workspaceConnection.configurationOpFactory().undo(change.item()));
                }
                changeSetsToCommit.add(changeSet);
                configOpsToCommit.add(ops);
            }
            if (!changeSetsToCommit.isEmpty()) {
                IUpdateReport report = this.workspaceConnection.commit(changeSetsToCommit, configOpsToCommit, (IProgressMonitor)progress.newChild(this.changeSetHandles.size()));
                EclipseWorkspaceUpdateOperation updateOp = new EclipseWorkspaceUpdateOperation(this.workspaceConnection, Collections.singletonList(report), 3, (UpdateDilemmaHandler)problemHandler);
                this.disableVerifyInSync((IFileSystemOperation)updateOp);
                updateOp.run((IProgressMonitor)progress.newChild(this.changeSetHandles.size()));
            }
        }
        finally {
            WorkspaceLockUtil.release((FlowNodeLock)workspaceLock);
        }
    }

    private Collection<ConfigurationDescriptor> getAffectedConfigurations(Collection<IAuditable> determinants, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ArrayList<IChangeSetHandle> csHandles = new ArrayList<IChangeSetHandle>(this.changeSetHandles.size());
        csHandles.addAll(this.changeSetHandles.values());
        this.fullChangeSets = this.workspaceConnection.teamRepository().itemManager().fetchCompleteItems(csHandles, 0, (IProgressMonitor)progress.newChild(50));
        determinants.addAll(this.fullChangeSets);
        HashSet<ConfigurationDescriptor> affectedConfigurations = new HashSet<ConfigurationDescriptor>();
        for (IChangeSet changeSet : this.fullChangeSets) {
            affectedConfigurations.add(new ConfigurationDescriptor((IConnection)this.workspaceConnection, changeSet.getComponent()));
        }
        return affectedConfigurations;
    }

    private void verify(UndoDilemmaHandler problemHandler, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        HashSet<UUID> openChangeSets = new HashSet<UUID>();
        for (IChangeSetHandle openCs : this.workspaceConnection.activeChangeSets()) {
            openChangeSets.add(openCs.getItemId());
        }
        for (IChangeSetHandle csToUndo : this.changeSetHandles.values()) {
            if (openChangeSets.contains(csToUndo.getItemId())) continue;
            throw new StaleDataException();
        }
        EclipseWorkspaceVerifySharesOperation verifyOp = new EclipseWorkspaceVerifySharesOperation((OutOfSyncDilemmaHandler)problemHandler);
        for (IChangeSet changeSet : this.fullChangeSets) {
            HashMap<UUID, IChange> changeMap = this.getChangeMap(changeSet);
            Iterator<IChange> iChangeToUndo = this.changesToUndo.get(changeSet.getItemId()).iterator();
            while (iChangeToUndo.hasNext()) {
                IChange changeToUndo = iChangeToUndo.next();
                IChange existing = changeMap.get(changeToUndo.item().getItemId());
                if (existing == null) {
                    iChangeToUndo.remove();
                    continue;
                }
                if (existing.kind() == changeToUndo.kind()) continue;
                throw new StaleDataException();
            }
            verifyOp.addToVerify((IConnection)this.workspaceConnection, changeSet.getComponent());
        }
        if (this.verifyInSyncEnabled() && !problemHandler.willIgnoreAllSharesOutOfSync()) {
            verifyOp.run(monitor);
        }
    }

    private HashMap<UUID, IChange> getChangeMap(IChangeSet changeSet) {
        HashMap<UUID, IChange> result = new HashMap<UUID, IChange>();
        for (IChange change : changeSet.changes()) {
            result.put(change.item().getItemId(), change);
        }
        return result;
    }
}

