/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsDilemmaHandler;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IFileSystemOperation;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.operations.EclipseWorkspaceUpdateOperation;
import com.ibm.team.filesystem.rcp.core.operations.EclipseWorkspaceVerifySharesOperation;
import com.ibm.team.filesystem.rcp.core.operations.NewCheckInOperation;
import com.ibm.team.filesystem.rcp.core.operations.SuspendDilemmaHandler;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuspendOperation
extends ChangeHistoryChangeSetsOperation {
    private final IWorkspaceConnection workspaceConnection;
    private final List<IChangeSetHandle> changeSetHandles;
    private final SuspendDilemmaHandler problemHandler;

    public SuspendOperation(IWorkspaceConnection workspace, Collection<IChangeSetHandle> changesToSuspend, SuspendDilemmaHandler dilemmaHandler) {
        super((ChangeHistoryChangeSetsDilemmaHandler)(dilemmaHandler == null ? SuspendDilemmaHandler.getDefault() : dilemmaHandler));
        SuspendDilemmaHandler suspendDilemmaHandler = this.problemHandler = dilemmaHandler == null ? SuspendDilemmaHandler.getDefault() : dilemmaHandler;
        if (workspace == null) {
            throw new IllegalArgumentException();
        }
        if (changesToSuspend == null) {
            throw new IllegalArgumentException();
        }
        this.workspaceConnection = workspace;
        this.changeSetHandles = new ArrayList<IChangeSetHandle>(changesToSuspend.size());
        HashSet<UUID> duplicateCheck = new HashSet<UUID>();
        for (IChangeSetHandle change : changesToSuspend) {
            if (change == null) {
                throw new IllegalArgumentException();
            }
            if (!duplicateCheck.add(change.getItemId())) {
                throw new IllegalArgumentException();
            }
            this.changeSetHandles.add(change);
        }
        if (this.changeSetHandles.isEmpty()) {
            throw new IllegalArgumentException();
        }
    }

    protected void execute(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.SuspendOperation_ProgressMessage, (int)175);
        ArrayList<IAuditable> determinants = new ArrayList<IAuditable>();
        final Collection<ConfigurationDescriptor> affectedConfigurations = this.getAffectedConfigurations(determinants, (IProgressMonitor)progress.newChild(10));
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWrite(affectedConfigurations, determinants);
        try {
            try {
                final TeamRepositoryException[] teamRepoException = new TeamRepositoryException[1];
                final FileSystemClientException[] fileSystemException = new FileSystemClientException[1];
                IWorkspaceRunnable workspaceOp = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        try {
                            SuspendOperation.this.suspend(affectedConfigurations, monitor);
                        }
                        catch (FileSystemClientException e) {
                            fileSystemException[0] = e;
                        }
                        catch (TeamRepositoryException e) {
                            teamRepoException[0] = e;
                        }
                    }
                };
                ResourcesPlugin.getWorkspace().run(workspaceOp, (IProgressMonitor)progress.newChild(165));
                if (teamRepoException[0] != null) {
                    throw teamRepoException[0];
                }
                if (fileSystemException[0] != null) {
                    throw fileSystemException[0];
                }
            }
            catch (CoreException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor((Throwable)e));
            }
        }
        finally {
            WorkspaceLockUtil.release((FlowNodeLock)workspaceLock);
        }
        progress.done();
    }

    private void suspend(Collection<ConfigurationDescriptor> affectedConfigurations, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)175);
        if (this.verifyInSyncEnabled() && !this.problemHandler.willIgnoreAllSharesOutOfSync()) {
            EclipseWorkspaceVerifySharesOperation verifyOp = new EclipseWorkspaceVerifySharesOperation((OutOfSyncDilemmaHandler)this.problemHandler);
            for (ConfigurationDescriptor configurationDescriptor : affectedConfigurations) {
                verifyOp.addToVerify((IConnection)this.workspaceConnection, configurationDescriptor.componentHandle);
            }
            verifyOp.run((IProgressMonitor)progress.newChild(20));
        }
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.checkinPendingChanges(affectedConfigurations, this.problemHandler, (IProgressMonitor)progress.newChild(30));
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        IUpdateReport report = this.workspaceConnection.suspend(this.changeSetHandles, (IProgressMonitor)progress.newChild(75));
        EclipseWorkspaceUpdateOperation op = new EclipseWorkspaceUpdateOperation(this.workspaceConnection, Collections.singletonList(report), 3, (UpdateDilemmaHandler)this.problemHandler);
        this.disableVerifyInSync((IFileSystemOperation)op);
        op.run((IProgressMonitor)progress.newChild(50));
    }

    private Collection<ConfigurationDescriptor> getAffectedConfigurations(Collection<IAuditable> determinants, IProgressMonitor monitor) throws TeamRepositoryException {
        HashSet<ConfigurationDescriptor> affectedConfigurations = new HashSet<ConfigurationDescriptor>();
        List changeSets = this.workspaceConnection.teamRepository().itemManager().fetchCompleteItems(this.changeSetHandles, 0, monitor);
        determinants.addAll(determinants);
        for (IChangeSet changeSet : changeSets) {
            affectedConfigurations.add(new ConfigurationDescriptor((IConnection)this.workspaceConnection, changeSet.getComponent()));
        }
        return affectedConfigurations;
    }

    public IFileSystemOperation getCheckInOperation(IWorkspaceConnection connection, IComponentHandle componentHandle, ILocalChange[] changes, String comment, CommitDilemmaHandler commitDilemmaHandler) {
        return new NewCheckInOperation(connection, componentHandle, changes, comment, commitDilemmaHandler);
    }
}

