/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsDilemmaHandler;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IFileSystemOperation;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.operations.EclipseWorkspaceUpdateOperation;
import com.ibm.team.filesystem.rcp.core.operations.EclipseWorkspaceVerifySharesOperation;
import com.ibm.team.filesystem.rcp.core.operations.NewCheckInOperation;
import com.ibm.team.filesystem.rcp.core.operations.ResumeDilemmaHandler;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResumeOperation
extends ChangeHistoryChangeSetsOperation {
    private final IWorkspaceConnection workspaceConnection;
    private final List<IChangeSetHandle> changeSetHandles;
    private final ResumeDilemmaHandler problemHandler;

    public ResumeOperation(IWorkspaceConnection workspace, List<IChangeSetHandle> changesToResume, ResumeDilemmaHandler dilemmaHandler) {
        super((ChangeHistoryChangeSetsDilemmaHandler)(dilemmaHandler == null ? ResumeDilemmaHandler.getDefault() : dilemmaHandler));
        ResumeDilemmaHandler resumeDilemmaHandler = this.problemHandler = dilemmaHandler == null ? ResumeDilemmaHandler.getDefault() : dilemmaHandler;
        if (workspace == null) {
            throw new IllegalArgumentException();
        }
        if (changesToResume == null) {
            throw new IllegalArgumentException();
        }
        this.workspaceConnection = workspace;
        HashSet<UUID> duplicateCheck = new HashSet<UUID>();
        for (IChangeSetHandle changeSet : changesToResume) {
            if (changeSet == null) {
                throw new IllegalArgumentException();
            }
            if (duplicateCheck.add(changeSet.getItemId())) continue;
            throw new IllegalArgumentException();
        }
        this.changeSetHandles = changesToResume;
        if (this.changeSetHandles.isEmpty()) {
            throw new IllegalArgumentException();
        }
    }

    protected void execute(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ResumeOperation_ProgressMessage, (int)150);
        ArrayList<IAuditable> determinants = new ArrayList<IAuditable>();
        final Collection<ConfigurationDescriptor> affectedConfigurations = this.getAffectedConfigurations(determinants, (IProgressMonitor)progress.newChild(10));
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWrite(affectedConfigurations, determinants);
        try {
            try {
                final TeamRepositoryException[] teamRepoException = new TeamRepositoryException[1];
                final FileSystemClientException[] fileSystemException = new FileSystemClientException[1];
                IWorkspaceRunnable workspaceOp = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        try {
                            ResumeOperation.this.resume(affectedConfigurations, monitor);
                        }
                        catch (FileSystemClientException e) {
                            fileSystemException[0] = e;
                        }
                        catch (TeamRepositoryException e) {
                            teamRepoException[0] = e;
                        }
                    }
                };
                ResourcesPlugin.getWorkspace().run(workspaceOp, (IProgressMonitor)progress.newChild(140));
                if (teamRepoException[0] != null) {
                    throw teamRepoException[0];
                }
                if (fileSystemException[0] != null) {
                    throw fileSystemException[0];
                }
            }
            catch (CoreException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor((Throwable)e));
            }
        }
        finally {
            WorkspaceLockUtil.release((FlowNodeLock)workspaceLock);
        }
        progress.done();
    }

    private void resume(Collection<ConfigurationDescriptor> affectedConfigurations, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)170);
        if (this.verifyInSyncEnabled() && !this.problemHandler.willIgnoreAllSharesOutOfSync()) {
            EclipseWorkspaceVerifySharesOperation verifyOp = new EclipseWorkspaceVerifySharesOperation((OutOfSyncDilemmaHandler)this.problemHandler);
            for (ConfigurationDescriptor configurationDescriptor : affectedConfigurations) {
                verifyOp.addToVerify((IConnection)this.workspaceConnection, configurationDescriptor.componentHandle);
            }
            verifyOp.run((IProgressMonitor)progress.newChild(20));
        }
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.checkinPendingChanges(affectedConfigurations, this.problemHandler, (IProgressMonitor)progress.newChild(20));
        Map<IComponentHandle, IChangeSetHandle> changeSetsToMakeCurrent = this.shouldMakeResumedCurrent(this.workspaceConnection, this.changeSetHandles, (IProgressMonitor)progress.newChild(5));
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        IUpdateReport report = this.workspaceConnection.resume(2, this.changeSetHandles, (IProgressMonitor)progress.newChild(65));
        EclipseWorkspaceUpdateOperation updateOp = new EclipseWorkspaceUpdateOperation(this.workspaceConnection, Collections.singletonList(report), 3, (UpdateDilemmaHandler)this.problemHandler);
        this.disableVerifyInSync((IFileSystemOperation)updateOp);
        updateOp.run((IProgressMonitor)progress.newChild(55));
        for (IChangeSetHandle toMakeCurrent : changeSetsToMakeCurrent.values()) {
            this.workspaceConnection.setCurrentChangeSet(toMakeCurrent, (IProgressMonitor)progress.newChild(5));
        }
    }

    private Map<IComponentHandle, IChangeSetHandle> shouldMakeResumedCurrent(IWorkspaceConnection workspaceConnection, List<IChangeSetHandle> changeSetHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        HashMap<UUID, ArrayList<IChangeSet>> groupedByComponent = new HashMap<UUID, ArrayList<IChangeSet>>();
        HashMap<IComponentHandle, IChangeSetHandle> changeSetsToMakeCurrent = new HashMap<IComponentHandle, IChangeSetHandle>();
        List changeSets = workspaceConnection.teamRepository().itemManager().fetchCompleteItems(changeSetHandles, 0, monitor);
        for (IChangeSet changeSet : changeSets) {
            if (!changeSet.isActive()) continue;
            IComponentHandle component = changeSet.getComponent();
            ArrayList<IChangeSet> gCsets = (ArrayList<IChangeSet>)groupedByComponent.get(component.getItemId());
            if (gCsets == null) {
                gCsets = new ArrayList<IChangeSet>();
                groupedByComponent.put(component.getItemId(), gCsets);
            }
            gCsets.add(changeSet);
        }
        for (UUID componentUUID : groupedByComponent.keySet()) {
            IComponentHandle componentHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(componentUUID, null);
            IChangeSetHandle currentChangeSetHandle = workspaceConnection.getCurrentChangeSet(componentHandle);
            List changeSetsInComponent = (List)groupedByComponent.get(componentUUID);
            if (currentChangeSetHandle != null || changeSetsInComponent.size() != 1) continue;
            changeSetsToMakeCurrent.put(componentHandle, (IChangeSetHandle)changeSetsInComponent.get(0));
        }
        return changeSetsToMakeCurrent;
    }

    private Collection<ConfigurationDescriptor> getAffectedConfigurations(Collection<IAuditable> determinants, IProgressMonitor monitor) throws TeamRepositoryException {
        HashSet<ConfigurationDescriptor> affectedConfigurations = new HashSet<ConfigurationDescriptor>();
        List changeSets = this.workspaceConnection.teamRepository().itemManager().fetchCompleteItems(this.changeSetHandles, 0, monitor);
        determinants.addAll(changeSets);
        for (IChangeSet changeSet : changeSets) {
            affectedConfigurations.add(new ConfigurationDescriptor((IConnection)this.workspaceConnection, changeSet.getComponent()));
        }
        return affectedConfigurations;
    }

    public IFileSystemOperation getCheckInOperation(IWorkspaceConnection connection, IComponentHandle componentHandle, ILocalChange[] changes, String comment, CommitDilemmaHandler commitDilemmaHandler) {
        return new NewCheckInOperation(connection, componentHandle, changes, comment, commitDilemmaHandler);
    }
}

