/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeTracker;
import com.ibm.team.filesystem.client.internal.operations.AbstractCommitOperation;
import com.ibm.team.filesystem.client.internal.operations.VerifySharesOperation;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.client.operations.IFailedUpload;
import com.ibm.team.filesystem.client.operations.IFileSystemOperation;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.internal.FileItem;
import com.ibm.team.filesystem.common.internal.FilesystemFactory;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.operations.ChangeSetChooser;
import com.ibm.team.filesystem.rcp.core.internal.operations.FailedUpload;
import com.ibm.team.filesystem.rcp.core.internal.resources.ContentProperties;
import com.ibm.team.filesystem.rcp.core.internal.resources.ResourceUtil;
import com.ibm.team.filesystem.rcp.core.internal.resources.ShareableResource;
import com.ibm.team.filesystem.rcp.core.operations.EclipseWorkspaceUpdateOperation;
import com.ibm.team.repository.client.IContentManagerInputStreamProvider;
import com.ibm.team.repository.client.IContentManagerSession;
import com.ibm.team.repository.client.IUploadHandler;
import com.ibm.team.repository.client.util.UploadAdapter;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.LineDelimiter;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.Content;
import com.ibm.team.repository.common.model.RepositoryFactory;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.common.utils.ContentLineDelimiterError;
import com.ibm.team.repository.common.utils.HashCode;
import com.ibm.team.repository.common.utils.HashComputingInputStream;
import com.ibm.team.repository.common.utils.LineDelimiterUtil;
import com.ibm.team.repository.common.utils.LineDelimiterVerifier;
import com.ibm.team.repository.common.utils.ReaderToInputStream;
import com.ibm.team.repository.common.utils.TemporaryOutputStream;
import com.ibm.team.repository.common.utils.VerifyConvertToCRInputStream;
import com.ibm.team.repository.common.utils.VerifyConvertToCRLFInputStream;
import com.ibm.team.repository.common.utils.VerifyConvertToLFInputStream;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.IItemUpdateReport;
import com.ibm.team.scm.common.dto.ISyncTime;
import com.ibm.team.scm.common.dto.IUpdateReport;
import com.ibm.team.scm.common.internal.Folder;
import com.ibm.team.scm.common.internal.ScmFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.Checksum;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewCheckInOperation
extends AbstractCommitOperation {
    private final CopyFileAreaStore cfa;
    private ILocalChange[] toCommit;
    private final String newChangeSetComment;
    private IShareable[] shareablesToCommit;
    private Map<UUID, Long> modTimes = new HashMap<UUID, Long>();
    private Map<UUID, Long> uploadContentSize = new HashMap<UUID, Long>();
    private Map<UUID, Checksum> uploadHashCode = new HashMap<UUID, Checksum>();
    private Map<UUID, Content> uploadContent = new HashMap<UUID, Content>();
    private Map<UUID, Boolean> executable = new HashMap<UUID, Boolean>();
    private List<CheckinUploadHandler> filesNeedingConversion = new ArrayList<CheckinUploadHandler>();
    private Map<UUID, IStatus> failureUploads = new HashMap<UUID, IStatus>();
    private boolean isAtomicCommitRequired = true;

    public NewCheckInOperation(IWorkspaceConnection workspace, IComponentHandle component, IShareable[] shareablesCommit, IChangeSetHandle changeSet, CommitDilemmaHandler commitProblemHandler) {
        super(workspace, component, changeSet, commitProblemHandler);
        this.validateShareablesToCommit(component, shareablesCommit);
        this.cfa = CopyFileAreaStore.getDefaultCopyFileArea();
        this.toCommit = null;
        this.shareablesToCommit = shareablesCommit;
        this.newChangeSetComment = "";
    }

    public NewCheckInOperation(IWorkspaceConnection workspace, IComponentHandle component, IShareable[] shareablesCommit, String newChangeSetComment, CommitDilemmaHandler commitProblemHandler) {
        super(workspace, component, commitProblemHandler);
        this.validateShareablesToCommit(component, shareablesCommit);
        if (newChangeSetComment == null) {
            throw new IllegalArgumentException();
        }
        this.cfa = CopyFileAreaStore.getDefaultCopyFileArea();
        this.toCommit = null;
        this.shareablesToCommit = shareablesCommit;
        this.newChangeSetComment = newChangeSetComment;
    }

    public void setIsAtomicCommitRequired(boolean isAtomicCommitRequired) {
        this.isAtomicCommitRequired = isAtomicCommitRequired;
    }

    private void validateShareablesToCommit(IComponentHandle component, IShareable[] shareablesCommit) {
        if (shareablesCommit == null) {
            throw new IllegalArgumentException();
        }
        IShareable[] iShareableArray = shareablesCommit;
        int n = shareablesCommit.length;
        int n2 = 0;
        while (n2 < n) {
            IShareable shareable = iShareableArray[n2];
            IShare share = shareable.getShare();
            if (share == null) {
                throw new IllegalArgumentException();
            }
            if (!share.getSharingDescriptor().getComponent().sameItemId((IItemHandle)component)) {
                throw new IllegalArgumentException();
            }
            ++n2;
        }
    }

    public NewCheckInOperation(IWorkspaceConnection workspace, IComponentHandle component, IChangeSetHandle changeSet, ILocalChange[] toCommit, CommitDilemmaHandler commitProblemHandler) {
        super(workspace, component, changeSet, commitProblemHandler);
        this.cfa = CopyFileAreaStore.getDefaultCopyFileArea();
        this.toCommit = toCommit;
        this.newChangeSetComment = "";
    }

    public NewCheckInOperation(IWorkspaceConnection workspace, IComponentHandle component, ILocalChange[] toCommit, String newChangeSetComment, CommitDilemmaHandler commitProblemHandler) {
        super(workspace, component, commitProblemHandler);
        if (newChangeSetComment == null) {
            throw new IllegalArgumentException();
        }
        this.cfa = CopyFileAreaStore.getDefaultCopyFileArea();
        this.toCommit = toCommit;
        this.newChangeSetComment = newChangeSetComment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.NewCheckInOperation_ProgressMessage, (int)100);
        mon.setTaskName(Messages.NewCheckInOperation_ProgressMessage);
        FlowNodeLock jazzWorkspaceLock = WorkspaceLockUtil.acquireWrite((IWorkspaceConnection)this.workspace, (Collection)Collections.singleton(this.component), (Collection)Collections.EMPTY_LIST);
        try {
            LocalChangeManager lcm = (LocalChangeManager)FileSystemCore.getSharingManager().getLocalChangeManager();
            IWorkspaceRoot workspaceRule = ResourcesPlugin.getWorkspace().getRoot();
            try {
                Job.getJobManager().beginRule((ISchedulingRule)workspaceRule, (IProgressMonitor)mon.newChild(1));
                ISchedulingRule rule = this.cfa.lock(this.component, (IContextHandle)this.workspace.getResolvedWorkspace(), (IProgressMonitor)mon.newChild(1));
                try {
                    LocalChangeTracker lct = lcm.findTracker((IContextHandle)this.workspace.getResolvedWorkspace(), this.component, this.cfa.getRoot());
                    if (lct == null) {
                        return;
                    }
                    LocalChangeTracker localChangeTracker = lct;
                    synchronized (localChangeTracker) {
                        lcm.syncPendingChanges((IContextHandle)this.workspace.getResolvedWorkspace(), this.component, this.cfa.getRoot());
                        String checkInMsg = NLS.bind((String)Messages.NewCheckInOperation_ProgresMessageCheckIn, (Object[])new Object[]{this.workspace.getResolvedWorkspace().getName()});
                        mon.setTaskName(checkInMsg);
                        if (this.toCommit == null) {
                            this.toCommit = this.shareablesToCommit == null ? lcm.getPendingChanges((IContextHandle)this.workspace.getResolvedWorkspace(), this.component, this.cfa.getRoot()) : lcm.getPendingChanges(this.shareablesToCommit);
                        }
                        HashMap<String, Share> toVerify = new HashMap<String, Share>();
                        ArrayList<ILocalChange> toCancel = new ArrayList<ILocalChange>();
                        SharingManager sharingManager = SharingManager.getInstance();
                        int i = 0;
                        while (i < this.toCommit.length) {
                            Share share = sharingManager.getShare(this.cfa.getRoot(), this.toCommit[i].getPath());
                            IShareable shareable = share.getShareable(this.toCommit[i].getPath(), this.toCommit[i].getTarget() instanceof IFolderHandle);
                            if (shareable.shouldBeIgnored()) {
                                toCancel.add(this.toCommit[i]);
                            } else {
                                toVerify.put(share.getPath().toString(), share);
                            }
                            ++i;
                        }
                        DilemmaHandler problemHandler = this.getDilemmaHandler();
                        if (!(problemHandler instanceof CommitDilemmaHandler)) {
                            problemHandler = CommitDilemmaHandler.getDefault();
                        }
                        if (this.verifyInSyncEnabled() && !((CommitDilemmaHandler)problemHandler).willIgnoreAllSharesOutOfSync() && !toVerify.isEmpty()) {
                            VerifySharesOperation verifyOp = new VerifySharesOperation(sharingManager.getDefaultCFARoot(), (OutOfSyncDilemmaHandler)((CommitDilemmaHandler)problemHandler));
                            verifyOp.addToVerify((IConnection)this.workspace, toVerify.values());
                            verifyOp.run((IProgressMonitor)mon.newChild(10));
                        }
                        if (!toCancel.isEmpty()) {
                            lcm.cancelChanges(toCancel.toArray(new ILocalChange[toCancel.size()]));
                        }
                        ArrayList<IAuditable> determinants = new ArrayList<IAuditable>();
                        jazzWorkspaceLock.addDeterminants(determinants);
                        ChangeSetChooser organizer = new ChangeSetChooser(this.workspace, determinants);
                        HashMap<UUID, IChangeSetHandle> changeSetsToCommit = new HashMap<UUID, IChangeSetHandle>();
                        HashMap<UUID, Set<ILocalChange>> changesToCommit = new HashMap<UUID, Set<ILocalChange>>();
                        mon.setWorkRemaining(100);
                        Set<ILocalChange> allChanges = this.addRequiredChanges(this.toCommit, lct, (IProgressMonitor)mon.newChild(1));
                        SubMonitor iterProgress = mon.newChild(1);
                        iterProgress.setWorkRemaining(allChanges.size());
                        for (ILocalChange change : allChanges) {
                            UUID key;
                            IChangeSetHandle bestChangeSet = organizer.getBestChangeSet(this.component, change.getTarget(), this.changeSet, (IProgressMonitor)iterProgress.newChild(1));
                            if (bestChangeSet != null) {
                                key = bestChangeSet.getItemId();
                                changeSetsToCommit.put(key, bestChangeSet);
                            } else {
                                key = null;
                            }
                            Set<ILocalChange> changes = changesToCommit.get(key);
                            if (changes == null) {
                                changes = new HashSet<ILocalChange>();
                                changesToCommit.put(key, changes);
                            }
                            changes.add(change);
                        }
                        mon.worked(9);
                        this.checkCancelled((IProgressMonitor)mon);
                        this.commitChanges(changesToCommit, changeSetsToCommit, lcm, checkInMsg, (IProgressMonitor)mon.newChild(90));
                    }
                }
                finally {
                    this.cfa.release(rule, (IProgressMonitor)mon.newChild(1));
                }
            }
            finally {
                Job.getJobManager().endRule((ISchedulingRule)workspaceRule);
                mon.done();
            }
        }
        finally {
            WorkspaceLockUtil.release((FlowNodeLock)jazzWorkspaceLock);
        }
    }

    private void commitChanges(HashMap<UUID, Set<ILocalChange>> changesToCommit, HashMap<UUID, IChangeSetHandle> changeSetsToCommit, LocalChangeManager lcm, String checkInMsg, IProgressMonitor progress) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IWorkspaceConnection.IConfigurationOpFactory configOpFactory = this.workspace.configurationOpFactory();
        int numChanges = 0;
        int numUploads = 0;
        boolean isNonAtomicCommitAllowed = !this.isAtomicCommitRequired;
        for (Set<ILocalChange> changes : changesToCommit.values()) {
            numChanges += changes.size();
            for (ILocalChange iLocalChange : changes) {
                if (iLocalChange.getTarget() instanceof IFileItemHandle && (iLocalChange.getType() & 3) != 0) {
                    ++numUploads;
                }
                isNonAtomicCommitAllowed &= (iLocalChange.getType() & 2) != 0;
            }
        }
        IStatus[] sessionErrorStatus = new IStatus[]{};
        if (numUploads != 0) {
            IContentManagerSession session = this.workspace.teamRepository().contentManager().createSession(NLS.bind((String)Messages.NewCheckInOperation_ProgressMessageUpload, (Object[])new Object[]{this.workspace.getName()}), isNonAtomicCommitAllowed, (long)numUploads, (IProgressMonitor)mon.newChild(40));
            try {
                for (Set set : changesToCommit.values()) {
                    for (Object chg : set) {
                        if (!(chg.getTarget() instanceof IFileItemHandle) || (chg.getType() & 3) == 0) continue;
                        CheckinUploadHandler uh = new CheckinUploadHandler((ILocalChange)chg);
                        session.storeContent((IUploadHandler)uh);
                    }
                }
            }
            catch (TeamRepositoryException teamRepositoryException) {}
            session.join();
            sessionErrorStatus = session.getErrorStatus();
            if (!isNonAtomicCommitAllowed) {
                if (!this.failureUploads.isEmpty()) {
                    RepositoryUtils.throwAppropriateException((String)Messages.NewCheckInOperation_ErrorMessageUpload, (IStatus[])this.failureUploads.values().toArray(new IStatus[this.failureUploads.size()]));
                } else {
                    RepositoryUtils.throwAppropriateException((String)Messages.NewCheckInOperation_ErrorMessageUpload, (IStatus[])sessionErrorStatus);
                }
            } else {
                this.checkCancellationStatus(this.failureUploads.values(), session.getErrorStatus());
            }
            SubMonitor subMonitor = mon.newChild(5);
            subMonitor.setWorkRemaining(this.filesNeedingConversion.size());
            for (CheckinUploadHandler uh : this.filesNeedingConversion) {
                uh.convert((IProgressMonitor)subMonitor.newChild(1));
            }
        }
        this.filesNeedingConversion = null;
        LinkedHashMap<UUID, ILocalChange> changes = new LinkedHashMap<UUID, ILocalChange>(numChanges * 4 / 3);
        ArrayList<ILocalChange> arrayList = new ArrayList<ILocalChange>(numChanges);
        ArrayList<IChangeSetHandle> changeSets = new ArrayList<IChangeSetHandle>(changesToCommit.size());
        ArrayList configOps = new ArrayList(changesToCommit.size());
        SubMonitor subProgress = mon.newChild(5);
        subProgress.setWorkRemaining(changesToCommit.size());
        for (Map.Entry<UUID, Set<ILocalChange>> entry : changesToCommit.entrySet()) {
            IChangeSetHandle cs;
            Collection allChanges = entry.getValue();
            ArrayList allOps = new ArrayList(allChanges.size());
            for (ILocalChange chg : allChanges) {
                if (!this.addConfigOp(chg, configOpFactory, allOps, subProgress)) continue;
                arrayList.add(chg);
            }
            if (allOps.isEmpty()) continue;
            for (ILocalChange changeToCommit : allChanges) {
                if (changeToCommit.isCanceled() || (changeToCommit.getType() & 0x10) != 0) continue;
                changes.put(changeToCommit.getTarget().getItemId(), changeToCommit);
            }
            if (entry.getKey() == null) {
                cs = this.workspace.getCurrentChangeSet(this.component);
                if (cs == null) {
                    cs = this.workspace.createChangeSet(this.component, this.newChangeSetComment, true, (IProgressMonitor)subProgress.newChild(1));
                }
            } else {
                cs = changeSetsToCommit.get(entry.getKey());
            }
            changeSets.add(cs);
            configOps.add(allOps);
        }
        subProgress.done();
        mon.setTaskName(checkInMsg);
        this.checkCancelled((IProgressMonitor)mon);
        mon.setWorkRemaining(60);
        if (!changeSets.isEmpty()) {
            IUpdateReport updateReport = this.workspace.commit(changeSets, configOps, (IProgressMonitor)mon.newChild(50));
            for (IChangeSetHandle cs : changeSets) {
                this.changeSetsCommitted.put(cs.getItemId(), cs);
            }
            this.updateMetadata(updateReport, changes, (IProgressMonitor)mon.newChild(5));
            this.modTimes = null;
            this.uploadContentSize = null;
            this.uploadHashCode = null;
            this.uploadContent = null;
            lcm.commitChanges(arrayList.toArray(new ILocalChange[arrayList.size()]));
            if (!updateReport.incidentalResolutionUpdates().isEmpty()) {
                EclipseWorkspaceUpdateOperation op = new EclipseWorkspaceUpdateOperation(this.workspace, Collections.singletonList(updateReport), 2, (UpdateDilemmaHandler)this.commitProblemHandler);
                this.disableVerifyInSync((IFileSystemOperation)op);
                op.run((IProgressMonitor)mon.newChild(5));
            }
            this.updateCFAConfigState(updateReport);
        }
        if (isNonAtomicCommitAllowed) {
            if (!this.failureUploads.isEmpty()) {
                RepositoryUtils.throwAppropriateException((String)Messages.NewCheckInOperation_ErrorMessageUpload, (IStatus[])this.failureUploads.values().toArray(new IStatus[this.failureUploads.size()]));
            } else {
                RepositoryUtils.throwAppropriateException((String)Messages.NewCheckInOperation_ErrorMessageUpload, (IStatus[])sessionErrorStatus);
            }
        }
        mon.done();
    }

    private void checkCancellationStatus(Collection<IStatus> statuses, IStatus[] errorStatus) {
        for (IStatus status : statuses) {
            if (!status.matches(8)) continue;
            throw new OperationCanceledException();
        }
        IStatus[] iStatusArray = errorStatus;
        int n = errorStatus.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus status;
            status = iStatusArray[n2];
            if (status.matches(8)) {
                throw new OperationCanceledException();
            }
            ++n2;
        }
    }

    private boolean addConfigOp(ILocalChange chg, IWorkspaceConnection.IConfigurationOpFactory configOpFactory, Collection<? super IWorkspaceConnection.IConfigurationOp> allOps, SubMonitor mon) throws FileSystemClientException, TeamRepositoryException {
        boolean toBeCommitted = true;
        if (chg.isType(4)) {
            if (chg.getTarget() instanceof IFolderHandle) {
                allOps.add((IWorkspaceConnection.IConfigurationOp)configOpFactory.deleteSubtree((IFolderHandle)chg.getTarget()));
            } else {
                allOps.add((IWorkspaceConnection.IConfigurationOp)configOpFactory.delete(chg.getTarget()));
            }
        } else if (!chg.isType(16)) {
            if (chg.getTarget() instanceof IFolderHandle) {
                Folder folder = ScmFactory.eINSTANCE.createFolder();
                folder.initNew();
                folder.setItemId(chg.getTarget().getItemId());
                folder.setParent(chg.getTargetParent());
                folder.setName(chg.getResultingPath().lastSegment());
                allOps.add((IWorkspaceConnection.IConfigurationOp)configOpFactory.save((IVersionable)folder));
            } else if (this.failureUploads.containsKey(chg.getTarget().getItemId())) {
                toBeCommitted = false;
            } else {
                InverseFileItemInfo info = this.cfa.getItemInfo(chg.getTarget(), this.component, (IContextHandle)this.workspace.getResolvedWorkspace());
                FileItem file = FilesystemFactory.eINSTANCE.createFileItem();
                file.initNew();
                file.setItemId(chg.getTarget().getItemId());
                file.setParent(info.getLocalParent());
                file.setName(info.getLocalName());
                IFileStorage storage = ((Shareable)chg.getShareable()).getFileStorage();
                boolean isExecutable = storage.isExecutable();
                file.setExecutable(isExecutable);
                file.setFileTimestamp(new Date(storage.getLocalTimeStamp()));
                this.executable.put(chg.getTarget().getItemId(), isExecutable);
                IContent cnt = (IContent)this.uploadContent.get(chg.getTarget().getItemId());
                if (cnt != null) {
                    file.setContent(cnt);
                } else if (info.getStoredContentId() != null) {
                    Content content = RepositoryFactory.eINSTANCE.createContent();
                    content.setContentId(info.getStoredContentId());
                    content.setDeltaPredecessor(info.getStoredDeltaPredecessor());
                    content.setLineDelimiter(info.getOriginalLineDelimiter());
                    content.setContentType(info.getOriginalContentType());
                    content.setContentLength(info.getStoredSize());
                    content.setCharacterEncoding(info.getStoredEncoding());
                    content.setChecksum(info.getStoredChecksum());
                    content.setLineDelimiterCount(info.getStoredNumLineDelimiters());
                    file.setContent((IContent)content);
                } else {
                    IFileItem fi = (IFileItem)this.workspace.configuration(this.component).fetchCompleteItem(info.getVersionableHandle(), (IProgressMonitor)mon.newChild(0));
                    file.setContent(fi.getContent());
                }
                allOps.add((IWorkspaceConnection.IConfigurationOp)configOpFactory.save((IVersionable)file));
            }
        } else if (this.failureUploads.containsKey(chg.getTarget().getItemId())) {
            toBeCommitted = false;
        }
        return toBeCommitted;
    }

    private Set<ILocalChange> addRequiredChanges(ILocalChange[] changesToBeCommitted, LocalChangeTracker lct, IProgressMonitor monitor) throws FileSystemClientException {
        ArrayList<ILocalChange> toCommit = new ArrayList<ILocalChange>((Collection)Arrays.asList(changesToBeCommitted));
        HashSet<ILocalChange> changes = new HashSet<ILocalChange>(changesToBeCommitted.length * 4 / 3);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)toCommit.size());
        while (!toCommit.isEmpty()) {
            ILocalChange change = (ILocalChange)toCommit.remove(toCommit.size() - 1);
            if (change.isCanceled()) {
                progress.worked(1);
                continue;
            }
            changes.add(change);
            if (change.getCounterpart() != null) {
                changes.add(change.getCounterpart());
                if (change.isType(16)) {
                    change = change.getCounterpart();
                }
                this.addDependentChangesForNewParent(change, toCommit, changes, lct);
            } else if (change.isType(2)) {
                this.addDependentChangesForNewParent(change, toCommit, changes, lct);
            } else if (change.isType(4)) {
                this.addDependentChangesForDeletion(change, toCommit, changes, lct);
            }
            progress.setWorkRemaining(toCommit.size() + 1);
            progress.worked(1);
        }
        progress.done();
        return changes;
    }

    private void addDependentChangesForDeletion(ILocalChange change, List<ILocalChange> toCommit, Set<ILocalChange> changes, LocalChangeTracker lct) throws FileSystemClientException {
        if (!(change.getTarget() instanceof IFolderHandle)) {
            return;
        }
        InverseFileItemInfo info = this.cfa.getItemInfo(change.getTarget(), this.component, this.workspace.getContextHandle());
        ArrayList toVisit = new ArrayList(info.getRemoteChildren().values());
        while (!toVisit.isEmpty()) {
            IVersionableHandle item = (IVersionableHandle)toVisit.remove(toVisit.size() - 1);
            ILocalChange chg = lct.getPendingChange(item);
            if (chg.getType() != 0) {
                Assert.isTrue((boolean)chg.isType(8));
                if (!changes.add(chg)) continue;
                toCommit.add(chg);
                continue;
            }
            if (!(item instanceof IFolderHandle)) continue;
            info = this.cfa.getItemInfo(item, this.component, this.workspace.getContextHandle());
            toVisit.addAll(info.getRemoteChildren().values());
        }
    }

    private void addDependentChangesForNewParent(ILocalChange change, List<ILocalChange> toCommit, Set<ILocalChange> changes, LocalChangeTracker lct) throws FileSystemClientException {
        IFolderHandle parent;
        ILocalChange dep = this.getDependentChangeForNewParent(change, lct);
        if (dep != null && changes.add(dep)) {
            toCommit.add(dep);
        }
        if (!(parent = change.getTargetParent()).hasStateId()) {
            dep = lct.getPendingChange((IVersionableHandle)parent);
            Assert.isTrue((boolean)dep.isType(2));
            if (changes.add(dep)) {
                toCommit.add(dep);
            }
        }
    }

    private ILocalChange getDependentChangeForNewParent(ILocalChange change, LocalChangeTracker lct) throws FileSystemClientException {
        IVersionableHandle conflicting;
        IFolderHandle parent = change.getTargetParent();
        if (!parent.hasStateId()) {
            return null;
        }
        String name = change.getResultingPath().lastSegment();
        InverseFileItemInfo info = this.cfa.getItemInfo((IVersionableHandle)parent, this.component, this.workspace.getContextHandle());
        if (this.cfa.isCaseSensitive()) {
            conflicting = (IVersionableHandle)info.getRemoteChildren().get(name);
        } else {
            conflicting = null;
            name = name.toUpperCase().toLowerCase();
            for (Map.Entry e : info.getRemoteChildren().entrySet()) {
                String rName = ((String)e.getKey()).toUpperCase().toLowerCase();
                if (!name.equals(rName)) continue;
                conflicting = (IVersionableHandle)e.getValue();
                break;
            }
        }
        if (conflicting == null || conflicting.sameItemId((IItemHandle)parent)) {
            return null;
        }
        ILocalChange dep = lct.getPendingChange(conflicting);
        Assert.isTrue(((dep.getType() & 0xC) != 0 ? 1 : 0) != 0);
        return dep;
    }

    private void updateMetadata(IUpdateReport updateReport, Map<UUID, ILocalChange> changes, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        progress.setWorkRemaining(changes.size());
        int completed = 0;
        int size = updateReport.updates().size();
        for (IItemUpdateReport report : updateReport.updates()) {
            progress.subTask(NLS.bind((String)Messages.NewCheckInOperation_ProgressMetadata, (Object[])new Object[]{++completed, size}));
            try {
                String name;
                IFolderHandle parent;
                InverseFileItemInfo oldInfo;
                if (report.getNewCurrentState() == null) continue;
                ILocalChange change = changes.remove(report.item().getItemId());
                long modTime = -1L;
                HashCode hash = null;
                long contentLength = -1L;
                LineDelimiter lineDelimiter = null;
                LineDelimiter originalLineDelimiter = null;
                String contentType = null;
                String originalContentType = null;
                UUID contentId = null;
                UUID deltaPredecessor = null;
                long storedSize = -1L;
                String encoding = null;
                long storedChecksum = -1L;
                long storedNumLineDelimiters = -1L;
                boolean isExecutable = false;
                if (report.item() instanceof IFolderHandle) {
                    if (change == null || (change.getType() & 0xA) == 0) {
                        oldInfo = this.cfa.getItemInfo(report.item(), report.getComponent(), (IContextHandle)this.workspace.getResolvedWorkspace());
                        if (change != null && !oldInfo.getName().equals(change.getPath().lastSegment())) {
                            throw new IllegalStateException("Name should have been " + oldInfo.getName() + " but the path is " + change.getPath());
                        }
                        parent = oldInfo.getParent();
                        name = oldInfo.getName();
                    } else {
                        parent = change.getTargetParent();
                        name = change.getResultingPath().lastSegment();
                    }
                } else {
                    Boolean exec;
                    oldInfo = this.cfa.getItemInfo(report.item(), report.getComponent(), (IContextHandle)this.workspace.getResolvedWorkspace());
                    if (oldInfo != null) {
                        originalLineDelimiter = oldInfo.getOriginalLineDelimiter();
                        lineDelimiter = oldInfo.getLineDelimiter();
                        modTime = oldInfo.getLastModification();
                        hash = oldInfo.getHash();
                        contentLength = oldInfo.getContentLength();
                        originalContentType = oldInfo.getOriginalContentType();
                        contentType = oldInfo.getContentType();
                        contentId = oldInfo.getStoredContentId();
                        deltaPredecessor = oldInfo.getStoredDeltaPredecessor();
                        storedSize = oldInfo.getStoredSize();
                        encoding = oldInfo.getStoredEncoding();
                        storedChecksum = oldInfo.getStoredChecksum();
                        storedNumLineDelimiters = oldInfo.getStoredNumLineDelimiters();
                        isExecutable = oldInfo.isOriginalExecutable();
                    }
                    if ((change.getType() & 0xA) == 0) {
                        if (!oldInfo.getName().equals(change.getPath().lastSegment())) {
                            throw new IllegalStateException("Name should have been " + oldInfo.getName() + " but the path is " + change.getPath());
                        }
                        parent = oldInfo.getParent();
                        name = oldInfo.getName();
                    } else {
                        parent = change.getTargetParent();
                        name = change.getResultingPath().lastSegment();
                    }
                    UUID itemId = report.item().getItemId();
                    Long contentSize = this.uploadContentSize.get(itemId);
                    if (contentSize != null) {
                        Checksum checksum = this.uploadHashCode.get(itemId);
                        hash = new HashCode(checksum);
                        contentLength = contentSize;
                        modTime = this.modTimes.get(itemId);
                        Content contentUploaded = this.uploadContent.get(itemId);
                        lineDelimiter = originalLineDelimiter = contentUploaded.getLineDelimiter();
                        originalContentType = contentUploaded.getContentType();
                        if (contentType == null) {
                            contentType = contentUploaded.getContentType();
                        }
                        contentId = contentUploaded.getContentId();
                        deltaPredecessor = contentUploaded.getDeltaPredecessor();
                        storedSize = contentUploaded.getContentLength();
                        encoding = contentUploaded.getCharacterEncoding();
                        storedChecksum = contentUploaded.getChecksum();
                        storedNumLineDelimiters = contentUploaded.getLineDelimiterCount();
                    }
                    if ((exec = this.executable.get(itemId)) != null) {
                        isExecutable = exec;
                    }
                }
                this.cfa.setItemInfo(report.item(), report.getComponent(), (IContextHandle)this.workspace.getResolvedWorkspace(), new FileItemInfo(report.getNewCurrentState(), modTime, parent, name, hash, contentLength, originalLineDelimiter, lineDelimiter, originalContentType, contentType, contentId, deltaPredecessor, storedSize, encoding, storedChecksum, storedNumLineDelimiters, isExecutable, isExecutable), (IProgressMonitor)progress.newChild(1));
            }
            catch (FileSystemClientException e) {
                this.collectStatus(FileSystemStatus.getStatusFor((Throwable)e));
            }
        }
        for (ILocalChange change : changes.values()) {
            if (!change.isType(4)) {
                this.collectStatus((IStatus)new Status(4, "com.ibm.team.filesystem.rcp.core", "Change is not a deletion: " + change));
                continue;
            }
            try {
                this.cfa.deleteTreeInfo(change.getTarget(), this.component, this.workspace.getContextHandle(), (IProgressMonitor)progress.newChild(1));
            }
            catch (FileSystemClientException e) {
                this.collectStatus(FileSystemStatus.getStatusFor((Throwable)e));
            }
        }
        progress.done();
    }

    private void updateCFAConfigState(IUpdateReport updateReport) throws FileSystemClientException {
        HashMap<UUID, ISyncTime> beforeStates = new HashMap<UUID, ISyncTime>();
        for (IComponentStateSummary summary : updateReport.getComponentStatesBefore()) {
            beforeStates.put(summary.getComponent().getItemId(), summary.getConfigurationTime());
        }
        for (IComponentStateSummary summary : updateReport.getComponentStatesAfter()) {
            ISyncTime beforeState = (ISyncTime)beforeStates.get(summary.getComponent().getItemId());
            this.cfa.setConfigurationState((IContextHandle)this.workspace.getResolvedWorkspace(), this.component, beforeState, summary.getConfigurationTime(), null);
        }
    }

    protected String getTraceMessage() {
        return String.valueOf(super.getTraceMessage()) + " " + this.workspace.getName() + " " + this.toCommit.length + " changes committed";
    }

    private class CheckinUploadHandler
    extends UploadAdapter
    implements IContentManagerInputStreamProvider {
        ILocalChange change;
        UUID itemId;
        IPath path;
        IShareable shareable;
        IFileStorage file;
        UUID predecessorId;
        ContentProperties contentProperties;
        boolean inferredLineDelimiter;
        LineDelimiterVerifier delimiterVerifier;
        LineDelimiter expectedLineDelimiter;
        LineDelimiter propsLineDelimiter;
        LineDelimiter foundLineDelimiter;
        HashComputingInputStream contents;
        long size;
        Checksum hashcode;
        private FailedUpload override;
        private boolean forceConsistentDelimiters;

        public CheckinUploadHandler(ILocalChange localChange) throws FileSystemClientException {
            this.change = localChange;
            this.override = null;
        }

        public CheckinUploadHandler(ILocalChange localChange, FailedUpload override) throws FileSystemClientException {
            this.change = localChange;
            this.override = override;
        }

        public String getCharacterEncoding() throws TeamRepositoryException {
            this.init();
            return this.contentProperties.encoding;
        }

        public String getContentType() throws TeamRepositoryException {
            this.init();
            return this.contentProperties.mimeType;
        }

        public LineDelimiter getLineDelimiter() throws TeamRepositoryException {
            this.init();
            return this.propsLineDelimiter;
        }

        public UUID getPredecessorContentId() throws TeamRepositoryException {
            this.init();
            return this.predecessorId;
        }

        public IContentManagerInputStreamProvider getStreamProvider() throws TeamRepositoryException {
            return this;
        }

        public InputStream wrapInputStream(InputStream in) throws IOException, TeamRepositoryException {
            this.updateFields();
            return in;
        }

        private void updateFields() {
            if (this.delimiterVerifier != null) {
                this.foundLineDelimiter = this.delimiterVerifier.getLineDelimiter();
                this.delimiterVerifier = null;
            }
            if (this.contents != null) {
                this.size = this.contents.getContentSize();
                this.hashcode = this.contents.getChecksum();
                this.contents = null;
            }
        }

        public InputStream getInputStream(int flags) throws IOException, TeamRepositoryException {
            this.init();
            this.updateFields();
            try {
                InputStream in;
                SharingManager.getInstance().disableChangeMonitoring();
                try {
                    in = this.file.getContents();
                }
                catch (FileSystemClientException e) {
                    throw new TeamRepositoryException((Throwable)e);
                }
                if ((flags & 2) != 0) {
                    InputStream inputStream = in;
                    return inputStream;
                }
                if (this.propsLineDelimiter == LineDelimiter.LINE_DELIMITER_NONE) {
                    this.delimiterVerifier = null;
                    this.expectedLineDelimiter = this.propsLineDelimiter;
                    HashComputingInputStream hashComputingInputStream = this.contents = new HashComputingInputStream(in);
                    return hashComputingInputStream;
                }
                this.expectedLineDelimiter = this.propsLineDelimiter == LineDelimiter.LINE_DELIMITER_PLATFORM ? LineDelimiter.getPlatformDelimiter() : this.propsLineDelimiter;
                if (this.forceConsistentDelimiters) {
                    this.delimiterVerifier = LineDelimiterUtil.getNonVerifyingLineDelimiterConverter((InputStream)in, (String)this.contentProperties.encoding, (LineDelimiter)this.expectedLineDelimiter);
                } else if (this.expectedLineDelimiter == LineDelimiter.LINE_DELIMITER_LF) {
                    this.delimiterVerifier = new VerifyConvertToLFInputStream(in, this.contentProperties.encoding);
                } else if (this.expectedLineDelimiter == LineDelimiter.LINE_DELIMITER_CRLF) {
                    this.delimiterVerifier = new VerifyConvertToCRLFInputStream(in, this.contentProperties.encoding);
                } else if (this.expectedLineDelimiter == LineDelimiter.LINE_DELIMITER_CR) {
                    this.delimiterVerifier = new VerifyConvertToCRInputStream(in, this.contentProperties.encoding);
                } else {
                    throw new IllegalStateException();
                }
                HashComputingInputStream hashComputingInputStream = this.contents = new HashComputingInputStream((InputStream)new ReaderToInputStream((InputStreamReader)this.delimiterVerifier));
                return hashComputingInputStream;
            }
            finally {
                SharingManager.getInstance().enableChangeMonitoring();
            }
        }

        public void uploadCanceled() throws TeamRepositoryException {
            this.delimiterVerifier = null;
            this.contents = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void uploadCompleted(IContent content) throws TeamRepositoryException {
            this.updateFields();
            boolean needsConversion = false;
            if (this.forceConsistentDelimiters) {
                needsConversion = true;
            } else if (this.foundLineDelimiter == null) {
                if (this.expectedLineDelimiter != LineDelimiter.LINE_DELIMITER_NONE) {
                    throw new IllegalStateException();
                }
            } else if (this.foundLineDelimiter != this.expectedLineDelimiter && this.foundLineDelimiter != LineDelimiter.LINE_DELIMITER_NONE) {
                needsConversion = true;
            }
            UUID id = this.itemId;
            Long uploadedSize = this.size;
            Checksum uploadedHashCode = this.hashcode;
            Content uploadedContent = (Content)content;
            Map map = NewCheckInOperation.this.uploadContentSize;
            synchronized (map) {
                NewCheckInOperation.this.uploadContentSize.put(id, uploadedSize);
                NewCheckInOperation.this.uploadHashCode.put(id, uploadedHashCode);
                NewCheckInOperation.this.uploadContent.put(id, uploadedContent);
                if (needsConversion) {
                    NewCheckInOperation.this.filesNeedingConversion.add(this);
                }
            }
        }

        public void convert(IProgressMonitor monitor) throws FileSystemClientException {
            if (!(this.forceConsistentDelimiters || this.foundLineDelimiter != null && this.foundLineDelimiter != this.expectedLineDelimiter && this.foundLineDelimiter != LineDelimiter.LINE_DELIMITER_NONE)) {
                throw new IllegalStateException();
            }
            try {
                SharingManager.getInstance().disableChangeMonitoring();
                TemporaryOutputStream tmpOut = null;
                InputStream fileIn = null;
                InputStream tmpIn = null;
                try {
                    try {
                        LineDelimiterVerifier conversionStream;
                        fileIn = this.file.getContents();
                        if (this.forceConsistentDelimiters) {
                            conversionStream = LineDelimiterUtil.getNonVerifyingLineDelimiterConverter((InputStream)fileIn, (String)this.contentProperties.encoding, (LineDelimiter)this.expectedLineDelimiter);
                        } else if (this.expectedLineDelimiter == LineDelimiter.LINE_DELIMITER_LF) {
                            conversionStream = new VerifyConvertToLFInputStream(fileIn, this.contentProperties.encoding);
                        } else if (this.expectedLineDelimiter == LineDelimiter.LINE_DELIMITER_CRLF) {
                            conversionStream = new VerifyConvertToCRLFInputStream(fileIn, this.contentProperties.encoding);
                        } else if (this.expectedLineDelimiter == LineDelimiter.LINE_DELIMITER_CR) {
                            conversionStream = new VerifyConvertToCRInputStream(fileIn, this.contentProperties.encoding);
                        } else {
                            throw new IllegalStateException();
                        }
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                        ReaderToInputStream in = new ReaderToInputStream((InputStreamReader)conversionStream);
                        SubMonitor subProgress = progress.newChild(50);
                        int work = 1000;
                        int worked = 0;
                        long total = this.size * 2L;
                        long transferred = 0L;
                        subProgress.setWorkRemaining(work);
                        byte[] buffer = new byte[4096];
                        tmpOut = TemporaryOutputStream.getTemporaryOutputStream((long)this.size);
                        int numbytes = in.read(buffer);
                        while (numbytes != -1) {
                            int newWorked = (int)((double)(transferred += (long)numbytes) / (double)total * (double)work);
                            subProgress.worked(newWorked - worked);
                            worked = newWorked;
                            tmpOut.write(buffer, 0, numbytes);
                            newWorked = (int)((double)(transferred += (long)numbytes) / (double)total * (double)work);
                            subProgress.worked(newWorked - worked);
                            worked = newWorked;
                            numbytes = in.read(buffer);
                        }
                        subProgress.done();
                        fileIn.close();
                        fileIn = null;
                        tmpOut.close();
                        tmpIn = tmpOut.getInputStream((IProgressMonitor)progress.newChild(25));
                        this.file.setContents(tmpIn, (IProgressMonitor)progress.newChild(25));
                        tmpIn.close();
                        tmpIn = null;
                        tmpOut.dispose();
                        tmpOut = null;
                        NewCheckInOperation.this.uploadContentSize.put(this.itemId, this.size);
                        NewCheckInOperation.this.uploadHashCode.put(this.itemId, this.hashcode);
                        NewCheckInOperation.this.modTimes.put(this.itemId, this.file.getModificationStamp());
                    }
                    catch (CoreException e) {
                        throw new FileSystemClientException(StatusUtil.newStatus((Object)"com.ibm.team.filesystem.client", (String)NLS.bind((String)Messages.NewCheckInOperation_ErrorEclipseWorkspace, (Object[])new Object[]{this.path}), (Throwable)e));
                    }
                    catch (IOException e) {
                        throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (String)NLS.bind((String)Messages.NewCheckInOperation_ErrorLineDelimiter, (Object[])new Object[]{this.path}), (Throwable)e));
                    }
                }
                catch (Throwable throwable) {
                    if (fileIn != null) {
                        try {
                            fileIn.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (tmpIn != null) {
                        try {
                            tmpIn.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (tmpOut != null) {
                        try {
                            tmpOut.close();
                            tmpOut.dispose();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (fileIn != null) {
                    try {
                        fileIn.close();
                    }
                    catch (IOException iOException) {}
                }
                if (tmpIn != null) {
                    try {
                        tmpIn.close();
                    }
                    catch (IOException iOException) {}
                }
                if (tmpOut != null) {
                    try {
                        tmpOut.close();
                        tmpOut.dispose();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                SharingManager.getInstance().enableChangeMonitoring();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean uploadFailed(TeamRepositoryException e) {
            this.delimiterVerifier = null;
            this.contents = null;
            try {
                Throwable rootCause;
                SharingManager.getInstance().disableChangeMonitoring();
                Throwable cause = e.getCause();
                if (cause instanceof ContentLineDelimiterError) {
                    if (this.inferredLineDelimiter) {
                        this.propsLineDelimiter = LineDelimiter.LINE_DELIMITER_NONE;
                        return true;
                    }
                    FailedUpload failedUpload = new FailedUpload(this.shareable, false);
                    int reaction = NewCheckInOperation.this.commitProblemHandler.lineDelimiterErrors((IFailedUpload)failedUpload);
                    if (reaction == 1) {
                        Throwable rootCause2 = this.getRootCause(e);
                        Status status = new Status(8, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.NewCheckInOperation_2, (Object[])new Object[]{this.file.getFullPath().toString(), this.propsLineDelimiter}), rootCause2);
                        Map map = NewCheckInOperation.this.failureUploads;
                        synchronized (map) {
                            NewCheckInOperation.this.failureUploads.put(this.itemId, status);
                            return false;
                        }
                    }
                    if (reaction == 0) {
                        this.forceConsistentDelimiters = failedUpload.isForceConsistentDelimiters();
                        if (this.forceConsistentDelimiters) return true;
                        this.propsLineDelimiter = LineDelimiter.LINE_DELIMITER_NONE;
                        return true;
                    }
                }
                Status status = (rootCause = this.getRootCause(e)) instanceof UnsupportedEncodingException || rootCause instanceof UnsupportedCharsetException ? new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.NewCheckInOperation_0, (Object[])new Object[]{this.file.getFullPath().toString(), this.contentProperties.encoding}), rootCause) : (rootCause instanceof CharacterCodingException ? new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.NewCheckInOperation_1, (Object[])new Object[]{this.file.getFullPath().toString(), this.contentProperties.encoding}), rootCause) : (rootCause instanceof ContentLineDelimiterError ? new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.NewCheckInOperation_2, (Object[])new Object[]{this.file.getFullPath().toString(), this.propsLineDelimiter}), rootCause) : new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.NewCheckInOperation_3, (Object[])new Object[]{this.file.getFullPath().toString()}), rootCause)));
                Map map = NewCheckInOperation.this.failureUploads;
                synchronized (map) {
                    NewCheckInOperation.this.failureUploads.put(this.itemId, status);
                    return false;
                }
            }
            finally {
                SharingManager.getInstance().enableChangeMonitoring();
            }
        }

        private Throwable getRootCause(Throwable rootCause) {
            int paranoiaCount = 0;
            while (rootCause instanceof TeamRepositoryException && paranoiaCount < 50) {
                Throwable t = ((TeamRepositoryException)rootCause).getCause();
                if (t == null) break;
                rootCause = t;
                ++paranoiaCount;
            }
            return rootCause;
        }

        public void uploadStart() throws TeamRepositoryException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void init() throws TeamRepositoryException {
            if (this.change != null) {
                try {
                    try {
                        SharingManager.getInstance().disableChangeMonitoring();
                        ILocalChange localChange = this.change;
                        this.shareable = localChange.getShareable();
                        this.file = ((Shareable)this.shareable).getFileStorage();
                        this.itemId = localChange.getTarget().getItemId();
                        this.path = localChange.getResultingPath();
                        Long modStamp = this.file.getModificationStamp();
                        UUID id = this.itemId;
                        Map map = NewCheckInOperation.this.modTimes;
                        synchronized (map) {
                            NewCheckInOperation.this.modTimes.put(id, modStamp);
                        }
                        this.contentProperties = this.shareable instanceof ShareableResource ? ResourceUtil.getContentProperties((IFile)((ShareableResource)this.shareable).getResource()) : ResourceUtil.getContentProperties(this.file.getContents(), localChange.getResultingPath().lastSegment());
                        if (this.contentProperties == null) {
                            throw new TeamRepositoryException(NLS.bind((String)Messages.NewCheckInOperation_4, (Object[])new Object[]{this.file.getFullPath()}));
                        }
                        this.propsLineDelimiter = this.contentProperties.lineDelimiter;
                        InverseFileItemInfo info = NewCheckInOperation.this.cfa.getItemInfo(localChange.getTarget(), NewCheckInOperation.this.component, (IContextHandle)NewCheckInOperation.this.workspace.getResolvedWorkspace());
                        this.inferredLineDelimiter = info.getLineDelimiter() == null;
                        this.predecessorId = info.getStoredContentId();
                        this.change = null;
                        if (this.override != null) {
                            if (this.override.isForceConsistentDelimiters()) {
                                this.forceConsistentDelimiters = true;
                            } else {
                                this.propsLineDelimiter = LineDelimiter.LINE_DELIMITER_NONE;
                                this.inferredLineDelimiter = false;
                                this.forceConsistentDelimiters = false;
                            }
                            this.override = null;
                        }
                    }
                    catch (CoreException e) {
                        throw new TeamRepositoryException(NLS.bind((String)Messages.NewCheckInOperation_ErrorMessageUploadEclipseFileArea, (Object[])new Object[]{this.change.getResultingPath()}), (Throwable)e);
                    }
                }
                finally {
                    SharingManager.getInstance().enableChangeMonitoring();
                }
            }
        }
    }
}

