/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.ignore.DefaultIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreRule;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeTracker;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.CopyFileAreaLockUtil;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.IgnoreUtils;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.common.IChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.operations.CancelRemoteChangesOperation;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.rcp.core.internal.LoggingHelper;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.INameItemPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IgnoreOperation {
    List<Ignoreable> toIgnore = new LinkedList<Ignoreable>();
    Collection<? extends IIgnoreProvider.IIgnoreRule> rules = null;
    private IRepositoryResolver resolver;
    private Boolean locked = false;
    IConnection connection;
    IComponentHandle component;

    public IgnoreOperation addIgnoreable(IWorkspaceConnection connection, IShareable shareable, IVersionableHandle remote, IContextHandle workspace, IComponentHandle component, IRemoteChangeSummary summary, boolean cancelChange) {
        this.ensureUnlocked((IConnection)connection, component);
        this.toIgnore.add(new IgnoreableVersionedShareable(this.resolver, connection, shareable, remote, workspace, component, summary, true, cancelChange));
        return this;
    }

    public IgnoreOperation addIgnoreable(IWorkspaceConnection connection, IShareable shareable) {
        IShare share = shareable.getShare();
        if (share == null) {
            throw new IllegalArgumentException("Cannot ignore unshared item");
        }
        this.ensureUnlocked((IConnection)connection, share.getSharingDescriptor().getComponent());
        if (shareable.getRemote() == null) {
            this.toIgnore.add(new IgnoreablePendingShareable(connection, shareable));
        } else {
            this.toIgnore.add(new IgnoreableVersionedShareable(this.resolver, connection, shareable, shareable.getRemote(), share.getSharingDescriptor().getConnectionHandle(), share.getSharingDescriptor().getComponent(), null, true, true));
        }
        return this;
    }

    public IgnoreOperation addIgnoreable(IConnection conn, IComponentHandle component, IRemoteChangeSummary summary) {
        this.ensureUnlocked(conn, component);
        this.toIgnore.add(new IgnoreableRemoteChangeSummary(summary, true));
        return this;
    }

    public IgnoreOperation(IRepositoryResolver resolver) {
        this.resolver = resolver;
    }

    public IgnoreOperation() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(IProgressMonitor m) throws TeamRepositoryException, FileSystemClientException {
        this.lock();
        if (this.connection == null) {
            assert (this.component == null);
            assert (this.toIgnore == null || this.toIgnore.size() == 0);
            assert (this.rules == null || this.rules.size() == 0);
            m.done();
            return;
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)m, (int)8);
        List<IComponentHandle> components = this.getAffectedComponents(monitor.newChild(1));
        FlowNodeLock flowLock = new FlowNodeLock();
        for (IComponentHandle cHandle : components) {
            flowLock.toWriteLock(new ConfigurationDescriptor(this.connection, cHandle));
        }
        flowLock.acquire();
        try {
            ISchedulingRule resourceLock = this.getResourceRule(monitor.newChild(1));
            try {
                Job.getJobManager().beginRule(resourceLock, (IProgressMonitor)monitor.newChild(1));
                CopyFileAreaStore cfa = CopyFileAreaStore.getDefaultCopyFileArea();
                ISchedulingRule rule = CopyFileAreaLockUtil.getCopyFileAreaLock((CopyFileAreaStore)cfa, (Collection)Collections.EMPTY_LIST, (IProgressMonitor)monitor.newChild(1));
                try {
                    LocalChangeManager lcm = (LocalChangeManager)FileSystemCore.getSharingManager().getLocalChangeManager();
                    LocalChangeTracker lct = lcm.findTracker(this.connection.getContextHandle(), this.component, cfa.getRoot());
                    if (lct == null) {
                        return;
                    }
                    LocalChangeTracker localChangeTracker = lct;
                    synchronized (localChangeTracker) {
                        this.run((IProgressMonitor)monitor.newChild(4));
                    }
                }
                finally {
                    cfa.release(rule, (IProgressMonitor)monitor.newChild(1));
                }
            }
            finally {
                Job.getJobManager().endRule(resourceLock);
            }
        }
        finally {
            WorkspaceLockUtil.release((FlowNodeLock)flowLock);
        }
    }

    private ISchedulingRule getResourceRule(SubMonitor monitor) {
        SharingManager sm = (SharingManager)FileSystemCore.getSharingManager();
        return sm.getTrackingRule(sm.getDefaultCFARoot());
    }

    private List<IComponentHandle> getAffectedComponents(SubMonitor monitor) {
        monitor.setWorkRemaining(this.toIgnore.size());
        LinkedList<IComponentHandle> toReturn = new LinkedList<IComponentHandle>();
        for (Ignoreable ignoreable : this.toIgnore) {
            try {
                toReturn.add(ignoreable.getComponent(monitor.newChild(1)));
            }
            catch (FileSystemClientException e) {
                LoggingHelper.log((String)"com.ibm.team.filesystem.rcp.core", (IStatus)FileSystemStatus.getStatusFor((int)4, (String)Messages.IgnoreOperation_ErrorMessageComponents, (Throwable)e));
            }
            catch (TeamRepositoryException e) {
                LoggingHelper.log((String)"com.ibm.team.filesystem.rcp.core", (IStatus)FileSystemStatus.getStatusFor((int)4, (String)Messages.IgnoreOperation_ErrorMessageComponents, (Throwable)e));
            }
        }
        return toReturn;
    }

    private void run(IProgressMonitor m) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)m, (int)38);
        try {
            this.syncPendingChanges(monitor.newChild(1));
            this.rationalizeIgnoreables(monitor.newChild(1));
            this.updateIgnoreManager(monitor.newChild(1));
            CancelRemoteChangesOperation op = new CancelRemoteChangesOperation(this.resolver);
            op.addCancelables(this.toIgnore);
            try {
                op.execute((IProgressMonitor)monitor.newChild(30));
            }
            catch (NotLoggedInException notLoggedInException) {
                monitor.done();
                return;
            }
        }
        finally {
            monitor.done();
        }
    }

    private void syncPendingChanges(SubMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        monitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.toIgnore.size() * 2));
        HashMap<IPath, Share> shares = new HashMap<IPath, Share>();
        for (Ignoreable ignoreable : this.toIgnore) {
            IPath root;
            IShareable shareable = ignoreable.getShareable((IProgressMonitor)monitor.newChild(1));
            if (shareable == null || (root = shareable.getRoot()) == null || shares.containsKey(root)) continue;
            shares.put(root, (Share)shareable.getShare());
        }
        for (Map.Entry entry : shares.entrySet()) {
            if (entry.getValue() == null) continue;
            Share share = (Share)entry.getValue();
            ISchedulingRule rule = share.lock((IProgressMonitor)monitor.newChild(1));
            try {
                share.syncChanges();
            }
            finally {
                share.unlock(rule, (IProgressMonitor)monitor.newChild(1));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lock() {
        Boolean bl = this.locked;
        synchronized (bl) {
            this.locked = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureUnlocked(IConnection conn, IComponentHandle comp) {
        Boolean bl = this.locked;
        synchronized (bl) {
            if (this.connection == null) {
                assert (this.component == null);
                this.connection = conn;
                this.component = comp;
            } else if (!conn.getContextHandle().sameItemId((IItemHandle)this.connection.getContextHandle())) {
                throw new IllegalStateException("IgnoreOperation may only be called on items shared on the same connection.");
            }
            if (this.locked.booleanValue()) {
                throw new IllegalStateException("execute() has already been called on " + this.getClass().getSimpleName());
            }
        }
    }

    private void rationalizeIgnoreables(SubMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        monitor.beginTask(Messages.IgnoreOperation_FindingIgnoresProgressMessage, 3);
        this.purgeContainedIgnoreables(monitor.newChild(1));
        this.collectContainedChanges(monitor.newChild(2));
    }

    private void purgeContainedIgnoreables(SubMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        IShareable shareable;
        monitor.beginTask(Messages.IgnoreOperation_RemovingIgnoresProgressMessage, 4 * this.toIgnore.size());
        HashSet<IPath> parents = new HashSet<IPath>();
        for (Ignoreable ignoreable : this.toIgnore) {
            shareable = ignoreable.getShareable((IProgressMonitor)monitor.newChild(1));
            if (shareable == null || !((Shareable)shareable).getFileStorage().isFolder()) continue;
            parents.add(shareable.getLocalFullPath());
        }
        Iterator<Ignoreable> iToIgnore = this.toIgnore.iterator();
        block1: while (iToIgnore.hasNext()) {
            Ignoreable ignoreable = iToIgnore.next();
            shareable = ignoreable.getShareable((IProgressMonitor)monitor.newChild(1));
            if (shareable == null) continue;
            IPath path = shareable.getLocalFullPath();
            for (IPath possibleAncestor : parents) {
                if (possibleAncestor.equals((Object)path) || !possibleAncestor.isPrefixOf(path)) continue;
                iToIgnore.remove();
                continue block1;
            }
        }
    }

    private void collectContainedChanges(SubMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        monitor.beginTask(Messages.IgnoreOperation_FindingChangesProgressMessage, this.toIgnore.size() * 2);
        try {
            HashMap allActivities = new HashMap();
            HashMap<ConfigurationDescriptor, HashSet<UUID>> allIgnoreableIds = new HashMap<ConfigurationDescriptor, HashSet<UUID>>();
            for (Ignoreable ignoreable : this.toIgnore) {
                IComponentSyncContext context;
                IShareable shareable = ignoreable.getShareable((IProgressMonitor)monitor.newChild(1));
                if (shareable != null && shareable.getRemote() != null && (context = ComponentSyncUtil.getContext(shareable)) != null) {
                    ConfigurationDescriptor descriptor = new ConfigurationDescriptor(context.getOutgoingConnection(), (IComponentHandle)context.getComponent());
                    HashSet activities = (HashSet)allActivities.get(descriptor);
                    if (activities == null) {
                        activities = new HashSet();
                        allActivities.put(descriptor, activities);
                    }
                    activities.addAll(context.getOutgoingActivitySource().getActivities());
                    HashSet<UUID> ignorableIds = (HashSet<UUID>)allIgnoreableIds.get(descriptor);
                    if (ignorableIds == null) {
                        ignorableIds = new HashSet<UUID>();
                        allIgnoreableIds.put(descriptor, ignorableIds);
                    }
                    ignorableIds.add(shareable.getRemote().getItemId());
                }
                this.checkCancelled(monitor);
            }
            monitor.setWorkRemaining(allActivities.size());
            for (Map.Entry entry : allActivities.entrySet()) {
                Set ignorableIds = (Set)allIgnoreableIds.get(entry.getKey());
                for (IRemoteActivity activity : (Set)entry.getValue()) {
                    block6: for (IRemoteChangeSummary summary : activity.getChanges()) {
                        IChange change = summary.getChange();
                        if (change == null || change.kind() == 0) continue;
                        IChangeSummary changeSummary = summary.getChangeSummary();
                        List ancestorPath = changeSummary.isChangeType(8) ? changeSummary.getNewAncestorPathHint() : changeSummary.getAncestorPathHint();
                        Iterator iPair = ancestorPath.iterator();
                        while (iPair.hasNext()) {
                            INameItemPair pair = (INameItemPair)iPair.next();
                            if (!iPair.hasNext() || !ignorableIds.contains(pair.getItem().getItemId())) continue;
                            this.toIgnore.add(new IgnoreableRemoteChangeSummary(summary, false));
                            continue block6;
                        }
                    }
                }
                monitor.worked(1);
                this.checkCancelled(monitor);
            }
        }
        finally {
            monitor.done();
        }
    }

    private void checkCancelled(SubMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private void updateIgnoreManager(SubMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        if (this.rules != null) {
            this.applyIgnoreRules(monitor);
            return;
        }
        monitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.toIgnore.size() * 2));
        try {
            int i = 0;
            for (Ignoreable ignoreable : this.toIgnore) {
                monitor.setTaskName(NLS.bind((String)Messages.IgnoreOperation_UpdatingProgressMessage, (Object[])new Object[]{++i, this.toIgnore.size()}));
                if (ignoreable.shouldUpdateIgnoreManager) {
                    IShareable shareable = ignoreable.getShareable((IProgressMonitor)monitor.newChild(1));
                    if (shareable == null) continue;
                    DefaultIgnoreProvider.getDefault().ignore(shareable, (IProgressMonitor)monitor.newChild(1));
                    continue;
                }
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
    }

    private void applyIgnoreRules(SubMonitor monitor) throws FileSystemClientException {
        Assert.isNotNull(this.rules);
        monitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.rules.size());
        try {
            for (IIgnoreProvider.IIgnoreRule iIgnoreRule : this.rules) {
                ((DefaultIgnoreProvider)iIgnoreRule.getProvider()).addIgnoreRule(iIgnoreRule, (IProgressMonitor)monitor.newChild(1));
            }
        }
        finally {
            monitor.done();
        }
    }

    public IgnoreOperation setIgnoreRules(IWorkspaceConnection connection, IComponentHandle component, Collection<? extends IgnoreRule> rules, IProgressMonitor progress) throws FileSystemClientException, TeamRepositoryException {
        return this.setIgnoreRules(connection, component, rules, false, progress);
    }

    public IgnoreOperation setIgnoreRules(IWorkspaceConnection connection, IComponentHandle component, Collection<? extends IgnoreRule> rules, boolean includeIgnoredResources, IProgressMonitor progress) throws FileSystemClientException {
        if (rules == null) {
            throw new IllegalArgumentException("rules may not be null");
        }
        this.ensureUnlocked((IConnection)connection, component);
        if (this.toIgnore.size() > 0) {
            throw new IllegalStateException("Cannot set ignore rule. #addIgnoreable() has already been called");
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)10);
        this.rules = rules;
        try {
            HashSet ignored = new HashSet();
            IgnoreUtils.findIgnoresForRules(rules, (boolean)includeIgnoredResources, ignored, (IProgressMonitor)monitor.newChild(9));
            for (IShareable shareable : ignored) {
                this.addIgnoreable(connection, shareable);
            }
        }
        finally {
            this.lock();
            monitor.done();
        }
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Ignoreable
    implements CancelRemoteChangesOperation.Cancelable {
        boolean shouldUpdateIgnoreManager;
        private boolean shouldCancelChange;

        private Ignoreable() {
        }

        public void setShouldCancelChange(boolean b) {
            this.shouldCancelChange = b;
        }

        @Override
        public boolean shouldCancelChange() {
            return this.shouldCancelChange;
        }

        @Override
        public abstract CancelRemoteChangesOperation.ChangeSetUndoList getUndoList(SubMonitor var1) throws TeamRepositoryException;

        @Override
        public abstract IShareable getShareable(IProgressMonitor var1) throws FileSystemClientException, TeamRepositoryException;

        abstract Collection<IShareable> getShareables(SubMonitor var1) throws FileSystemClientException, TeamRepositoryException;

        @Override
        public abstract IWorkspaceConnection getConnection();

        @Override
        public abstract UUID getUUID();

        @Override
        public Collection<IShareable> getRefreshShareables(IProgressMonitor mon) throws FileSystemClientException, TeamRepositoryException {
            return this.getShareables(SubMonitor.convert((IProgressMonitor)mon));
        }

        Collection<IShareable> getSkipSharebles(SubMonitor mon) throws FileSystemClientException, TeamRepositoryException {
            return this.getShareables(mon);
        }

        abstract IComponentHandle getComponent(SubMonitor var1) throws FileSystemClientException, TeamRepositoryException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IgnoreablePendingShareable
    extends Ignoreable {
        private IShareable shareable;
        private IWorkspaceConnection connection;

        public IgnoreablePendingShareable(IWorkspaceConnection connection, IShareable shareable) {
            this.connection = connection;
            this.shareable = shareable;
            this.shouldUpdateIgnoreManager = true;
            this.setShouldCancelChange(false);
        }

        @Override
        public IWorkspaceConnection getConnection() {
            return this.connection;
        }

        @Override
        public IShareable getShareable(IProgressMonitor mon) throws FileSystemClientException, TeamRepositoryException {
            return this.shareable;
        }

        @Override
        Collection<IShareable> getShareables(SubMonitor mon) throws FileSystemClientException, TeamRepositoryException {
            ArrayList<IShareable> list = new ArrayList<IShareable>(1);
            list.add(this.getShareable((IProgressMonitor)mon));
            return list;
        }

        @Override
        public UUID getUUID() {
            throw new UnsupportedOperationException("Must be committed");
        }

        @Override
        public CancelRemoteChangesOperation.ChangeSetUndoList getUndoList(SubMonitor monitor) throws TeamRepositoryException {
            throw new UnsupportedOperationException("Must be committed");
        }

        @Override
        IComponentHandle getComponent(SubMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
            monitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
            IShareable shareable = this.getShareable((IProgressMonitor)monitor.newChild(1));
            IShare share = shareable.getShare();
            Assert.isNotNull((Object)share);
            return share.getSharingDescriptor().getComponent();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IgnoreableRemoteChangeSummary
    extends Ignoreable {
        IRemoteChangeSummary summary;
        private IShareable shareable;

        public IgnoreableRemoteChangeSummary(IRemoteChangeSummary summary, boolean updateIgnoreManager) {
            this.summary = summary;
            this.shouldUpdateIgnoreManager = updateIgnoreManager;
            this.setShouldCancelChange(true);
        }

        @Override
        public CancelRemoteChangesOperation.ChangeSetUndoList getUndoList(SubMonitor monitor) {
            ArrayList<IChange> toReturn = new ArrayList<IChange>(2);
            toReturn.add(this.summary.getChange());
            return new CancelRemoteChangesOperation.ChangeSetUndoList(this.summary.getChangeSummary().component(), this.summary.getActivity().getChangeSetHandle(), Collections.singletonList(this.summary.getChange().item()));
        }

        @Override
        public IShareable getShareable(IProgressMonitor progress) throws FileSystemClientException, TeamRepositoryException {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)1);
            if (this.shareable != null) {
                return this.shareable;
            }
            ISharingManager sharingManager = FileSystemCore.getSharingManager();
            IPath cfaRoot = sharingManager.getDefaultCFARoot();
            IComponent componentHandle = this.summary.getActivity().getActivitySource().getModel().getComponent();
            IWorkspace contextHandle = this.summary.getActivity().getActivitySource().getWorkspace();
            this.shareable = sharingManager.findShareable(cfaRoot, this.summary.getItem(), (IComponentHandle)componentHandle, (IContextHandle)contextHandle, (IProgressMonitor)monitor.newChild(1));
            if (this.shareable != null) {
                return this.shareable;
            }
            if (this.summary.getChange() != null) {
                IPath shareablePath;
                List ancestorPath = this.summary.getChangeSummary().getNewAncestorPathHint();
                if (ancestorPath == null) {
                    ancestorPath = this.summary.getChangeSummary().getAncestorPathHint();
                }
                if ((shareablePath = (IPath)sharingManager.getPathRelativeToShares(cfaRoot, (IContextHandle)contextHandle, (IComponentHandle)componentHandle, Collections.singletonList(ancestorPath), (IProgressMonitor)monitor.newChild(1)).get(0)) != null) {
                    Share share = SharingManager.getInstance().getShare(cfaRoot, shareablePath);
                    this.shareable = share.getShareable(shareablePath, this.summary.getItem() instanceof IFolderHandle);
                }
            }
            return this.shareable;
        }

        @Override
        public Collection<IShareable> getShareables(SubMonitor mon) throws FileSystemClientException, TeamRepositoryException {
            IChangeSummary changeSummary;
            mon.setWorkRemaining(2);
            ArrayList<IShareable> result = new ArrayList<IShareable>(2);
            IShareable shareable = this.getShareable((IProgressMonitor)mon);
            if (shareable != null) {
                result.add(shareable);
            }
            if ((changeSummary = this.summary.getChangeSummary()).isChangeType(8)) {
                ISharingManager sharingManager = FileSystemCore.getSharingManager();
                IPath cfaRoot = sharingManager.getDefaultCFARoot();
                IComponent componentHandle = this.summary.getActivity().getActivitySource().getModel().getComponent();
                IWorkspace contextHandle = this.summary.getActivity().getActivitySource().getWorkspace();
                IPath shareablePath = (IPath)sharingManager.getPathRelativeToShares(cfaRoot, (IContextHandle)contextHandle, (IComponentHandle)componentHandle, Collections.singletonList(changeSummary.getAncestorPathHint()), (IProgressMonitor)mon.newChild(1)).get(0);
                if (shareablePath != null) {
                    Share share = SharingManager.getInstance().getShare(SharingManager.getInstance().getDefaultCFARoot(), shareablePath);
                    result.add(share.getShareable(shareablePath, changeSummary.item() instanceof IFolderHandle));
                }
            }
            return result;
        }

        @Override
        public IWorkspaceConnection getConnection() {
            return this.summary.getActivity().getActivitySource().getModel().getOutgoingTeamPlace();
        }

        @Override
        IComponentHandle getComponent(SubMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
            return this.summary.getChangeSummary().component();
        }

        @Override
        public UUID getUUID() {
            return this.summary.getItem().getItemId();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IgnoreableVersionedShareable
    extends Ignoreable {
        private IRepositoryResolver resolver;
        private IWorkspaceConnection connection;
        private IShareable shareable;
        private IVersionableHandle remote;
        private IRemoteChangeSummary summary;
        private IComponentHandle component;
        private IContextHandle ws;

        IgnoreableVersionedShareable(IRepositoryResolver resolver, final IWorkspaceConnection connection, IShareable shareable, IVersionableHandle remote, IContextHandle connectableHandle, IComponentHandle component, IRemoteChangeSummary summary, boolean updateIgnoreManager, boolean cancelChange) {
            if (remote == null) {
                throw new IllegalArgumentException("Remote handle may not be null");
            }
            if (cancelChange && shareable != null && shareable.getRemote() == null) {
                throw new IllegalArgumentException("shareable must have a remote to cancel change");
            }
            if (cancelChange && shareable != null && !remote.getItemId().equals((Object)shareable.getRemote().getItemId())) {
                throw new IllegalArgumentException("UUID of shareable and UUID remote item do not match(" + shareable.getRemote().getItemId() + " != " + remote.getItemId() + ")");
            }
            if (connectableHandle == null) {
                throw new IllegalArgumentException("connection may not be null");
            }
            if (component == null) {
                throw new IllegalArgumentException("component may not be null");
            }
            if (resolver == null) {
                resolver = new IRepositoryResolver(){

                    public ITeamRepository getRepoFor(String uri, UUID id) {
                        return connection.teamRepository();
                    }
                };
            }
            this.resolver = resolver;
            this.connection = connection;
            this.shareable = shareable;
            this.remote = remote;
            this.ws = connectableHandle;
            this.component = component;
            this.summary = summary;
            this.shouldUpdateIgnoreManager = updateIgnoreManager;
            this.setShouldCancelChange(cancelChange);
        }

        public String toString() {
            return "Ignoreable(" + this.shareable + ", " + this.remote + ")";
        }

        @Override
        public CancelRemoteChangesOperation.ChangeSetUndoList getUndoList(SubMonitor monitor) throws TeamRepositoryException {
            if (this.summary != null) {
                return this.getUndoListFromSummary(monitor);
            }
            Share share = (Share)this.shareable.getShare();
            IContextHandle cHandle = share.getSharingDescriptor().getConnectionHandle();
            IComponentHandle component = share.getSharingDescriptor().getComponent();
            ITeamRepository repo = this.resolver.getRepoFor(share.getSharingDescriptor().getRepositoryUri(), share.getSharingDescriptor().getRepositoryId());
            IWorkspaceManager wsMan = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
            IWorkspaceConnection connection = wsMan.getWorkspaceConnection((IWorkspaceHandle)cHandle, null);
            List changesets = connection.activeChangeSets();
            monitor.setWorkRemaining(changesets.size() + 10);
            monitor.subTask(Messages.IgnoreOperation_SubTask);
            IChangeSet changesetHandle = null;
            LinkedList<IVersionableHandle> toUndo = new LinkedList<IVersionableHandle>();
            block0: for (IChangeSetHandle csHandle : changesets) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IChangeSet changeSet = (IChangeSet)connection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)csHandle, 0, (IProgressMonitor)monitor.newChild(1));
                monitor.worked(1);
                for (IChange c : changeSet.changes()) {
                    if (!this.remote.getItemId().equals((Object)c.item().getItemId())) continue;
                    toUndo.add(c.item());
                    changesetHandle = changeSet;
                    continue block0;
                }
            }
            return new CancelRemoteChangesOperation.ChangeSetUndoList(component, (IChangeSetHandle)changesetHandle, (List<IVersionableHandle>)toUndo);
        }

        private CancelRemoteChangesOperation.ChangeSetUndoList getUndoListFromSummary(SubMonitor monitor) {
            Assert.isNotNull((Object)this.summary);
            monitor.beginTask(Messages.IgnoreOperation_GetUndoListProgressMessage, 1);
            ArrayList<IVersionableHandle> toReturn = new ArrayList<IVersionableHandle>(2);
            toReturn.add(this.summary.getChange().item());
            monitor.done();
            return new CancelRemoteChangesOperation.ChangeSetUndoList(this.component, this.summary.getActivity().getChangeSetHandle(), toReturn);
        }

        @Override
        public IShareable getShareable(IProgressMonitor monitor) throws FileSystemClientException {
            if (this.shareable != null) {
                monitor.beginTask(null, 1);
                monitor.worked(1);
                monitor.done();
                return this.shareable;
            }
            SharingManager sharingManager = SharingManager.getInstance();
            this.shareable = sharingManager.findShareable(sharingManager.getDefaultCFARoot(), this.remote, this.component, this.ws, monitor);
            return this.shareable;
        }

        @Override
        public Collection<IShareable> getShareables(SubMonitor mon) throws FileSystemClientException, TeamRepositoryException {
            return Collections.singleton(this.getShareable((IProgressMonitor)mon));
        }

        @Override
        public IWorkspaceConnection getConnection() {
            return this.connection;
        }

        @Override
        public UUID getUUID() {
            return this.remote.getItemId();
        }

        @Override
        IComponentHandle getComponent(SubMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
            return this.component;
        }
    }
}

