/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileSystemManager;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.LoadTree;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.resources.EclipseWorkspaceMergeLoadMutator;
import com.ibm.team.filesystem.rcp.core.operations.EclipseWorkspaceVerifySharesOperation;
import com.ibm.team.filesystem.rcp.core.operations.ReplaceDilemmaHandler;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseWorkspaceReplaceOperation
extends FileSystemOperation {
    public static final int DEPTH_INFINITY = -1;
    private final IConnection connection;
    private final Collection<IShareable> shareablesToReplace;
    private final int depth;
    private ReplaceDilemmaHandler problemHandler;

    public EclipseWorkspaceReplaceOperation(IConnection connection, Collection<IShareable> shareablesToReplace, int depth, ReplaceDilemmaHandler problemHandler) {
        super((DilemmaHandler)(problemHandler == null ? ReplaceDilemmaHandler.getDefault() : problemHandler));
        ReplaceDilemmaHandler replaceDilemmaHandler = this.problemHandler = problemHandler == null ? ReplaceDilemmaHandler.getDefault() : problemHandler;
        if (connection == null) {
            throw new IllegalArgumentException("connection must not be null");
        }
        if (shareablesToReplace == null) {
            throw new IllegalArgumentException("shareables must not be null");
        }
        if (depth < 0 && depth != -1) {
            throw new IllegalArgumentException("depth must be greater than 0");
        }
        this.connection = connection;
        this.shareablesToReplace = shareablesToReplace;
        this.depth = depth;
    }

    protected void execute(IProgressMonitor reporter) throws FileSystemClientException, TeamRepositoryException {
        final TeamRepositoryException[] teamRepoException = new TeamRepositoryException[1];
        final FileSystemClientException[] fileSystemException = new FileSystemClientException[1];
        IWorkspaceRunnable workspaceOp = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    EclipseWorkspaceReplaceOperation.this.replace(monitor);
                }
                catch (FileSystemClientException e) {
                    fileSystemException[0] = e;
                }
                catch (TeamRepositoryException e) {
                    teamRepoException[0] = e;
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(workspaceOp, reporter);
        }
        catch (FileSystemClientException e) {
            throw e;
        }
        catch (CoreException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor((Throwable)e));
        }
        if (teamRepoException[0] != null) {
            throw teamRepoException[0];
        }
        if (fileSystemException[0] != null) {
            throw fileSystemException[0];
        }
    }

    protected void replace(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor iterationProgress;
        int retrievalDepth;
        monitor.subTask(Messages.EclipseWorkspaceReplaceOperation_ProgressMessage);
        int numShareables = this.shareablesToReplace.size();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)numShareables);
        int processed = 0;
        ArrayList<IShareable> toReload = new ArrayList<IShareable>();
        ArrayList<IShareable> toDelete = new ArrayList<IShareable>();
        HashMap<String, IShare> sharesToVerify = new HashMap<String, IShare>();
        Iterator<IShareable> iShareables = this.shareablesToReplace.iterator();
        while (iShareables.hasNext()) {
            ISharingDescriptor descriptor;
            IShare share;
            boolean needsToBeLoaded = false;
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            IShareable shareable = iShareables.next();
            IVersionableHandle remoteHandle = shareable.getRemote();
            if (remoteHandle != null && (share = shareable.getShare()) != null && (descriptor = share.getSharingDescriptor()) != null) {
                needsToBeLoaded = true;
                sharesToVerify.put(share.getPath().toString(), share);
            }
            if (needsToBeLoaded) {
                toReload.add(shareable);
                continue;
            }
            toDelete.add(shareable);
        }
        FileSystemServiceProxy fileSystemService = ((FileSystemManager)FileSystemCore.getFileSystemManager((ITeamRepository)this.connection.teamRepository())).getFileSystemService();
        int n = retrievalDepth = this.depth == -1 ? -1 : this.depth;
        if (!sharesToVerify.isEmpty() && this.verifyInSyncEnabled() && !this.problemHandler.willIgnoreAllSharesOutOfSync()) {
            EclipseWorkspaceVerifySharesOperation verifyOp = new EclipseWorkspaceVerifySharesOperation(this.problemHandler);
            verifyOp.addToVerify(this.connection, sharesToVerify.values());
            verifyOp.run((IProgressMonitor)progress.newChild(1));
        }
        for (IShareable shareable : toReload) {
            iterationProgress = progress.newChild(1);
            iterationProgress.setWorkRemaining(100);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            monitor.setTaskName(NLS.bind((String)Messages.EclipseWorkspaceReplaceOperation_ProgressSubTaskMessage, (Object[])new Object[]{shareable.getLocalFullPath(), ++processed, numShareables}));
            IComponentHandle component = shareable.getShare().getSharingDescriptor().getComponent();
            String[] subtree = shareable.getLocalFullPath().segments();
            LoadTree loadTree = fileSystemService.getFileTreeByVersionable(this.connection, component, new IVersionableHandle[]{shareable.getRemote()}, retrievalDepth, true, null, (IProgressMonitor)iterationProgress.newChild(50));
            HashMap<ConfigurationDescriptor, Collection<IVersionableHandle>> shareRoots = new HashMap<ConfigurationDescriptor, Collection<IVersionableHandle>>();
            Collection roots = Collections.singleton(shareable.getShare().getSharingDescriptor().getRootFolder());
            shareRoots.put(new ConfigurationDescriptor(this.connection, component), roots);
            EclipseWorkspaceMergeLoadMutator mutator = new EclipseWorkspaceMergeLoadMutator(this.connection, shareRoots, (Collection<String[]>)Collections.singleton(subtree), loadTree, this.getDilemmaHandler());
            try {
                SharingManager.getInstance().disableChangeMonitoring();
                mutator.run((IProgressMonitor)iterationProgress.newChild(50));
            }
            finally {
                SharingManager.getInstance().enableChangeMonitoring();
            }
        }
        for (IShareable shareable : toDelete) {
            iterationProgress = progress.newChild(1);
            iterationProgress.setWorkRemaining(100);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            IResource resource = (IResource)shareable.getAdapter(IResource.class);
            try {
                if (resource.getType() == 4) {
                    resource.delete(7, (IProgressMonitor)iterationProgress.newChild(25));
                } else {
                    resource.delete(3, (IProgressMonitor)iterationProgress.newChild(25));
                }
            }
            catch (CoreException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor((Throwable)e));
            }
            iterationProgress.setWorkRemaining(25);
            ((Shareable)shareable).forget((IProgressMonitor)iterationProgress.newChild(25));
        }
    }
}

