/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.streams;

import com.ibm.team.filesystem.rcp.core.internal.patches.FilePatchResult;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;

public class PatchResultInputStreamProvider
implements IInputStreamProvider {
    private FilePatchResult patchResult;
    private boolean patched;

    public PatchResultInputStreamProvider(FilePatchResult patchResult, boolean patched) {
        this.patchResult = patchResult;
        this.patched = patched;
    }

    public InputStream getInputStream(IProgressMonitor monitor) throws IOException {
        if (this.patched) {
            return this.patchResult.getPatchedContents();
        }
        return this.patchResult.getOriginalContents();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.patchResult == null ? 0 : this.patchResult.hashCode());
        result = 31 * result + (this.patched ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PatchResultInputStreamProvider other = (PatchResultInputStreamProvider)obj;
        if (this.patchResult == null ? other.patchResult != null : !this.patchResult.equals(other.patchResult)) {
            return false;
        }
        return this.patched == other.patched;
    }
}

