/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.streams;

import com.ibm.team.filesystem.rcp.core.internal.patches.Hunk;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;

public class HunkInputStream
implements IInputStreamProvider {
    private Hunk hunk;
    private boolean patched;

    public HunkInputStream(Hunk theHunk, boolean patched) {
        this.hunk = theHunk;
        this.patched = patched;
    }

    public InputStream getInputStream(IProgressMonitor monitor) throws IOException {
        if (this.patched) {
            return this.hunk.getPatchedContents();
        }
        return this.hunk.getOriginalContents();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.hunk == null ? 0 : this.hunk.hashCode());
        result = 31 * result + (this.patched ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HunkInputStream other = (HunkInputStream)obj;
        if (this.hunk == null ? other.hunk != null : !this.hunk.equals(other.hunk)) {
            return false;
        }
        return this.patched == other.patched;
    }
}

