/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.rest.util;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.client.operations.IInvalidLoadRequest;
import com.ibm.team.filesystem.client.operations.ILoadOverlap;
import com.ibm.team.filesystem.client.operations.IRemovedShare;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.IShareableToLoad;
import com.ibm.team.filesystem.client.operations.IWorkspaceUpdateOperation;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.operations.WorkspaceUpdateDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsAcceptChangeSets;
import com.ibm.team.filesystem.client.rest.parameters.ParmsOutOfSyncInstructions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPendingChangesDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceUpdate;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceUpdateDilemmaHandler;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.FilesystemRestClientDTOchangesetFactory;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.GapChangeSetsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.ProblemChangeSetsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.WorkspaceUpdateResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConfigurationDescriptorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.LineDelimiterErrorDTO;
import com.ibm.team.filesystem.rcp.core.internal.EclipseFileSystemManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.SyncCache;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.CommitUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.CoreUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.VerifyOutOfSyncUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceUpdateUtil {
    private static final String request = "WorkspaceUpdate";

    public static WorkspaceUpdateResultDTO workspaceUpdate(ParmsWorkspaceUpdate parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        parms.validate(request);
        WorkspaceUpdateResultDTO result = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createWorkspaceUpdateResultDTO();
        WorkspaceUpdateDilemmaHandler dilemmaHandler = WorkspaceUpdateUtil.getWorkspaceUpdateDilemmaHandler(parms.workspaceUpdateDilemmaHandler, parms.pendingChangesDilemmaHandler, parms.outOfSyncInstructions, result.getComponentFlowAdditions(), result.getComponentFlowDeletions(), result.getComponentReplacementCandidates(), result.getDisconnectedComponents(), result.getConfigurationsWithUnCheckedInChanges(), result.getLineDelimiterFailures(), result.getOutOfSyncShares(), result.getActiveChangeSets(), result.getActiveChangeSetsOverlap(), result.getGap());
        IWorkspaceUpdateOperation workspaceUpdateOperation = WorkspaceUpdateUtil.prepareWorkspaceUpdateOperation(parms, dilemmaHandler, (IProgressMonitor)monitor.newChild(10));
        try {
            if (parms.evaluateRequestOnly == null || !parms.evaluateRequestOnly.booleanValue()) {
                workspaceUpdateOperation.run((IProgressMonitor)monitor.newChild(90));
            } else {
                workspaceUpdateOperation.runPreConditionsOnly((IProgressMonitor)monitor.newChild(90));
            }
            result.setChangeSetsAlreadyInHistory(workspaceUpdateOperation.changeSetsAlreadyInHistory());
            result.setAcceptedSuspendedChanges(workspaceUpdateOperation.acceptedSuspendedChangeSets());
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
        }
        catch (OperationCanceledException operationCanceledException) {
            result.setChangeSetsAlreadyInHistory(workspaceUpdateOperation.changeSetsAlreadyInHistory());
            result.setAcceptedSuspendedChanges(workspaceUpdateOperation.acceptedSuspendedChangeSets());
            result.setCancelled(true);
        }
        WorkspaceUpdateUtil.recordConfigurationDescriptors(workspaceUpdateOperation.getComponentsAdded(), result.getComponentsAdded());
        return result;
    }

    private static IWorkspaceUpdateOperation prepareWorkspaceUpdateOperation(ParmsWorkspaceUpdate parms, WorkspaceUpdateDilemmaHandler dilemmaHandler, IProgressMonitor progress) throws TeamRepositoryException {
        List components;
        IWorkspaceConnection sourceWorkspace;
        IWorkspaceConnection workspace;
        int n;
        int n2;
        ParmsAcceptChangeSets[] parmsAcceptChangeSetsArray;
        SubMonitor subMonitor;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)600);
        IWorkspaceUpdateOperation workspaceUpdateOperation = EclipseFileSystemManager.instance.getWorkspaceUpdateOperation(dilemmaHandler);
        if (parms.acceptChangeSets != null && parms.acceptChangeSets.length > 0) {
            subMonitor = monitor.newChild(100).setWorkRemaining(parms.acceptChangeSets.length * 10);
            parmsAcceptChangeSetsArray = parms.acceptChangeSets;
            n2 = parms.acceptChangeSets.length;
            n = 0;
            while (n < n2) {
                ParmsAcceptChangeSets acceptChangeSetsParm = parmsAcceptChangeSetsArray[n];
                ITeamRepository repo = CommonUtil.getTeamRepository((String)acceptChangeSetsParm.workspace.repositoryUrl);
                IWorkspaceConnection workspace2 = acceptChangeSetsParm.workspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                ArrayList<IChangeSetHandle> changeSets = new ArrayList<IChangeSetHandle>();
                String[] stringArray = acceptChangeSetsParm.changeSetItemIds;
                int n3 = acceptChangeSetsParm.changeSetItemIds.length;
                int n4 = 0;
                while (n4 < n3) {
                    String changeSetItemId = stringArray[n4];
                    changeSets.add(CommonUtil.createChangeSetHandle((ITeamRepository)repo, (String)changeSetItemId));
                    ++n4;
                }
                workspaceUpdateOperation.acceptChangeSets(workspace2, changeSets);
                ++n;
            }
        }
        if (parms.workspaceAcceptDetailed != null && parms.workspaceAcceptDetailed.length > 0) {
            subMonitor = monitor.newChild(100).setWorkRemaining(parms.workspaceAcceptDetailed.length * 30);
            parmsAcceptChangeSetsArray = parms.workspaceAcceptDetailed;
            n2 = parms.workspaceAcceptDetailed.length;
            n = 0;
            while (n < n2) {
                int n5;
                ParmsAcceptChangeSets workspaceAcceptDetailed = parmsAcceptChangeSetsArray[n];
                workspace = workspaceAcceptDetailed.workspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                ITeamRepository sourceRepo = CommonUtil.getTeamRepository((String)workspaceAcceptDetailed.sourceWorkspace.repositoryUrl);
                IWorkspaceConnection sourceWorkspace2 = workspaceAcceptDetailed.sourceWorkspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                List baselines = workspaceAcceptDetailed.getBaselineHandles();
                ArrayList<IChangeSetHandle> changeSets = new ArrayList<IChangeSetHandle>();
                if (workspaceAcceptDetailed.changeSetItemIds != null) {
                    String[] stringArray = workspaceAcceptDetailed.changeSetItemIds;
                    n5 = workspaceAcceptDetailed.changeSetItemIds.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        String changeSetItemId = stringArray[n6];
                        changeSets.add(CommonUtil.createChangeSetHandle((ITeamRepository)sourceRepo, (String)changeSetItemId));
                        ++n6;
                    }
                }
                ArrayList<IComponentHandle> components2 = new ArrayList<IComponentHandle>();
                if (workspaceAcceptDetailed.componentItemIds != null) {
                    String[] stringArray = workspaceAcceptDetailed.componentItemIds;
                    int n7 = workspaceAcceptDetailed.componentItemIds.length;
                    n5 = 0;
                    while (n5 < n7) {
                        String componentItemId = stringArray[n5];
                        components2.add(CommonUtil.createComponentHandle((ITeamRepository)sourceRepo, (String)componentItemId));
                        ++n5;
                    }
                }
                IChangeHistorySyncReport syncReport = WorkspaceUpdateUtil.getSyncReport(workspace, sourceWorkspace2, (IProgressMonitor)subMonitor.newChild(10));
                workspaceUpdateOperation.accept(workspace, sourceWorkspace2, syncReport, baselines, changeSets, components2);
                ++n;
            }
        }
        if (parms.workspaceAccept != null && parms.workspaceAccept.length > 0) {
            subMonitor = monitor.newChild(100).setWorkRemaining(parms.workspaceAccept.length * 30);
            parmsAcceptChangeSetsArray = parms.workspaceAccept;
            n2 = parms.workspaceAccept.length;
            n = 0;
            while (n < n2) {
                ParmsAcceptChangeSets workspaceAccept = parmsAcceptChangeSetsArray[n];
                workspace = workspaceAccept.workspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                sourceWorkspace = workspaceAccept.sourceWorkspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                IChangeHistorySyncReport syncReport = WorkspaceUpdateUtil.getSyncReport(workspace, sourceWorkspace, (IProgressMonitor)subMonitor.newChild(10));
                workspaceUpdateOperation.accept(workspace, sourceWorkspace, syncReport);
                ++n;
            }
        }
        if (parms.workspaceReplaceWithBaseline != null && parms.workspaceReplaceWithBaseline.length > 0) {
            subMonitor = monitor.newChild(100).setWorkRemaining(parms.workspaceReplaceWithBaseline.length * 20);
            parmsAcceptChangeSetsArray = parms.workspaceReplaceWithBaseline;
            n2 = parms.workspaceReplaceWithBaseline.length;
            n = 0;
            while (n < n2) {
                ParmsAcceptChangeSets workspaceReplaceWithBaseline = parmsAcceptChangeSetsArray[n];
                workspace = workspaceReplaceWithBaseline.workspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                IBaselineConnection sourceBaseline = workspaceReplaceWithBaseline.baseline.getBaselineConnection((IProgressMonitor)subMonitor.newChild(10));
                workspaceUpdateOperation.replace(workspace, sourceBaseline);
                ++n;
            }
        }
        if (parms.workspaceReplaceWithSnapshot != null && parms.workspaceReplaceWithSnapshot.length > 0) {
            subMonitor = monitor.newChild(100).setWorkRemaining(parms.workspaceReplaceWithSnapshot.length * 10);
            parmsAcceptChangeSetsArray = parms.workspaceReplaceWithSnapshot;
            n2 = parms.workspaceReplaceWithSnapshot.length;
            n = 0;
            while (n < n2) {
                ParmsAcceptChangeSets workspaceReplaceWithSnapshot = parmsAcceptChangeSetsArray[n];
                workspace = workspaceReplaceWithSnapshot.workspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                IBaselineSetHandle sourceBaselineSet = workspaceReplaceWithSnapshot.baselineSet.getBaselineSetHandle();
                components = workspaceReplaceWithSnapshot.getComponentHandles();
                if (components.isEmpty()) {
                    workspaceUpdateOperation.replace(workspace, sourceBaselineSet);
                } else {
                    workspaceUpdateOperation.replace(workspace, sourceBaselineSet, components);
                }
                ++n;
            }
        }
        if (parms.workspaceReplaceWithWorkspace != null && parms.workspaceReplaceWithWorkspace.length > 0) {
            subMonitor = monitor.newChild(100).setWorkRemaining(parms.workspaceReplaceWithWorkspace.length * 10);
            parmsAcceptChangeSetsArray = parms.workspaceReplaceWithWorkspace;
            n2 = parms.workspaceReplaceWithWorkspace.length;
            n = 0;
            while (n < n2) {
                ParmsAcceptChangeSets workspaceReplaceWithWorkspace = parmsAcceptChangeSetsArray[n];
                workspace = workspaceReplaceWithWorkspace.workspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                sourceWorkspace = workspaceReplaceWithWorkspace.sourceWorkspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                components = workspaceReplaceWithWorkspace.getComponentHandles();
                if (components.isEmpty()) {
                    workspaceUpdateOperation.replace(workspace, sourceWorkspace);
                } else {
                    workspaceUpdateOperation.replace(workspace, sourceWorkspace, components);
                }
                ++n;
            }
        }
        return workspaceUpdateOperation;
    }

    private static IChangeHistorySyncReport getSyncReport(IWorkspaceConnection workspace, IWorkspaceConnection sourceWorkspace, IProgressMonitor monitor) throws TeamRepositoryException {
        int flags = ((ComponentSyncModel)ComponentSyncModel.getInstance()).getCompareToFlags();
        IChangeHistorySyncReport syncReport = SyncCache.get().fetch((IWorkspaceConnection)workspace, (IWorkspaceConnection)sourceWorkspace, (int)flags, (IProgressMonitor)monitor).syncReport;
        return syncReport;
    }

    public static WorkspaceUpdateDilemmaHandler getWorkspaceUpdateDilemmaHandler(ParmsWorkspaceUpdateDilemmaHandler workspaceUpdateDilemmaParms, ParmsPendingChangesDilemmaHandler pendingChangesDilemmaParms, ParmsOutOfSyncInstructions outOfSyncInstructions, final List<ConfigurationDescriptorDTO> componentFlowAdditions, final List<ConfigurationDescriptorDTO> componentFlowDeletions, final List<ConfigurationDescriptorDTO> componentReplacementCandidates, final List<ConfigurationDescriptorDTO> disconnectedComponents, final List<ConfigurationDescriptorDTO> configurationsWithPendingChanges, List<LineDelimiterErrorDTO> lineDelimiterErrors, List<ShareDTO> outOfSyncShares, final List<ProblemChangeSetsDTO> activeChangeSetsEncountered, final List<ProblemChangeSetsDTO> activeChangeSetsOverlapEncountered, final List<GapChangeSetsDTO> gapEncountered) throws TeamRepositoryException {
        int gapInstruction;
        int activeChangeSetsOverlapInstruction;
        int activeChangeSetsInstruction;
        int staleDataInstruction;
        int disconnectedComponentsInstruction;
        int componentFlowInstruction;
        int replaceComponentsInstruction;
        if (workspaceUpdateDilemmaParms == null) {
            replaceComponentsInstruction = 2;
            componentFlowInstruction = 2;
            disconnectedComponentsInstruction = 2;
            staleDataInstruction = 2;
            activeChangeSetsInstruction = 2;
            activeChangeSetsOverlapInstruction = 2;
            gapInstruction = 2;
        } else {
            ParmsWorkspaceUpdateDilemmaHandler dilemmaParms = workspaceUpdateDilemmaParms;
            replaceComponentsInstruction = WorkspaceUpdateUtil.getInstruction(dilemmaParms.componentReplacementCandidatesDirection, true, "workspaceUpdateDilemmaHandler.componentReplacementCandidatesDirection");
            componentFlowInstruction = WorkspaceUpdateUtil.getInstruction(dilemmaParms.componentFlowDirection, true, "workspaceUpdateDilemmaHandler.componentFlowDirection");
            disconnectedComponentsInstruction = WorkspaceUpdateUtil.getInstruction(dilemmaParms.disconnectedComponentsDirection, false, "workspaceUpdateDilemmaHandler.disconnectedComponentsDirection");
            staleDataInstruction = WorkspaceUpdateUtil.getInstruction(dilemmaParms.staleDataDirection, false, "workspaceUpdateDilemmaHandler.staleDataDirection");
            activeChangeSetsInstruction = WorkspaceUpdateUtil.getInstruction(dilemmaParms.activeChangeSetsDirection, true, "activeChangeSetsDirection");
            activeChangeSetsOverlapInstruction = WorkspaceUpdateUtil.getInstruction(dilemmaParms.activeChangeSetsOverlapDirection, true, "activeChangeSetsOverlapDirection");
            gapInstruction = WorkspaceUpdateUtil.getInstruction(dilemmaParms.gapDirection, true, "gapDirection");
        }
        final int pendingChangesInstruction = CommitUtil.getUncheckedInChangesInstruction(pendingChangesDilemmaParms);
        WorkspaceUpdateDilemmaHandler workspaceUpdateDilemmaHandler = new WorkspaceUpdateDilemmaHandler(outOfSyncInstructions, outOfSyncShares, pendingChangesDilemmaParms, lineDelimiterErrors){
            final OutOfSyncDilemmaHandler outOfSyncDilemmaHandler;
            final CommitDilemmaHandler commitDilemmaHandler;
            {
                this.outOfSyncDilemmaHandler = VerifyOutOfSyncUtil.getOutOfSyncDilemmaHandler(parmsOutOfSyncInstructions, list);
                this.commitDilemmaHandler = CommitUtil.getCommitDilemmaHandler(parmsPendingChangesDilemmaHandler, this.outOfSyncDilemmaHandler, (List<LineDelimiterErrorDTO>)list2);
            }

            public int componentReplacementCandidates(Collection<ConfigurationDescriptor> replaceConfigurations) {
                WorkspaceUpdateUtil.recordConfigurationDescriptors(replaceConfigurations, componentReplacementCandidates);
                return replaceComponentsInstruction;
            }

            public int componentsToBeAddedOrRemoved(Collection<ConfigurationDescriptor> added, Collection<ConfigurationDescriptor> removed) {
                WorkspaceUpdateUtil.recordConfigurationDescriptors(added, componentFlowAdditions);
                WorkspaceUpdateUtil.recordConfigurationDescriptors(removed, componentFlowDeletions);
                return componentFlowInstruction;
            }

            public int disconnectedComponents(Collection<ConfigurationDescriptor> configurations) {
                WorkspaceUpdateUtil.recordConfigurationDescriptors(configurations, disconnectedComponents);
                return disconnectedComponentsInstruction;
            }

            public CommitDilemmaHandler getCommitDilemmaHandler() {
                return this.commitDilemmaHandler;
            }

            public int staleData(IWorkspaceConnection workspaceConnection, IWorkspaceConnection sourceWorkspaceConnection) {
                return staleDataInstruction;
            }

            public int uncheckedInChanges(Map<ConfigurationDescriptor, Collection<ILocalChange>> changes) {
                WorkspaceUpdateUtil.recordConfigurationDescriptors(changes.keySet(), configurationsWithPendingChanges);
                return pendingChangesInstruction;
            }

            public int outOfSync(Collection<IShareOutOfSync> sharesOutOfSync) {
                return this.outOfSyncDilemmaHandler.outOfSync(sharesOutOfSync);
            }

            public boolean willIgnoreAllSharesOutOfSync() {
                return this.outOfSyncDilemmaHandler.willIgnoreAllSharesOutOfSync();
            }

            public int collision(Collection<ICollision> collisions, Collection<IRemovedShare> removedShares, Collection<IShareOutOfSync> sharesOutOfSync) {
                return this.outOfSyncDilemmaHandler.collision(collisions, removedShares, sharesOutOfSync);
            }

            public int invalidLoadRequest(Collection<IInvalidLoadRequest> requests) {
                return this.outOfSyncDilemmaHandler.invalidLoadRequest(requests);
            }

            public int newItemsToLoad(Collection<IShareableToLoad> sharesToLoad) {
                return this.outOfSyncDilemmaHandler.newItemsToLoad(sharesToLoad);
            }

            public int overlappingLoadRequests(Collection<ILoadOverlap> foldersOverlapping) {
                return this.outOfSyncDilemmaHandler.overlappingLoadRequests(foldersOverlapping);
            }

            public int activeChangeSets(IWorkspaceConnection workspace, Collection<IChangeSetHandle> activeChangeSets) {
                if (activeChangeSets != null) {
                    activeChangeSetsEncountered.add(CoreUtil.translateProblemChangeSetsDTO(workspace, activeChangeSets));
                }
                return activeChangeSetsInstruction;
            }

            public int activeChangeSetsOverlap(IWorkspaceConnection workspace, Collection<? extends IChangeSetHandle> activeChangeSets) {
                if (activeChangeSetsOverlapEncountered != null) {
                    activeChangeSetsOverlapEncountered.add(CoreUtil.translateProblemChangeSetsDTO(workspace, activeChangeSets));
                }
                return activeChangeSetsOverlapInstruction;
            }

            public int gap(IWorkspaceConnection workspace, List<IChangeSetHandle> changeSetsWithGap, boolean handlingSuspended) {
                if (gapEncountered != null) {
                    gapEncountered.add(CoreUtil.translateGapProblemChangeSetsDTO(workspace, changeSetsWithGap, handlingSuspended));
                }
                return gapInstruction;
            }
        };
        return workspaceUpdateDilemmaHandler;
    }

    private static void recordConfigurationDescriptors(Collection<ConfigurationDescriptor> configurationDescriptors, List<ConfigurationDescriptorDTO> configurationDescriptorDTOs) {
        if (configurationDescriptorDTOs != null) {
            for (ConfigurationDescriptor descriptor : configurationDescriptors) {
                configurationDescriptorDTOs.add(CoreUtil.translateConfigurationDescriptor(descriptor));
            }
        }
    }

    private static int getInstruction(String direction, boolean noIsValidDirection, String field) {
        int uncheckedInChangesInstruction = 2;
        if ("continue".equals(direction)) {
            uncheckedInChangesInstruction = 0;
        } else if (direction == null) {
            uncheckedInChangesInstruction = 2;
        } else if ("cancel".equals(direction)) {
            uncheckedInChangesInstruction = 1;
        } else if ("fail".equals(direction)) {
            uncheckedInChangesInstruction = 2;
        } else if ("no".equals(direction)) {
            uncheckedInChangesInstruction = 3;
        } else {
            if (noIsValidDirection) {
                throw new IllegalArgumentException(NLS.bind((String)"Invalid value {0} of {1} must be one of {2}, {3}, {4} or {5}", (Object[])new Object[]{direction, field, "cancel", "continue", "no", "fail"}));
            }
            throw new IllegalArgumentException(NLS.bind((String)"Invalid value {0} of {1} must be one of {2}, {3}, or {4}", (Object[])new Object[]{direction, field, "cancel", "continue", "fail"}));
        }
        return uncheckedInChangesInstruction;
    }
}

