/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.rest.util;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.ignore.DefaultIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreRule;
import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.rest.parameters.ParmsShare;
import com.ibm.team.filesystem.client.rest.parameters.ParmsShareRequest;
import com.ibm.team.filesystem.common.internal.rest.client.share.FilesystemRestClientDTOshareFactory;
import com.ibm.team.filesystem.common.internal.rest.client.share.ShareOverlapDTO;
import com.ibm.team.filesystem.common.internal.rest.client.share.ShareResultDTO;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.operations.share.ShareProjectsOperationWithIgnores;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.CoreUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.IgnoresUtil;
import com.ibm.team.filesystem.rcp.core.operations.IShareOverlap;
import com.ibm.team.filesystem.rcp.core.operations.IShareProjectsOperation;
import com.ibm.team.filesystem.rcp.core.operations.ShareDilemmaHandler;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class ShareUtil {
    private static final String REQUEST_NAME = "share";

    public static ShareResultDTO share(ParmsShare parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        parms.validate(REQUEST_NAME);
        final ShareResultDTO result = FilesystemRestClientDTOshareFactory.eINSTANCE.createShareResultDTO();
        ShareDilemmaHandler shareDilemmaHandler = new ShareDilemmaHandler(){

            public int outOfSync(Collection<IShareOutOfSync> sharesOutOfSync) {
                return 0;
            }

            public boolean willIgnoreAllSharesOutOfSync() {
                return true;
            }

            @Override
            public int overlappingShareRequests(Collection<? extends IShareOverlap> projectShares) {
                for (IShareOverlap iShareOverlap : projectShares) {
                    result.getShareOverlaps().add(this.translateShareOverlap(iShareOverlap));
                }
                return 0;
            }

            private ShareOverlapDTO translateShareOverlap(IShareOverlap overlap) {
                ShareOverlapDTO shareOverlap = FilesystemRestClientDTOshareFactory.eINSTANCE.createShareOverlapDTO();
                shareOverlap.setRepositoryURL(overlap.getConnection().teamRepository().getRepositoryURI());
                shareOverlap.setWorkspaceItemId(overlap.getConnection().getContextHandle().getItemId().getUuidValue());
                shareOverlap.setComponentItemId(overlap.getComponent().getItemId().getUuidValue());
                shareOverlap.setFolderName(overlap.getProject().getName());
                for (IProject project : overlap.getOverlappingProjects()) {
                    shareOverlap.getOverlappingFolderNames().add(project.getName());
                }
                for (IShare share : overlap.getOverlappingShares()) {
                    shareOverlap.getOverlappingShares().add(CoreUtil.translateShare(share));
                }
                return shareOverlap;
            }
        };
        IShareProjectsOperation shareOperation = ShareUtil.prepareShareRequest(parms, shareDilemmaHandler, (IProgressMonitor)monitor.newChild(10));
        try {
            shareOperation.run((IProgressMonitor)monitor.newChild(90));
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
        }
        for (IChangeSetHandle changeSetHandle : shareOperation.getCommittedChangeSets()) {
            result.getCommittedChangeSetItemIds().add(changeSetHandle.getItemId().getUuidValue());
        }
        return result;
    }

    private static IShareProjectsOperation prepareShareRequest(ParmsShare parms, ShareDilemmaHandler dilemmaHandler, IProgressMonitor progress) throws TeamRepositoryException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        CopyFileAreaStore cfa = CopyFileAreaStore.getDefaultCopyFileArea();
        ShareProjectsOperationWithIgnores op = new ShareProjectsOperationWithIgnores(dilemmaHandler);
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)parms.shareRequests.length);
        ParmsShareRequest[] parmsShareRequestArray = parms.shareRequests;
        int n = parms.shareRequests.length;
        int n2 = 0;
        while (n2 < n) {
            ParmsShareRequest request = parmsShareRequestArray[n2];
            SubMonitor loopMonitor = SubMonitor.convert((IProgressMonitor)monitor.newChild(1), (int)60);
            IWorkspaceConnection workspace = request.workspace.getWorkspaceConnection((IProgressMonitor)loopMonitor.newChild(10));
            ArrayList<IProject> projects = new ArrayList<IProject>(request.foldersToShare.length);
            String[] stringArray = request.foldersToShare;
            int n3 = request.foldersToShare.length;
            int n4 = 0;
            while (n4 < n3) {
                String projectName = stringArray[n4];
                SubMonitor projectMonitor = SubMonitor.convert((IProgressMonitor)loopMonitor.newChild(20), (int)30);
                IProject project = root.getProject(projectName);
                if (!project.exists()) {
                    File projectFile = new File(cfa.getRoot().toFile(), projectName);
                    try {
                        projectFile = projectFile.getCanonicalFile();
                    }
                    catch (IOException iOException) {
                        throw new IllegalArgumentException(NLS.bind((String)Messages.ShareUtil_8, (Object)projectName));
                    }
                    projectName = project.getName();
                    if (!projectFile.exists() || !projectName.equals(projectFile.getName())) {
                        throw new IllegalArgumentException(NLS.bind((String)Messages.ShareUtil_7, (Object)projectName));
                    }
                    try {
                        project.create((IProgressMonitor)loopMonitor.newChild(10));
                        project.open((IProgressMonitor)loopMonitor.newChild(10));
                        project.refreshLocal(2, (IProgressMonitor)loopMonitor.newChild(10));
                    }
                    catch (CoreException e) {
                        throw new TeamRepositoryException((Throwable)e);
                    }
                }
                if (!project.isOpen()) {
                    try {
                        project.open((IProgressMonitor)monitor.newChild(10));
                        project.refreshLocal(2, (IProgressMonitor)loopMonitor.newChild(20));
                    }
                    catch (CoreException e) {
                        throw new TeamRepositoryException((Throwable)e);
                    }
                } else {
                    monitor.worked(30);
                }
                projects.add(project);
                projectMonitor.done();
                ++n4;
            }
            String[] newFolderNames = request.newFolderPath == null || request.newFolderPath.trim().length() == 0 ? new String[]{} : new Path(request.newFolderPath).segments();
            IComponentHandle component = request.getComponentHandle();
            if (component == null) {
                op.share(workspace, request.componentName, newFolderNames, projects, (boolean)parms.overwrite);
            } else {
                IChangeSetHandle changeSet = request.getChangeSetHandle();
                IFolderHandle parentFolder = request.getParentFolderHandle();
                op.share(workspace, changeSet, component, parentFolder, newFolderNames, projects, parms.overwrite);
            }
            if (request.ignoreRules != null) {
                try {
                    ShareUtil.purgeIgnoresBeforeShare(request, loopMonitor.newChild(10));
                }
                catch (CoreException e) {
                    throw new TeamRepositoryException(Messages.ShareUtil_FAILED_TO_PURGE_IGNORES, (Throwable)e);
                }
                if (request.ignoreRules.length > 0) {
                    DefaultIgnoreProvider dip = op.getIgnoreProvider();
                    IgnoresUtil.ValidatedIgnoreRuleList val = IgnoresUtil.validateIgnoreRuleList(workspace, component, dip, request.ignoreRules, (IProgressMonitor)loopMonitor.newChild(1));
                    SubMonitor ruleMonitor = SubMonitor.convert((IProgressMonitor)loopMonitor.newChild(9), (int)val.rules.size());
                    for (IgnoreRule rule : val.rules) {
                        try {
                            dip.addIgnoreRule((IIgnoreProvider.IIgnoreRule)rule, (IProgressMonitor)ruleMonitor.newChild(1));
                        }
                        catch (FileSystemClientException e) {
                            throw new TeamRepositoryException(NLS.bind((String)Messages.ShareUtil_FAILURE_CREATING_IGNORE_RULE, (Object)rule.getMatcher().getPattern()), (Throwable)e);
                        }
                    }
                    ruleMonitor.done();
                    dip.clearFileCache();
                }
            }
            loopMonitor.done();
            ++n2;
        }
        return op;
    }

    private static void purgeIgnoresBeforeShare(ParmsShareRequest request, SubMonitor monitor) throws CoreException {
        monitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(request.foldersToShare.length * 2));
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        int i = 1;
        String[] stringArray = request.foldersToShare;
        int n = request.foldersToShare.length;
        int n2 = 0;
        while (n2 < n) {
            String shareRoot = stringArray[n2];
            IProject project = root.getProject(shareRoot);
            monitor.setTaskName(NLS.bind((String)Messages.ShareUtil_PURGING_IGNORES_FROM_PROJECT, (Object[])new Object[]{shareRoot, i++, request.foldersToShare.length}));
            final LinkedList toDelete = new LinkedList();
            project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource.getName().equals(".jazzignore")) {
                        toDelete.add(resource);
                        return false;
                    }
                    return true;
                }
            });
            monitor.worked(1);
            SubMonitor victimMonitor = monitor.newChild(1);
            victimMonitor.setWorkRemaining(toDelete.size());
            for (IResource staleIgnoreFile : toDelete) {
                victimMonitor.subTask(NLS.bind((String)Messages.ShareUtil_DELETING_IGNORE_FILE, (Object)staleIgnoreFile.getFullPath().toPortableString()));
                staleIgnoreFile.delete(true, (IProgressMonitor)victimMonitor.newChild(1));
            }
            ++n2;
        }
    }
}

