/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.rest.util;

import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSyncSameOccurrences;
import com.ibm.team.filesystem.common.internal.rest.client.sync.FilesystemRestClientDTOsyncFactory;
import com.ibm.team.filesystem.common.internal.rest.client.sync.SameOccurrenceSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.SameOccurrencesSyncDTO;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IBaselineGroup;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IIncomingActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ISuspendedActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedSource;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ModelUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.UnresolvedSource;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.SyncViewDTOUtil;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchChangesUtil {
    public static SameOccurrencesSyncDTO getSyncSameOccurrences(ParmsSyncSameOccurrences parms) {
        SameOccurrencesSyncDTO result = FilesystemRestClientDTOsyncFactory.eINSTANCE.createSameOccurrencesSyncDTO();
        Object selection = SyncViewDTOUtil.find(ComponentSyncModel.getInstance(), parms.id);
        if (selection == null) {
            return result;
        }
        for (Object element : SearchChangesUtil.allOccurrences(selection)) {
            SameOccurrenceSyncDTO occurrence = FilesystemRestClientDTOsyncFactory.eINSTANCE.createSameOccurrenceSyncDTO();
            if (element instanceof IOutgoingActivitySource) {
                occurrence.setId(((IActivitySource)element).getModel().hashCode());
                occurrence.setOutgoing(true);
            } else if (element instanceof IIncomingActivitySource) {
                occurrence.setId(((IActivitySource)element).getModel().hashCode());
                occurrence.setIncoming(true);
            } else if (element instanceof ISuspendedActivitySource) {
                occurrence.setId(((IActivitySource)element).getModel().hashCode());
                occurrence.setSuspended(true);
            } else if (element instanceof IUnresolvedSource) {
                occurrence.setId(((IUnresolvedSource)element).getModel().hashCode());
                occurrence.setUnresolved(true);
            } else {
                occurrence.setId(element.hashCode());
            }
            result.getOccurrences().add(occurrence);
        }
        return result;
    }

    public static Set allOccurrences(Object current) {
        IComponentSyncContext context;
        if (current == null) {
            return Collections.EMPTY_SET;
        }
        IComponentSyncContext iComponentSyncContext = context = current instanceof ILocalChange ? ComponentSyncUtil.getContext(FileSystemResourcesPlugin.getComponentSyncModel(), (ILocalChange)current) : ComponentSyncUtil.getContext(current);
        if (context == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<Object> occurrences = new HashSet<Object>();
        List sources = context.getActivitySources();
        for (IActivitySource source : sources) {
            for (IRemoteActivity activity : source.getActivities()) {
                List changes = activity.getChanges();
                for (IRemoteChangeSummary summary : changes) {
                    if (!SearchChangesUtil.match(summary, current)) continue;
                    occurrences.add(summary);
                    occurrences.add(ComponentSyncUtil.findFolder(summary));
                    occurrences.add(activity);
                    occurrences.add(source);
                }
            }
            for (IBaselineGroup baselineGroup : source.getBaselines()) {
                for (IRemoteActivity activity : baselineGroup.getActivities()) {
                    List changes = activity.getChanges();
                    for (IRemoteChangeSummary summary : changes) {
                        if (!SearchChangesUtil.match(summary, current)) continue;
                        occurrences.add(summary);
                        occurrences.add(ComponentSyncUtil.findFolder(summary));
                        occurrences.add(activity);
                        occurrences.add(baselineGroup);
                        occurrences.add(source);
                    }
                }
            }
        }
        if (context.getType() != 0) {
            for (IUnresolvedFolder folder : ((UnresolvedSource)context.getUnresolvedSource()).getFolders()) {
                for (IUnresolvedItem item : folder.getItems()) {
                    if (!SearchChangesUtil.match(item, current) || item.getLocalChanges().contains(current) || item.getConflictItems().contains(current)) continue;
                    occurrences.add(item);
                    occurrences.addAll(item.getLocalChanges());
                    occurrences.addAll(item.getConflictItems());
                    occurrences.add(folder);
                    occurrences.add(context.getUnresolvedSource());
                }
            }
        }
        return occurrences;
    }

    private static boolean match(Object element1, Object element2) {
        if (element1 == element2) {
            return false;
        }
        Collection<IVersionableHandle> handles1 = SearchChangesUtil.getItems(element1);
        Collection<IVersionableHandle> handles2 = SearchChangesUtil.getItems(element2);
        for (IVersionableHandle handle : handles1) {
            if (!ModelUtil.containsSameItemId(handles2, (IItemHandle)handle)) continue;
            return true;
        }
        String path1 = SearchChangesUtil.getAfterPath(element1);
        String path2 = SearchChangesUtil.getAfterPath(element2);
        return path1 != null && path1.equals(path2);
    }

    private static Collection<IVersionableHandle> getItems(Object element) {
        if (element instanceof IRemoteChangeSummary) {
            return Collections.singletonList(((IRemoteChangeSummary)element).getItem());
        }
        if (element instanceof IConflictItem) {
            return Collections.singletonList(((IConflictItem)element).getItem());
        }
        if (element instanceof ILocalChange) {
            return Collections.singletonList(((ILocalChange)element).getTarget());
        }
        if (element instanceof IUnresolvedItem) {
            return ((IUnresolvedItem)element).getHandles();
        }
        return Collections.EMPTY_LIST;
    }

    private static String getAfterPath(Object element) {
        if (element instanceof IRemoteChangeSummary) {
            return ((IRemoteChangeSummary)element).getAfterPath();
        }
        if (element instanceof IUnresolvedItem) {
            return ((IUnresolvedItem)element).getId();
        }
        if (element instanceof IConflictItem) {
            return ((IConflictItem)element).getResourceName(true);
        }
        if (element instanceof ILocalChange) {
            ILocalChange c = (ILocalChange)element;
            if (c.isType(4)) {
                return c.getPath().toString();
            }
            return c.getResultingPath().toString();
        }
        return null;
    }
}

