/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.rest.util;

import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.ignore.DefaultIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreRule;
import com.ibm.team.filesystem.client.rest.parameters.ParmsGetIgnoredResourcesPaths;
import com.ibm.team.filesystem.client.rest.parameters.ParmsIgnoreRuleList;
import com.ibm.team.filesystem.client.rest.parameters.ParmsJazzIgnoreRule;
import com.ibm.team.filesystem.common.internal.rest.client.core.PathDTO;
import com.ibm.team.filesystem.common.internal.rest.client.ignores.FilesystemRestClientDTOignoresFactory;
import com.ibm.team.filesystem.common.internal.rest.client.ignores.IgnoreRuleDTO;
import com.ibm.team.filesystem.common.internal.rest.client.ignores.IgnoredResourcesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.ignores.JazzIgnoreRuleDTO;
import com.ibm.team.filesystem.common.internal.rest.client.ignores.UnknownIgnoreRuleDTO;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.resources.ShareableResource;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.CoreUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.ResourceUtil;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IgnoresUtil {
    public static ValidatedIgnoreRuleList validateIgnoreRuleList(ParmsIgnoreRuleList parms, String requestName, IProgressMonitor progress) throws TeamRepositoryException {
        parms.validate("", new Object[]{requestName});
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)2);
        IWorkspaceConnection wc = parms.workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(1));
        IComponentHandle componentHandle = null;
        ArrayList<IShareable> dirs = new ArrayList<IShareable>(parms.rules.length);
        int i = 0;
        while (i < parms.rules.length) {
            ParmsJazzIgnoreRule rule = parms.rules[i];
            IShareable dir = ResourceUtil.findShareableFor(rule.directoryPath);
            dirs.add(IgnoresUtil.findIgnoreRoot(rule.directoryPath));
            IShare share = dir.getShare();
            if (share == null) {
                throw new IllegalArgumentException(NLS.bind((String)"Rule directory[{0}] is not shared: {1}", (Object[])new Object[]{i, rule.directoryPath}));
            }
            IComponentHandle ruleCompHandle = share.getSharingDescriptor().getComponent();
            if (componentHandle == null) {
                componentHandle = ruleCompHandle;
            } else if (!ruleCompHandle.sameItemId((IItemHandle)componentHandle)) {
                throw new IllegalArgumentException(NLS.bind((String)"Component containing directory [{0}] ({1}) component containing directory [{2}] ({3}). ", (Object[])new Object[]{i - 1, parms.rules[i - 1].directoryPath, i, parms.rules[i].directoryPath}));
            }
            ++i;
        }
        DefaultIgnoreProvider dip = DefaultIgnoreProvider.getDefault();
        ArrayList<IgnoreRule> rules = new ArrayList<IgnoreRule>(parms.rules.length);
        int i2 = 0;
        while (i2 < parms.rules.length) {
            rules.addAll(dip.getIgnoreRulesFor(parms.rules[i2].pattern, Collections.singletonList((IShareable)dirs.get(i2)), "project-global".equals(parms.rules[i2].scope)));
            ++i2;
        }
        monitor.done();
        return new ValidatedIgnoreRuleList(wc, componentHandle, rules);
    }

    public static ValidatedIgnoreRuleList validateIgnoreRuleList(IWorkspaceConnection wc, IComponentHandle componentHandle, DefaultIgnoreProvider dip, ParmsJazzIgnoreRule[] unverifiedRules, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)2);
        ArrayList<IShareable> dirs = new ArrayList<IShareable>(unverifiedRules.length);
        int i = 0;
        while (i < unverifiedRules.length) {
            IComponentHandle ruleCompHandle;
            ParmsJazzIgnoreRule rule = unverifiedRules[i];
            IShareable dir = ResourceUtil.findShareableFor(rule.directoryPath);
            dirs.add(IgnoresUtil.findIgnoreRoot(rule.directoryPath));
            IShare share = dir.getShare();
            if (share != null && componentHandle != null && !(ruleCompHandle = share.getSharingDescriptor().getComponent()).sameItemId((IItemHandle)componentHandle)) {
                throw new IllegalArgumentException(NLS.bind((String)"Component containing directory [{0}] ({1}) component containing directory [{2}] ({3}). ", (Object[])new Object[]{i - 1, unverifiedRules[i - 1].directoryPath, i, unverifiedRules[i].directoryPath}));
            }
            ++i;
        }
        ArrayList<IgnoreRule> rules = new ArrayList<IgnoreRule>(unverifiedRules.length);
        int i2 = 0;
        while (i2 < unverifiedRules.length) {
            rules.addAll(dip.getIgnoreRulesFor(unverifiedRules[i2].pattern, Collections.singletonList((IShareable)dirs.get(i2)), "project-global".equals(unverifiedRules[i2].scope)));
            ++i2;
        }
        monitor.done();
        return new ValidatedIgnoreRuleList(wc, componentHandle, rules);
    }

    public static IShareable findIgnoreRoot(String root) {
        Path resourcePath = new Path(root);
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)resourcePath);
        if (resource.getType() != 2 && resource.getType() != 4) {
            throw new IllegalArgumentException("Root path must be folder: " + root);
        }
        return new ShareableResource((IResource)((IContainer)resource).getFile((IPath)new Path(".jazzignore")));
    }

    public static <T extends IIgnoreProvider.IIgnoreRule> IgnoreRuleDTO translateRule(T rule) {
        if (rule.getProvider() instanceof DefaultIgnoreProvider) {
            IgnoreRule dipRule = (IgnoreRule)rule;
            JazzIgnoreRuleDTO jir = FilesystemRestClientDTOignoresFactory.eINSTANCE.createJazzIgnoreRuleDTO();
            jir.setRuleType("jazzignore");
            jir.setPath(CoreUtil.translatePath(dipRule.getRootShareable()));
            jir.setPattern(dipRule.getMatcher().getPattern());
            jir.setScope(dipRule.isGlobal() ? "project-global" : "directory-local");
            return jir;
        }
        UnknownIgnoreRuleDTO uir = FilesystemRestClientDTOignoresFactory.eINSTANCE.createUnknownIgnoreRuleDTO();
        uir.setRuleType("unknown");
        uir.setProviderType(rule.getProvider().getClass().getName());
        uir.setDescription(rule.getShortDescription());
        return uir;
    }

    public static IgnoredResourcesDTO getIgnoredResources(final ParmsGetIgnoredResourcesPaths parms, IProgressMonitor progress) throws TeamRepositoryException {
        parms.validate("getIgnoredResources", parms);
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)parms.roots.length);
        IgnoredResourcesDTO dto = FilesystemRestClientDTOignoresFactory.eINSTANCE.createIgnoredResourcesDTO();
        final List ignoredFiles = dto.getIgnoredFiles();
        final List ignoredFolders = dto.getIgnoredFolders();
        int i = 0;
        IDepthVisitor visitor = new IDepthVisitor(){

            public boolean visit(IResource r, int currentDepth) {
                if (currentDepth > parms.depth && parms.depth != -1) {
                    return false;
                }
                IShareable shareable = (IShareable)r.getAdapter(IShareable.class);
                if (shareable == null) {
                    return r instanceof IWorkspaceRoot;
                }
                if (shareable.shouldBeIgnored()) {
                    PathDTO path = CoreUtil.translatePath(shareable);
                    if (r instanceof IContainer) {
                        ignoredFolders.add(path);
                    } else {
                        ignoredFiles.add(path);
                    }
                    return false;
                }
                return true;
            }
        };
        ArrayList<IResource> roots = new ArrayList<IResource>(parms.roots.length);
        String[] stringArray = parms.roots;
        int n = parms.roots.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            if (resource == null) {
                dto.getUnknownPaths().add(path);
            } else {
                roots.add(resource);
            }
            ++n2;
        }
        for (IResource resource : roots) {
            SubMonitor pathMonitor = monitor.newChild(1);
            pathMonitor.beginTask(NLS.bind((String)Messages.IgnoresUtil_PROGRESS_MESSAGE, (Object[])new Object[]{resource.getFullPath().toPortableString(), ++i, parms.roots.length}), 100);
            try {
                try {
                    Job.getJobManager().beginRule((ISchedulingRule)resource, (IProgressMonitor)pathMonitor.newChild(1));
                    IgnoresUtil.visit(resource, visitor, 0);
                }
                catch (CoreException e) {
                    throw new TeamRepositoryException("Exception while traversing " + resource.getFullPath().toPortableString(), (Throwable)e);
                }
            }
            finally {
                Job.getJobManager().endRule((ISchedulingRule)resource);
            }
            pathMonitor.done();
        }
        return dto;
    }

    private static void visit(IResource resource, IDepthVisitor depthVisitor, int depth) throws CoreException {
        if (!depthVisitor.visit(resource, depth)) {
            return;
        }
        if (resource instanceof IContainer) {
            IContainer container = (IContainer)resource;
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource r = iResourceArray[n2];
                IgnoresUtil.visit(r, depthVisitor, depth + 1);
                ++n2;
            }
        }
    }

    private static interface IDepthVisitor {
        public boolean visit(IResource var1, int var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ValidatedIgnoreRuleList {
        public final IWorkspaceConnection wc;
        public final IComponentHandle compHandle;
        public final List<IgnoreRule> rules;

        public ValidatedIgnoreRuleList(IWorkspaceConnection wc2, IComponentHandle compHandle2, ArrayList<IgnoreRule> rules2) {
            this.wc = wc2;
            this.compHandle = compHandle2;
            this.rules = rules2;
        }
    }
}

