/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.rest.util;

import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.HistoryItem;
import com.ibm.team.foundation.rcp.core.IDateProvider;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.osgi.util.NLS;

public class HistoryBin {
    public static final int HISTORY_ITEM_TODAY = 0;
    public static final int HISTORY_ITEM_YESTERDAY = 1;
    public static final int HISTORY_ITEM_EARLIER_THIS_WEEK = 2;
    public static final int HISTORY_ITEM_LASTWEEK = 3;
    public static final int HISTORY_ITEM_EARLIER_THIS_MONTH = 4;
    public static final int HISTORY_ITEM_LASTMONTH = 5;
    public static final int HISTORY_ITEM_EARLIER_THIS_YEAR = 6;
    public static final int HISTORY_ITEM_LASTYEAR = 7;
    public static final int HISTORY_ITEM_BEFORE_LASTYEAR = 8;
    public static final int HISTORY_ITEM_UNKNOWN = 9;
    private static Calendar fgCalBase = Calendar.getInstance();
    private static Calendar fgCalActual = Calendar.getInstance();
    private static DateFormat fgShortTimeFormat = DateFormat.getTimeInstance(3);
    private static DateFormat fgMediumDateFormat = DateFormat.getDateTimeInstance(2, 3);
    private static Calendar fgCal = Calendar.getInstance();
    private static final Date NULL_DATE = new Date(0L);
    private HistoryItem[] fHistoryItems = new HistoryItem[10];
    private List<Object> fElements = new ArrayList<Object>();
    private List<Date> fDates = new ArrayList<Date>();
    private static Calendar fCal = Calendar.getInstance();

    public HistoryBin(Object[] elements) {
        this.init();
        this.prepare(elements);
        this.fill(this.fElements.toArray(), this.fDates.toArray(new Date[this.fDates.size()]));
    }

    public HistoryBin(Object[] elements, Date[] dates) {
        Assert.isTrue((elements.length == dates.length ? 1 : 0) != 0);
        this.init();
        this.fElements.addAll((Collection<Object>)Arrays.asList(elements));
        int i = 0;
        while (i < dates.length) {
            this.fDates.add(dates[i] != null ? dates[i] : NULL_DATE);
            ++i;
        }
        this.fill(this.fElements.toArray(), this.fDates.toArray(new Date[this.fDates.size()]));
    }

    public void addItem(Object element, Date date) {
        Assert.isNotNull((Object)element);
        date = date != null ? date : NULL_DATE;
        this.fElements.add(element);
        this.fDates.add(date);
        this.fill(new Object[]{element}, new Date[]{date});
    }

    public void addItem(Object element) {
        Assert.isNotNull((Object)element);
        Date date = this.getDate(element);
        date = date != null ? date : NULL_DATE;
        this.fElements.add(element);
        this.fDates.add(date);
        this.fill(new Object[]{element}, new Date[]{date});
    }

    public HistoryItem[] getHistoryItems() {
        return this.fHistoryItems;
    }

    private Date getDate(Object object) {
        IAdaptable adaptable;
        Object dateProvider;
        if (object instanceof IDateProvider) {
            IDateProvider element = (IDateProvider)object;
            return element.getDate();
        }
        if (object instanceof IAdaptable && (dateProvider = (adaptable = (IAdaptable)object).getAdapter(IDateProvider.class)) != null) {
            return ((IDateProvider)dateProvider).getDate();
        }
        return null;
    }

    private void prepare(Object[] elements) {
        int i = 0;
        while (i < elements.length) {
            Object object = elements[i];
            Date date = this.getDate(object);
            this.fElements.add(object);
            this.fDates.add(date != null ? date : NULL_DATE);
            ++i;
        }
    }

    private void init() {
        this.fHistoryItems[0] = new HistoryItem(0);
        this.fHistoryItems[1] = new HistoryItem(1);
        this.fHistoryItems[2] = new HistoryItem(2);
        this.fHistoryItems[3] = new HistoryItem(3);
        this.fHistoryItems[4] = new HistoryItem(4);
        this.fHistoryItems[5] = new HistoryItem(5);
        this.fHistoryItems[6] = new HistoryItem(6);
        this.fHistoryItems[7] = new HistoryItem(7);
        this.fHistoryItems[8] = new HistoryItem(8);
        this.fHistoryItems[9] = new HistoryItem(9);
    }

    private void fill(Object[] obj, Date[] dates) {
        Date lastMonth;
        Assert.isTrue((obj.length == dates.length ? 1 : 0) != 0);
        fgCal.setTimeInMillis(HistoryBin.trimToDay(System.currentTimeMillis()));
        int month = fgCal.get(2);
        int year = fgCal.get(1);
        Date today = new Date(fgCal.getTimeInMillis());
        Date yesterday = new Date(today.getTime() - (long)this.toMillis(1));
        Date thisWeek = new Date(HistoryBin.trimToWeek(today.getTime()));
        Date lastweek = new Date(today.getTime() - (long)this.toMillis(fgCal.get(7) + 7));
        Date thisMonth = new Date(HistoryBin.trimToMonth(today.getTime()));
        Date thisYear = new Date(HistoryBin.trimToYear(today.getTime()));
        if (month != 0) {
            fgCal.set(2, month - 1);
            lastMonth = new Date(HistoryBin.trimToMonth(fgCal.getTimeInMillis()));
        } else {
            fgCal.set(1, year - 1);
            fgCal.set(2, 11);
            lastMonth = new Date(HistoryBin.trimToMonth(fgCal.getTimeInMillis()));
        }
        fgCal.setTimeInMillis(HistoryBin.trimToDay(System.currentTimeMillis()));
        fgCal.set(1, year - 1);
        Date lastYear = new Date(HistoryBin.trimToYear(fgCal.getTimeInMillis()));
        int i = 0;
        while (i < obj.length) {
            Object element = obj[i];
            Date date = dates[i];
            if (date == NULL_DATE) {
                this.fHistoryItems[9].addItem(element);
            } else if (date.after(today)) {
                this.fHistoryItems[0].addItem(element);
            } else if (date.after(yesterday)) {
                this.fHistoryItems[1].addItem(element);
            } else if (date.after(thisWeek)) {
                this.fHistoryItems[2].addItem(element);
            } else if (date.after(lastweek)) {
                this.fHistoryItems[3].addItem(element);
            } else if (date.after(thisMonth)) {
                this.fHistoryItems[4].addItem(element);
            } else if (date.after(lastMonth)) {
                this.fHistoryItems[5].addItem(element);
            } else if (date.after(thisYear)) {
                this.fHistoryItems[6].addItem(element);
            } else if (date.after(lastYear)) {
                this.fHistoryItems[7].addItem(element);
            } else {
                this.fHistoryItems[8].addItem(element);
            }
            ++i;
        }
    }

    private int toMillis(int days) {
        return days * 24 * 60 * 60 * 1000;
    }

    public static String getReadableTimeDif(Date date) {
        if (date == null) {
            return "";
        }
        long now = System.currentTimeMillis();
        long then = date.getTime();
        long dif = now - then;
        long second = 1000L;
        long minute = second * 60L;
        long hour = minute * 60L;
        int[] minuteIntervals = new int[]{1, 2, 3, 5, 10, 15, 20, 30, 45};
        int[] hourIntervals = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24};
        if (dif > -minute && dif < minute) {
            return Messages.HistoryBin_NOW;
        }
        if (dif < 0L) {
            if ((dif *= -1L) < minute) {
                return Messages.HistoryBin_IN_ONE_MINUTE;
            }
            int i = 1;
            while (i < minuteIntervals.length) {
                if (dif < (long)minuteIntervals[i] * minute) {
                    return NLS.bind((String)Messages.HistoryBin_IN_N_MINUTES, (Object)minuteIntervals[i]);
                }
                ++i;
            }
            if (dif < hour) {
                return Messages.HistoryBin_IN_ONE_HOUR;
            }
            i = 1;
            while (i < hourIntervals.length) {
                if (dif < (long)hourIntervals[i] * hour) {
                    return NLS.bind((String)Messages.HistoryBin_IN_N_HOURS, (Object)hourIntervals[i]);
                }
                ++i;
            }
            return Messages.HistoryBin_IN_MORE_THAN_ONE_DAY;
        }
        if (dif < minute) {
            return Messages.HistoryBin_ONE_MINUTE_AGO;
        }
        int i = 1;
        while (i < minuteIntervals.length) {
            if (dif < (long)minuteIntervals[i] * minute) {
                return NLS.bind((String)Messages.HistoryBin_N_MINUTES_AGO, (Object)minuteIntervals[i]);
            }
            ++i;
        }
        if (dif < hour) {
            return Messages.HistoryBin_ONE_HOUR_AGO;
        }
        i = 1;
        while (i < hourIntervals.length) {
            if (dif < (long)hourIntervals[i] * hour) {
                return NLS.bind((String)Messages.HistoryBin_N_HOURS_AGO, (Object)hourIntervals[i]);
            }
            ++i;
        }
        return Messages.HistoryBin_MORE_THAN_ONE_DAY_AGO;
    }

    public static String formatDif(Date date, boolean showAbsoluteDate, boolean showRelativeDate) {
        StringBuilder str = new StringBuilder();
        if (date == null) {
            return "";
        }
        fgCalBase.setTimeInMillis(System.currentTimeMillis());
        fgCalActual.setTime(date);
        int baseDay = fgCalBase.get(6);
        int actualDay = fgCalActual.get(6);
        int baseWeek = fgCalBase.get(3);
        int actualWeek = fgCalActual.get(3);
        int baseYear = fgCalBase.get(1);
        int actualYear = fgCalActual.get(1);
        if (baseDay == actualDay && baseYear == actualYear) {
            if (showAbsoluteDate) {
                str.append(fgShortTimeFormat.format(date));
            }
            if (showAbsoluteDate && showRelativeDate) {
                str.append(" ");
            }
            if (showRelativeDate) {
                str.append(showAbsoluteDate ? "(" : "").append(HistoryBin.getReadableTimeDif(date)).append(showAbsoluteDate ? ")" : "");
            }
        } else if (baseDay - actualDay == 1 && baseYear == actualYear) {
            if (showAbsoluteDate) {
                str.append(fgMediumDateFormat.format(date));
            }
            if (showAbsoluteDate && showRelativeDate) {
                str.append(" ");
            }
            if (showRelativeDate) {
                str.append(showAbsoluteDate ? "(" : "").append(Messages.HistoryBin_YESTERDAY).append(showAbsoluteDate ? ")" : "");
            }
        } else if (actualDay - baseDay == 1 && baseYear == actualYear) {
            if (showAbsoluteDate) {
                str.append(fgMediumDateFormat.format(date));
            }
            if (showAbsoluteDate && showRelativeDate) {
                str.append(" ");
            }
            if (showRelativeDate) {
                str.append(showAbsoluteDate ? "(" : "").append(Messages.HistoryBin_TOMORROW).append(showAbsoluteDate ? ")" : "");
            }
        } else if (baseWeek == actualWeek && baseYear == actualYear) {
            if (showAbsoluteDate) {
                str.append(fgMediumDateFormat.format(date));
            }
            if (showAbsoluteDate && showRelativeDate) {
                str.append(" ");
            }
            if (showRelativeDate) {
                int dayDif = actualDay - baseDay;
                String dayStr = dayDif * dayDif == 1 ? (dayDif > 0 ? Messages.HistoryBin_IN_ONE_DAY : Messages.HistoryBin_ONE_DAY_AGO) : (dayDif > 0 ? NLS.bind((String)Messages.HistoryBin_IN_N_DAYS, (Object)dayDif) : NLS.bind((String)Messages.HistoryBin_N_DAYS_AGO, (Object)(dayDif * -1)));
                str.append(showAbsoluteDate ? "(" : "").append(dayStr).append(showAbsoluteDate ? ")" : "");
            }
        } else if (baseWeek - actualWeek == 1 && baseYear == actualYear) {
            if (showAbsoluteDate) {
                str.append(fgMediumDateFormat.format(date));
            }
            if (showAbsoluteDate && showRelativeDate) {
                str.append(" ");
            }
            if (showRelativeDate) {
                str.append(showAbsoluteDate ? "(" : "").append(Messages.HistoryBin_LAST_WEEK).append(showAbsoluteDate ? ")" : "");
            }
        } else if (actualWeek - baseWeek == 1 && baseYear == actualYear) {
            if (showAbsoluteDate) {
                str.append(fgMediumDateFormat.format(date));
            }
            if (showAbsoluteDate && showRelativeDate) {
                str.append(" ");
            }
            if (showRelativeDate) {
                str.append(showAbsoluteDate ? "(" : "").append(Messages.HistoryBin_NEXT_WEEK).append(showAbsoluteDate ? ")" : "");
            }
        } else if (baseYear == actualYear) {
            str.append(fgMediumDateFormat.format(date));
        } else {
            str.append(fgMediumDateFormat.format(date));
        }
        return str.toString();
    }

    public static long trimToHour(long date) {
        fCal.setTimeInMillis(date);
        fCal.set(12, 0);
        fCal.set(13, 0);
        fCal.set(14, 0);
        return fCal.getTimeInMillis();
    }

    public static long trimToDay(long date) {
        fCal.setTimeInMillis(date);
        fCal.set(11, 0);
        fCal.set(12, 0);
        fCal.set(13, 0);
        fCal.set(14, 0);
        return fCal.getTimeInMillis();
    }

    public static long trimToWeek(long date) {
        fCal.setTimeInMillis(date);
        fCal.set(7, fCal.getFirstDayOfWeek());
        fCal.set(11, 0);
        fCal.set(12, 0);
        fCal.set(13, 0);
        fCal.set(14, 0);
        return fCal.getTimeInMillis();
    }

    public static long trimToMonth(long date) {
        fCal.setTimeInMillis(date);
        fCal.set(5, 1);
        fCal.set(11, 0);
        fCal.set(12, 0);
        fCal.set(13, 0);
        fCal.set(14, 0);
        return fCal.getTimeInMillis();
    }

    public static long trimToYear(long date) {
        fCal.setTimeInMillis(date);
        fCal.set(2, 0);
        fCal.set(6, 1);
        fCal.set(11, 0);
        fCal.set(12, 0);
        fCal.set(13, 0);
        fCal.set(14, 0);
        return fCal.getTimeInMillis();
    }
}

