/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.rest.util;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.client.operations.IInvalidLoadRequest;
import com.ibm.team.filesystem.client.operations.ILoadOverlap;
import com.ibm.team.filesystem.client.operations.IRemovedShare;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.IShareableToLoad;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeleteFoldersInWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsMoveAcrossComponentRequest;
import com.ibm.team.filesystem.client.rest.parameters.ParmsMoveFoldersInWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConfigurationDescriptorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.LineDelimiterErrorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.DeleteFoldersInWorkspaceResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.FilesystemRestClientDTOworkspaceFactory;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.MoveFoldersInWorkspaceResultDTO;
import com.ibm.team.filesystem.rcp.core.IEclipseFileSystemManager;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.resources.ShareableResource;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.CommitUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.CoreUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.VerifyOutOfSyncUtil;
import com.ibm.team.filesystem.rcp.core.operations.IDeleteFoldersOperation;
import com.ibm.team.filesystem.rcp.core.operations.IMoveFoldersOperation;
import com.ibm.team.filesystem.rcp.core.operations.MoveFoldersDilemmaHandler;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

public class FolderManipulationUtil {
    static final String MOVE_FOLDERS = "moveFoldersInWorkspace";
    static final String DELETE_FOLDERS = "deleteFoldersInWorkspace";

    public static DeleteFoldersInWorkspaceResultDTO deleteFoldersInWorkspace(ParmsDeleteFoldersInWorkspace parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        parms.validate(DELETE_FOLDERS);
        DeleteFoldersInWorkspaceResultDTO result = FilesystemRestClientDTOworkspaceFactory.eINSTANCE.createDeleteFoldersInWorkspaceResultDTO();
        OutOfSyncDilemmaHandler oosDilemmaHandler = VerifyOutOfSyncUtil.getOutOfSyncDilemmaHandler(parms.outOfSyncInstructions, result.getOutOfSyncShares());
        CommitDilemmaHandler dilemmaHandler = CommitUtil.getCommitDilemmaHandler(null, oosDilemmaHandler, null);
        IDeleteFoldersOperation op = FolderManipulationUtil.prepareOperation(parms, dilemmaHandler, monitor.newChild(10));
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            op.run((IProgressMonitor)monitor.newChild(75));
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
        }
        catch (OperationCanceledException operationCanceledException) {
            result.setCancelled(true);
        }
        return result;
    }

    private static IDeleteFoldersOperation prepareOperation(ParmsDeleteFoldersInWorkspace parms, CommitDilemmaHandler dilemmaHandler, SubMonitor newChild) throws TeamRepositoryException {
        IDeleteFoldersOperation op = IEclipseFileSystemManager.instance.getDeleteFoldersOperation(dilemmaHandler);
        IShareable[] shareables = new IShareable[parms.projectsToDelete.length];
        int i = 0;
        while (i < parms.projectsToDelete.length) {
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(parms.projectsToDelete[i]));
            if (resource == null) {
                throw new TeamRepositoryException(NLS.bind((String)Messages.FolderManipulationUtil_0, (Object[])new Object[]{parms.projectsToDelete[i]}));
            }
            shareables[i] = new ShareableResource(resource);
            ++i;
        }
        op.addDeleteRequest(shareables);
        if (parms.deleteContent != null && parms.deleteContent.booleanValue()) {
            op.setDeleteContent(true);
        } else {
            op.setDeleteContent(false);
        }
        return op;
    }

    public static MoveFoldersInWorkspaceResultDTO moveFoldersInWorkspace(ParmsMoveFoldersInWorkspace parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        parms.validate(MOVE_FOLDERS);
        MoveFoldersInWorkspaceResultDTO result = FilesystemRestClientDTOworkspaceFactory.eINSTANCE.createMoveFoldersInWorkspaceResultDTO();
        MoveFoldersDilemmaHandler dilemmaHandler = FolderManipulationUtil.getMoveFoldersDilemmaHandler(parms, result.getOutOfSyncShares(), result.getConfigurationsWithUnCheckedInChanges(), result.getLineDelimiterFailures(), monitor.newChild(10));
        IMoveFoldersOperation op = FolderManipulationUtil.prepareOperation(parms, dilemmaHandler, (IProgressMonitor)monitor.newChild(10));
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            op.run((IProgressMonitor)monitor.newChild(80));
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
        }
        catch (OperationCanceledException operationCanceledException) {
            result.setCancelled(true);
        }
        return result;
    }

    private static MoveFoldersDilemmaHandler getMoveFoldersDilemmaHandler(ParmsMoveFoldersInWorkspace parms, List outOfSyncShares, final List configurationsWithPendingChanges, List lineDelimiterFailures, SubMonitor newChild) {
        final int pendingChangesInstruction = CommitUtil.getUncheckedInChangesInstruction(parms.pendingChangesDilemmaHandler);
        final OutOfSyncDilemmaHandler outOfSyncDilemmaHandler = VerifyOutOfSyncUtil.getOutOfSyncDilemmaHandler(parms.outOfSyncInstructions, outOfSyncShares);
        final CommitDilemmaHandler commitDilemmaHandler = CommitUtil.getCommitDilemmaHandler(parms.pendingChangesDilemmaHandler, outOfSyncDilemmaHandler, (List<LineDelimiterErrorDTO>)lineDelimiterFailures);
        MoveFoldersDilemmaHandler dilemmaHandler = new MoveFoldersDilemmaHandler(){

            public CommitDilemmaHandler getCommitDilemmaHandler() {
                return commitDilemmaHandler;
            }

            public int uncheckedInChanges(Map<ConfigurationDescriptor, Collection<ILocalChange>> changes) {
                this.recordConfigurationDescriptors((Collection<ConfigurationDescriptor>)changes.keySet(), configurationsWithPendingChanges);
                return pendingChangesInstruction;
            }

            public int outOfSync(Collection<IShareOutOfSync> sharesOutOfSync) {
                return outOfSyncDilemmaHandler.outOfSync(sharesOutOfSync);
            }

            public boolean willIgnoreAllSharesOutOfSync() {
                return outOfSyncDilemmaHandler.willIgnoreAllSharesOutOfSync();
            }

            public int collision(Collection<ICollision> collisions, Collection<IRemovedShare> removedShares, Collection<IShareOutOfSync> sharesOutOfSync) {
                return outOfSyncDilemmaHandler.collision(collisions, removedShares, sharesOutOfSync);
            }

            public int invalidLoadRequest(Collection<IInvalidLoadRequest> requests) {
                return outOfSyncDilemmaHandler.invalidLoadRequest(requests);
            }

            public int newItemsToLoad(Collection<IShareableToLoad> sharesToLoad) {
                return outOfSyncDilemmaHandler.newItemsToLoad(sharesToLoad);
            }

            public int overlappingLoadRequests(Collection<ILoadOverlap> foldersOverlapping) {
                return outOfSyncDilemmaHandler.overlappingLoadRequests(foldersOverlapping);
            }

            private void recordConfigurationDescriptors(Collection<ConfigurationDescriptor> configurationDescriptors, List<ConfigurationDescriptorDTO> configurationDescriptorDTOs) {
                if (configurationDescriptorDTOs != null) {
                    for (ConfigurationDescriptor descriptor : configurationDescriptors) {
                        configurationDescriptorDTOs.add(CoreUtil.translateConfigurationDescriptor(descriptor));
                    }
                }
            }
        };
        return dilemmaHandler;
    }

    private static IMoveFoldersOperation prepareOperation(ParmsMoveFoldersInWorkspace parms, MoveFoldersDilemmaHandler dilemmaHandler, IProgressMonitor progress) throws TeamRepositoryException {
        IComponentHandle sourceComponent;
        IWorkspaceConnection workspaceConnection;
        ParmsMoveAcrossComponentRequest request;
        int n;
        int n2;
        ParmsMoveAcrossComponentRequest[] parmsMoveAcrossComponentRequestArray;
        SubMonitor iterProgress;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IMoveFoldersOperation op = IEclipseFileSystemManager.instance.getMoveFoldersOperation(dilemmaHandler);
        if (parms.moveAcrossComponentRequests != null) {
            iterProgress = monitor.newChild(50);
            iterProgress = iterProgress.setWorkRemaining(parms.moveAcrossComponentRequests.length);
            parmsMoveAcrossComponentRequestArray = parms.moveAcrossComponentRequests;
            n2 = parms.moveAcrossComponentRequests.length;
            n = 0;
            while (n < n2) {
                request = parmsMoveAcrossComponentRequestArray[n];
                workspaceConnection = request.workspace.getWorkspaceConnection((IProgressMonitor)iterProgress.newChild(1));
                sourceComponent = request.getSourceComponentHandle();
                IComponentHandle targetComponent = request.getTargetComponentHandle();
                IFolderHandle[] foldersToMove = request.getToMoveFolderHandles();
                IFolderHandle[] parentsToMoveInto = request.getParentFolderHandles();
                op.addMoveAcrossComponentRequest(workspaceConnection, sourceComponent, foldersToMove, targetComponent, parentsToMoveInto, request.sourceChangeSetComment, request.targetChangeSetComment);
                ++n;
            }
        }
        if (parms.moveWithinComponentRequests != null) {
            iterProgress = monitor.newChild(50);
            iterProgress = iterProgress.setWorkRemaining(parms.moveWithinComponentRequests.length);
            parmsMoveAcrossComponentRequestArray = parms.moveWithinComponentRequests;
            n2 = parms.moveWithinComponentRequests.length;
            n = 0;
            while (n < n2) {
                request = parmsMoveAcrossComponentRequestArray[n];
                workspaceConnection = request.workspace.getWorkspaceConnection((IProgressMonitor)iterProgress.newChild(1));
                sourceComponent = request.getComponentHandle();
                IFolderHandle[] foldersToMove = request.getToMoveFolderHandles();
                IFolderHandle[] parentsToMoveInto = request.getParentFolderHandles();
                op.addMoveWithinComponentRequest(workspaceConnection, sourceComponent, foldersToMove, parentsToMoveInto, request.changeSetComment);
                ++n;
            }
        }
        if (parms.renameFolderRequests != null) {
            iterProgress = monitor.newChild(50);
            iterProgress = iterProgress.setWorkRemaining(parms.moveWithinComponentRequests.length);
            parmsMoveAcrossComponentRequestArray = parms.renameFolderRequests;
            n2 = parms.renameFolderRequests.length;
            n = 0;
            while (n < n2) {
                request = parmsMoveAcrossComponentRequestArray[n];
                workspaceConnection = request.workspace.getWorkspaceConnection((IProgressMonitor)iterProgress.newChild(1));
                IComponentHandle component = request.getComponentHandle();
                IFolderHandle[] foldersToRename = request.getRenameFolderHandles();
                op.addRenameRequest(workspaceConnection, component, foldersToRename, request.newNames, request.changeSetComment);
                ++n;
            }
        }
        return op;
    }
}

