/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.rest.util;

import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.FilesystemRestClientDTOchangesetFactory;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.GapChangeSetsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.ProblemChangeSetsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.BaselineDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.BaselineSetDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConfigurationDescriptorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConnectionDescriptorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.FilesystemRestClientDTOcoreFactory;
import com.ibm.team.filesystem.common.internal.rest.client.core.PathDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceFlowEntryDTO;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentFlowUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.internal.FlowUtils;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.ICurrentComponentInfo;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreUtil {
    public static ShareDTO translateShare(IShare share) {
        ShareDTO translation = FilesystemRestClientDTOcoreFactory.eINSTANCE.createShareDTO();
        ISharingDescriptor sharingDescriptor = share.getSharingDescriptor();
        translation.setComponentItemId(sharingDescriptor.getComponent().getItemId().getUuidValue());
        translation.setComponentName(sharingDescriptor.getComponentName());
        translation.setRootFolderItemId(sharingDescriptor.getRootFolder().getItemId().getUuidValue());
        translation.setPath(CoreUtil.translatePath(share.getPath()));
        translation.setContextItemId(sharingDescriptor.getConnectionHandle().getItemId().getUuidValue());
        translation.setIsWorkspaceContext(sharingDescriptor.getConnectionHandle() instanceof IWorkspaceHandle);
        translation.setContextName(sharingDescriptor.getConnectionName());
        translation.setRepositoryURL(sharingDescriptor.getRepositoryUri());
        return translation;
    }

    public static String translatePathToString(PathDTO path) {
        StringBuffer buf = new StringBuffer();
        for (String seg : path.getSegments()) {
            buf.append('/');
            buf.append(seg);
        }
        return buf.toString();
    }

    public static PathDTO translatePath(IPath path) {
        return CoreUtil.translatePath(path.segments());
    }

    public static PathDTO translatePath(IShareable shareable) {
        return CoreUtil.translatePath(shareable.getLocalFullPath());
    }

    public static PathDTO translatePath(String path) {
        return CoreUtil.translatePath(new Path(path).segments());
    }

    public static PathDTO translatePath(String[] pathSegments) {
        PathDTO path = FilesystemRestClientDTOcoreFactory.eINSTANCE.createPathDTO();
        path.getSegments().addAll((Collection)Arrays.asList(pathSegments));
        return path;
    }

    public static PathDTO translatePath(IAncestorReport report) {
        PathDTO path = FilesystemRestClientDTOcoreFactory.eINSTANCE.createPathDTO();
        Iterator iPairs = report.getNameItemPairs().iterator();
        iPairs.next();
        while (iPairs.hasNext()) {
            path.getSegments().add(((INameItemPair)iPairs.next()).getName());
        }
        return path;
    }

    public static ConfigurationDescriptorDTO translateConfigurationDescriptor(ConfigurationDescriptor descriptor) {
        ConfigurationDescriptorDTO configurationDescriptor = FilesystemRestClientDTOcoreFactory.eINSTANCE.createConfigurationDescriptorDTO();
        ConnectionDescriptorDTO connectionDescriptor = FilesystemRestClientDTOcoreFactory.eINSTANCE.createConnectionDescriptorDTO();
        connectionDescriptor.setRepositoryURL(descriptor.uri);
        connectionDescriptor.setContextItemId(descriptor.connectionHandle.getItemId().getUuidValue());
        connectionDescriptor.setIsWorkspaceContext(descriptor.connectionHandle instanceof IWorkspaceHandle);
        configurationDescriptor.setConnection(connectionDescriptor);
        configurationDescriptor.setComponentItemId(descriptor.componentHandle.getItemId().getUuidValue());
        return configurationDescriptor;
    }

    public static BaselineDTO translateBaseline(IBaselineConnection baselineConnection, HashMap<UUID, IContributor> contributors) {
        return CoreUtil.translateBaseline(baselineConnection.teamRepository(), baselineConnection.getResolvedBaseline(), contributors);
    }

    public static HashMap<UUID, IContributor> fetchCreatorAndGetModifiedBy(ITeamRepository repo, List<IBaseline> baselines, IProgressMonitor monitor) throws TeamRepositoryException {
        HashMap<UUID, IContributorHandle> contributorHandles = new HashMap<UUID, IContributorHandle>();
        for (IBaseline baseline : baselines) {
            IContributorHandle contributor = baseline.getCreator();
            contributorHandles.put(contributor.getItemId(), contributor);
            contributor = baseline.getModifiedBy();
            if (contributor == null) continue;
            contributorHandles.put(contributor.getItemId(), contributor);
        }
        List contributors = repo.itemManager().fetchCompleteItems(new ArrayList(contributorHandles.values()), 0, monitor);
        HashMap<UUID, IContributor> result = new HashMap<UUID, IContributor>();
        for (IContributorHandle contributor : contributors) {
            result.put(contributor.getItemId(), (IContributor)contributor);
        }
        return result;
    }

    public static BaselineDTO translateBaseline(ITeamRepository repository, IBaseline baseline, HashMap<UUID, IContributor> contributors) {
        BaselineDTO baselineDTO = FilesystemRestClientDTOcoreFactory.eINSTANCE.createBaselineDTO();
        baselineDTO.setItemId(baseline.getItemId().getUuidValue());
        baselineDTO.setRepositoryURL(repository.getRepositoryURI());
        baselineDTO.setId(baseline.getId());
        baselineDTO.setName(baseline.getName());
        baselineDTO.setComment(baseline.getComment());
        baselineDTO.setComponentItemId(baseline.getComponent().getItemId().getUuidValue());
        baselineDTO.setCreationDate(baseline.getCreationDate().getTime());
        baselineDTO.setCreatorContributorItemId(baseline.getCreator().getItemId().getUuidValue());
        baselineDTO.setModifiedDate(baseline.modified().getTime());
        baselineDTO.setModifierContributorItemId(baseline.getModifiedBy().getItemId().getUuidValue());
        IContributor contributor = contributors.get(baseline.getCreator().getItemId());
        if (contributor != null) {
            baselineDTO.setCreatorContributorName(contributor.getName());
        }
        if ((contributor = contributors.get(baseline.getModifiedBy().getItemId())) != null) {
            baselineDTO.setModifierContributorName(contributor.getName());
        }
        return baselineDTO;
    }

    public static BaselineSetDTO translateBaselineSet(ITeamRepository repository, IBaselineSet baselineSet) {
        BaselineSetDTO baselineSetDTO = FilesystemRestClientDTOcoreFactory.eINSTANCE.createBaselineSetDTO();
        baselineSetDTO.setComment(baselineSet.getComment());
        baselineSetDTO.setCreationDate(baselineSet.getCreationDate().getTime());
        baselineSetDTO.setCreatorContributorItemId(baselineSet.getCreator().getItemId().getUuidValue());
        baselineSetDTO.setItemId(baselineSet.getItemId().getUuidValue());
        baselineSetDTO.setModifiedDate(baselineSet.modified().getTime());
        baselineSetDTO.setModifierContributorItemId(baselineSet.getModifiedBy().getItemId().getUuidValue());
        baselineSetDTO.setName(baselineSet.getName());
        baselineSetDTO.setOwnerWorkspaceItemId(baselineSet.getOwner().getItemId().getUuidValue());
        baselineSetDTO.setRepositoryURL(repository.getRepositoryURI());
        for (IBaselineHandle baselineHandle : baselineSet.getBaselines()) {
            baselineSetDTO.getBaselineItemIds().add(baselineHandle.getItemId().getUuidValue());
        }
        return baselineSetDTO;
    }

    public static ProblemChangeSetsDTO translateProblemChangeSetsDTO(IWorkspaceConnection workspace, Collection<? extends IChangeSetHandle> changeSets) {
        ProblemChangeSetsDTO problemChangeSetsDTO = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createProblemChangeSetsDTO();
        problemChangeSetsDTO.setRepositoryURL(workspace.teamRepository().getRepositoryURI());
        problemChangeSetsDTO.setWorkspaceItemId(workspace.getContextHandle().getItemId().getUuidValue());
        for (IChangeSetHandle iChangeSetHandle : changeSets) {
            problemChangeSetsDTO.getChangeSetItemIds().add(iChangeSetHandle.getItemId().getUuidValue());
        }
        return problemChangeSetsDTO;
    }

    public static GapChangeSetsDTO translateGapProblemChangeSetsDTO(IWorkspaceConnection workspace, Collection<IChangeSetHandle> changeSets, boolean handlingSuspended) {
        GapChangeSetsDTO gapChangeSetsDTO = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createGapChangeSetsDTO();
        gapChangeSetsDTO.setRepositoryURL(workspace.teamRepository().getRepositoryURI());
        gapChangeSetsDTO.setWorkspaceItemId(workspace.getContextHandle().getItemId().getUuidValue());
        for (IChangeSetHandle changeSet : changeSets) {
            gapChangeSetsDTO.getChangeSetItemIds().add(changeSet.getItemId().getUuidValue());
        }
        gapChangeSetsDTO.setHandlingSuspended(handlingSuspended);
        return gapChangeSetsDTO;
    }

    public static WorkspaceDetailsDTO translateWorkspace(IWorkspaceConnection connection, boolean includeComponents, boolean includeFlowTargets, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        WorkspaceDetailsDTO workspace = FilesystemRestClientDTOcoreFactory.eINSTANCE.createWorkspaceDetailsDTO();
        workspace.setRepositoryURL(connection.teamRepository().getRepositoryURI());
        workspace.setItemId(connection.getResolvedWorkspace().getItemId().getUuidValue());
        workspace.setOwner(connection.getOwner());
        workspace.setName(connection.getName());
        workspace.setDescription(connection.getDescription());
        workspace.setStream(connection.isStream());
        if (includeComponents) {
            ArrayList<Object> toRetrieve = new ArrayList<Object>(2 * connection.getComponentsInfo().size());
            for (ICurrentComponentInfo currentComponentInfo : connection.getComponentsInfo()) {
                toRetrieve.add(currentComponentInfo.basis());
                toRetrieve.add(currentComponentInfo.getComponent());
            }
            List items = connection.teamRepository().itemManager().fetchCompleteItems(toRetrieve, 0, (IProgressMonitor)monitor.newChild(80));
            HashMap<UUID, IAuditable> retrieved = new HashMap<UUID, IAuditable>();
            ArrayList<IBaseline> baselines = new ArrayList<IBaseline>();
            for (IAuditable auditable : items) {
                if (auditable == null) continue;
                retrieved.put(auditable.getItemId(), auditable);
                if (!(auditable instanceof IBaseline)) continue;
                baselines.add((IBaseline)auditable);
            }
            HashMap<UUID, IContributor> contributors = CoreUtil.fetchCreatorAndGetModifiedBy(connection.teamRepository(), baselines, (IProgressMonitor)monitor.newChild(20));
            for (ICurrentComponentInfo currentComponentInfo : connection.getComponentsInfo()) {
                BaselineDTO baselineDTO;
                WorkspaceComponentDTO component = FilesystemRestClientDTOcoreFactory.eINSTANCE.createWorkspaceComponentDTO();
                workspace.getComponents().add(component);
                component.setItemId(currentComponentInfo.getComponent().getItemId().getUuidValue());
                IAuditable auditable = (IAuditable)retrieved.get(currentComponentInfo.getComponent().getItemId());
                if (auditable instanceof IComponent) {
                    IComponent fullComponent = (IComponent)auditable;
                    component.setName(fullComponent.getName());
                    component.setRootFolder(fullComponent.getRootFolder().getItemId().getUuidValue());
                    component.setOwner(fullComponent.getOwner());
                }
                if ((auditable = (IAuditable)retrieved.get(currentComponentInfo.basis().getItemId())) instanceof IBaseline) {
                    IBaseline fullBaseline = (IBaseline)auditable;
                    baselineDTO = CoreUtil.translateBaseline(connection.teamRepository(), fullBaseline, contributors);
                } else {
                    baselineDTO = FilesystemRestClientDTOcoreFactory.eINSTANCE.createBaselineDTO();
                    baselineDTO.setItemId(currentComponentInfo.basis().getItemId().getUuidValue());
                }
                component.setBaseline(baselineDTO);
            }
        }
        if (includeFlowTargets) {
            IFlowNodeHandle flowNode;
            List flowEntries = workspace.getFlowEntries();
            IFlowTable flowTable = connection.getFlowTable();
            IWorkspaceHandle defaultCollaborationHandle = FlowUtils.getDefaultFlowTarget((IWorkspaceConnection)connection);
            IWorkspaceHandle currentCollaborationHandle = ComponentFlowUtil.getCurrentCollaboration(connection);
            HashSet<UUID> targetsReported = new HashSet<UUID>();
            for (IFlowEntry entry : flowTable.acceptSources()) {
                flowNode = entry.getFlowNode();
                if (!(flowNode instanceof IWorkspaceHandle) || !targetsReported.add(flowNode.getItemId())) continue;
                flowEntries.add(CoreUtil.translateFlowEntry(entry, defaultCollaborationHandle, currentCollaborationHandle, connection.teamRepository()));
            }
            for (IFlowEntry entry : flowTable.deliverTargets()) {
                flowNode = entry.getFlowNode();
                if (!(flowNode instanceof IWorkspaceHandle) || !targetsReported.add(flowNode.getItemId())) continue;
                flowEntries.add(CoreUtil.translateFlowEntry(entry, defaultCollaborationHandle, currentCollaborationHandle, connection.teamRepository()));
            }
        }
        return workspace;
    }

    private static WorkspaceFlowEntryDTO translateFlowEntry(IFlowEntry entry, IWorkspaceHandle defaultCollaborationHandle, IWorkspaceHandle currentCollaborationHandle, ITeamRepository fallbackRepo) {
        WorkspaceFlowEntryDTO flowEntry = FilesystemRestClientDTOcoreFactory.eINSTANCE.createWorkspaceFlowEntryDTO();
        flowEntry.setRepositoryURL(fallbackRepo.getRepositoryURI());
        flowEntry.setWorkspaceItemId(entry.getFlowNode().getItemId().getUuidValue());
        flowEntry.setCurrentFlow(currentCollaborationHandle.sameItemId((IItemHandle)entry.getFlowNode()));
        flowEntry.setDefaultFlow(defaultCollaborationHandle.sameItemId((IItemHandle)entry.getFlowNode()));
        List componentScopes = entry.getComponentScopes();
        for (IComponentHandle componentHandle : componentScopes) {
            flowEntry.getScopedComponentItemIds().add(componentHandle.getItemId().getUuidValue());
        }
        return flowEntry;
    }

    public static IResource findRoot(IPath path, IProgressMonitor progress) throws TeamRepositoryException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource existingAncestor = null;
        IPath existingAncestorPath = path;
        while (path.segmentCount() > 0) {
            existingAncestor = root.findMember(existingAncestorPath);
            if (existingAncestor != null) break;
            existingAncestorPath = existingAncestorPath.removeLastSegments(1);
        }
        assert (existingAncestor != null && existingAncestor.exists());
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)progress, (int)1);
        mon.beginTask(NLS.bind((String)Messages.CoreUtil_REFRESHING_TO_PATH, (Object)path.toPortableString()), path.segmentCount() - existingAncestorPath.segmentCount());
        if (existingAncestor.getFullPath().equals((Object)path)) {
            try {
                existingAncestor.refreshLocal(0, (IProgressMonitor)mon.newChild(1));
            }
            catch (CoreException e) {
                throw new TeamRepositoryException("Exception refreshing " + existingAncestor.getFullPath().toPortableString(), (Throwable)e);
            }
            if (existingAncestor.exists()) {
                return existingAncestor;
            }
            return null;
        }
        mon.setWorkRemaining(path.segmentCount() - existingAncestor.getFullPath().segmentCount());
        IPath walker = existingAncestor.getFullPath();
        int i = walker.segmentCount();
        while (i < path.segmentCount()) {
            mon.subTask(NLS.bind((String)Messages.CoreUtil_REFRESHING_PATH, (Object)existingAncestor.getFullPath().toPortableString()));
            try {
                existingAncestor.refreshLocal(1, (IProgressMonitor)mon.newChild(1));
            }
            catch (CoreException e) {
                throw new TeamRepositoryException("Exception refreshing " + existingAncestor.getFullPath().toPortableString(), (Throwable)e);
            }
            walker = walker.append(path.segment(i));
            existingAncestor = root.findMember(walker);
            if (existingAncestor == null) {
                try {
                    root.findMember(path.removeLastSegments(1)).refreshLocal(2, null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                return null;
            }
            ++i;
        }
        return existingAncestor;
    }

    public static IResource findRoot(String p, IProgressMonitor progress) throws TeamRepositoryException {
        return CoreUtil.findRoot((IPath)new Path(p), progress);
    }
}

