/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.rest.util;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.client.operations.IFailedUpload;
import com.ibm.team.filesystem.client.operations.IRemovedShare;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCheckInChanges;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCommitDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPendingChangesDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsRefreshEclipseWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.CheckInResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.FilesystemRestClientDTOchangesetFactory;
import com.ibm.team.filesystem.common.internal.rest.client.resource.LineDelimiterErrorDTO;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.resources.ShareableResource;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.RefreshUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.ResourceUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.VerifyOutOfSyncUtil;
import com.ibm.team.filesystem.rcp.core.operations.NewCheckInOperation;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitUtil {
    private static final String REQUEST_NAME = "postCheckInChanges";

    /*
     * Unable to fully structure code
     */
    public static CheckInResultDTO checkInChanges(ParmsCheckInChanges parms, IProgressMonitor progress) throws TeamRepositoryException {
        monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        parms.validate("postCheckInChanges");
        workspace = parms.workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(10));
        component = parms.getComponentHandle();
        result = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createCheckInResultDTO();
        outOfSyncDilemmaHandler = VerifyOutOfSyncUtil.getOutOfSyncDilemmaHandler(parms.outOfSyncInstructions, result.getOutOfSyncShares());
        commitDilemmaHandler = CommitUtil.getCommitDilemmaHandler(parms.commitDilemmaHandler, outOfSyncDilemmaHandler, (List<LineDelimiterErrorDTO>)result.getLineDelimiterFailures());
        try {
            pathsRefreshed = new HashSet<String>();
            retry = true;
            paranoiaCount = 0;
            while (retry && paranoiaCount < 100) {
                retry = false;
                ++paranoiaCount;
                commitOp = CommitUtil.getCommitOp(parms, workspace, component, commitDilemmaHandler);
                try {
                    if (commitOp == null) continue;
                    commitOp.run((IProgressMonitor)monitor.newChild(80));
                    continue;
                }
                catch (FileSystemClientException e) {
                    monitor.setWorkRemaining(100);
                    pathsToRefresh = CommitUtil.getPathsToRefresh(e);
                    iPath = pathsToRefresh.iterator();
                    ** while (iPath.hasNext())
                }
lbl-1000:
                // 1 sources

                {
                    path = iPath.next();
                    if (pathsRefreshed.add(path)) continue;
                    iPath.remove();
                    continue;
                }
lbl30:
                // 1 sources

                if (!pathsToRefresh.isEmpty()) {
                    parmsRefresh = new ParmsRefreshEclipseWorkspace();
                    parmsRefresh.openNamedEclipseProjects = true;
                    parmsRefresh.paths = pathsToRefresh.toArray(new String[pathsToRefresh.size()]);
                    RefreshUtil.refreshEclipseWorkspace(parmsRefresh, (IProgressMonitor)monitor.newChild(10));
                    retry = true;
                    continue;
                }
                throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
            }
        }
        catch (OperationCanceledException v0) {
            result.setCancelled(true);
        }
        return result;
    }

    private static NewCheckInOperation getCommitOp(ParmsCheckInChanges parms, IWorkspaceConnection workspace, IComponentHandle component, CommitDilemmaHandler commitDilemmaHandler) throws TeamRepositoryException {
        NewCheckInOperation commitOp = null;
        if (parms.checkInAllComponentChanges != null && parms.checkInAllComponentChanges.booleanValue()) {
            ILocalChange[] changesToCommit = null;
            IChangeSetHandle changeSet = parms.getChangeSetHandle();
            commitOp = changeSet != null ? new NewCheckInOperation(workspace, component, changeSet, changesToCommit, commitDilemmaHandler) : new NewCheckInOperation(workspace, component, changesToCommit, CommitUtil.getComment(parms), commitDilemmaHandler);
        } else if (parms.resourcesToCheckIn != null && parms.resourcesToCheckIn.length > 0) {
            IShareable[] shareableToCommit = new IShareable[parms.resourcesToCheckIn.length];
            int i = 0;
            while (i < parms.resourcesToCheckIn.length) {
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(parms.resourcesToCheckIn[i]));
                if (resource == null) {
                    throw new TeamRepositoryException(NLS.bind((String)Messages.CommitUtil_1, (Object[])new Object[]{parms.resourcesToCheckIn[i]}));
                }
                shareableToCommit[i] = new ShareableResource(resource);
                ++i;
            }
            IChangeSetHandle changeSet = parms.getChangeSetHandle();
            commitOp = changeSet != null ? new NewCheckInOperation(workspace, component, shareableToCommit, changeSet, commitDilemmaHandler) : new NewCheckInOperation(workspace, component, shareableToCommit, CommitUtil.getComment(parms), commitDilemmaHandler);
        } else {
            HashMap<UUID, ILocalChange> localChanges = CommitUtil.getLocalChanges(workspace, component);
            ArrayList<ILocalChange> changesToCheckIn = new ArrayList<ILocalChange>(parms.versionablesToCheckIn.length);
            int i = 0;
            while (i < parms.versionablesToCheckIn.length) {
                ILocalChange change = localChanges.get(UUID.valueOf((String)parms.versionablesToCheckIn[i]));
                if (change != null) {
                    changesToCheckIn.add(change);
                }
                ++i;
            }
            if (!changesToCheckIn.isEmpty()) {
                IChangeSetHandle changeSet = parms.getChangeSetHandle();
                commitOp = changeSet != null ? new NewCheckInOperation(workspace, component, changeSet, changesToCheckIn.toArray(new ILocalChange[changesToCheckIn.size()]), commitDilemmaHandler) : new NewCheckInOperation(workspace, component, changesToCheckIn.toArray(new ILocalChange[changesToCheckIn.size()]), CommitUtil.getComment(parms), commitDilemmaHandler);
            }
        }
        return commitOp;
    }

    private static List<String> getPathsToRefresh(FileSystemClientException e) {
        ArrayList<String> paths = new ArrayList<String>();
        IStatus status = e.getStatus();
        CommitUtil.getPathsToRefresh(status, paths);
        return paths;
    }

    private static void getPathsToRefresh(IStatus status, List<String> paths) {
        if (status instanceof IResourceStatus) {
            IResourceStatus resourceStatus = (IResourceStatus)status;
            if (resourceStatus.getCode() == 274) {
                paths.add(resourceStatus.getPath().toString());
            }
        } else {
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus exceptionStatus;
                IStatus child = iStatusArray[n2];
                if (child instanceof IResourceStatus) {
                    IResourceStatus resourceStatus = (IResourceStatus)child;
                    if (resourceStatus.getCode() == 274) {
                        paths.add(resourceStatus.getPath().toString());
                    }
                } else if (child.getException() instanceof CoreException && (exceptionStatus = ((CoreException)child.getException()).getStatus()) != null) {
                    CommitUtil.getPathsToRefresh(exceptionStatus, paths);
                }
                ++n2;
            }
        }
    }

    private static String getComment(ParmsCheckInChanges parms) {
        return parms.newChangeSetComment == null ? "" : parms.newChangeSetComment;
    }

    private static HashMap<UUID, ILocalChange> getLocalChanges(IWorkspaceConnection workspace, IComponentHandle component) {
        ILocalChange[] pendingChanges;
        HashMap<UUID, ILocalChange> result = new HashMap<UUID, ILocalChange>();
        IPath cfaRoot = FileSystemCore.getSharingManager().getDefaultCFARoot();
        ILocalChangeManager lcm = FileSystemCore.getSharingManager().getLocalChangeManager();
        lcm.syncPendingChanges(workspace.getContextHandle(), component, cfaRoot);
        ILocalChange[] iLocalChangeArray = pendingChanges = lcm.getPendingChanges(workspace.getContextHandle(), component, cfaRoot);
        int n = pendingChanges.length;
        int n2 = 0;
        while (n2 < n) {
            ILocalChange change = iLocalChangeArray[n2];
            result.put(change.getTarget().getItemId(), change);
            ++n2;
        }
        return result;
    }

    public static final CommitDilemmaHandler getCommitDilemmaHandler(ParmsCommitDilemmaHandler commitDilemmaHandlerParms, OutOfSyncDilemmaHandler oosDilemmaHandler, List<LineDelimiterErrorDTO> lineDelimiterErrorsReported) {
        if (commitDilemmaHandlerParms == null && oosDilemmaHandler == null) {
            return CommitDilemmaHandler.getDefault();
        }
        final OutOfSyncDilemmaHandler outOfSyncDilemmaHandler = oosDilemmaHandler == null ? OutOfSyncDilemmaHandler.getDefault() : oosDilemmaHandler;
        final ResourceUtil.LineDelimiterErrorHandler lineDelimiterErrorHandler = commitDilemmaHandlerParms == null ? new ResourceUtil.LineDelimiterErrorHandler(null, lineDelimiterErrorsReported) : new ResourceUtil.LineDelimiterErrorHandler(commitDilemmaHandlerParms.lineDelimiterDilemmaHandler, lineDelimiterErrorsReported);
        CommitDilemmaHandler commitDilemmaHandler = new CommitDilemmaHandler(){

            public int lineDelimiterErrors(IFailedUpload failedFile) {
                return lineDelimiterErrorHandler.lineDelimiterErrors(failedFile);
            }

            public int outOfSync(Collection<IShareOutOfSync> sharesOutOfSync) {
                return outOfSyncDilemmaHandler.outOfSync(sharesOutOfSync);
            }

            public boolean willIgnoreAllSharesOutOfSync() {
                return outOfSyncDilemmaHandler.willIgnoreAllSharesOutOfSync();
            }

            public int collision(Collection<ICollision> collisions, Collection<IRemovedShare> removedShares, Collection<IShareOutOfSync> sharesOutOfSync) {
                return outOfSyncDilemmaHandler.collision(collisions, removedShares, sharesOutOfSync);
            }
        };
        return commitDilemmaHandler;
    }

    public static int getUncheckedInChangesInstruction(ParmsPendingChangesDilemmaHandler changeDilemmaHandlerParm) {
        int uncheckedInChangesInstruction = 2;
        if (changeDilemmaHandlerParm != null) {
            uncheckedInChangesInstruction = CommitUtil.getInstruction(changeDilemmaHandlerParm.pendingChangesInstruction);
        }
        return uncheckedInChangesInstruction;
    }

    private static int getInstruction(String instruction) {
        int uncheckedInChangesInstruction = 2;
        if ("continue".equals(instruction)) {
            uncheckedInChangesInstruction = 0;
        } else if (instruction == null) {
            uncheckedInChangesInstruction = 2;
        } else if ("cancel".equals(instruction)) {
            uncheckedInChangesInstruction = 1;
        } else if ("fail".equals(instruction)) {
            uncheckedInChangesInstruction = 2;
        } else if ("no".equals(instruction)) {
            uncheckedInChangesInstruction = 3;
        } else {
            throw new IllegalArgumentException("The value of uncheckedInChangesInstruction must be one of cancel, continue, no or fail");
        }
        return uncheckedInChangesInstruction;
    }

    public static CommitDilemmaHandler getCommitDilemmaHandler(ParmsPendingChangesDilemmaHandler pendingChangesDilemmaHandler, OutOfSyncDilemmaHandler outOfSyncDilemmaHandler, List<LineDelimiterErrorDTO> lineDelimiterErrors) {
        if (pendingChangesDilemmaHandler == null) {
            return CommitUtil.getCommitDilemmaHandler(null, outOfSyncDilemmaHandler, lineDelimiterErrors);
        }
        return CommitUtil.getCommitDilemmaHandler(pendingChangesDilemmaHandler.commitDilemmaHandler, outOfSyncDilemmaHandler, lineDelimiterErrors);
    }
}

