/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.resources.efs;

import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.resources.ResourceUtil;
import com.ibm.team.filesystem.rcp.core.internal.resources.efs.ResourceFileSystem;
import com.ibm.team.repository.common.utils.TemporaryOutputStream;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class ResourceFileStore
extends FileStore {
    private IPath path;
    private ResourceFileSystem fileSystem;

    protected ResourceFileStore(ResourceFileSystem fileSystem, IPath path) {
        this.path = path;
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        IContainer container = ResourceUtil.getContainer(this.path);
        IResource[] members = container.members();
        String[] result = new String[members.length];
        int i = 0;
        while (i < members.length) {
            IResource resource = members[i];
            result[i] = resource.getName();
            ++i;
        }
        return result;
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
        IResource resource = this.getResource();
        FileInfo result = new FileInfo(resource.getName());
        ResourceAttributes attribs = resource.getResourceAttributes();
        if (attribs != null) {
            ResourceFileStore.copyResourceAttribsToFileInfo((IFileInfo)result, attribs);
        }
        result.setDirectory(resource instanceof IContainer);
        result.setExists(resource.exists());
        result.setLastModified(resource.getLocalTimeStamp());
        return result;
    }

    private IResource getResource() {
        IResource resource = ResourceUtil.getResource(this.path);
        return resource;
    }

    private static void copyResourceAttribsToFileInfo(IFileInfo result, ResourceAttributes attribs) {
        result.setAttribute(8, attribs.isArchive());
        result.setAttribute(2, attribs.isReadOnly());
        result.setAttribute(4, attribs.isExecutable());
        result.setAttribute(16, attribs.isHidden());
    }

    private static void copyFileInfoToResourceAttribs(ResourceAttributes result, IFileInfo attribs) {
        result.setArchive(attribs.getAttribute(8));
        result.setReadOnly(attribs.getAttribute(2));
        result.setExecutable(attribs.getAttribute(4));
        result.setHidden(attribs.getAttribute(16));
    }

    public IFileStore getChild(String name) {
        return new ResourceFileStore(this.fileSystem, this.path.append(name));
    }

    public String getName() {
        String name = this.path.lastSegment();
        if (name == null) {
            return "";
        }
        return name;
    }

    public IFileStore getParent() {
        if (this.path.segmentCount() == 0) {
            return null;
        }
        return new ResourceFileStore(this.fileSystem, this.path.removeLastSegments(1));
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        IFile file = ResourceUtil.getFile(this.path);
        if (file != null && file.exists()) {
            return file.getContents();
        }
        throw new CoreException(StatusUtil.newStatus((Object)((Object)this), (String)NLS.bind((String)Messages.ResourceFileStore_0, (Object)this.path.toString())));
    }

    public URI toURI() {
        try {
            return new URI("resource", this.path.makeAbsolute().toString(), null);
        }
        catch (URISyntaxException e) {
            StatusUtil.log((Object)((Object)this), (Throwable)e);
            return null;
        }
    }

    public IFileInfo[] childInfos(int options, IProgressMonitor monitor) throws CoreException {
        return super.childInfos(options, monitor);
    }

    public IFileStore[] childStores(int options, IProgressMonitor monitor) throws CoreException {
        return super.childStores(options, monitor);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.fileSystem == null ? 0 : this.fileSystem.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ResourceFileStore other = (ResourceFileStore)((Object)obj);
        if (this.fileSystem == null ? other.fileSystem != null : !this.fileSystem.equals((Object)other.fileSystem)) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals((Object)other.path));
    }

    public void delete(int options, IProgressMonitor monitor) throws CoreException {
        IResource resource = this.getResource();
        resource.delete(this.fileSystem.force, monitor);
    }

    public IFileStore getChild(IPath path) {
        return super.getChild(path);
    }

    public IFileSystem getFileSystem() {
        return this.fileSystem;
    }

    public boolean isParentOf(IFileStore other) {
        if (other instanceof ResourceFileStore) {
            ResourceFileStore rfs = (ResourceFileStore)other;
            return this.path.isPrefixOf(rfs.path);
        }
        return super.isParentOf(other);
    }

    public IFileStore mkdir(int options, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (this.path.isEmpty()) {
            return this;
        }
        IContainer container = ResourceUtil.getContainer(this.path);
        if ((options & 4) == 0) {
            progress.setWorkRemaining(200);
            ResourceUtil.createPath(container.getParent(), this.fileSystem.force, this.fileSystem.keepHistory, (IProgressMonitor)progress.newChild(100));
        }
        if (container instanceof IFolder) {
            IFolder folder = (IFolder)container;
            folder.create(this.fileSystem.force, this.fileSystem.keepHistory, monitor);
        } else if (container instanceof IProject) {
            IProject project = (IProject)container;
            project.create((IProgressMonitor)progress.newChild(50));
            project.open((IProgressMonitor)progress.newChild(50));
        }
        return this;
    }

    public void move(IFileStore destination, int options, IProgressMonitor monitor) throws CoreException {
        if (destination instanceof ResourceFileStore) {
            ResourceFileStore target = (ResourceFileStore)destination;
            this.getResource().move(target.path, this.fileSystem.force, monitor);
            return;
        }
        super.move(destination, options, monitor);
    }

    public OutputStream openOutputStream(final int options, IProgressMonitor monitor) throws CoreException {
        try {
            TemporaryOutputStream outputStream = TemporaryOutputStream.getEstimatedSizeTemporaryOutputStream((long)-1L);
            FilterOutputStream result = new FilterOutputStream((OutputStream)outputStream){

                public void close() throws IOException {
                    TemporaryOutputStream tos = (TemporaryOutputStream)this.out;
                    try {
                        tos.close();
                        InputStream inputStream = tos.getInputStream(null);
                        try {
                            try {
                                IFile theFile = ResourceUtil.getFile(ResourceFileStore.this.path);
                                if ((options & 1) != 0) {
                                    theFile.appendContents(inputStream, ((ResourceFileStore)ResourceFileStore.this).fileSystem.force, ((ResourceFileStore)ResourceFileStore.this).fileSystem.keepHistory, null);
                                } else {
                                    theFile.setContents(inputStream, ((ResourceFileStore)ResourceFileStore.this).fileSystem.force, ((ResourceFileStore)ResourceFileStore.this).fileSystem.keepHistory, null);
                                }
                            }
                            catch (CoreException e) {
                                throw new IOException(e.getMessage());
                            }
                        }
                        finally {
                            inputStream.close();
                        }
                    }
                    finally {
                        tos.dispose();
                    }
                    super.close();
                }
            };
            return result;
        }
        catch (IOException e1) {
            throw new CoreException(StatusUtil.newStatus((Object)((Object)this), (Throwable)e1));
        }
    }

    public void putInfo(IFileInfo info, int options, IProgressMonitor monitor) throws CoreException {
        IResource resource = this.getResource();
        if ((options & 0x400) != 0) {
            ResourceAttributes attributes = new ResourceAttributes();
            ResourceFileStore.copyFileInfoToResourceAttribs(attributes, info);
            resource.setResourceAttributes(attributes);
        }
        if ((options & 0x800) != 0) {
            resource.setLocalTimeStamp(info.getLastModified());
        }
        super.putInfo(info, options, monitor);
    }

    public File toLocalFile(int options, IProgressMonitor monitor) throws CoreException {
        IResource resource = this.getResource();
        IPath path = resource.getLocation();
        if (path == null) {
            return null;
        }
        return path.toFile();
    }
}

