/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.resources;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IShareableVisitor;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.resources.EclipseFileStorage;
import com.ibm.team.repository.common.util.NLS;
import java.net.URI;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;

public class ShareableResource
extends Shareable {
    private final IResource resource;

    public ShareableResource(IResource resource) {
        Assert.isNotNull((Object)resource);
        this.resource = resource;
    }

    public ShareableResource(IPath path, boolean isFolder) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this.resource = path.segmentCount() == 1 ? root.getProject(path.segment(0)) : (isFolder ? root.getFolder(path) : root.getFile(path));
        Assert.isNotNull((Object)this.resource);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ShareableResource)) {
            return false;
        }
        return this.resource.equals((Object)((ShareableResource)((Object)obj)).resource);
    }

    public int hashCode() {
        return this.resource.hashCode();
    }

    public IResource getResource() {
        return this.resource;
    }

    public Object getAdapter(Class adaptTo) {
        if (adaptTo.isAssignableFrom(ShareableResource.class)) {
            return this;
        }
        if (adaptTo.isAssignableFrom(IResource.class)) {
            return this.getResource();
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adaptTo);
    }

    public boolean shouldBeIgnored() {
        IResource walker = this.resource;
        while (walker != null) {
            if (walker.isDerived()) {
                return true;
            }
            walker = walker.getParent();
        }
        return super.shouldBeIgnored();
    }

    public IFileStorage getFileStorage() {
        return new EclipseFileStorage(this.getResource());
    }

    public IPath getLocalFullPath() {
        return this.getResource().getFullPath();
    }

    public IPath getRoot() {
        return SharingManager.getInstance().getDefaultCFARoot();
    }

    public void accept(final IShareableVisitor visitor, final int depth, boolean includeLocal, final ISchedulingRule rule, IProgressMonitor monitor) throws FileSystemClientException {
        if (this.getRemote() != null || !includeLocal) {
            super.accept(visitor, depth, includeLocal, rule, monitor);
            return;
        }
        if (!this.resource.isAccessible()) {
            return;
        }
        try {
            final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
            this.resource.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    ShareableResource current = (ShareableResource)((Object)resource.getAdapter(IShareable.class));
                    if (current.getRemote() == null) {
                        return visitor.visit((IShareable)current, (IProgressMonitor)progress.newChild(1));
                    }
                    current.accept(visitor, depth == 2 ? Integer.MAX_VALUE : 0, true, rule, (IProgressMonitor)progress.newChild(1));
                    progress.setWorkRemaining(20);
                    return false;
                }
            }, depth == Integer.MAX_VALUE ? 2 : 0, false);
            progress.done();
        }
        catch (CoreException e) {
            if (e instanceof FileSystemClientException) {
                throw (FileSystemClientException)((Object)e);
            }
            throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (String)NLS.bind((String)Messages.ShareableResource_0, (Object[])new Object[]{this.resource.getName()}), (Throwable)e));
        }
    }

    public IShare share(ISharingDescriptor descriptor, boolean overwrite, boolean loadChanges, IProgressMonitor monitor) throws FileSystemClientException {
        if (this.getResource().getType() != 4) {
            throw new UnsupportedOperationException(NLS.bind((String)Messages.ShareableResource_1, (Object[])new Object[]{this.getLocalFullPath()}));
        }
        IProject project = (IProject)this.resource;
        RepositoryProvider existing = RepositoryProvider.getProvider((IProject)project);
        if (existing != null && !overwrite) {
            throw new FileSystemClientException((IStatus)new FileSystemStatus(4, 204, NLS.bind((String)Messages.ShareableResource_2, (Object[])new Object[]{project.getName(), existing.getID()})));
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IShare result = super.share(descriptor, overwrite, loadChanges, (IProgressMonitor)progress.newChild(50));
        try {
            RepositoryProvider.map((IProject)project, (String)"com.ibm.team.filesystem.rcp.core.provider");
        }
        catch (TeamException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (int)204, (String)NLS.bind((String)Messages.ShareableResource_3, (Object[])new Object[]{project.getName()}), (Throwable)e));
        }
        progress.done();
        return result;
    }

    public boolean isManaged(IProgressMonitor monitor) {
        IProject p = this.getResource().getProject();
        URI l = p.getLocationURI();
        if (l != null && "sourcecontrol".equals(l.getScheme())) {
            return true;
        }
        RepositoryProvider provider = RepositoryProvider.getProvider((IProject)p);
        return provider != null && "com.ibm.team.filesystem.rcp.core.provider".equals(provider.getID());
    }

    public void manage(IProgressMonitor monitor) throws FileSystemClientException {
        if (this.getResource().getType() != 4) {
            throw new UnsupportedOperationException(this.getLocalFullPath() + " cannot be shared. Only projects can be shared");
        }
        IProject project = (IProject)this.resource;
        RepositoryProvider existing = RepositoryProvider.getProvider((IProject)project);
        if (existing == null) {
            try {
                RepositoryProvider.map((IProject)project, (String)"com.ibm.team.filesystem.rcp.core.provider");
            }
            catch (TeamException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (int)204, (String)Messages.ShareableResource_4, (Throwable)e));
            }
        }
    }

    public void forget(IProgressMonitor monitor) throws FileSystemClientException {
        boolean isProject = this.getResource().getType() == 4;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(isProject ? 100 : 50));
        super.forget((IProgressMonitor)progress.newChild(50));
        if (isProject) {
            this.unshareProject((IProject)this.getResource(), (IProgressMonitor)progress.newChild(50));
        }
        progress.done();
    }

    public void unshare(IProgressMonitor monitor) throws FileSystemClientException {
        if (this.getResource().getType() != 4) {
            throw new UnsupportedOperationException(this.getLocalFullPath() + " cannot be shared. Only projects can be shared");
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        super.unshare((IProgressMonitor)progress.newChild(50));
        this.unshareProject((IProject)this.getResource(), (IProgressMonitor)progress.newChild(50));
        progress.done();
    }

    private void unshareProject(IProject sharedProject, IProgressMonitor monitor) throws FileSystemClientException {
        if (RepositoryProvider.getProvider((IProject)sharedProject, (String)"com.ibm.team.filesystem.rcp.core.provider") != null) {
            try {
                RepositoryProvider.unmap((IProject)sharedProject.getProject());
            }
            catch (TeamException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (int)206, (String)NLS.bind((String)Messages.ShareableResource_5, (Object[])new Object[]{sharedProject.getName()}), (Throwable)e));
            }
        }
    }

    public Shareable getShareableFor(IPath path, boolean isFolder) {
        return new ShareableResource(path, isFolder);
    }

    public void visit(final IShareableVisitor visitor, int depth, IProgressMonitor monitor) throws FileSystemClientException {
        try {
            final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)50);
            if (this.getResource().isAccessible()) {
                this.getResource().accept(new IResourceVisitor(){

                    public boolean visit(IResource nonRemote) throws CoreException {
                        if (ShareableResource.this.getResource().equals((Object)nonRemote)) {
                            return true;
                        }
                        ShareableResource shareable = new ShareableResource(nonRemote);
                        boolean result = visitor.visit((IShareable)shareable, (IProgressMonitor)progress.newChild(1));
                        progress.setWorkRemaining(50);
                        return result;
                    }
                });
            }
            progress.done();
        }
        catch (CoreException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (int)205, (String)Messages.ShareableResource_6, (Throwable)e));
        }
    }

    public boolean isLocal() {
        return this.resource.exists();
    }

    public String toString() {
        return "shareable " + this.getResource();
    }
}

