/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.resources;

import com.ibm.team.filesystem.common.internal.patch.CommonContentUtil;
import com.ibm.team.filesystem.rcp.core.internal.resources.ContentProperties;
import com.ibm.team.filesystem.rcp.core.internal.resources.ContentPropertiesPreference;
import com.ibm.team.filesystem.rcp.core.internal.resources.ContentPropertiesPreferenceManager;
import com.ibm.team.filesystem.rcp.core.internal.resources.ShareableResource;
import com.ibm.team.filesystem.rcp.core.internal.streams.InputStreamStorage;
import com.ibm.team.internal.repository.rcp.streams.EmptyInputStreamProvider;
import com.ibm.team.internal.repository.rcp.streams.InputStreamUtil;
import com.ibm.team.repository.common.LineDelimiter;
import com.ibm.team.repository.common.utils.DisposableInputStreamProvider;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.common.utils.TemporaryOutputStream;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;

public class ResourceUtil {
    public static final String FOLDER_TYPE = "inode/directory";

    public static ContentProperties getContentPropertiesNotNull(IFile file) throws CoreException {
        ContentProperties result = ResourceUtil.getContentProperties(file);
        if (result == null) {
            return new ContentProperties(null, CommonContentUtil.CHARACTER_ENCODING_UNKNOWN, "application/unknown", LineDelimiter.LINE_DELIMITER_NONE, false, true);
        }
        return result;
    }

    public static ContentProperties getContentProperties(IFile file) throws CoreException {
        boolean isText;
        boolean isDefaultBinary;
        if (!file.exists()) {
            return null;
        }
        CoreException encodingException = null;
        String encoding = null;
        try {
            encoding = file.getCharset(true);
        }
        catch (CoreException e) {
            encodingException = e;
        }
        ShareableResource shareable = new ShareableResource((IResource)file);
        String mimeType = shareable.getContentType();
        LineDelimiter lineDelimiter = shareable.getLineDelimiter();
        IContentType contentType = ResourceUtil.getContentTypeFor(file);
        ContentPropertiesPreferenceManager manager = new ContentPropertiesPreferenceManager();
        ContentPropertiesPreference pref = manager.get(contentType, file.getName());
        if (mimeType == null) {
            mimeType = pref.getMimeType();
        }
        if (lineDelimiter == null) {
            lineDelimiter = pref.getLineDelimiter();
        }
        boolean bl = isDefaultBinary = !(isText = ResourceUtil.isText(mimeType, contentType)) && !pref.preferenceHeiarchyExists();
        if (isText && encodingException != null) {
            throw encodingException;
        }
        return new ContentProperties(contentType, encoding, mimeType, lineDelimiter, isText, isDefaultBinary);
    }

    public static ContentProperties getContentProperties(InputStream contents, String name) {
        String encoding;
        IContentType contentType;
        block13: {
            contentType = null;
            encoding = null;
            try {
                try {
                    IContentDescription description = Platform.getContentTypeManager().getDescriptionFor(contents, name, new QualifiedName[]{IContentDescription.CHARSET, IContentDescription.BYTE_ORDER_MARK});
                    encoding = ResourceUtil.getEncoding(description);
                    if (description != null) {
                        contentType = description.getContentType();
                    }
                }
                catch (IOException iOException) {
                    try {
                        contents.close();
                    }
                    catch (IOException iOException2) {}
                    break block13;
                }
            }
            catch (Throwable throwable) {
                try {
                    contents.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                contents.close();
            }
            catch (IOException iOException) {}
        }
        ContentPropertiesPreferenceManager manager = new ContentPropertiesPreferenceManager();
        ContentPropertiesPreference pref = manager.get(contentType, name);
        String mimeType = pref.getMimeType();
        LineDelimiter lineDelimiter = pref.getLineDelimiter();
        boolean isText = pref.isText();
        if (isText && encoding == null) {
            encoding = System.getProperty("file.encoding");
        }
        boolean isDefaultBinary = !isText && !pref.preferenceHeiarchyExists();
        return new ContentProperties(contentType, encoding, mimeType, lineDelimiter, isText, isDefaultBinary);
    }

    public static boolean isText(String mimeType, String fileName) {
        IContentType contentType = ResourceUtil.getContentTypeFor(fileName);
        return ResourceUtil.isText(mimeType, contentType);
    }

    public static boolean isText(String mimeType, IContentType contentType) {
        return mimeType != null && mimeType.startsWith("text") || contentType != null && contentType.isKindOf(ContentPropertiesPreferenceManager.ICONTENT_TYPE_TEXT);
    }

    public static void createPath(IContainer toCreate, IProgressMonitor monitor) throws CoreException {
        ResourceUtil.createPath(toCreate, false, true, monitor);
    }

    public static void createPath(IContainer toCreate, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (toCreate.exists() || toCreate instanceof IWorkspaceRoot) {
            return;
        }
        if (toCreate instanceof IFolder) {
            ResourceUtil.createPath(toCreate.getParent(), force, keepHistory, (IProgressMonitor)progress.newChild(50));
            progress.setWorkRemaining(100);
        }
        ResourceUtil.createShallow(toCreate, force, keepHistory, (IProgressMonitor)progress.newChild(100));
    }

    private static void createShallow(IContainer toCreate, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (toCreate instanceof IProject) {
            IProject project = (IProject)toCreate;
            project.create((IProgressMonitor)progress.newChild(50));
            project.open((IProgressMonitor)progress.newChild(50));
            return;
        }
        if (toCreate instanceof IFolder) {
            IFolder folder = (IFolder)toCreate;
            folder.create(force, keepHistory, (IProgressMonitor)progress.newChild(100));
        }
    }

    public static IFile getFile(IPath targetPath) {
        try {
            return ResourcesPlugin.getWorkspace().getRoot().getFile(targetPath);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static IContainer getContainer(IPath targetPath) {
        Object root = targetPath.segmentCount() == 0 ? ResourcesPlugin.getWorkspace().getRoot() : (targetPath.segmentCount() == 1 ? ResourcesPlugin.getWorkspace().getRoot().getProject(targetPath.segment(0)) : ResourcesPlugin.getWorkspace().getRoot().getFolder(targetPath));
        return root;
    }

    public static IResource getResource(IPath targetPath) {
        if (targetPath.segmentCount() >= 2) {
            IContainer container;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IFile file = root.getFile(targetPath);
            if (!file.exists() && (container = ResourceUtil.getContainer(targetPath)).exists()) {
                return container;
            }
            return file;
        }
        return ResourceUtil.getContainer(targetPath);
    }

    public static void deleteAllMembers(IContainer container, IProgressMonitor monitor) throws CoreException {
        IResource[] members = container.members();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)members.length);
        int i = 0;
        while (i < members.length) {
            IResource next = members[i];
            next.delete(false, (IProgressMonitor)progress.newChild(1));
            ++i;
        }
    }

    public static IContentType getContentTypeFor(IFile resource) throws CoreException {
        if (!resource.exists()) {
            return null;
        }
        IContentDescription contentDescription = resource.getContentDescription();
        if (contentDescription == null) {
            return null;
        }
        return contentDescription.getContentType();
    }

    public static IContentType getContentTypeFor(String fileName) {
        return Platform.getContentTypeManager().findContentTypeFor(fileName);
    }

    private static String getEncoding(IContentDescription description) {
        if (description != null) {
            byte[] bom = (byte[])description.getProperty(IContentDescription.BYTE_ORDER_MARK);
            if (bom == null) {
                return (String)description.getProperty(IContentDescription.CHARSET);
            }
            if (bom == IContentDescription.BOM_UTF_8) {
                return "UTF-8";
            }
            if (bom == IContentDescription.BOM_UTF_16BE) {
                return "UTF-16BE";
            }
            if (bom == IContentDescription.BOM_UTF_16LE) {
                return "UTF-16LE";
            }
        }
        return "";
    }

    public static IContentType getContentTypeFor(InputStream contents, String fileName) {
        IContentType type;
        block13: {
            type = null;
            if (contents != null) {
                try {
                    try {
                        type = Platform.getContentTypeManager().findContentTypeFor(contents, fileName);
                    }
                    catch (IOException e) {
                        StatusUtil.log(ResourceUtil.class, (Throwable)e);
                        try {
                            contents.close();
                        }
                        catch (IOException iOException) {}
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        contents.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    contents.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (type == null) {
            type = Platform.getContentTypeManager().findContentTypeFor(fileName);
        }
        return type;
    }

    public static String getFileExtension(String filename) {
        int index = filename.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        if (index == filename.length() - 1) {
            return null;
        }
        return "*." + filename.substring(index + 1).toLowerCase();
    }

    public static boolean isFolder(String contentType) {
        return contentType.equals(FOLDER_TYPE);
    }

    public static boolean validMimeType(String mime) {
        return mime.matches("\\w((\\+|-)?\\w)*/\\w((\\+|-)?\\w)*");
    }

    public static DisposableInputStreamProvider getCurrentFileContents(IPath targetPath) throws CoreException {
        try {
            IFile theFile = ResourceUtil.getFile(targetPath);
            if (theFile == null) {
                return new EmptyInputStreamProvider();
            }
            long estimatedLength = 0x100000L;
            try {
                IFileStore theStore = EFS.getStore((URI)theFile.getLocationURI());
                IFileInfo info = theStore.fetchInfo();
                estimatedLength = info.getLength();
            }
            catch (CoreException coreException) {}
            TemporaryOutputStream outputStream = TemporaryOutputStream.getEstimatedSizeTemporaryOutputStream((long)estimatedLength);
            InputStream currentInputStream = null;
            boolean success = false;
            try {
                int read;
                currentInputStream = theFile.getContents();
                byte[] buffer = new byte[4096];
                do {
                    if ((read = currentInputStream.read(buffer)) <= 0) continue;
                    outputStream.write(buffer, 0, read);
                } while (read == buffer.length);
                currentInputStream.close();
                currentInputStream = null;
                success = true;
            }
            catch (Throwable throwable) {
                if (currentInputStream != null) {
                    try {
                        currentInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (!success) {
                    try {
                        outputStream.dispose();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (currentInputStream != null) {
                try {
                    currentInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (!success) {
                try {
                    outputStream.dispose();
                }
                catch (IOException iOException) {}
            }
            return outputStream;
        }
        catch (IOException e) {
            throw new CoreException(StatusUtil.newStatus(InputStreamUtil.class, (Throwable)e));
        }
    }

    public static IStorage getStorageForPath(IPath targetPath) {
        IFile _file = ResourceUtil.getFile(targetPath);
        InputStreamStorage storage = _file != null && _file.exists() && _file.getProject().isOpen() ? _file : new InputStreamStorage((IInputStreamProvider)new EmptyInputStreamProvider());
        return storage;
    }
}

