/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.resources;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.load.UpdateMutator;
import com.ibm.team.filesystem.client.internal.operations.VerifySharesOperation;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdateReport;
import com.ibm.team.filesystem.rcp.core.internal.resources.EclipseWorkspaceMutator;
import com.ibm.team.filesystem.rcp.core.internal.resources.ResourceShare;
import com.ibm.team.filesystem.rcp.core.internal.resources.ShareableResource;
import com.ibm.team.filesystem.rcp.core.operations.EclipseWorkspaceVerifySharesOperation;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.service.datalocation.Location;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceSharingManager
extends SharingManager {
    protected final IPath defaultRoot;

    public ResourceSharingManager() throws IOException {
        Location instanceLocation = Platform.getInstanceLocation();
        this.defaultRoot = new Path(new File(instanceLocation.getURL().getPath()).getCanonicalPath());
    }

    protected List getShareablesForPaths(IPath copyFileAreaRoot, Collection<IPath> paths) {
        if (copyFileAreaRoot.equals((Object)this.getDefaultCFARoot()) || ResourceSharingManager.getCanonicalPath(copyFileAreaRoot).equals((Object)this.getDefaultCFARoot())) {
            ArrayList<Object> result = new ArrayList<Object>(paths.size());
            for (IPath path : paths) {
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
                if (resource == null) continue;
                result.add(resource.getAdapter(IShareable.class));
            }
            return result;
        }
        return super.getShareablesForPaths(copyFileAreaRoot, paths);
    }

    public List<IShareable> getRootShareables(IPath copyFileAreaRoot) {
        if (copyFileAreaRoot.equals((Object)this.getDefaultCFARoot()) || ResourceSharingManager.getCanonicalPath(copyFileAreaRoot).equals((Object)this.getDefaultCFARoot())) {
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            ArrayList<IShareable> result = new ArrayList<IShareable>(projects.length);
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject p = iProjectArray[n2];
                result.add((IShareable)p.getAdapter(IShareable.class));
                ++n2;
            }
            return result;
        }
        return super.getRootShareables(copyFileAreaRoot);
    }

    public IShareable findShareable(IPath copyFileAreaRoot, IPath path, boolean isFolderHint) {
        if (copyFileAreaRoot.equals((Object)this.getDefaultCFARoot()) || ResourceSharingManager.getCanonicalPath(copyFileAreaRoot).equals((Object)this.getDefaultCFARoot())) {
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            if (resource != null && resource.exists()) {
                return (IShareable)resource.getAdapter(IShareable.class);
            }
            return new ShareableResource(path, isFolderHint);
        }
        return super.findShareable(copyFileAreaRoot, path, isFolderHint);
    }

    public IShareable findShareable(IPath copyFileAreaRoot, IVersionableHandle versionable, IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemClientException {
        if (copyFileAreaRoot == null) {
            throw new IllegalArgumentException();
        }
        if (versionable == null) {
            throw new IllegalArgumentException();
        }
        if (component == null) {
            throw new IllegalArgumentException();
        }
        if (connection == null) {
            throw new IllegalArgumentException();
        }
        ThreadCheck.checkLongOpsAllowed();
        if (ResourceSharingManager.getCanonicalPath(copyFileAreaRoot).equals((Object)this.getDefaultCFARoot())) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            IPath path = CopyFileAreaStore.getDefaultCopyFileArea().getLocalPathFor(versionable, component, connection, (IProgressMonitor)progress.newChild(100));
            progress.done();
            if (path == null) {
                return null;
            }
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            if (resource == null) {
                return null;
            }
            return new ShareableResource(resource);
        }
        return super.findShareable(copyFileAreaRoot, versionable, component, connection, monitor);
    }

    private static IPath getCanonicalPath(IPath path) {
        try {
            return new Path(path.toFile().getCanonicalPath());
        }
        catch (IOException iOException) {
            return path;
        }
    }

    public int getState(IShareable shareable) {
        if (shareable instanceof ShareableResource && !((ShareableResource)shareable).getResource().getProject().isAccessible()) {
            return 0;
        }
        return super.getState(shareable);
    }

    protected Share createShare(ISharingDescriptor descriptor, IPath sharePath, CopyFileAreaStore cfa) {
        if (cfa == CopyFileAreaStore.getDefaultCopyFileArea()) {
            return new ResourceShare(descriptor, sharePath);
        }
        return super.createShare(descriptor, sharePath, cfa);
    }

    public boolean shouldIgnore(CopyFileAreaStore cfa, IPath path, boolean folder) {
        if (cfa != CopyFileAreaStore.getDefaultCopyFileArea()) {
            return super.shouldIgnore(cfa, path, folder);
        }
        return new ShareableResource(path, folder).shouldBeIgnored();
    }

    public ISchedulingRule getExternalSchedulingRule(IShareable shareable) {
        if (shareable.getRoot() == this.getDefaultCFARoot()) {
            return ((ShareableResource)shareable).getResource();
        }
        return super.getExternalSchedulingRule(shareable);
    }

    public UpdateMutator getUpdateMutator(IConnection connection, Collection<IComponentStateSummary> componentStatesBeforeUpdate, Collection<IComponentStateSummary> componentStatesAfterUpdate, FileAreaUpdateReport updates, IPath root) throws TeamRepositoryException {
        if (root.equals((Object)this.getDefaultCFARoot())) {
            return new EclipseWorkspaceMutator(connection, componentStatesBeforeUpdate, componentStatesAfterUpdate, updates, null);
        }
        return super.getUpdateMutator(connection, componentStatesBeforeUpdate, componentStatesAfterUpdate, updates, root);
    }

    public VerifySharesOperation getVerifySharesOperation(IPath copyFileAreaRoot, OutOfSyncDilemmaHandler problemHandler) {
        return new EclipseWorkspaceVerifySharesOperation(problemHandler);
    }

    public IPath getDefaultCFARoot() {
        return this.defaultRoot;
    }

    public ISchedulingRule getTrackingRule(IPath cfaRoot) {
        if (cfaRoot.equals((Object)this.getDefaultCFARoot())) {
            return ResourcesPlugin.getWorkspace().getRoot();
        }
        return super.getTrackingRule(cfaRoot);
    }

    public void runWithinFileSystemLock(final IRunnableWithProgress runnableWithProgress, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        final InvocationTargetException[] invocationTargetExceptions = new InvocationTargetException[1];
        IWorkspaceRunnable workspaceOp = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    ResourceSharingManager.super.runWithinFileSystemLock(runnableWithProgress, monitor);
                }
                catch (InvocationTargetException e) {
                    invocationTargetExceptions[0] = e;
                }
                catch (InterruptedException interruptedException) {
                    throw new OperationCanceledException();
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(workspaceOp, monitor);
            if (invocationTargetExceptions[0] != null) {
                throw invocationTargetExceptions[0];
            }
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }
}

