/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.resources;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileStorage;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;

public class EclipseFileStorage
extends FileStorage
implements IFileStorage {
    private final IResource resource;

    public EclipseFileStorage(IResource resource) {
        this.resource = resource;
    }

    public IResource getResource() {
        return this.resource;
    }

    public boolean isFolder() {
        return this.resource.getType() != 1;
    }

    public long getModificationStamp() {
        return this.resource.getModificationStamp();
    }

    public long getLocalTimeStamp() {
        return this.resource.getLocalTimeStamp();
    }

    public boolean isModified(long newTimeStamp) {
        return this.resource.getLocalTimeStamp() != newTimeStamp;
    }

    /*
     * Exception decompiling
     */
    public long getSize(IProgressMonitor monitor) throws FileSystemClientException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public IFileStorage getParent() {
        IContainer parent = this.resource.getParent();
        if (parent == null || parent.getType() == 8) {
            return null;
        }
        return new EclipseFileStorage((IResource)parent);
    }

    public IFileStorage getChild(String name) {
        if (this.isFolder()) {
            IResource child = ((IContainer)this.resource).findMember(name);
            if (child != null) {
                return new EclipseFileStorage(child);
            }
            try {
                if (!EFS.getStore((URI)this.resource.getLocationURI()).getFileSystem().isCaseSensitive()) {
                    IResource[] children;
                    name = name.toUpperCase().toLowerCase();
                    IResource[] iResourceArray = children = ((IContainer)this.resource).members();
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource r = iResourceArray[n2];
                        if (r.getName().toUpperCase().toLowerCase().equals(name)) {
                            return new EclipseFileStorage(r);
                        }
                        ++n2;
                    }
                }
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public IFileStorage[] getChildren() throws FileSystemClientException {
        if (this.isFolder()) {
            IResource[] children = null;
            try {
                children = ((IContainer)this.resource).members();
            }
            catch (CoreException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (int)205, (String)"Couldn't find children", (Throwable)e));
            }
            IFileStorage[] storageChildren = new IFileStorage[children.length];
            int i = 0;
            while (i < children.length) {
                storageChildren[i] = new EclipseFileStorage(children[i]);
                ++i;
            }
            return storageChildren;
        }
        return null;
    }

    public InputStream getContents() throws FileSystemClientException {
        return this.getContents(false);
    }

    public InputStream getContents(boolean force) throws FileSystemClientException {
        if (this.isFolder()) {
            return null;
        }
        try {
            return ((IFile)this.resource).getContents(force);
        }
        catch (CoreException e) {
            URI uri;
            if (force && e.getStatus().getCode() == 368 && this.resource.getParent() != null && this.resource.getParent().exists() && (uri = this.resource.getLocationURI()) != null) {
                try {
                    final IFileStore store = EFS.getStore((URI)uri);
                    final InputStream[] stream = new InputStream[1];
                    SharingManager.getInstance().doSilentChange(new SharingManager.CoreRunnable(){

                        public void run() throws CoreException {
                            stream[0] = store.openInputStream(0, null);
                        }
                    });
                    return stream[0];
                }
                catch (CoreException coreException) {}
            }
            throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (int)203, (String)"Error getting contents", (Throwable)e));
        }
    }

    public void create(InputStream in, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            try {
                if (this.isFolder()) {
                    throw new FileSystemClientException((IStatus)new FileSystemStatus(Messages.EclipseFileStorage_0));
                }
                ((IFile)this.resource).create(in, false, (IProgressMonitor)progress.newChild(100));
            }
            catch (CoreException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor((Throwable)e));
            }
        }
        catch (Throwable throwable) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            progress.done();
            throw throwable;
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        progress.done();
    }

    public void create(IProgressMonitor progress) throws FileSystemClientException {
        if (!this.isFolder()) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor((int)4, (String)Messages.EclipseFileStorage_1, null));
        }
        try {
            ((IFolder)this.resource).create(true, true, progress);
        }
        catch (CoreException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor((Throwable)e));
        }
    }

    public void setContents(InputStream in, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            if (this.isFolder()) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        throw new FileSystemClientException(FileSystemStatus.getStatusFor((Throwable)e));
                    }
                }
                throw new FileSystemClientException((IStatus)new FileSystemStatus("Cannot set contents on a folder"));
            }
            try {
                ((IFile)this.resource).setContents(in, false, true, (IProgressMonitor)progress.newChild(100));
            }
            catch (FileSystemClientException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor((Throwable)e));
            }
        }
        finally {
            progress.done();
        }
    }

    public IPath getFullPath() {
        return this.resource.getFullPath();
    }

    public String getName() {
        return this.resource.getName();
    }

    public boolean isReadOnly() {
        ResourceAttributes attr = this.resource.getResourceAttributes();
        return attr != null ? attr.isReadOnly() : false;
    }

    public IVersionableHandle getRemote() {
        IShareable shareable = (IShareable)this.resource.getAdapter(IShareable.class);
        return shareable != null ? shareable.getRemote() : null;
    }

    public String toString() {
        return String.valueOf(this.getFullPath().toString()) + (this.isFolder() ? "/" : "");
    }

    public Shareable getShareable() {
        return (Shareable)this.getResource().getAdapter(IShareable.class);
    }

    public boolean isExecutable() {
        if (!this.supportsExecBit()) {
            return super.isExecutable();
        }
        ResourceAttributes attr = this.getResource().getResourceAttributes();
        return attr == null ? false : attr.isExecutable();
    }

    public boolean setExecutable(boolean exec, IProgressMonitor monitor) {
        if (!this.supportsExecBit()) {
            return super.setExecutable(exec, monitor);
        }
        ResourceAttributes attr = this.getResource().getResourceAttributes();
        if (attr != null) {
            attr.setExecutable(exec);
            try {
                this.getResource().setResourceAttributes(attr);
                return true;
            }
            catch (CoreException e) {
                LoggingHelper.log((IStatus)FileSystemStatus.getStatusFor((Throwable)e));
            }
        }
        return false;
    }

    public boolean exists() {
        return this.resource.exists();
    }

    public void move(IFileStorage destination, IProgressMonitor monitor) throws FileSystemClientException {
        EclipseFileStorage dest = (EclipseFileStorage)destination;
        try {
            this.resource.move(dest.getFullPath(), false, monitor);
        }
        catch (FileSystemClientException e) {
            throw e;
        }
        catch (CoreException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor((Throwable)e));
        }
    }

    public void delete(IProgressMonitor monitor) throws FileSystemClientException {
        try {
            this.resource.delete(6, monitor);
        }
        catch (FileSystemClientException e) {
            throw e;
        }
        catch (CoreException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor((Throwable)e));
        }
    }

    public boolean contains(ISchedulingRule rule) {
        if (rule instanceof EclipseFileStorage) {
            rule = ((EclipseFileStorage)rule).resource;
        }
        return this.getResource().contains(rule);
    }

    public boolean isConflicting(ISchedulingRule rule) {
        if (rule instanceof EclipseFileStorage) {
            rule = ((EclipseFileStorage)rule).resource;
        }
        return this.getResource().isConflicting(rule);
    }

    public void refreshCachedSubTree(IProgressMonitor monitor) throws FileSystemClientException {
        try {
            this.resource.refreshLocal(2, monitor);
        }
        catch (FileSystemClientException e) {
            throw e;
        }
        catch (CoreException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor((Throwable)e));
        }
    }

    public ISchedulingRule getRule(IFileStorage.RuleKind kind) {
        switch (kind) {
            case CREATE: {
                return this.getResource().getWorkspace().getRuleFactory().createRule(this.getResource());
            }
            case DELETE: {
                return this.getResource().getWorkspace().getRuleFactory().deleteRule(this.getResource());
            }
            case MODIFY: {
                return this.getResource().getWorkspace().getRuleFactory().modifyRule(this.getResource());
            }
            case REFRESH: {
                return this.getResource().getWorkspace().getRuleFactory().refreshRule(this.getResource());
            }
        }
        throw new IllegalArgumentException(NLS.bind((String)Messages.EclipseFileStorage_2, (Object)kind));
    }
}

