/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.resources;

import com.ibm.team.filesystem.client.internal.ManagedFileSystem;
import com.ibm.team.filesystem.rcp.core.internal.resources.MoveDeleteHook;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.net.URI;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.resources.team.ResourceRuleFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.core.RepositoryProvider;

public class ApoRepositoryProvider
extends RepositoryProvider {
    private static final ResourceRuleFactory RULE_FACTORY = new ResourceRuleFactory(){};
    public static final String ID = "com.ibm.team.filesystem.rcp.core.provider";
    private MoveDeleteHook moveDeleteHook = new MoveDeleteHook();

    public void configureProject() throws CoreException {
        IProject project = this.getProject();
        URI projectLocation = project.getDescription().getLocationURI();
        if (projectLocation != null && "sourcecontrol".equals(projectLocation.getScheme())) {
            return;
        }
        IProjectDescription projectDesc = project.getDescription();
        projectDesc.setLocationURI(ManagedFileSystem.getManagedURI(null, (IPath)project.getFullPath(), (URI)projectLocation));
        project.move(projectDesc, 256, null);
    }

    public String getID() {
        return ID;
    }

    public void deconfigure() throws CoreException {
    }

    protected void deconfigured() {
        IProject project = this.getProject();
        URI projectLocation = project.getLocationURI();
        if (projectLocation == null || !"sourcecontrol".equals(projectLocation.getScheme())) {
            return;
        }
        try {
            IProjectDescription projectDesc = project.getDescription();
            URI basicURI = ManagedFileSystem.getBasicURI((URI)projectLocation);
            if (ResourcesPlugin.getWorkspace().validateProjectLocationURI(project, basicURI).getSeverity() != 0) {
                basicURI = null;
            }
            projectDesc.setLocationURI(basicURI);
            project.move(projectDesc, 256, null);
        }
        catch (CoreException e) {
            StatusUtil.log((Object)((Object)this), (Throwable)e);
        }
        super.deconfigured();
    }

    public IMoveDeleteHook getMoveDeleteHook() {
        return this.moveDeleteHook;
    }

    public IResourceRuleFactory getRuleFactory() {
        return RULE_FACTORY;
    }

    public boolean canHandleLinkedResourceURI() {
        return true;
    }

    public IStatus validateCreateLink(IResource resource, int updateFlags, URI location) {
        return super.validateCreateLink(resource, updateFlags, location);
    }
}

