/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.patches;

import com.ibm.team.filesystem.rcp.core.internal.resources.ResourceUtil;
import com.ibm.team.repository.rcp.common.collection.WeakValueMap;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class MovableResource {
    private IPath path;
    private static WeakValueMap<IPath, MovableResource> allKnownResources = new WeakValueMap();

    private MovableResource(IResource resource) {
        this.path = resource.getFullPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MovableResource create(IResource resource) {
        WeakValueMap<IPath, MovableResource> weakValueMap = allKnownResources;
        synchronized (weakValueMap) {
            MovableResource res = (MovableResource)allKnownResources.get((Object)resource.getFullPath());
            if (res != null) {
                return res;
            }
            res = new MovableResource(resource);
            allKnownResources.put((Object)resource.getFullPath(), (Object)res);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(IPath destination, boolean force, IProgressMonitor monitor) throws CoreException {
        IPath source = this.path;
        IResource resource = this.getResource();
        resource.move(destination, force, monitor);
        WeakValueMap<IPath, MovableResource> weakValueMap = allKnownResources;
        synchronized (weakValueMap) {
            HashSet knownValues = new HashSet();
            knownValues.addAll(allKnownResources.values());
            for (MovableResource res : knownValues) {
                IPath path;
                if (res == null || !source.isPrefixOf(path = res.getPath())) continue;
                allKnownResources.remove((Object)path);
                res.setTargetPath(destination.append(path.removeFirstSegments(source.segmentCount())));
                allKnownResources.put((Object)res.getPath(), (Object)res);
            }
        }
    }

    private void setTargetPath(IPath newPath) {
        this.path = newPath;
    }

    public IResource getResource() {
        return ResourceUtil.getResource(this.path);
    }

    private IPath getPath() {
        return this.path;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }
}

