/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.patches;

import com.ibm.team.filesystem.common.internal.patch.ByteArrayLines;
import com.ibm.team.filesystem.common.internal.patch.CreatePatchUtil;
import com.ibm.team.filesystem.common.internal.patch.HunkRange;
import com.ibm.team.filesystem.common.internal.patch.RangeDifference;
import com.ibm.team.filesystem.rcp.core.internal.patches.FilePatch;
import com.ibm.team.filesystem.rcp.core.internal.patches.FilePatchFactory;
import com.ibm.team.filesystem.rcp.core.internal.patches.FilePatchResult;
import com.ibm.team.filesystem.rcp.core.internal.streams.HunkInputStream;
import com.ibm.team.filesystem.rcp.core.internal.streams.InputStreamStorage;
import com.ibm.team.filesystem.rcp.core.internal.streams.PatchResultInputStreamProvider;
import com.ibm.team.internal.repository.rcp.streams.ByteArrayInputStreamProvider;
import com.ibm.team.internal.repository.rcp.streams.EmptyInputStreamProvider;
import com.ibm.team.internal.repository.rcp.streams.InputStreamUtil;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.rcp.common.NullUtil;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Hunk {
    public static FilePatch createFilePatch(IPath beforePath, IPath afterPath, Date beforeDate, Date afterDate, List<Hunk> hunks, String header, IProgressMonitor monitor) throws CoreException, UnsupportedEncodingException, IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)hunks.size());
        StringBuffer patchBuffer = new StringBuffer();
        patchBuffer.append(header);
        patchBuffer.append(CreatePatchUtil.getFilePatchHeader((IPath)beforePath, (IPath)afterPath, (Date)beforeDate, (Date)afterDate));
        for (Hunk next : hunks) {
            SubMonitor iterationProgress = progress.newChild(1).setWorkRemaining(100);
            ByteArrayLines originalLines = new ByteArrayLines(next.getOriginalContents());
            ByteArrayLines finalLines = new ByteArrayLines(next.getPatchedContents());
            StringBuffer hunkBuffer = Hunk.getHunkData(next.getStartPosition(), originalLines, finalLines, next.getCharset(), (IProgressMonitor)iterationProgress.newChild(40));
            patchBuffer.append(hunkBuffer);
        }
        ByteArrayInputStreamProvider patchStream = new ByteArrayInputStreamProvider(patchBuffer.toString().getBytes("UTF-8"));
        InputStreamStorage patchStorage = new InputStreamStorage((IInputStreamProvider)patchStream, "UTF-8");
        FilePatch[] parsedPatch = FilePatchFactory.getFactory().parsePatch(patchStorage);
        Assert.isTrue((parsedPatch.length == 1 ? 1 : 0) != 0);
        return parsedPatch[0];
    }

    public static List<Hunk> getHunks(FilePatch filePatch, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        InputStreamStorage emptyStorage = new InputStreamStorage((IInputStreamProvider)EmptyInputStreamProvider.getDefault());
        FilePatchResult result = filePatch.apply(emptyStorage, (IProgressMonitor)progress.newChild(50));
        try {
            List hunks = NewCollection.arrayList();
            PatchResultInputStreamProvider patchedContents = new PatchResultInputStreamProvider(result, true);
            if (!InputStreamUtil.isEmpty((IInputStreamProvider)patchedContents, (IProgressMonitor)progress.newChild(20))) {
                hunks.add(Hunk.constructCreationHunk(result.getCharset(), patchedContents));
            }
            Hunk[] rejects = result.getRejects();
            hunks.addAll((Collection)Arrays.asList(rejects));
            return hunks;
        }
        catch (IOException e) {
            IStatus status = StatusUtil.newStatus(Hunk.class, (Throwable)e);
            StatusUtil.log((IStatus)status);
            throw new CoreException(status);
        }
    }

    public static Hunk constructHunkFrom(int startPosition, String charset, IInputStreamProvider originalContents, IInputStreamProvider patchedContents, IProgressMonitor monitor) throws IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        StringBuffer patchBuffer = new StringBuffer();
        Date bogusDate = new Date();
        String bogusFilename = "tempfile.txt";
        Path bogusPath = new Path(bogusFilename);
        patchBuffer.append(CreatePatchUtil.getFilePatchHeader((IPath)bogusPath, (IPath)bogusPath, (Date)bogusDate, (Date)bogusDate));
        ByteArrayLines originalLines = new ByteArrayLines(originalContents.getInputStream((IProgressMonitor)progress.newChild(1)));
        ByteArrayLines finalLines = new ByteArrayLines(patchedContents.getInputStream((IProgressMonitor)progress.newChild(1)));
        StringBuffer hunkBuffer = Hunk.getHunkData(startPosition, originalLines, finalLines, charset, (IProgressMonitor)progress.newChild(20));
        patchBuffer.append(hunkBuffer);
        ByteArrayInputStreamProvider patchStream = new ByteArrayInputStreamProvider(patchBuffer.toString().getBytes(charset));
        InputStreamStorage patchStorage = new InputStreamStorage((IInputStreamProvider)patchStream, charset);
        try {
            FilePatch[] parsedPatch = FilePatchFactory.getFactory().parsePatch(patchStorage);
            Assert.isTrue((parsedPatch.length == 1 ? 1 : 0) != 0);
            FilePatch filePatch = parsedPatch[0];
            Object targetFile = originalLines.numLines() == 0 ? new ByteArrayInputStreamProvider("temp contents/n".getBytes(charset)) : EmptyInputStreamProvider.getDefault();
            InputStreamStorage tempFile = new InputStreamStorage((IInputStreamProvider)targetFile, charset);
            Hunk[] rejects = filePatch.getHunks(tempFile, (IProgressMonitor)progress.newChild(50));
            Assert.isTrue((rejects.length == 1 ? 1 : 0) != 0);
            return rejects[0];
        }
        catch (CoreException e) {
            Throwable cause = StatusUtil.getCause((Throwable)e);
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException();
        }
    }

    private static StringBuffer getHunkData(int startPosition, ByteArrayLines originalContents, ByteArrayLines finalContents, String charset, IProgressMonitor monitor) throws UnsupportedEncodingException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        StringBuffer hunkBuffer = new StringBuffer();
        HunkRange range = new HunkRange(startPosition, originalContents.numLines(), startPosition, finalContents.numLines());
        hunkBuffer.append(String.valueOf(range.toString()) + "\n");
        RangeDifference[] diff = originalContents.lcs(finalContents).getRanges();
        progress.worked(50);
        int i = 0;
        while (i < diff.length) {
            int line;
            int count;
            RangeDifference rangeDifference = diff[i];
            if (rangeDifference.kind() == 0) {
                count = 0;
                while (count < rangeDifference.leftLength()) {
                    line = count + rangeDifference.leftStart();
                    hunkBuffer.append(" " + new String(originalContents.get(line), charset));
                    ++count;
                }
            } else {
                count = 0;
                while (count < rangeDifference.leftLength()) {
                    line = count + rangeDifference.leftStart();
                    hunkBuffer.append("-" + new String(originalContents.get(line), charset));
                    if (!originalContents.hasTrailingNL() && line == originalContents.numLines() - 1) {
                        hunkBuffer.append("\n\\ No newline at end of file\n");
                    }
                    ++count;
                }
                count = 0;
                while (count < rangeDifference.rightLength()) {
                    line = count + rangeDifference.rightStart();
                    hunkBuffer.append("+" + new String(finalContents.get(line), charset));
                    if (!finalContents.hasTrailingNL() && line == finalContents.numLines() - 1) {
                        hunkBuffer.append("\n\\ No newline at end of file\n");
                    }
                    ++count;
                }
            }
            ++i;
        }
        return hunkBuffer;
    }

    public static List<String> parseAsText(String charset, IInputStreamProvider patchedContents, IProgressMonitor monitor) throws IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        InputStream finalContentsStream = patchedContents.getInputStream((IProgressMonitor)progress.newChild(5));
        List<String> finalLines = Hunk.parseAsText(charset, finalContentsStream, (IProgressMonitor)progress.newChild(95));
        return finalLines;
    }

    public static List<String> parseAsText(String charset, InputStream finalContentsStream, IProgressMonitor monitor) throws UnsupportedEncodingException, IOException {
        String nextLine;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        InputStreamReader finalReader = new InputStreamReader(finalContentsStream, charset);
        BufferedReader finalBufReader = new BufferedReader(finalReader);
        List finalLines = NewCollection.arrayList();
        do {
            nextLine = finalBufReader.readLine();
            progress.setWorkRemaining(100);
            progress.worked(2);
            if (nextLine == null) continue;
            finalLines.add(nextLine);
        } while (nextLine != null);
        finalContentsStream.close();
        return finalLines;
    }

    public static Hunk constructCreationHunk(String charset, IInputStreamProvider fileContents) throws IOException {
        return Hunk.constructHunkFrom(0, charset, (IInputStreamProvider)EmptyInputStreamProvider.getDefault(), fileContents, null);
    }

    public static Hunk load(BufferedReader br, IProgressMonitor monitor) throws IOException {
        String lineRanges = NullUtil.safeString((String)br.readLine());
        String charset = NullUtil.safeString((String)br.readLine());
        if (charset.equals("")) {
            throw new IOException("Empty hunk detected");
        }
        int startLine = 0;
        try {
            startLine = Integer.parseInt(br.readLine());
        }
        catch (NumberFormatException numberFormatException) {
            startLine = 0;
        }
        HunkRange range = HunkRange.fromString((String)lineRanges);
        StringBuffer beforeLines = new StringBuffer();
        int idx = 0;
        while (idx < range.getBeforeLength()) {
            beforeLines.append(String.valueOf(NullUtil.safeString((String)br.readLine())) + "\n");
            ++idx;
        }
        StringBuffer afterLines = new StringBuffer();
        int idx2 = 0;
        while (idx2 < range.getAfterLength()) {
            afterLines.append(String.valueOf(NullUtil.safeString((String)br.readLine())) + "\n");
            ++idx2;
        }
        return Hunk.constructHunkFrom(startLine, charset, (IInputStreamProvider)new ByteArrayInputStreamProvider(beforeLines.toString().getBytes(charset)), (IInputStreamProvider)new ByteArrayInputStreamProvider(afterLines.toString().getBytes(charset)), monitor);
    }

    public static void store(Hunk hunk, Writer bw, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        String charSet = hunk.getCharset();
        HunkInputStream originalContents = new HunkInputStream(hunk, false);
        HunkInputStream patchedContents = new HunkInputStream(hunk, true);
        try {
            List<String> beforeBuffer = Hunk.parseAsText(charSet, originalContents, (IProgressMonitor)progress.newChild(50));
            List<String> afterBuffer = Hunk.parseAsText(charSet, patchedContents, (IProgressMonitor)progress.newChild(50));
            HunkRange range = new HunkRange(hunk.getStartPosition(), beforeBuffer.size(), hunk.getStartPosition(), afterBuffer.size());
            bw.write(String.valueOf(range.toString()) + "\n");
            bw.write(String.valueOf(charSet) + "\n");
            bw.write(String.valueOf(hunk.getStartPosition()) + "\n");
            for (String line : beforeBuffer) {
                bw.write(String.valueOf(line) + "\n");
            }
            for (String line : afterBuffer) {
                bw.write(String.valueOf(line) + "\n");
            }
        }
        catch (IOException e) {
            throw new CoreException(StatusUtil.newStatus(Hunk.class, (Throwable)e));
        }
    }

    public static boolean isCreation(Hunk theHunk, IProgressMonitor monitor) throws IOException {
        HunkInputStream beforeStream = new HunkInputStream(theHunk, false);
        boolean beforeStateEmpty = InputStreamUtil.isEmpty((IInputStreamProvider)beforeStream, (IProgressMonitor)monitor);
        return beforeStateEmpty && theHunk.getStartPosition() == 0;
    }

    public static boolean isDeletion(Hunk theHunk, IProgressMonitor monitor) throws IOException {
        HunkInputStream afterStream = new HunkInputStream(theHunk, true);
        boolean afterStateEmpty = InputStreamUtil.isEmpty((IInputStreamProvider)afterStream, (IProgressMonitor)monitor);
        return afterStateEmpty && theHunk.getStartPosition() == 0;
    }

    public abstract String getLabel();

    public abstract int getStartPosition();

    public abstract InputStream getOriginalContents();

    public abstract InputStream getPatchedContents();

    public abstract String getCharset() throws CoreException;
}

