/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.patches;

import com.ibm.team.filesystem.rcp.core.internal.patches.FilePatch;
import com.ibm.team.filesystem.rcp.core.internal.patches.impl.DefaultFilePatchFactory;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public abstract class FilePatchFactory {
    private static FilePatchFactory factory;

    public static synchronized FilePatchFactory getFactory() {
        if (factory == null && (factory = FilePatchFactory.loadUIFactory()) == null) {
            factory = new DefaultFilePatchFactory();
        }
        return factory;
    }

    private static FilePatchFactory loadUIFactory() {
        String className = "com.ibm.team.internal.filesystem.ui.patches.UIFilePatchFactory";
        String bundleName = "com.ibm.team.filesystem.ide.ui";
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle == null) {
            return null;
        }
        try {
            Class clazz = bundle.loadClass(className);
            return (FilePatchFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            StatusUtil.log((Object)"com.ibm.team.filesystem.rcp.core", (Throwable)e);
        }
        catch (ClassCastException e) {
            StatusUtil.log((Object)"com.ibm.team.filesystem.rcp.core", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            StatusUtil.log((Object)"com.ibm.team.filesystem.rcp.core", (Throwable)e);
        }
        catch (InstantiationException e) {
            StatusUtil.log((Object)"com.ibm.team.filesystem.rcp.core", (Throwable)e);
        }
        return null;
    }

    public abstract FilePatch[] parsePatch(IStorage var1) throws CoreException;
}

