/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.patches;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.impl.WorkspaceContext;
import com.ibm.team.filesystem.rcp.core.IEclipseFileSystemManager;
import com.ibm.team.filesystem.rcp.core.internal.CoreShareablesUtil;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.patches.AbstractTrivialOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.IgnoreSyncsHandler;
import com.ibm.team.filesystem.rcp.core.internal.patches.MovableResource;
import com.ibm.team.filesystem.rcp.core.internal.resources.ResourceUtil;
import com.ibm.team.filesystem.rcp.core.operations.IDeleteFoldersOperation;
import com.ibm.team.filesystem.rcp.core.patches.PatchConflictException;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.repository.rcp.streams.EmptyInputStreamProvider;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.rcp.core.preferences.SerializationContext;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.common.internal.util.ItemId;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class DeleteFolderOp
extends AbstractTrivialOp {
    public DeleteFolderOp() {
    }

    public DeleteFolderOp(SerializationContext savedState, IProgressMonitor monitor) throws CoreException {
    }

    public void autoResolve(MovableResource moveResource, IProgressMonitor monitor) throws FileSystemClientException, PatchConflictException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IResource resource = moveResource.getResource();
        IContainer container = ResourceUtil.getContainer(resource.getFullPath());
        if (!container.exists()) {
            return;
        }
        this.doVerify(moveResource);
        try {
            IItemContext context;
            ItemNamespace workspace;
            IShareable shareable;
            if (container instanceof IProject && (shareable = (IShareable)Adapters.getAdapter((Object)container, IShareable.class)) != null && (workspace = CoreShareablesUtil.getContributorPlace(shareable)) != null && (context = workspace.getContext((IProgressMonitor)progress.newChild(20))) instanceof WorkspaceContext) {
                WorkspaceContext workspaceContext = (WorkspaceContext)context;
                ItemId changeSet = workspaceContext.getCurrentChangeSet();
                if (changeSet.isNull()) {
                    changeSet = workspaceContext.createChangeSet(NLS.bind((String)"", (Object)resource.getName()), true, (IProgressMonitor)progress.newChild(20));
                }
                IgnoreSyncsHandler ignoreSyncs = new IgnoreSyncsHandler();
                IDeleteFoldersOperation op = IEclipseFileSystemManager.instance.getDeleteFoldersOperation(ignoreSyncs);
                op.setDeleteContent(false);
                op.addDeleteRequest(new IShareable[]{shareable});
                op.run((IProgressMonitor)progress.newChild(20));
                progress.setWorkRemaining(100);
            }
            container.delete(false, (IProgressMonitor)progress.newChild(100));
        }
        catch (Exception e) {
            throw new FileSystemClientException(StatusUtil.newStatus((Object)this, (Throwable)e));
        }
    }

    public void save(SerializationContext whereToSave, IProgressMonitor monitor) throws CoreException {
    }

    public IStatus verify(MovableResource path, IProgressMonitor monitor) {
        try {
            this.doVerify(path);
        }
        catch (PatchConflictException e) {
            return e.getStatus();
        }
        catch (FileSystemClientException e) {
            StatusUtil.log((Object)this, (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    private void doVerify(MovableResource moveResource) throws PatchConflictException, FileSystemClientException {
        IResource resource = moveResource.getResource();
        IContainer container = ResourceUtil.getContainer(resource.getFullPath());
        if (!container.exists()) {
            return;
        }
        try {
            if (this.hasNonderivedChildren(container)) {
                throw new PatchConflictException(StatusUtil.newStatus((Object)this, (String)Messages.DeleteFolderOp_0));
            }
        }
        catch (CoreException e) {
            if (e instanceof PatchConflictException) {
                throw (PatchConflictException)e;
            }
            throw new FileSystemClientException(StatusUtil.newStatus((Object)this, (Throwable)e));
        }
    }

    private boolean hasNonderivedChildren(IContainer container) throws CoreException {
        boolean found = false;
        IResource[] members = container.members();
        int i = 0;
        while (i < members.length) {
            IResource next = members[i];
            if (!next.isDerived()) {
                found = true;
            }
            ++i;
        }
        return found;
    }

    public boolean isDelete() {
        return true;
    }

    public IInputStreamProvider getAfterStream(IProgressMonitor monitor) throws FileSystemClientException {
        return EmptyInputStreamProvider.getDefault();
    }

    public IInputStreamProvider getBeforeStream(IProgressMonitor monitor) throws FileSystemClientException {
        return EmptyInputStreamProvider.getDefault();
    }
}

