/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.patches;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.rcp.core.internal.CoreShareablesUtil;
import com.ibm.team.filesystem.rcp.core.internal.InternalPreferencesUtil;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.patches.MovableResource;
import com.ibm.team.filesystem.rcp.core.internal.resources.ResourceUtil;
import com.ibm.team.filesystem.rcp.core.patches.PatchConflictException;
import com.ibm.team.filesystem.rcp.core.patches.PatchOp;
import com.ibm.team.internal.repository.rcp.streams.EmptyInputStreamProvider;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.rcp.core.preferences.SerializationContext;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.Preferences;

public class CreateFolderOp
extends PatchOp {
    private static final String ITEM_ID = "itemId";
    private VersionablePath itemId;

    public CreateFolderOp(VersionablePath itemId) {
        this.itemId = itemId;
    }

    public CreateFolderOp(SerializationContext savedState, IProgressMonitor monitor) throws CoreException {
        Preferences prefs = savedState.getPrefs();
        this.itemId = InternalPreferencesUtil.getVersionablePath(prefs, ITEM_ID, VersionablePath.getNullPath());
    }

    public void autoResolve(MovableResource moveResource, IProgressMonitor monitor) throws FileSystemClientException, PatchConflictException {
        IResource resource = moveResource.getResource();
        IContainer container = ResourceUtil.getContainer(resource.getFullPath());
        if (container.exists()) {
            return;
        }
        this.doVerify(moveResource);
        try {
            CoreShareablesUtil.createFolder(container, this.itemId, monitor);
        }
        catch (Exception e) {
            throw new FileSystemClientException(StatusUtil.newStatus((Object)this, (Throwable)e));
        }
    }

    private void doVerify(MovableResource moveResource) throws PatchConflictException {
        IResource resource = moveResource.getResource();
        IContainer container = ResourceUtil.getContainer(resource.getFullPath());
        if (container.exists()) {
            return;
        }
        if (resource.exists()) {
            throw new PatchConflictException(StatusUtil.newStatus((Object)this, (String)NLS.bind((String)Messages.CreateFolderOp_0, (Object)resource.getFullPath())));
        }
    }

    public void save(SerializationContext whereToSave, IProgressMonitor monitor) throws CoreException {
    }

    public IStatus verify(MovableResource path, IProgressMonitor monitor) {
        try {
            this.doVerify(path);
        }
        catch (PatchConflictException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    public boolean isCreate() {
        return true;
    }

    public PatchOp copy() {
        return new CreateFolderOp(this.itemId);
    }

    public void dispose() {
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.itemId == null ? 0 : this.itemId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CreateFolderOp other = (CreateFolderOp)obj;
        return !(this.itemId == null ? other.itemId != null : !this.itemId.equals((Object)other.itemId));
    }

    public IInputStreamProvider getAfterStream(IProgressMonitor monitor) throws FileSystemClientException {
        return EmptyInputStreamProvider.getDefault();
    }

    public IInputStreamProvider getBeforeStream(IProgressMonitor monitor) throws FileSystemClientException {
        return EmptyInputStreamProvider.getDefault();
    }
}

