/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.patches;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.patches.AbstractTrivialOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.MovableResource;
import com.ibm.team.filesystem.rcp.core.patches.PatchConflictException;
import com.ibm.team.internal.repository.rcp.streams.EmptyInputStreamProvider;
import com.ibm.team.repository.rcp.core.preferences.SerializationContext;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class CreateEmptyFileOp
extends AbstractTrivialOp {
    public CreateEmptyFileOp() {
    }

    public CreateEmptyFileOp(SerializationContext savedState, IProgressMonitor monitor) throws CoreException {
    }

    public void autoResolve(MovableResource moveResource, IProgressMonitor monitor) throws FileSystemClientException, PatchConflictException {
        IResource resource = moveResource.getResource();
        this.doVerify(moveResource);
        IFile file = (IFile)resource;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            file.create(EmptyInputStreamProvider.getDefault().getInputStream((IProgressMonitor)progress.newChild(50)), true, (IProgressMonitor)progress.newChild(50));
        }
        catch (Exception e) {
            throw new FileSystemClientException(StatusUtil.newStatus((Object)this, (Throwable)e));
        }
    }

    private void doVerify(MovableResource moveResource) throws PatchConflictException {
        IResource resource = moveResource.getResource();
        if (resource.exists()) {
            throw new PatchConflictException(StatusUtil.newStatus((Object)this, (String)NLS.bind((String)Messages.CreateEmptyFileOp_0, (Object)resource.getFullPath())));
        }
        if (!(resource instanceof IFile)) {
            throw new PatchConflictException(StatusUtil.newStatus((Object)this, (String)NLS.bind((String)Messages.CreateEmptyFileOp_1, (Object)resource.getFullPath())));
        }
    }

    public void save(SerializationContext whereToSave, IProgressMonitor monitor) throws CoreException {
    }

    public IStatus verify(MovableResource path, IProgressMonitor monitor) {
        try {
            this.doVerify(path);
        }
        catch (PatchConflictException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    public boolean isCreate() {
        return true;
    }
}

