/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.operations.share;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.operations.NewCheckInOperation;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.IItemUpdateReport;
import com.ibm.team.scm.common.dto.ISyncTime;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShareProjects {
    final IWorkspaceConnection workspace;
    final IChangeSetHandle changeSet;
    final IComponent component;
    final IFolderHandle parentFolder;
    final String[] newFolderUnderParent;
    final boolean overwrite;
    private final List<IProject> projects;
    private CommitDilemmaHandler problemHandler;
    private Map<UUID, IChangeSetHandle> changeSetsCommitted;

    public ShareProjects(IWorkspaceConnection workspace, IChangeSetHandle changeSet, IComponent component, IFolderHandle parentFolder, String[] newFolderUnderParent, boolean overwrite, CommitDilemmaHandler problemHandler) {
        this.workspace = workspace;
        this.changeSet = changeSet;
        this.component = component;
        this.parentFolder = parentFolder;
        this.newFolderUnderParent = newFolderUnderParent;
        this.projects = new ArrayList<IProject>();
        this.overwrite = overwrite;
        this.problemHandler = problemHandler;
    }

    public void addProject(IProject project) {
        this.projects.add(project);
    }

    public Collection<IProject> getProjects() {
        return this.projects;
    }

    public int getProjectCount() {
        return this.projects.size();
    }

    public Collection<IChangeSetHandle> share(Map<String, IFolder> foldersCreated, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        this.changeSetsCommitted = new HashMap<UUID, IChangeSetHandle>();
        if (this.projects.isEmpty()) {
            return this.changeSetsCommitted.values();
        }
        int numProjects = this.projects.size();
        SubMonitor reporter = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ArrayList<IWorkspaceConnection.ISaveOp> newFolderChanges = new ArrayList<IWorkspaceConnection.ISaveOp>();
        IFolderHandle folderToShareUnder = this.createNewFolderToShareUnder(this.parentFolder, foldersCreated, newFolderChanges);
        reporter.setTaskName(NLS.bind((String)Messages.ShareProjects_0, (Object[])new Object[]{numProjects}));
        Map<UUID, ResourceVersionablePair> changes = this.mapProjectsToVersionablesToBeCommitted(folderToShareUnder, this.component.getName(), (IProgressMonitor)reporter.newChild(5));
        if (!changes.isEmpty() || !newFolderChanges.isEmpty()) {
            this.commitNewProjects(this.component.getName(), folderToShareUnder, newFolderChanges, changes, reporter.newChild(15));
            if (!changes.isEmpty()) {
                this.commitNewProjectContents((IProgressMonitor)reporter.newChild(80));
            }
        }
        return this.changeSetsCommitted.values();
    }

    private IFolderHandle createNewFolderToShareUnder(IFolderHandle folderToShareUnder, Map<String, IFolder> foldersCreated, ArrayList<IWorkspaceConnection.ISaveOp> newFolderChanges) {
        if (this.newFolderUnderParent.length > 0) {
            IWorkspaceConnection.IConfigurationOpFactory opFactory = this.workspace.configurationOpFactory();
            String relativePath = "";
            String[] stringArray = this.newFolderUnderParent;
            int n = this.newFolderUnderParent.length;
            int n2 = 0;
            while (n2 < n) {
                String folderToCreate = stringArray[n2];
                IFolder folder = foldersCreated.get(relativePath = String.valueOf(relativePath) + "/" + folderToCreate);
                if (folder == null) {
                    folder = (IFolder)IFolder.ITEM_TYPE.createItem();
                    folder.setName(folderToCreate);
                    folder.setParent(folderToShareUnder);
                    newFolderChanges.add(opFactory.save((IVersionable)folder));
                    foldersCreated.put(relativePath, folder);
                }
                folderToShareUnder = folder;
                ++n2;
            }
        }
        return folderToShareUnder;
    }

    private void commitNewProjectContents(IProgressMonitor progress) throws TeamRepositoryException, FileSystemClientException {
        IShareable[] projectShareables = new IShareable[this.projects.size()];
        int index = 0;
        for (IProject project : this.projects) {
            projectShareables[index++] = (IShareable)project.getAdapter(IShareable.class);
        }
        NewCheckInOperation commit = this.changeSet == null ? new NewCheckInOperation(this.workspace, (IComponentHandle)this.component, projectShareables, Messages.ShareProjects_1, this.problemHandler) : new NewCheckInOperation(this.workspace, (IComponentHandle)this.component, projectShareables, this.changeSet, this.problemHandler);
        commit.setIsAtomicCommitRequired(false);
        commit.run(progress);
        for (IChangeSetHandle changeSet : commit.getCommittedChangeSets()) {
            this.changeSetsCommitted.put(changeSet.getItemId(), changeSet);
        }
    }

    private void commitNewProjects(String componentName, IFolderHandle parentFolderForShare, ArrayList<IWorkspaceConnection.ISaveOp> newFolderChanges, Map<UUID, ResourceVersionablePair> changes, SubMonitor reporter) throws TeamRepositoryException, FileSystemClientException {
        IWorkspaceConnection.IConfigurationOpFactory opFactory = this.workspace.configurationOpFactory();
        ArrayList<IWorkspaceConnection.ISaveOp> allOps = new ArrayList<IWorkspaceConnection.ISaveOp>(changes.size() + newFolderChanges.size());
        allOps.addAll(newFolderChanges);
        for (ResourceVersionablePair pair : changes.values()) {
            allOps.add(opFactory.save(pair.getVersionable()));
        }
        IChangeSetHandle changeSetCommitted = this.changeSet;
        if (changeSetCommitted == null && (changeSetCommitted = this.workspace.getCurrentChangeSet((IComponentHandle)this.component)) == null) {
            changeSetCommitted = this.workspace.createChangeSet((IComponentHandle)this.component, Messages.ShareProjects_2, true, (IProgressMonitor)reporter.newChild(1));
        }
        reporter.setTaskName(Messages.ShareProjects_3);
        IUpdateReport outcome = this.workspace.commit(changeSetCommitted, allOps, (IProgressMonitor)reporter.newChild(4));
        this.changeSetsCommitted.put(changeSetCommitted.getItemId(), changeSetCommitted);
        SubMonitor subProgress = reporter.newChild(10);
        ArrayList allUpdates = new ArrayList(outcome.updates().size() + outcome.incidentalResolutionUpdates().size());
        allUpdates.addAll(outcome.updates());
        allUpdates.addAll(outcome.incidentalResolutionUpdates());
        int cnt = 0;
        int total = allUpdates.size();
        subProgress.setWorkRemaining(total);
        ISyncTime beforeConfigurationState = this.getConfigurationState(outcome.getComponentStatesBefore());
        ISyncTime configurationState = this.getConfigurationState(outcome.getComponentStatesAfter());
        for (IItemUpdateReport current : allUpdates) {
            ResourceVersionablePair toUpdate = changes.get(current.getNewCurrentState().getItemId());
            if (toUpdate != null) {
                subProgress.setTaskName(NLS.bind((String)Messages.ShareProjects_4, (Object[])new Object[]{cnt, total, toUpdate.getResource().getName()}));
                SharingDescriptor descriptor = new SharingDescriptor(this.workspace.teamRepository().getRepositoryURI(), this.workspace.teamRepository().getId(), (IConnection)this.workspace, (IComponentHandle)this.component, componentName, (IFolderHandle)current.getNewCurrentState(), configurationState);
                ((Shareable)toUpdate.getResource().getAdapter(IShareable.class)).share((ISharingDescriptor)descriptor, this.overwrite, true, (IProgressMonitor)subProgress.newChild(1));
            } else {
                subProgress.worked(1);
            }
            ++cnt;
        }
        CopyFileAreaStore.getDefaultCopyFileArea().setConfigurationState((IContextHandle)this.workspace.getResolvedWorkspace(), (IComponentHandle)this.component, beforeConfigurationState, configurationState, (IProgressMonitor)subProgress.newChild(1));
        subProgress.done();
    }

    private ISyncTime getConfigurationState(Collection<IComponentStateSummary> configurationStates) {
        ISyncTime configurationState = null;
        for (IComponentStateSummary summary : configurationStates) {
            if (!summary.getComponent().sameItemId((IItemHandle)this.component)) continue;
            configurationState = summary.getConfigurationTime();
            break;
        }
        return configurationState;
    }

    private Map<UUID, ResourceVersionablePair> mapProjectsToVersionablesToBeCommitted(IFolderHandle rootFolder, String componentName, IProgressMonitor reporter) throws FileSystemClientException, TeamRepositoryException {
        int numProjects = this.projects.size();
        SubMonitor shareProgress = SubMonitor.convert((IProgressMonitor)reporter, (int)(numProjects * 100));
        HashMap<UUID, ResourceVersionablePair> changes = new HashMap<UUID, ResourceVersionablePair>(numProjects);
        try {
            int processed = 0;
            Iterator<IProject> iter = this.projects.iterator();
            while (iter.hasNext()) {
                if (shareProgress.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IProject project = iter.next();
                shareProgress.setTaskName(NLS.bind((String)Messages.ShareProjects_5, (Object[])new Object[]{project.getName(), ++processed, numProjects}));
                IFolder projectFolder = (IFolder)IFolder.ITEM_TYPE.createItem();
                changes.put(projectFolder.getItemId(), new ResourceVersionablePair((IResource)project, (IVersionable)projectFolder));
                projectFolder.setName(project.getName());
                projectFolder.setParent(rootFolder);
                shareProgress.worked(100);
            }
        }
        finally {
            shareProgress.done();
        }
        return changes;
    }

    public void removeProject(IProject projectToRemove) {
        Iterator<IProject> i = this.projects.iterator();
        while (i.hasNext()) {
            IProject project = i.next();
            if (!project.equals((Object)projectToRemove)) continue;
            i.remove();
        }
    }

    private class ResourceVersionablePair {
        private IResource resource;
        private IVersionable versionable;

        public IResource getResource() {
            return this.resource;
        }

        public IVersionable getVersionable() {
            return this.versionable;
        }

        public ResourceVersionablePair(IResource resource, IVersionable versionable) {
            this.resource = resource;
            this.versionable = versionable;
        }
    }
}

