/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.operations.share;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemManager;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.filesystem.common.internal.dto.LoadTree;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.LineDelimiter;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.Content;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.common.utils.ContentLineDelimiterError;
import com.ibm.team.repository.common.utils.HashCode;
import com.ibm.team.repository.common.utils.HashComputingInputStream;
import com.ibm.team.repository.common.utils.ReaderToInputStream;
import com.ibm.team.repository.common.utils.VerifyConvertToCRInputStream;
import com.ibm.team.repository.common.utils.VerifyConvertToCRLFInputStream;
import com.ibm.team.repository.common.utils.VerifyConvertToLFInputStream;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.ISyncTime;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReshareProject {
    private static final int BUFFER_LENGTH = 16384;
    final IConnection connection;
    final IComponent component;
    final IProject localProject;
    final IFolderHandle remoteProject;
    final boolean overwrite;
    private CopyFileAreaStore cfa;

    public ReshareProject(IConnection connection, IComponent component, IFolderHandle remoteProject, IProject localProject, boolean overwrite) {
        this.connection = connection;
        this.component = component;
        this.remoteProject = remoteProject;
        this.localProject = localProject;
        this.overwrite = overwrite;
        this.cfa = CopyFileAreaStore.getDefaultCopyFileArea();
    }

    public void reShare(IProgressMonitor progress) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor reshareProgress = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IShareable shareable = (IShareable)this.localProject.getAdapter(IShareable.class);
        ITeamRepository repo = this.connection.teamRepository();
        FileSystemServiceProxy fileSystemService = ((FileSystemManager)FileSystemCore.getFileSystemManager((ITeamRepository)repo)).getFileSystemService();
        progress.setTaskName(NLS.bind((String)Messages.ReshareProject_0, (Object[])new Object[]{this.localProject.getName()}));
        IFolderHandle remoteProjectState = this.remoteProject;
        if (!remoteProjectState.hasStateId()) {
            remoteProjectState = this.connection instanceof IWorkspaceConnection ? (IFolderHandle)((IWorkspaceConnection)this.connection).configuration((IComponentHandle)this.component).fetchCompleteItem((IVersionableHandle)this.remoteProject, (IProgressMonitor)reshareProgress.newChild(2)) : (IFolderHandle)((IBaselineConnection)this.connection).configuration().fetchCompleteItem((IVersionableHandle)this.remoteProject, (IProgressMonitor)reshareProgress.newChild(2));
        }
        SharingDescriptor descriptor = new SharingDescriptor(repo.getRepositoryURI(), repo.getId(), this.connection, (IComponentHandle)this.component, this.component.getName(), remoteProjectState);
        ((Shareable)shareable).share((ISharingDescriptor)descriptor, this.overwrite, false, (IProgressMonitor)reshareProgress.newChild(3));
        final LoadTree loadTree = fileSystemService.getFileTreeByVersionable(this.connection, (IComponentHandle)this.component, new IVersionableHandle[]{this.remoteProject}, -1, true, null, (IProgressMonitor)reshareProgress.newChild(20));
        progress.setTaskName(NLS.bind((String)Messages.ReshareProject_1, (Object[])new Object[]{this.localProject.getName()}));
        this.cfa.run(shareable.getRule(), new CopyFileAreaStore.IOperation(){

            public void execute(IProgressMonitor monitor) throws FileSystemClientException {
                ReshareProject.this.loadMetadata(ReshareProject.this.connection, (IComponentHandle)ReshareProject.this.component, ReshareProject.this.localProject, loadTree.getFileAreaUpdates(), monitor);
            }
        }, (IProgressMonitor)reshareProgress.newChild(60));
        CopyFileAreaStore.getDefaultCopyFileArea().setConfigurationState(this.connection.getContextHandle(), (IComponentHandle)this.component, this.remoteProject, ISyncTime.FACTORY.createFrom(loadTree.getConfigurationState()), (IProgressMonitor)reshareProgress.newChild(5));
        LocalChangeManager.getInstance().refreshChanges(shareable.getShare(), null, (IProgressMonitor)reshareProgress.newChild(10));
    }

    private void loadMetadata(IConnection connection, IComponentHandle component, IProject current, List<FileAreaUpdate> additions, IProgressMonitor monitor) throws FileSystemClientException {
        HashMap<UUID, IPath> foldersEncountered = new HashMap<UUID, IPath>();
        byte[] buffer = new byte[16384];
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)additions.size());
        try {
            try {
                for (FileAreaUpdate currentAddition : additions) {
                    SubMonitor subProgress = progress.newChild(1);
                    IPath parentPath = (IPath)foldersEncountered.get(currentAddition.parent().getItemId());
                    Object resourcePath = parentPath == null ? new Path(currentAddition.getName()) : parentPath.append(currentAddition.getName());
                    IResource resource = root.findMember(resourcePath);
                    IVersionableHandle handle = currentAddition.afterState();
                    Assert.isTrue((boolean)handle.hasStateId());
                    boolean isFolder = handle instanceof IFolderHandle;
                    if (isFolder) {
                        foldersEncountered.put(handle.getItemId(), (IPath)resourcePath);
                    }
                    IFolderHandle parent = currentAddition.parent();
                    FileItemInfo itemInfo = null;
                    if (resource != null) {
                        switch (resource.getType()) {
                            case 4: {
                                if (!isFolder) break;
                                itemInfo = new FileItemInfo((IFolderHandle)handle, null, null);
                                break;
                            }
                            case 2: {
                                if (!isFolder) break;
                                itemInfo = new FileItemInfo((IFolderHandle)handle, parent, resourcePath.lastSegment());
                                break;
                            }
                            case 1: {
                                if (isFolder) break;
                                subProgress.setWorkRemaining(2);
                                itemInfo = ReshareProject.sameContents((IFile)resource, currentAddition, buffer, connection.teamRepository(), (IProgressMonitor)subProgress.newChild(1));
                            }
                        }
                    }
                    subProgress.setWorkRemaining(1);
                    if (itemInfo != null) {
                        subProgress.setWorkRemaining(1);
                        IShareable shareable = (IShareable)resource.getAdapter(IShareable.class);
                        this.cfa.setItemInfo(shareable, itemInfo, (IProgressMonitor)subProgress.newChild(1));
                    } else {
                        HashCode hash = null;
                        long size = -1L;
                        LineDelimiter lineDelimiter = null;
                        String contentType = null;
                        UUID contentId = null;
                        UUID deltaPredecessor = null;
                        long storedSize = -1L;
                        String encoding = null;
                        long storedChecksum = -1L;
                        long storedNumLineDelimiters = -1L;
                        if (currentAddition.getOptionalContent() != null) {
                            Content content = (Content)currentAddition.getOptionalContent();
                            if (connection.teamRepository().contentManager().convertDelimitersDuringRetrieval((IContent)content)) {
                                subProgress.setWorkRemaining(10);
                                InputStream in = connection.teamRepository().contentManager().retrieveContentStream((IContent)content, (IProgressMonitor)subProgress.newChild(9));
                                try {
                                    HashComputingInputStream hin = new HashComputingInputStream(in);
                                    while (hin.read(buffer) != -1) {
                                    }
                                    hash = new HashCode(hin.getChecksum());
                                    size = hin.getContentSize();
                                }
                                finally {
                                    in.close();
                                }
                            } else {
                                hash = content.getRawHashCode();
                                size = content.getEstimatedConvertedLength();
                            }
                            lineDelimiter = content.getLineDelimiter();
                            contentType = content.getContentType();
                            contentId = content.getContentId();
                            deltaPredecessor = content.getDeltaPredecessor();
                            storedSize = content.getContentLength();
                            encoding = content.getCharacterEncoding();
                            storedChecksum = content.getChecksum();
                            storedNumLineDelimiters = content.getLineDelimiterCount();
                        }
                        subProgress.setWorkRemaining(1);
                        itemInfo = new FileItemInfo(handle, -1L, parent, resourcePath.lastSegment(), hash, size, lineDelimiter, lineDelimiter, contentType, contentType, contentId, deltaPredecessor, storedSize, encoding, storedChecksum, storedNumLineDelimiters, currentAddition.isExecutable(), currentAddition.isExecutable());
                        this.cfa.setItemInfo(currentAddition.getItem(), component, connection.getContextHandle(), itemInfo, (IProgressMonitor)subProgress.newChild(1));
                    }
                    subProgress.done();
                }
            }
            catch (IOException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor((Throwable)e));
            }
            catch (TeamRepositoryException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor((Throwable)e));
            }
        }
        finally {
            progress.done();
        }
    }

    private static FileItemInfo sameContents(IFile file, FileAreaUpdate addition, byte[] buffer, ITeamRepository repo, IProgressMonitor monitor) throws TeamRepositoryException, IOException {
        String actualContentType;
        String originalContentType;
        LineDelimiter actualLineDelimiter;
        LineDelimiter originalLineDelimiter;
        HashCode hashCode;
        long contentSize;
        long modificationTime;
        Content content;
        SubMonitor progress;
        block27: {
            progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            content = (Content)addition.getOptionalContent();
            modificationTime = -1L;
            contentSize = content.getEstimatedConvertedLength();
            hashCode = null;
            originalLineDelimiter = content.getLineDelimiter();
            actualLineDelimiter = content.getLineDelimiter();
            originalContentType = content.getContentType();
            actualContentType = content.getContentType();
            URI location = file.getLocationURI();
            if (location != null) {
                try {
                    HashComputingInputStream localHashedStream;
                    HashComputingInputStream remoteHashedStream;
                    IFileStore store = EFS.getStore((URI)location);
                    IFileInfo localInfo = store.fetchInfo();
                    long localLength = localInfo.getLength();
                    if (localLength != content.getEstimatedConvertedLength()) break block27;
                    InputStream inStream = store.openInputStream(0, (IProgressMonitor)progress.newChild(80));
                    try {
                        block3 : switch (originalLineDelimiter) {
                            case LINE_DELIMITER_CR: {
                                inStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToCRInputStream(inStream, file.getCharset(true)));
                                localHashedStream = remoteHashedStream = new HashComputingInputStream(inStream);
                                break;
                            }
                            case LINE_DELIMITER_PLATFORM: {
                                String charset = file.getCharset(true);
                                switch (LineDelimiter.getPlatformDelimiter()) {
                                    case LINE_DELIMITER_CRLF: {
                                        inStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToCRLFInputStream(inStream, charset));
                                        localHashedStream = new HashComputingInputStream(inStream);
                                        inStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToLFInputStream(inStream, charset));
                                        remoteHashedStream = new HashComputingInputStream(inStream);
                                        break block3;
                                    }
                                    case LINE_DELIMITER_CR: {
                                        inStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToCRInputStream(inStream, charset));
                                        localHashedStream = new HashComputingInputStream(inStream);
                                        inStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToLFInputStream(inStream, charset));
                                        remoteHashedStream = new HashComputingInputStream(inStream);
                                        break block3;
                                    }
                                }
                                inStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToLFInputStream(inStream, charset));
                                localHashedStream = remoteHashedStream = new HashComputingInputStream(inStream);
                                break;
                            }
                            case LINE_DELIMITER_LF: {
                                inStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToLFInputStream(inStream, file.getCharset(true)));
                                localHashedStream = remoteHashedStream = new HashComputingInputStream(inStream);
                                break;
                            }
                            case LINE_DELIMITER_CRLF: {
                                inStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToCRLFInputStream(inStream, file.getCharset(true)));
                                localHashedStream = remoteHashedStream = new HashComputingInputStream(inStream);
                                break;
                            }
                            default: {
                                localHashedStream = remoteHashedStream = new HashComputingInputStream(inStream);
                            }
                        }
                        while (remoteHashedStream.read(buffer) != -1) {
                        }
                    }
                    finally {
                        inStream.close();
                    }
                    HashCode convertedRemoteHashCode = new HashCode(remoteHashedStream.getHash());
                    if (convertedRemoteHashCode.equals((Object)content.getRawHashCode()) && remoteHashedStream.getContentSize() == content.getRawLength() && localHashedStream.getContentSize() == content.getEstimatedConvertedLength()) {
                        hashCode = new HashCode(localHashedStream.getChecksum());
                        contentSize = localHashedStream.getContentSize();
                        modificationTime = file.getModificationStamp();
                    }
                }
                catch (ContentLineDelimiterError contentLineDelimiterError) {
                    actualLineDelimiter = LineDelimiter.LINE_DELIMITER_NONE;
                }
                catch (CoreException coreException) {
                }
                catch (IOException iOException) {
                    actualLineDelimiter = LineDelimiter.LINE_DELIMITER_NONE;
                }
            }
        }
        if (hashCode == null) {
            if (repo.contentManager().convertDelimitersDuringRetrieval((IContent)content)) {
                progress.setWorkRemaining(20);
                InputStream in = repo.contentManager().retrieveContentStream((IContent)content, (IProgressMonitor)progress.newChild(20));
                try {
                    HashComputingInputStream hin = new HashComputingInputStream(in);
                    while (hin.read(buffer) != -1) {
                    }
                    hashCode = new HashCode(hin.getChecksum());
                    contentSize = hin.getContentSize();
                }
                finally {
                    in.close();
                }
            } else {
                hashCode = content.getRawHashCode();
                contentSize = content.getEstimatedConvertedLength();
            }
        }
        return new FileItemInfo(addition.afterState(), modificationTime, addition.parent(), file.getName(), hashCode, contentSize, originalLineDelimiter, actualLineDelimiter, originalContentType, actualContentType, content.getContentId(), content.getDeltaPredecessor(), content.getContentLength(), content.getCharacterEncoding(), content.getChecksum(), content.getLineDelimiterCount(), addition.isExecutable(), addition.isExecutable());
    }
}

