/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.operations.merge;

import com.ibm.team.filesystem.client.internal.utils.FileContentInputStream;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.LineDelimiter;
import java.io.InputStream;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;

public class FileContentStorage
extends PlatformObject
implements IEncodedStorage {
    private IContent content;
    private ITeamRepository repository;
    private IPath path;
    private final LineDelimiter lineDelimeter;
    private final IProgressMonitor monitor;

    public FileContentStorage(ITeamRepository repository, IContent content, IPath path, IProgressMonitor monitor) {
        this(repository, content, path, content.getLineDelimiter(), monitor);
    }

    public FileContentStorage(ITeamRepository repository, IContent content, IPath path, LineDelimiter lineDelimeter, IProgressMonitor monitor) {
        this.repository = repository;
        this.content = content;
        this.path = path;
        this.lineDelimeter = lineDelimeter;
        this.monitor = monitor;
    }

    public String getCharset() throws CoreException {
        return this.content.getCharacterEncoding();
    }

    public InputStream getContents() throws CoreException {
        return new FileContentInputStream(this.repository, this.content, this.lineDelimeter, this.monitor);
    }

    public IPath getFullPath() {
        return this.path;
    }

    public String getName() {
        return this.path.lastSegment();
    }

    public boolean isReadOnly() {
        return true;
    }
}

