/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.changemodel.IPathResolver;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.rcp.core.IEclipseFileSystemManager;
import com.ibm.team.filesystem.rcp.core.internal.CoreShareablesUtil;
import com.ibm.team.filesystem.rcp.core.internal.resources.ResourceUtil;
import com.ibm.team.filesystem.rcp.core.operations.ChangePropertiesDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.operations.IChangeFilePropertiesOperation;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.repository.rcp.streams.EmptyInputStreamProvider;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.utils.DisposableInputStreamProvider;
import com.ibm.team.repository.common.utils.TemporaryOutputStream;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import com.ibm.team.scm.common.internal.util.StateId;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilesystemUtil {
    public static IFile createFile(IPath path, ITeamRepository repository, IComponentHandle component, StateId versionableHandle, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            IFileItem item = versionableHandle.isDeleted() ? null : (IFileItem)RepoFetcher.fetchItem((ITeamRepository)repository, (StateId)versionableHandle, (IProgressMonitor)progress.newChild(50));
            return FilesystemUtil.createFile(path, repository, component, item, (IProgressMonitor)progress);
        }
        catch (TeamRepositoryException e) {
            throw new CoreException(StatusUtil.newStatus(FilesystemUtil.class, (Throwable)e));
        }
    }

    public static IFile createFile(IPath path, ITeamRepository repository, IComponentHandle component, IFileItem item, IProgressMonitor monitor) throws CoreException, TeamRepositoryException, FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        InputStream input = null;
        try {
            try {
                IShareable shareable;
                if (!file.exists()) {
                    ResourceUtil.createPath(file.getParent(), (IProgressMonitor)progress.newChild(10));
                    input = FilesystemUtil.getFileInputStream(repository, item, (IProgressMonitor)progress.newChild(65));
                    CoreShareablesUtil.createFile(file, input, VersionablePath.getUnresolvedPath((IVersionable)item, (ItemId)ItemId.create((IItemHandle)component)), (IProgressMonitor)progress.newChild(5));
                } else {
                    input = FilesystemUtil.getFileInputStream(repository, item, (IProgressMonitor)progress.newChild(70));
                    file.setContents(input, true, true, null);
                }
                progress.setWorkRemaining(20);
                if (item != null && (shareable = (IShareable)Adapters.getAdapter((Object)file, IShareable.class)).getShare() != null) {
                    try {
                        ChangePropertiesDilemmaHandler dilemmaHandler = new ChangePropertiesDilemmaHandler();
                        IChangeFilePropertiesOperation changePropertiesOp = IEclipseFileSystemManager.instance.getChangeFilePropertiesOperation(dilemmaHandler);
                        changePropertiesOp.setContentType(shareable, item.getContent().getContentType());
                        changePropertiesOp.setLineDelimiter(shareable, item.getContent().getLineDelimiter());
                        changePropertiesOp.run((IProgressMonitor)progress.newChild(10));
                    }
                    catch (NotLoggedInException notLoggedInException) {}
                }
                input.close();
                input = null;
            }
            catch (IOException e) {
                throw new FileSystemClientException(StatusUtil.newStatus(FilesystemUtil.class, (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (input != null) {
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
        return file;
    }

    public static InputStream getFileInputStream(ITeamRepository server, IFileItem item, IProgressMonitor mon) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)mon, (int)100);
        if (item == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        IContent content = item.getContent();
        return server.contentManager().retrieveContentStream(content, (IProgressMonitor)progress.newChild(50));
    }

    public static DisposableInputStreamProvider openFileContents(ITeamRepository server, StateId<IFileItem> fileState, IProgressMonitor mon) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)mon, (int)100);
        if (fileState.isDeleted()) {
            return new EmptyInputStreamProvider();
        }
        IFileItem item = (IFileItem)RepoFetcher.fetchItem((ITeamRepository)server, fileState, (IProgressMonitor)progress.newChild(50));
        return FilesystemUtil.openFileContents(server, item, (IProgressMonitor)progress);
    }

    public static DisposableInputStreamProvider openFileContents(ITeamRepository server, IFileItem item, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            IContent content = item.getContent();
            TemporaryOutputStream out = TemporaryOutputStream.getTemporaryOutputStream((long)content.getEstimatedConvertedLength());
            boolean success = false;
            try {
                server.contentManager().retrieveContent(content, (OutputStream)out, (IProgressMonitor)progress.newChild(100));
                success = true;
            }
            catch (Throwable throwable) {
                if (!success) {
                    try {
                        out.dispose();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (!success) {
                try {
                    out.dispose();
                }
                catch (IOException iOException) {}
            }
            return out;
        }
        catch (IOException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    public static Map<VersionablePath, VersionablePath> resolvePaths(IPathResolver pathResolver, Collection<VersionablePath> unresolved, IProgressMonitor monitor) throws TeamRepositoryException {
        HashSet<SiloedItemId> toResolve = new HashSet<SiloedItemId>();
        for (VersionablePath next : unresolved) {
            if (next.isAbsolute()) continue;
            toResolve.add(next.getSiloedRoot());
        }
        Map resolved = pathResolver.resolve(toResolve, monitor);
        HashMap<VersionablePath, VersionablePath> result = new HashMap<VersionablePath, VersionablePath>();
        for (VersionablePath next : unresolved) {
            if (!next.isAbsolute()) {
                VersionablePath nextResolved = (VersionablePath)resolved.get(next.getSiloedRoot());
                VersionablePath fullResolved = nextResolved.append(next);
                result.put(next, fullResolved);
                continue;
            }
            result.put(next, next);
        }
        return result;
    }
}

