/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.operations.DeliverOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.operations.DeliverDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.operations.NewCheckInOperation;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class EclipseWorkspaceDeliverOperation
extends DeliverOperation {
    public EclipseWorkspaceDeliverOperation(DeliverDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler);
    }

    protected void verifyUncheckedInChanges(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Collection affectedConfigurations = this.getAffectedDeliverConfigurations(this.getDeliverRequests(), new ArrayList(3), new ArrayList(3), (IProgressMonitor)progress.newChild(1));
        HashMap<ConfigurationDescriptor, List<ILocalChange>> pendingLocalChanges = new HashMap<ConfigurationDescriptor, List<ILocalChange>>();
        SubMonitor loopProgress = progress.newChild(50).setWorkRemaining(affectedConfigurations.size() * 2);
        for (ConfigurationDescriptor configurationDescriptor : affectedConfigurations) {
            ILocalChangeManager lcm = FileSystemCore.getSharingManager().getLocalChangeManager();
            CopyFileAreaStore cfa = CopyFileAreaStore.getDefaultCopyFileArea();
            IComponentHandle componentHandle = configurationDescriptor.componentHandle;
            IContextHandle connectionHandle = configurationDescriptor.connectionHandle;
            ISchedulingRule cfaLock = cfa.lock(componentHandle, connectionHandle, (IProgressMonitor)loopProgress.newChild(1));
            try {
                lcm.syncPendingChanges(connectionHandle, componentHandle, FileSystemCore.getSharingManager().getDefaultCFARoot());
            }
            finally {
                cfa.release(cfaLock, (IProgressMonitor)loopProgress.newChild(1));
            }
            ILocalChange[] localChanges = lcm.getPendingChanges(connectionHandle, componentHandle, FileSystemCore.getSharingManager().getDefaultCFARoot());
            if (localChanges.length <= 0) continue;
            pendingLocalChanges.put(configurationDescriptor, Arrays.asList(localChanges));
        }
        progress.setWorkRemaining(100);
        if (pendingLocalChanges.size() > 0) {
            ArrayList<IComponentHandle> componentsWithPending = new ArrayList<IComponentHandle>(pendingLocalChanges.keySet().size());
            for (ConfigurationDescriptor configurationDescriptor : pendingLocalChanges.keySet()) {
                componentsWithPending.add(configurationDescriptor.componentHandle);
            }
            int result = this.getProblemHandler().uncheckedInChanges(componentsWithPending);
            if (result == 0) {
                loopProgress = progress.newChild(50).setWorkRemaining(affectedConfigurations.size() * 2);
                for (ConfigurationDescriptor configurationDescriptor : pendingLocalChanges.keySet()) {
                    IConnection connection = configurationDescriptor.getConnection((IProgressMonitor)loopProgress.newChild(1));
                    if (!(connection instanceof IWorkspaceConnection)) continue;
                    new NewCheckInOperation((IWorkspaceConnection)connection, configurationDescriptor.componentHandle, ((List)pendingLocalChanges.get(configurationDescriptor)).toArray(new ILocalChange[0]), "", this.getProblemHandler().getCommitHandler()).run((IProgressMonitor)loopProgress.newChild(1));
                }
            } else {
                if (result == 1) {
                    throw new OperationCanceledException();
                }
                if (result == 2) {
                    throw new FileSystemClientException((IStatus)new FileSystemStatus(4, Messages.EclipseWorkspaceDeliverOperation_0));
                }
            }
        }
    }
}

