/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.operations.WorkspaceUpdateOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IFileSystemOperation;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.client.operations.WorkspaceUpdateDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.operations.EclipseWorkspaceUpdateOperation;
import com.ibm.team.filesystem.rcp.core.operations.EclipseWorkspaceVerifySharesOperation;
import com.ibm.team.filesystem.rcp.core.operations.IDownloadMonitor;
import com.ibm.team.filesystem.rcp.core.operations.NewCheckInOperation;
import com.ibm.team.filesystem.rcp.core.operations.UnshareProjectsOperation;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseWorkspaceConfigurationUpdateOperation
extends WorkspaceUpdateOperation {
    private IDownloadMonitor downloadMonitor = null;

    public EclipseWorkspaceConfigurationUpdateOperation(WorkspaceUpdateDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler);
    }

    protected void execute(IProgressMonitor progress) throws FileSystemClientException, TeamRepositoryException {
        if (progress instanceof IDownloadMonitor) {
            this.downloadMonitor = (IDownloadMonitor)progress;
        }
        super.execute(progress);
    }

    protected CopyFileAreaStore getCopyFileArea() {
        return CopyFileAreaStore.getDefaultCopyFileArea();
    }

    protected IFileSystemOperation getUpdateOperation(IWorkspaceConnection workspaceConnection, List<IUpdateReport> updateReports, int updatesToProcessFlags, UpdateDilemmaHandler problemHandler) {
        EclipseWorkspaceUpdateOperation updateOperation = new EclipseWorkspaceUpdateOperation(workspaceConnection, updateReports, updatesToProcessFlags, problemHandler, this.downloadMonitor);
        return updateOperation;
    }

    protected IVerifyInSyncOperation getVerifyOperation(OutOfSyncDilemmaHandler problemHandler) {
        EclipseWorkspaceVerifySharesOperation verifyInSyncOperation = new EclipseWorkspaceVerifySharesOperation(problemHandler);
        return verifyInSyncOperation;
    }

    protected IFileSystemOperation getUnshareProjectsOperation(Set<ConfigurationDescriptor> componentsRemoved) throws FileSystemClientException, TeamRepositoryException {
        UnshareProjectsOperation op = new UnshareProjectsOperation(componentsRemoved, true);
        return op;
    }

    public IFileSystemOperation getCheckInOperation(IWorkspaceConnection connection, IComponentHandle componentHandle, ILocalChange[] changes, String comment, CommitDilemmaHandler commitDilemmaHandler) {
        NewCheckInOperation checkinOperation = new NewCheckInOperation(connection, componentHandle, changes, comment, commitDilemmaHandler);
        return checkinOperation;
    }

    protected void runWithinFileSystemLock(final IRunnableWithProgress runnableWithProgress, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        final InvocationTargetException[] invocationTargetExceptions = new InvocationTargetException[1];
        IWorkspaceRunnable workspaceOp = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    runnableWithProgress.run(monitor);
                }
                catch (InvocationTargetException e) {
                    invocationTargetExceptions[0] = e;
                }
                catch (InterruptedException interruptedException) {
                    throw new OperationCanceledException();
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(workspaceOp, monitor);
            if (invocationTargetExceptions[0] != null) {
                throw invocationTargetExceptions[0];
            }
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }
}

