/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.utils.ConnectionDescriptor;
import com.ibm.team.filesystem.client.internal.utils.CopyFileAreaLockUtil;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.resources.ShareableResource;
import com.ibm.team.filesystem.rcp.core.operations.ChangePropertiesDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.operations.EclipseWorkspaceVerifySharesOperation;
import com.ibm.team.filesystem.rcp.core.operations.IChangeFilePropertiesOperation;
import com.ibm.team.filesystem.rcp.core.operations.IChangePropertiesRequest;
import com.ibm.team.repository.common.LineDelimiter;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.common.utils.ContentLineDelimiterError;
import com.ibm.team.repository.common.utils.DisposableInputStreamProvider;
import com.ibm.team.repository.common.utils.LineDelimiterUtil;
import com.ibm.team.repository.common.utils.ReaderToInputStream;
import com.ibm.team.repository.common.utils.TemporaryOutputStream;
import com.ibm.team.repository.common.utils.VerifyConvertToCRInputStream;
import com.ibm.team.repository.common.utils.VerifyConvertToCRLFInputStream;
import com.ibm.team.repository.common.utils.VerifyConvertToLFInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.UnmappableCharacterException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseWorkspaceChangeFilePropertiesOperation
extends FileSystemOperation
implements IChangeFilePropertiesOperation {
    private ChangePropertiesDilemmaHandler dilemmaHandler;
    private HashMap<IPath, ChangePropertiesRequest> changeProperties;
    private CopyFileAreaStore copyFileArea;

    public EclipseWorkspaceChangeFilePropertiesOperation(ChangePropertiesDilemmaHandler dilemmaHandler) {
        super((DilemmaHandler)(dilemmaHandler == null ? ChangePropertiesDilemmaHandler.getDefault() : dilemmaHandler));
        this.dilemmaHandler = dilemmaHandler == null ? ChangePropertiesDilemmaHandler.getDefault() : dilemmaHandler;
        this.changeProperties = new HashMap();
    }

    @Override
    public void setLineDelimiter(IShareable shareableFile, LineDelimiter lineDelimiter) {
        if (shareableFile == null) {
            throw new IllegalArgumentException();
        }
        if (lineDelimiter == null) {
            throw new IllegalArgumentException();
        }
        if (!(shareableFile instanceof ShareableResource)) {
            throw new IllegalArgumentException();
        }
        ShareableResource shareable = (ShareableResource)shareableFile;
        if (shareable.getFileStorage().isFolder()) {
            throw new IllegalArgumentException();
        }
        if (shareable.getShare() == null) {
            throw new IllegalArgumentException();
        }
        if (!shareable.getFileStorage().exists()) {
            throw new IllegalArgumentException();
        }
        IPath path = shareable.getLocalFullPath();
        ChangePropertiesRequest existingRequest = this.changeProperties.get(path);
        if (existingRequest == null) {
            this.changeProperties.put(path, new ChangePropertiesRequest(shareable, lineDelimiter));
        } else {
            existingRequest.lineDelimiter = lineDelimiter;
        }
    }

    @Override
    public void setContentType(IShareable shareableFile, String contentType) {
        if (shareableFile == null) {
            throw new IllegalArgumentException();
        }
        if (contentType == null) {
            throw new IllegalArgumentException();
        }
        if (!(shareableFile instanceof ShareableResource)) {
            throw new IllegalArgumentException();
        }
        ShareableResource shareable = (ShareableResource)shareableFile;
        if (shareable.getFileStorage().isFolder()) {
            throw new IllegalArgumentException();
        }
        if (shareable.getShare() == null) {
            throw new IllegalArgumentException();
        }
        if (!shareable.getFileStorage().exists()) {
            throw new IllegalArgumentException();
        }
        IPath path = shareable.getLocalFullPath();
        ChangePropertiesRequest existingRequest = this.changeProperties.get(path);
        if (existingRequest == null) {
            this.changeProperties.put(path, new ChangePropertiesRequest(shareable, contentType));
        } else {
            existingRequest.contentType = contentType;
        }
    }

    protected void execute(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        final CopyFileAreaStore copyFileArea = CopyFileAreaStore.getDefaultCopyFileArea();
        if (this.changeProperties.isEmpty()) {
            return;
        }
        this.verifyShares((IProgressMonitor)progress.newChild(10));
        final ArrayList<IShareable> shareables = new ArrayList<IShareable>();
        ISchedulingRule workspaceRule = this.getAffectedElements(shareables);
        IWorkspaceRunnable workspaceOp = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(2 + 8 * EclipseWorkspaceChangeFilePropertiesOperation.this.changeProperties.size()));
                ISchedulingRule copyFileAreaRule = CopyFileAreaLockUtil.getCopyFileAreaLockForShareables((CopyFileAreaStore)copyFileArea, (Collection)shareables, (IProgressMonitor)subMonitor.newChild(1));
                try {
                    EclipseWorkspaceChangeFilePropertiesOperation.this.updateProperties((IProgressMonitor)subMonitor.newChild(8 * EclipseWorkspaceChangeFilePropertiesOperation.this.changeProperties.size()));
                }
                finally {
                    copyFileArea.release(copyFileAreaRule, (IProgressMonitor)subMonitor.newChild(1));
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(workspaceOp, workspaceRule, 1, monitor);
        }
        catch (FileSystemClientException e) {
            throw e;
        }
        catch (CoreException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor((Throwable)e));
        }
    }

    private ISchedulingRule getAffectedElements(List<IShareable> shareables) {
        ArrayList<ISchedulingRule> rules = new ArrayList<ISchedulingRule>();
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        for (ChangePropertiesRequest request : this.changeProperties.values()) {
            IResource resource = request.shareableFile.getResource();
            rules.add(ruleFactory.modifyRule(resource));
            shareables.add((IShareable)request.shareableFile);
        }
        return MultiRule.combine((ISchedulingRule[])rules.toArray(new ISchedulingRule[rules.size()]));
    }

    private void verifyShares(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        if (!this.verifyInSyncEnabled() || this.dilemmaHandler.willIgnoreAllSharesOutOfSync()) {
            monitor.done();
            return;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.changeProperties.size() * 2));
        HashMap<ConnectionDescriptor, ConnectionDescriptor> resolvedDescriptors = new HashMap<ConnectionDescriptor, ConnectionDescriptor>();
        EclipseWorkspaceVerifySharesOperation verifyOp = new EclipseWorkspaceVerifySharesOperation(this.dilemmaHandler);
        for (ChangePropertiesRequest request : this.changeProperties.values()) {
            IShare share = request.shareableFile.getShare();
            if (share == null) continue;
            ISharingDescriptor sharingDescriptor = share.getSharingDescriptor();
            ConnectionDescriptor descriptor = new ConnectionDescriptor(sharingDescriptor.getRepositoryId(), sharingDescriptor.getRepositoryUri(), sharingDescriptor.getConnectionHandle());
            ConnectionDescriptor resolvedDescriptor = (ConnectionDescriptor)resolvedDescriptors.get(descriptor);
            if (resolvedDescriptor == null) {
                resolvedDescriptor = descriptor;
                resolvedDescriptors.put(resolvedDescriptor, resolvedDescriptor);
            }
            verifyOp.addToVerify(descriptor.getConnection((IProgressMonitor)progress.newChild(1)), request.shareableFile.getShare());
        }
        verifyOp.run((IProgressMonitor)progress.newChild(this.changeProperties.size()));
    }

    protected void updateProperties(IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.changeProperties.size() + 10));
        ArrayList<IChangePropertiesRequest> inconsistentDelimiters = new ArrayList<IChangePropertiesRequest>();
        this.copyFileArea = CopyFileAreaStore.getDefaultCopyFileArea();
        for (ChangePropertiesRequest request : this.changeProperties.values()) {
            this.checkCancelled((IProgressMonitor)progress);
            this.convert(request, inconsistentDelimiters, progress.newChild(1));
        }
        if (!inconsistentDelimiters.isEmpty()) {
            int result = this.dilemmaHandler.inconsistentLineDelimiters(Collections.unmodifiableList(inconsistentDelimiters));
            if (result == 0) {
                progress.setWorkRemaining(inconsistentDelimiters.size());
                for (IChangePropertiesRequest request : inconsistentDelimiters) {
                    if (!request.isChangeLineDelimiterRequest() || !request.isForceLineDelimiterChange()) continue;
                    this.convert((ChangePropertiesRequest)request, null, progress.newChild(1));
                }
            } else if (result != 1) {
                IStatus[] reportedInconsistencies = new IStatus[inconsistentDelimiters.size()];
                int i = 0;
                for (IChangePropertiesRequest request : inconsistentDelimiters) {
                    reportedInconsistencies[i] = new FileSystemStatus(4, NLS.bind((String)Messages.EclipseWorkspaceChangeFilePropertiesOperation_2, (Object[])new Object[]{request.getShareableToChange().getLocalFullPath()}));
                    ++i;
                }
                MultiStatus status = new MultiStatus("com.ibm.team.filesystem.client", 2, reportedInconsistencies, Messages.EclipseWorkspaceChangeFilePropertiesOperation_3, null);
                this.handleErrors(new IStatus[]{status});
            } else {
                throw new OperationCanceledException();
            }
        }
    }

    private void convert(ChangePropertiesRequest request, ArrayList<IChangePropertiesRequest> inconsistentDelimiters, SubMonitor progress) {
        block40: {
            try {
                FileItemInfo oldInfo = this.copyFileArea.getItemInfo(request.shareableFile.getLocalFullPath());
                progress.setTaskName(NLS.bind((String)Messages.EclipseWorkspaceChangeFilePropertiesOperation_0, (Object[])new Object[]{request.shareableFile.getLocalFullPath().toPortableString()}));
                if (oldInfo == null) {
                    this.collectStatus((IStatus)new FileSystemStatus(4, NLS.bind((String)Messages.EclipseWorkspaceChangeFilePropertiesOperation_1, (Object[])new Object[]{request.shareableFile.getLocalFullPath().toString()})));
                    break block40;
                }
                LineDelimiter lineDelimiter = request.isChangeLineDelimiterRequest() ? request.lineDelimiter : oldInfo.getLineDelimiter();
                String contentType = request.isChangeContentTypeRequest() ? request.contentType : oldInfo.getContentType();
                FileItemInfo newInfo = new FileItemInfo(oldInfo.getVersionableHandle(), oldInfo.getLastModification(), oldInfo.getParent(), oldInfo.getName(), oldInfo.getHash(), oldInfo.getContentLength(), oldInfo.getOriginalLineDelimiter(), lineDelimiter, oldInfo.getOriginalContentType(), contentType, oldInfo.getStoredContentId(), oldInfo.getStoredDeltaPredecessor(), oldInfo.getStoredSize(), oldInfo.getStoredEncoding(), oldInfo.getStoredChecksum(), oldInfo.getStoredNumLineDelimiters(), oldInfo.isExecutable(), oldInfo.isOriginalExecutable());
                if (request.isChangeLineDelimiterRequest() && lineDelimiter != LineDelimiter.LINE_DELIMITER_NONE) {
                    InputStream convertingStream = null;
                    InputStream inputStream = null;
                    IFile file = (IFile)request.shareableFile.getResource();
                    try {
                        if (request.isForceLineDelimiterChange()) {
                            convertingStream = new ReaderToInputStream((InputStreamReader)LineDelimiterUtil.getNonVerifyingLineDelimiterConverter((InputStream)file.getContents(), (String)file.getCharset(true), (LineDelimiter)lineDelimiter));
                        } else {
                            block8 : switch (lineDelimiter) {
                                case LINE_DELIMITER_LF: {
                                    convertingStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToLFInputStream(file.getContents(), file.getCharset(true)));
                                    break;
                                }
                                case LINE_DELIMITER_CRLF: {
                                    convertingStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToCRLFInputStream(file.getContents(), file.getCharset(true)));
                                    break;
                                }
                                case LINE_DELIMITER_CR: {
                                    convertingStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToCRInputStream(file.getContents(), file.getCharset(true)));
                                    break;
                                }
                                case LINE_DELIMITER_PLATFORM: {
                                    switch (LineDelimiter.getPlatformDelimiter()) {
                                        case LINE_DELIMITER_CRLF: {
                                            convertingStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToCRLFInputStream(file.getContents(), file.getCharset(true)));
                                            break block8;
                                        }
                                        case LINE_DELIMITER_LF: {
                                            convertingStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToLFInputStream(file.getContents(), file.getCharset(true)));
                                            break block8;
                                        }
                                        case LINE_DELIMITER_CR: {
                                            convertingStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToCRInputStream(file.getContents(), file.getCharset(true)));
                                            break block8;
                                        }
                                    }
                                    throw new IllegalStateException();
                                }
                                default: {
                                    throw new IllegalStateException();
                                }
                            }
                        }
                        DisposableInputStreamProvider provider = TemporaryOutputStream.createLocalBuffer((InputStream)convertingStream, (IProgressMonitor)progress.newChild(1));
                        try {
                            inputStream = provider.getInputStream((IProgressMonitor)progress.newChild(1));
                            try {
                                file.setContents(inputStream, true, true, (IProgressMonitor)progress.newChild(1));
                            }
                            finally {
                                inputStream.close();
                            }
                        }
                        finally {
                            provider.dispose();
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            if (convertingStream != null) {
                                convertingStream.close();
                            }
                        }
                        catch (IOException iOException) {}
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        if (convertingStream != null) {
                            convertingStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
                this.copyFileArea.setItemInfo((IShareable)request.shareableFile, newInfo, (IProgressMonitor)progress.newChild(1));
            }
            catch (ContentLineDelimiterError contentLineDelimiterError) {
                inconsistentDelimiters.add(request);
            }
            catch (CoreException e) {
                IStatus status = FileSystemStatus.getStatusFor((int)4, (String)NLS.bind((String)Messages.EclipseWorkspaceChangeFilePropertiesOperation_8, (Object[])new Object[]{request.shareableFile.getLocalFullPath().toString()}), (Throwable)e);
                this.collectStatus(status);
            }
            catch (UnsupportedCharsetException e) {
                IStatus status = FileSystemStatus.getStatusFor((int)4, (String)NLS.bind((String)Messages.EclipseWorkspaceChangeFilePropertiesOperation_4, (Object[])new Object[]{request.shareableFile.getLocalFullPath().toString()}), (Throwable)e);
                this.collectStatus(status);
            }
            catch (IOException e) {
                IStatus status = e instanceof UnsupportedEncodingException ? FileSystemStatus.getStatusFor((int)4, (String)NLS.bind((String)Messages.EclipseWorkspaceChangeFilePropertiesOperation_5, (Object[])new Object[]{request.shareableFile.getLocalFullPath().toString()}), (Throwable)e) : (e instanceof CharacterCodingException || e instanceof UnmappableCharacterException ? FileSystemStatus.getStatusFor((int)4, (String)NLS.bind((String)Messages.EclipseWorkspaceChangeFilePropertiesOperation_6, (Object[])new Object[]{request.shareableFile.getLocalFullPath().toString()}), (Throwable)e) : FileSystemStatus.getStatusFor((int)4, (String)NLS.bind((String)Messages.EclipseWorkspaceChangeFilePropertiesOperation_7, (Object[])new Object[]{request.shareableFile.getLocalFullPath().toString()}), (Throwable)e));
                this.collectStatus(status);
            }
        }
    }

    private class ChangePropertiesRequest
    implements IChangePropertiesRequest {
        private final ShareableResource shareableFile;
        private LineDelimiter lineDelimiter;
        private String contentType;
        private boolean forceLineDelimiterConversion;

        public ChangePropertiesRequest(ShareableResource shareableFile, LineDelimiter lineDelimiter) {
            this.shareableFile = shareableFile;
            this.lineDelimiter = lineDelimiter;
            this.forceLineDelimiterConversion = false;
        }

        public ChangePropertiesRequest(ShareableResource shareableFile, String contentType) {
            this.shareableFile = shareableFile;
            this.contentType = contentType;
            this.forceLineDelimiterConversion = false;
        }

        public IShareable getShareableToChange() {
            return this.shareableFile;
        }

        public LineDelimiter getLineDelimiter() {
            if (this.isChangeLineDelimiterRequest()) {
                return this.lineDelimiter;
            }
            return this.shareableFile.getLineDelimiter();
        }

        public String getContentType() {
            if (this.isChangeContentTypeRequest()) {
                return this.contentType;
            }
            return this.shareableFile.getContentType();
        }

        public boolean isChangeLineDelimiterRequest() {
            return this.lineDelimiter != null;
        }

        public boolean isChangeContentTypeRequest() {
            return this.contentType != null;
        }

        public void setForceLineDelimiterConversion(boolean forceConversion) {
            if (!this.isChangeLineDelimiterRequest()) {
                throw new IllegalStateException();
            }
            this.forceLineDelimiterConversion = forceConversion;
        }

        public boolean isForceLineDelimiterChange() {
            return this.forceLineDelimiterConversion;
        }
    }
}

