/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.util.mutator;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.mutator.IItemCache;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.mutator.IModelMutator;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.mutator.IMutate;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.mutator.IMutatorListener;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.mutator.IQuery;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.mutator.IQueryContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.mutator.ItemCache;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class ModelMutator
implements IModelMutator,
IQueryContext {
    ItemCache cache;
    ITeamRepository repo;
    List roots = new ArrayList();
    List mutates = new ArrayList();
    List dirtyItems = new ArrayList();
    List dirtyMutates = new ArrayList();
    List listeners = new ArrayList();

    public ModelMutator(IItemCache cache, ITeamRepository repo) {
        this.cache = (ItemCache)cache;
        this.repo = repo;
    }

    public synchronized void addListener(IMutatorListener listener) {
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    public synchronized void addMutateRoot(IMutate root) {
        this.roots.add(root);
        new MutateVisitor(){

            public void visit(IMutate elt) {
                ModelMutator.this.mutates.add(elt);
            }
        }.start(root);
    }

    public synchronized void removeMutateRoot(IMutate root) {
        if (!this.roots.remove(root)) {
            throw new RuntimeException("Wrong root to remove");
        }
        new MutateVisitor(){

            public void visit(IMutate elt) {
                ModelMutator.this.mutates.remove(elt);
            }
        }.start(root);
    }

    public synchronized void dispose() {
        this.roots = Collections.EMPTY_LIST;
        this.mutates = Collections.EMPTY_LIST;
        this.dirtyItems = Collections.EMPTY_LIST;
        this.listeners = Collections.EMPTY_LIST;
        this.cache = null;
        this.repo = null;
    }

    void removeDuplicates(List list, List newElements) {
        block0: for (IItemHandle existing : list) {
            for (IItemHandle newElement : newElements) {
                if (!existing.sameItemId(newElement)) continue;
                newElements.remove(newElement);
                continue block0;
            }
        }
    }

    public synchronized void setDirtyItems(Collection dirtyItems) {
        final ArrayList dirtyItemsNoDuplicate = new ArrayList();
        dirtyItemsNoDuplicate.addAll(dirtyItems);
        this.removeDuplicates(this.dirtyItems, dirtyItemsNoDuplicate);
        this.dirtyItems.addAll(dirtyItemsNoDuplicate);
        new MutateVisitor(){

            public void visit(IMutate elt) {
                if (ModelMutator.this.isDirty(elt, dirtyItemsNoDuplicate)) {
                    ModelMutator.this.dirtyMutates.add(elt);
                }
            }
        }.start(this.roots);
    }

    public synchronized void refresh(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        try {
            final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ModelMutator_0, (int)100);
            this.cache.clear();
            if (this.dirtyMutates.size() == 0) {
                this.dirtyItems.clear();
                Iterator iter = this.listeners.iterator();
                while (iter.hasNext()) {
                    ((IMutatorListener)iter.next()).refreshCompleted(Collections.EMPTY_LIST);
                }
                return;
            }
            final ArrayList cleanedObjects = new ArrayList();
            new MutateQueryVisitor().start(this.roots, (IProgressMonitor)progress.newChild(50));
            final Hashtable items = new Hashtable();
            new MutateVisitor(){

                public void visit(IMutate elt) {
                    if (ModelMutator.this.isDirty(elt)) {
                        List handles = elt.getItems();
                        for (IItemHandle handle : handles) {
                            items.put(handle.getItemId().getUuidValue(), handle);
                        }
                    }
                }
            }.start(this.roots);
            this.cache.fetchCurrent(new ArrayList(items.values()), 0, (IProgressMonitor)progress.newChild(40));
            progress.setWorkRemaining(this.dirtyMutates.size());
            new MutateVisitor(){

                public void visit(IMutate elt) {
                    if (ModelMutator.this.isDirty(elt)) {
                        elt.clean(ModelMutator.this.cache, (IProgressMonitor)progress.newChild(1));
                        cleanedObjects.add(elt);
                    }
                }
            }.start(this.roots);
            this.dirtyMutates.clear();
            this.dirtyItems.clear();
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                ((IMutatorListener)iter.next()).refreshCompleted(cleanedObjects);
            }
        }
        finally {
            this.cache.clear();
            monitor.done();
        }
    }

    public synchronized void removeListener(IMutatorListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    public synchronized boolean markDirty(IMutate element) {
        if (!this.mutates.contains(element)) {
            return false;
        }
        if (!this.dirtyMutates.contains(element)) {
            this.dirtyMutates.add(element);
        }
        return true;
    }

    public synchronized void markDirty() {
        this.dirtyMutates.clear();
        this.dirtyMutates.addAll(this.mutates);
    }

    public synchronized void setAdded(List elements) {
        this.mutates.addAll(elements);
        this.setDirty(elements);
    }

    public synchronized void setDirty(List elements) {
        this.dirtyMutates.addAll(elements);
    }

    public synchronized void setRemoved(List elements) {
        this.mutates.removeAll(elements);
        for (IMutate mutate : elements) {
            List[] children;
            List[] listArray = children = mutate.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                List l = listArray[n2];
                if (l != null) {
                    this.setRemoved(l);
                }
                ++n2;
            }
        }
        this.dirtyMutates.removeAll(elements);
    }

    public synchronized ITeamRepository teamRepository() {
        return this.repo;
    }

    public synchronized IItemCache getCache() {
        return this.cache;
    }

    public synchronized void newState(IMutate elt) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((IMutatorListener)iter.next()).refreshProgress(Collections.singletonList(elt));
        }
    }

    List getDirty(List elements) {
        ArrayList<IMutate> dirtyList = new ArrayList<IMutate>();
        for (IMutate mutate : elements) {
            if (!this.isDirty(mutate)) continue;
            dirtyList.add(mutate);
        }
        return dirtyList;
    }

    boolean isDirty(IMutate elt) {
        return this.dirtyMutates.contains(elt);
    }

    boolean isDirty(IMutate elt, List dirtyItems) {
        List items = elt.getItems();
        for (IItemHandle handle : items) {
            for (IItemHandle dirtyHandle : dirtyItems) {
                if (!handle.sameItemId(dirtyHandle)) continue;
                return true;
            }
        }
        return false;
    }

    class MutateQueryVisitor {
        MutateQueryVisitor() {
        }

        public void start(List roots, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
            try {
                monitor.beginTask(Messages.ModelMutator_1, roots.size());
                Iterator iRoots = roots.iterator();
                while (iRoots.hasNext()) {
                    this.start((IMutate)iRoots.next(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
            }
            finally {
                monitor.done();
            }
        }

        public void start(IMutate root, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
            this.visit(Collections.singletonList(root), root.getQuery(), monitor);
        }

        public void visit(List elements, IQuery query, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
            try {
                monitor.beginTask(Messages.ModelMutator_2, 2 * elements.size());
                query.computeItemsAndChildren(ModelMutator.this.getDirty(elements), ModelMutator.this, (IProgressMonitor)new SubProgressMonitor(monitor, elements.size()));
                for (IMutate elt : elements) {
                    List[] children = elt.getChildren();
                    if (children.length == 0) {
                        monitor.worked(1);
                        continue;
                    }
                    SubProgressMonitor childMonitor = new SubProgressMonitor(monitor, 1);
                    try {
                        childMonitor.beginTask(Messages.ModelMutator_3, children.length);
                        int i = 0;
                        while (i < children.length) {
                            if (children[i] == null || children[i].isEmpty()) {
                                childMonitor.worked(1);
                            } else {
                                IQuery childQuery = ((IMutate)children[i].get(0)).getQuery();
                                if (childQuery != null) {
                                    this.visit(children[i], childQuery, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                }
                            }
                            ++i;
                        }
                    }
                    finally {
                        childMonitor.done();
                    }
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    abstract class MutateVisitor {
        MutateVisitor() {
        }

        public void start(List roots) {
            Iterator iRoots = roots.iterator();
            while (iRoots.hasNext()) {
                this.start((IMutate)iRoots.next());
            }
        }

        public void start(IMutate root) {
            this.visit(root);
            List[] children = root.getChildren();
            int i = 0;
            while (i < children.length) {
                if (children[i] != null && children[i].size() != 0) {
                    for (IMutate elt : children[i]) {
                        this.start(elt);
                    }
                }
                ++i;
            }
        }

        public abstract void visit(IMutate var1);
    }
}

