/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.util.mutator;

import com.ibm.team.filesystem.rcp.core.internal.changes.util.ModelUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.mutator.IItemCache;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class ItemCache
implements IItemCache {
    ITeamRepository repo;
    Exception exception;

    public ItemCache(ITeamRepository repo) {
        this.repo = repo;
    }

    public static IItemCache create(ITeamRepository repo) {
        return new ItemCache(repo);
    }

    public void clear() {
        this.exception = null;
    }

    public IAuditable fetchCurrent(IAuditableHandle handle, IProgressMonitor monitor) {
        IAuditable result;
        block6: {
            this.exception = null;
            result = null;
            try {
                long traceBegin = 0L;
                if (ModelUtil.TRACE_REFRESH) {
                    traceBegin = ModelUtil.logBegin("ItemManager.fetchCompleteItem " + handle);
                }
                result = (IAuditable)this.repo.itemManager().fetchCompleteItem((IItemHandle)handle, 0, monitor);
                if (ModelUtil.TRACE_REFRESH) {
                    ModelUtil.logEnd("ItemManager.fetchCompleteItem DEFAULT " + result, traceBegin);
                }
                if (result == null) {
                    StatusUtil.log((Object)this, (String)("fetchCompleteItem returns null for handle " + handle + " on repo " + this.repo), (Throwable)new Throwable());
                    if (ModelUtil.TRACE_REFRESH) {
                        ModelUtil.log("ItemManager.fetchCompleteItem failure - returns null ");
                    }
                }
            }
            catch (TeamRepositoryException e) {
                this.exception = e;
                StatusUtil.log((Object)this, (String)"Error retrieving object state", (Throwable)e);
                if (!ModelUtil.TRACE_REFRESH) break block6;
                ModelUtil.log("fetchCompleteItem failure " + (Object)((Object)e));
            }
        }
        return result;
    }

    public List fetchCurrent(List items, int flags, IProgressMonitor monitor) {
        this.exception = null;
        long traceBegin = 0L;
        if (ModelUtil.TRACE_REFRESH) {
            traceBegin = ModelUtil.logBegin("ItemManager.fetchCompleteItems flag " + flags + " items size " + items.size());
        }
        List currentItems = null;
        try {
            try {
                currentItems = this.repo.itemManager().fetchCompleteItems(items, flags, monitor);
            }
            catch (TeamRepositoryException e) {
                this.exception = e;
                StatusUtil.log((Object)this, (String)"Error retrieving object state", (Throwable)e);
                if (ModelUtil.TRACE_REFRESH) {
                    ModelUtil.log("fetchCompleteItems failure " + (Object)((Object)e));
                }
                if (ModelUtil.TRACE_REFRESH) {
                    ModelUtil.logEnd("ItemManager.fetchCompleteItems", traceBegin);
                }
            }
        }
        finally {
            if (ModelUtil.TRACE_REFRESH) {
                ModelUtil.logEnd("ItemManager.fetchCompleteItems", traceBegin);
            }
        }
        return currentItems;
    }

    public Exception lastException() {
        return this.exception;
    }
}

