/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.util;

import com.ibm.team.filesystem.rcp.core.internal.changes.model.CompareInput;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.SyncCache;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.MultiComponentSyncContext;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;

public class WorkspaceSyncContext
extends MultiComponentSyncContext
implements IWorkspaceSyncContext {
    public IWorkspaceConnection local;
    public IConnection remote;

    public WorkspaceSyncContext(IComponentSyncModel model, ITeamRepository repo, IWorkspaceConnection local, IConnection remote, CompareInput input) {
        super(model, repo, input);
        this.local = local;
        this.remote = remote;
    }

    public IComponentSyncContext[] getComponentSyncContexts() {
        ArrayList<IComponentSyncContext> result = new ArrayList<IComponentSyncContext>();
        IComponentSyncContext[] contexts = this.model.getComponentSyncContexts();
        int i = 0;
        while (i < contexts.length) {
            if (contexts[i].getOutgoingTeamPlace() == this.local) {
                result.add(contexts[i]);
            }
            ++i;
        }
        return result.toArray(new IComponentSyncContext[result.size()]);
    }

    public IComponentSyncModel getComponentSyncModel() {
        return this.model;
    }

    public IWorkspaceConnection getLocal() {
        return this.local;
    }

    public IConnection getRemote() {
        return this.remote;
    }

    public void setRemote(IConnection remote) {
        if (remote == null) {
            remote = this.local;
        }
        this.remote = remote;
    }

    public IConnection[] getRemoteTargets() {
        IComponentSyncContext[] contexts;
        HashSet<IConnection> result = new HashSet<IConnection>();
        IComponentSyncContext[] iComponentSyncContextArray = contexts = this.model.getComponentSyncContexts();
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            IComponentSyncContext context = iComponentSyncContextArray[n2];
            if (context.getOutgoingTeamPlace() == this.local) {
                result.add(context.getIncomingConnection());
            }
            ++n2;
        }
        return result.toArray(new IConnection[result.size()]);
    }

    public IChangeHistorySyncReport getSyncReport(IProgressMonitor monitor) throws TeamRepositoryException {
        if (!(this.getRemote() instanceof IWorkspaceConnection)) {
            throw new IllegalArgumentException("only supported when comparing against workspace");
        }
        return SyncCache.get().fetch((IWorkspaceConnection)this.getLocal(), (IWorkspaceConnection)((IWorkspaceConnection)this.getRemote()), (int)this.model.getCompareToFlags(), (IProgressMonitor)monitor).syncReport;
    }
}

