/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.util;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.changes.ComponentSyncInfo;
import com.ibm.team.filesystem.rcp.core.internal.changes.LocalSynchronizationManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentConflictUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ILocalChangeSource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ILocalFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.AutoCommitManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.LocalFolderNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ModelUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.UnresolvedSource;
import com.ibm.team.repository.client.util.Event;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IEventSource;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IWorkspace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class LocalChangeSource
extends EventSource
implements ILocalChangeSource {
    private List localChanges = new ArrayList();
    private List folders;
    private boolean autoSave;
    private boolean autoCheckinArmed;
    private boolean autoComplete;
    private Throwable autoCheckinLastError;
    private ComponentSyncContext context;

    public LocalChangeSource(ComponentSyncContext context, EventSource parent) {
        super(parent);
        this.context = context;
        this.setAutoCheckinMode(FileSystemResourcesPlugin.getComponentSyncModel().getLocalSynchronizationManager().getAutoSave());
        this.setAutoComplete(FileSystemResourcesPlugin.getComponentSyncModel().getLocalSynchronizationManager().getAutoComplete());
    }

    public IComponentSyncContext getModel() {
        return this.context;
    }

    public void dispose() {
    }

    public List getLocalChanges() {
        return Collections.unmodifiableList(this.localChanges);
    }

    public List getLocalChanges(ILocalFolder folder) {
        ArrayList<ILocalChange> result = new ArrayList<ILocalChange>();
        for (ILocalChange change : this.localChanges) {
            if (!((LocalFolderNode)folder).contains(change)) continue;
            result.add(change);
        }
        return result;
    }

    public int size() {
        return this.localChanges.size();
    }

    public List getFolders() {
        return this.folders != null ? Collections.unmodifiableList(this.folders) : Collections.EMPTY_LIST;
    }

    public void update() {
        long traceBegin = 0L;
        if (ModelUtil.TRACE_REFRESH) {
            traceBegin = ModelUtil.logBegin("LocalChangeSource.update");
        }
        if (this.context.isDisposed()) {
            return;
        }
        try {
            ArrayList mergedFolders;
            this.acquire();
            FileSystemCore.getSharingManager();
            ArrayList<ILocalChange> newLocalChanges = new ArrayList<ILocalChange>();
            ArrayList newFolders = new ArrayList();
            ComponentSyncInfo info = this.context.getComponentSyncInfo();
            if (!(info.getLocalConnection() instanceof IWorkspaceConnection)) {
                return;
            }
            IWorkspace workspace = info.getLocal().getResolvedWorkspace();
            IComponent component = info.getComponent();
            ILocalChange[] changes = FileSystemCore.getSharingManager().getLocalChangeManager().getPendingChanges((IContextHandle)workspace, (IComponentHandle)component, FileSystemCore.getSharingManager().getDefaultCFARoot());
            int j = 0;
            while (j < changes.length) {
                ILocalChange change = changes[j];
                if (!change.isType(16)) {
                    newLocalChanges.add(change);
                    LocalFolderNode.add(newFolders, change, this);
                }
                ++j;
            }
            this.localChanges = Collections.unmodifiableList(newLocalChanges);
            if (this.folders == null) {
                mergedFolders = newFolders;
            } else {
                mergedFolders = new ArrayList(this.folders);
                ComponentConflictUtil.update(mergedFolders, newFolders, new ComponentConflictUtil.UpdateItem(){

                    public boolean sameItem(Object object, Object other) {
                        LocalFolderNode node = (LocalFolderNode)object;
                        LocalFolderNode otherNode = (LocalFolderNode)other;
                        return node.path.equals((Object)otherNode.path);
                    }

                    public void updateSameItem(Object object, Object other) {
                    }
                });
            }
            this.folders = mergedFolders;
            ((UnresolvedSource)this.getModel().getUnresolvedSource()).update();
            this.queueEvent(new Event((IEventSource)this, "shareablesChangedRefreshed"));
            LocalSynchronizationManager localManager = (LocalSynchronizationManager)FileSystemResourcesPlugin.getComponentSyncModel().getLocalSynchronizationManager();
            localManager.queueEvent(new Event((IEventSource)this, "shareablesChangedRefreshed"));
        }
        finally {
            this.release();
            if (ModelUtil.TRACE_REFRESH) {
                ModelUtil.logEnd("LocalChangeSource.update", traceBegin);
            }
        }
    }

    public boolean getAutoCheckinMode() {
        return this.autoSave;
    }

    public void setAutoCheckinMode(boolean enable) {
        this.autoSave = enable;
        if (!enable) {
            this.autoCheckinArmed = false;
        }
    }

    public Throwable getAutoCheckinLastError() {
        return this.autoCheckinLastError;
    }

    public void setAutoCheckinLastError(Throwable t) {
        this.autoCheckinLastError = t;
    }

    public void setAutoCheckinArmed(boolean armed) {
        if (!this.autoSave) {
            return;
        }
        this.autoCheckinArmed = armed;
    }

    public boolean isAutoCheckinArmed() {
        return this.autoCheckinArmed;
    }

    public void setAutoComplete(boolean enable) {
        this.autoComplete = enable;
    }

    public IStatus updateJob(CommitDilemmaHandler problemHandler, IProgressMonitor monitor) {
        try {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.LocalChangeSource_2, (int)100);
            if (this.context.isDisposed()) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            this.update();
            monitor.worked(20);
            if (this.autoCheckinArmed) {
                AutoCommitManager.getInstance().enqueueSource(this, problemHandler, (IProgressMonitor)progress.newChild(80));
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    IStatus autoCheckin(CommitDilemmaHandler problemHandler, IProgressMonitor progress) {
        if (!this.autoCheckinArmed) {
            return null;
        }
        try {
            this.context.autoCommitLocalChanges(this.localChanges, this.autoComplete && this.context.getType() == 1, false, problemHandler, progress);
        }
        catch (TeamRepositoryException e) {
            return FileSystemStatus.getStatusFor((int)4, (int)600, (String)Messages.LocalChangeSource_3, (Throwable)e);
        }
        catch (FileSystemClientException e) {
            return FileSystemStatus.getStatusFor((int)4, (int)600, (String)Messages.LocalChangeSource_4, (Throwable)e);
        }
        return Status.OK_STATUS;
    }
}

